; $Id$
; ************************************ ;
; NAME:
;  IS_ICE
;
; PURPOSE:
;  This function determines if the file specified
;  by the argument FILENAME is a valid ICE file (ASCII column format)
;  as produced by the ICE data acquisition system
;  at the NCNR.
;
; CATEGORY:
;  DAVE, Data Reduction, TAS.
;
; AUTHOR:
;   Richard Tumanjong Azuah
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
; ************************************ ;
function is_ice,filename,errmsg = errmsg,oFTP=oFTP

errmsg = 'Unsupported file format'
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   if n_elements(lun) ne 0 then free_lun,lun,/force
   errmsg = !error_state.msg
   return,0B
endif

fromFtp = (stregex(filename,'/pub/ncnrdata/',/fold,/bool))? 1 : 0
if (fromFTP) then begin
  if (~obj_valid(oFTP)) then return, 0
  ; retrieve file contents from ftp server and store into dstring array
  dstring = oFTP->GetFileContent(filename,/string)
  if (strcmp(dstring[0],'')) then return, 0
  nlines = n_elements(dstring)
endif else begin
  if ~file_test(filename) then begin
     errmsg = 'File '+filename+' not found'
     return,0B
  endif
  nlines = file_lines(filename)
  dstring = strarr(nlines)
  
  ; B/c of unusual error resulting from running out of available logical units
  ; (probably a bug in get_lun); add the following 4 lines to force the use of 
  ; the same first available file unit every time
  lun = 100
  while ((fstat(lun)).open && (lun lt 129)) do begin
    lun++
  endwhile
  
  openr,lun,filename;,/get_lun
  readf,lun,dstring
  free_lun,lun,/force
endelse
i = 0
while ((i lt nlines) && (strmid(dstring[i],0,1) eq '#')) do begin
  split = strsplit(dstring[i],/extract)
  if (strupcase(split[0]) eq '#ICE') then begin
     errmsg = ''
     return,1B
  endif
  i++
endwhile

return,0B
end
; ************************************ ;
;pro test_is_ice
;filename = sourceroot()+'fpx444.bt7.txt'
;ret = is_ice(filename,errmsg = errmsg)
;if ~ret then print,errmsg else print,filename+' is a valid ICE file'
;
;end