; $Id$
; ************************************ ;
; NAME:
;  DAVE_READ_FILECONTENTS
;
; PURPOSE:
;  This function reads in data file and
;  returns a string array containing the contents
;  of the whole file.
;
; REQUIRED PROGRAMS:
;
;
; CATEGORY:
;  DAVE, Data Reduction, TAS.
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
; ************************************ ;
function dave_read_filecontents,filename,dstring = dstring,errmsg = errmsg
errmsg = ''
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   if n_elements(lun) ne 0 then free_lun,lun,/force
   errmsg = !error_state.msg
   return,0B
endif
; Read in the contents of the whole file
nlines = file_lines(filename)
dstring = strarr(nlines)


; B/c of unusual error resulting from running out of available logical units
; (probably a bug in get_lun); add the following 4 lines to force the use of 
; the same first available file unit every time
lun = 100
while ((fstat(lun)).open && (lun lt 129)) do begin
  lun++
endwhile

openr,lun,filename;,/get_lun
;print,'::lun=',lun
readf,lun,dstring
free_lun,lun,/force

;catch,/cancel
return,1B
end
; ************************************ ;