; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    spurion_scanqpoint_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;   cwo_drawplot_data
;
;
;METHODS:
;    spurion_scanqpoint_data::calculate
;    spurion_scanqpoint_data::draw
;    spurion_scanqpoint_data::xrange
;    spurion_scanqpoint_data::yrange
;    spurion_scanqpoint_data::getproperty
;    spurion_scanqpoint_data::setproperty
;    spurion_scanqpoint_data::cleanup
;    spurion_scanqpoint_data::init
;    spurion_scanqpoint_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu Jun 01 20:34:13 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_scanqpoint_data::calculate,rm,r0,Q,Q1,Q2,E,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy

;pro qellipse2, rm, ro, COORDTITLE=coordtitle


    ;rm = resolution matrix
    ;r0 = its prefactor
    ;Q  = the Q of the ellipse
    ;Q1 = scattering plane vector
    ;Q2 = scattering plane vector
    ;E  = energy
    ;astar,bstar,cstar = recip lattice lengths
    ;alpha,beta,gamma  = recip lattice angles
    ;xw,yw,xy   = ellipse plot options


;    print,self.q

;###################################################################
;THE NEXT STEP IS NOT CORRECT, BUT USE IT FOR TESTING RIGHT NOW. . .
;GET THE Q COORDINATES (IN hkl??????)


    ;THESE SHOULD BE PASSED IN VIA setProperty
;    QX = total(self.q*self.orient1)
;    self.qx = qx
;    QY = total(self.q*self.orient2)
;    self.qy = qy
;
;    E  = self.E

    Qx = self.Qx
    Qy = self.Qy
;    print, 'plotting'
;    print, self.Qx
;    print, self.Qy
    E  = self.E

;###################################################################



    if n_elements(xw) eq 0 then xw = 0
    if n_elements(yw) eq 0 then yw = 0
    if n_elements(xy) eq 0 then xy = 0

;print,'scanqpoint_data::calculate'
;print,'xw=',xw
;print,'xy=',xy
;print,'yw=',yw

    xw = self.xw
    yw = self.yw
    xy = self.xy

;print,'scanPoint_data::calculate'
;print,'xy=',xy
;print,'xw=',xw
;print,'yw=',yw

    if xw eq 0 and yw eq 0 and xy eq 0 then xy = 1

    ;self.rm = rm
    ;self.r0 = r0

    rm = self.rm
    r0 = self.r0


    th = findgen(1001) * (0.001 *2.0 *!pi)

    ptr_free,self.xproj
    ptr_free,self.yproj
    ptr_free,self.xcut
    ptr_free,self.ycut


;	print, rm
;	print, r0
    ;XW PLANE
    if xw eq 1 then begin

        ;PROJECTION

        p1=rm[0,0]-rm[0,1]^2/rm[1,1]
        p2=rm[2,2]-rm[1,2]^2/rm[1,1]
        p3=(rm[0,2]-rm[0,1]*rm[1,2]/rm[1,1])

; original values
;		p1=rm[2,2]-rm[2,1]^2/rm[1,1]
;        p2=rm[0,0]-rm[0,1]^2/rm[1,1]
;        p3=(rm[2,0]-rm[2,1]*rm[0,1]/rm[1,1])

;		print, 'proj'
;		print, rm[0,0]
;		print,rm[0,1]
;		print, rm[1,1]
;		print, p1
;		print, p2
;		print, p3
        rt=sqrt(2*alog(2)/(p1*cos(th)^2+p2*sin(th)^2+2*p3*sin(th)*cos(th)))

        xproj=rt*cos(th)
        yproj=rt*sin(th)

        ;CUT?
        rc=sqrt(2*alog(2)/(rm[0,0]*cos(th)^2+rm[2,2]*sin(th)^2 $
        +2*rm[2,0]*sin(th)*cos(th)))


        y1=rc*sin(th)
        x1=rc*cos(th)

        xcut=rc*cos(th)
        ycut=rc*sin(th)

        xoffset = QX
        yoffset = E


    endif;XW


    ;YW
    if yw eq 1 then begin
        th = findgen(1001) * (0.001 *2.0 *!pi)
        p1=rm[2,2]-rm[2,0]^2/rm[0,0]
        p2=rm[1,1]-rm[0,1]^2/rm[0,0]
        p3=(rm[2,1]-rm[2,0]*rm[0,1]/rm[0,0])
        rt=sqrt(2*alog(2)/(p2*cos(th)^2+p1*sin(th)^2+2*p3*sin(th)*cos(th)))

;		print, p1
;		print, p2
;		print, p3

        xproj = rt*cos(th)
        yproj = rt*sin(th)

;        y=rt*cos(th)
;        x=rt*sin(th)

        p1c = rm[2,2]
        p2c = rm[1,1]
        p3c = rm[2,1]
        rc=sqrt(2*alog(2)/(p2c*cos(th)^2+p1c*sin(th)^2+2*p3c*sin(th)*cos(th)))
;        y1=rc*cos(th)
;        x1=rc*sin(th)

        xcut=rc*cos(th)
        ycut=rc*sin(th)

;print,'rc-rt=',rc-rt
;print,'rc=',rc
        xoffset = QY
        yoffset = E

;print,'WIDTHS: y,E'
;print,max(xcut)-min(xcut)
;print,max(ycut)-min(ycut)
    endif;YW


    ;XY
    if xy eq 1 then begin
        ;plot qxqy ellipse
        th = findgen(1001) * (0.001 *2.0 *!pi)
        p1=rm[0,0]-rm[2,0]^2/rm[2,2]
        p2=rm[1,1]-rm[2,1]^2/rm[2,2]
        p3=2*(rm[0,1]-rm[2,0]*rm[2,1]/rm[2,2])
        rt=sqrt(2*alog(2)/(p1*cos(th)^2+p2*sin(th)^2+p3*sin(th)*cos(th)))

        xproj = rt*cos(th)
        yproj = rt*sin(th)


        ;Calculate for w=0
        rc=sqrt(2*alog(2)/(rm[0,0]*cos(th)^2+rm[1,1]*sin(th)^2 $
        +2*rm[0,1]*sin(th)*cos(th)))

        xcut = rc*cos(th)
        ycut = rc*sin(th)

        xoffset = QX
        yoffset = QY
;        print, 'plotting'
;        print, qx
;        print, qy

    endif;XY



    self.xproj = ptr_new(xproj+xoffset)
    self.yproj = ptr_new(yproj+yoffset)

    self.xcut  = ptr_new(xcut+xoffset)
    self.ycut  = ptr_new(ycut+yoffset)



end;calculate


;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_scanqpoint_data::draw,win,_ref_Extra=Extra;,rm,r0,Q,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy


        self->calculate,_Extra=extra;,rm,r0,Q,Q1,Q2,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy
        wset,win


        device,get_decomposed=dc
        device,decomposed=1


;        self->getproperty,x=px,y=py,sy=psy,color=color,psym=psym,$
;                linestyle=linestyle,legend=legend,showdata=showdata,$
;                showlegend=showlegend,ebshow=ebshow,thesymsize=symsize
        if self.showdata ne 0 then begin


            xproj = *self.xproj
            yproj = *self.yproj

            xrange = !x.crange
            yrange = !y.crange


            wh = where(xproj lt min(xrange),count)
            if count gt 0 then xproj(wh) = min(xrange)
            wh = where(xproj gt max(xrange),count)
            if count gt 0 then xproj(wh) = max(xrange)

            wh = where(yproj lt min(yrange),count)
            if count gt 0 then yproj(wh) = min(yrange)
            wh = where(yproj gt max(yrange),count)
            if count gt 0 then yproj(wh) = max(yrange)



            if self.showellipse eq 1 then begin

                ;PROJECTION
                if self.showproj eq 1 then begin
                    ;oplot,(*self.xproj),(*self.xproj),color=self.projcolor
                    polyfill,xproj,yproj,color=self.projcolor;150
                endif



                ;CUT
                if self.showcut eq 1 then begin
                    oplot,(*self.xcut),(*self.ycut),color=self.black;white
                endif
            endif;showellipse

            if self.xy eq 1 then begin
                if self.showq eq 1 then $
                    arrow,[0.0],[0.0],[self.qx],[self.qy],/data,color=0L
                if self.showki eq 1 then begin
                    ;SET UP ki ARROW
                endif
                if self.showkf eq 1 then begin
                    ;SET UP kf ARROW
                endif
            endif

            if self.showsymbol eq 1 then begin
                oplot,[self.qx],[self.qy],color=self.green,psym=2,symsize=1
            endif

;           if self.xy eq 1 then arrow,[0.0],[0.0],[self.kix],[self.kiy],/data,color=0L
;           if self.xy eq 1 then arrow,[self.kix],[self.kiy],[self.kix+self.kfx],[self.kiy+self.kfy],/data,color=0L

        endif;show

        device, decomposed = dc

end;spurion_scanqpoint_data::draw

;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data::xrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion_scanqpoint_data::xrange

    if self.xy eq 1 then begin
        x = [0.,*self.xproj,*self.xcut]
    endif else begin
        x = [*self.xproj,*self.xcut]
    endelse
    return,[min(x),max(x)]

end;xrange
;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion_scanqpoint_data::yrange

    if self.xy eq 1 then begin
        y = [0.,*self.yproj,*self.ycut]
    endif else begin
        y = [*self.yproj,*self.ycut]
    endelse

    return,[min(y),max(y)]

end;yrange

;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_scanqpoint_data::getproperty,$
                            xproj=xproj,$
                            yproj=yproj,$
                            xcut=xcut,$
                            ycut=ycut,$
                            xy=xy,$
                            xw=xw,$
                            yw=yw,$
                            rm=rm,$
                            r0=r0,$
                            Qx=Qx,$
                            Qy=Qy,$
                            kix=kix,$
                            kiy=kiy,$
                            kfx=kfx,$
                            kfy=kfy,$
                            E=E,$
;                            Q=Q,$
;                            orient1=orient1,$
;                            orient2=orient2,$
;                            astar=astar,$
;                            bstar=bstar,$
;                            cstar=cstar,$
;                            alphastar=alphastar,$
;                            betastar=betastar,$
;                            gammastar=gammastar,$
                            projcolor=projcolor,$
                            cutcolor=cutcolor,$
                            id=id,$
                            ;_extra=extra
                            _ref_extra=extra

;print,'spurion_scanqpoint_data::getproperty'
;print,'ARG_PRESENT(id)?????'
;help,extra
;print,(extra)
;print,arg_present(id)




                self->cwo_drawplot_data::getproperty,id=id,_extra=extra

                if arg_present(xproj) gt 0 then xproj = self.xproj
                if arg_present(yproj) gt 0 then yproj = self.yproj

                if arg_present(xcut) gt 0 then xcut = self.xcut
                if arg_present(ycut) gt 0 then ycut = self.ycut

                if arg_present(xy) gt 0 then xy = self.xy
                if arg_present(xw) gt 0 then xw = self.xw
                if arg_present(yw) gt 0 then yw = self.yw


                if arg_present(rm) gt 0 then rm = self.rm
                if arg_present(r0) gt 0 then r0 = self.r0
                if arg_present(Qx) gt 0 then Qx = self.Qx
                if arg_present(Qy) gt 0 then Qy = self.Qy
                if arg_present(kix) gt 0 then kix = self.kix
                if arg_present(kiy) gt 0 then kiy = self.kiy
                if arg_present(kfx) gt 0 then kfx = self.kfx
                if arg_present(kfy) gt 0 then kfy = self.kfy

;                if arg_present(Q) gt 0 then Q = self.Q
;                if arg_present(orient1) gt 0 then orient1 = self.orient1
;                if arg_present(orient2) gt 0 then orient2 = self.orient2
                if arg_present(E) gt 0 then E = self.E

;                if arg_present(astar) gt 0 then astar = self.astar
;                if arg_present(bstar) gt 0 then bstar = self.bstar
;                if arg_present(cstar) gt 0 then cstar = self.cstar
;
;                if arg_present(alphastar) gt 0 then alphstar = self.alphastar
;                if arg_present(betastar) gt 0 then betastar = self.betastar
;                if arg_present(gammastar) gt 0 then gammastar = self.gammastar

                if arg_present(showki) eq 1 then showki = self.showki
                if arg_present(showkf) eq 1 then showkf = self.showkf
                if arg_present(showQ) eq 1 then showQ = self.showQ
                if arg_present(showproj) eq 1 then showproj = self.showproj
                if arg_present(showcut) eq 1 then showcut = self.showcut
                if arg_present(showellipse) eq 1 then showellipse = self.showellipse
                if arg_present(showsymbol) eq 1 then showsymbol = self.showsymbol


                if arg_present(projcolor) gt 0 then projcolor = self.projcolor
                if arg_present(cutcolor) gt 0 then cutcolor = self.cutcolor

end;getproperty

;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data::setcheckboxproperties
;
;PURPOSE:
;        SET PROPERTIES BASED ON CHECKBOX CONDITIONS IN ONE CALL.
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion_scanqpoint_data::setcheckboxproperties,vals

;['Q Vec','Ki','Kf','Cut','Proj','Ellipse',$
;'Symbol','Al Spheres','Recip. Lat.'],$
    self.showQ  = vals[0]
    self.showki = vals[1]
    self.showkf = vals[2]
    self.showcut = vals[3]
    self.showproj = vals[4]
    self.showellipse = vals[5]
    self.showsymbol = vals[6]

end;setcheckboxproperties


;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_scanqpoint_data::setproperty,$
                            xproj=xproj,$
                            yproj=yproj,$
                            xcut=xcut,$
                            ycut=ycut,$
                            xw=xw,$
                            yw=yw,$
                            xy=xy,$
                            rm=rm,$
                            r0=r0,$
                            Qx=Qx,$
                            Qy=Qy,$
                            kix=kix,$
                            kiy=kiy,$
                            kfx=kfx,$
                            kfy=kfy,$
                            E=E,$
;                            Q=Q,$
;                            orient1=orient1,$
;                            orient2=orient2,$
;                            astar=astar,$
;                            bstar=bstar,$
;                            cstar=cstar,$
;                            alphastar=alphastar,$
;                            betastar=betastar,$
;                            gammastar=gammastar,$
                            projcolor=projcolor,$
                            cutcolor=cutcolor,$
                            showki = showki,$
                            showkf = showkf,$
                            showQ = showQ,$
                            showproj = showproj,$
                            showcut = showcut,$
                            showellipse = showellipse,$
                            showsymbol = showsymbol,$
                            _ref_extra=extra

                self->cwo_drawplot_data::setproperty,_extra=extra

                if n_elements(xproj) gt 0 then self.xproj = xproj
                if n_elements(yproj) gt 0 then self.yproj = yproj

                if n_elements(xcut) gt 0 then self.xcut = xcut
                if n_elements(ycut) gt 0 then self.ycut = ycut

                if n_elements(xy) gt 0 then self.xy = xy
                if n_elements(xw) gt 0 then self.xw = xw
                if n_elements(yw) gt 0 then self.yw = yw


                if n_elements(rm) gt 0 then self.rm = rm
                if n_elements(r0) gt 0 then self.r0 = r0
                if n_elements(projcolor) gt 0 then self.projcolor = projcolor
                if n_elements(cutcolor) gt 0 then self.cutcolor = cutcolor

                if n_elements(Qx) eq 1 then self.Qx = Qx
                if n_elements(Qy) eq 1 then self.Qy = Qy
                if n_elements(kix) eq 1 then self.kix = kix
                if n_elements(kiy) eq 1 then self.kiy = kiy
                if n_elements(kfx) eq 1 then self.kfx = kfx
                if n_elements(kfy) eq 1 then self.kfy = kfy


                if n_elements(E) eq 1 then self.E = E

;                if n_elements(q)  ge 3 then self.Q  = q[0:2]
;                if n_elements(orient1) eq 3 then self.orient1 = orient1[0:2]
;                if n_elements(orient2) eq 3 then self.orient2 = orient2[0:2]
;
;                if n_elements(astar) eq 1 then self.astar = astar
;                if n_elements(bstar) eq 1 then self.bstar = bstar
;                if n_elements(cstar) eq 1 then self.cstar = cstar
;
;                if n_elements(alphastar) eq 1 then self.alphastar = alphastar
;                if n_elements( betastar) eq 1 then self.betastar  = betastar
;                if n_elements(gammastar) eq 1 then self.gammastar = gammastar

                if n_elements(showki) eq 1 then self.showki = showki
                if n_elements(showkf) eq 1 then self.showkf = showkf
                if n_elements(showQ) eq 1 then self.showQ = showQ
                if n_elements(showproj) eq 1 then self.showproj = showproj
                if n_elements(showcut) eq 1 then self.showcut = showcut
                if n_elements(showellipse) eq 1 then self.showellipse = showellipse
                if n_elements(showsymbol) eq 1 then self.showsymbol = showsymbol

                self->calculate;,rm,r0,xy=xy,xw=xw,yw=yw
end;setproperty


;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_scanqpoint_data::cleanup
    print,'spurion_scanqpoint_data::cleanup'

    ptr_free,self.xproj
    ptr_free,self.yproj
    ptr_free,self.xcut
    ptr_free,self.ycut
    self->cwo_drawplot_data::cleanup

end;spurion_scanqpoint_data::cleanup
;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion_scanqpoint_data::init,x,y,sy,legend=legend,showdata=showdata,$
                                    showlegend=showlegend,$
                                    rm=rm,$
                                    r0=r0,$
                                    Qx=Qx,$            ;Qx,Qy IN THE u,v COORDINATES, i.e. IN THE SCATTERING PLANE.
                                    Qy=Qy,$
                                    kix=kix,$
                                    kiy=kiy,$
                                    kfx=kfx,$
                                    kfy=kfy,$
                                    E=E,$
                                    projcolor=projcolor,$
                                    xy=xy,$
                                    xw=xw,$
                                    yw=yw,$
                                    id=id,$
                                    showq=showq,$
                                    showki = showki,$
                                    showkf = showkf,$
                                    showproj = showproj,$
                                    showcut = showcut,$
                                    showellipse = showellipse,$
                                    showsymbol = showsymbol,$
                                    _ref_extra=extra


    ret = self->cwo_drawplot_data::init(x,y,sy,legend=legend,showdata=showdata,id=id,$
                                            showlegend=showlegend,_extra=extra)

    if ret eq 1 then begin
        if n_elements(rm) eq 16 then self.rm = rm else self.rm = double([[1,0,0,0],$
                                                                        [0,1,0,0],$
                                                                        [0,0,1,0],$
                                                                        [0,0,0,1]])

        if n_elements(r0) eq 1  then self.r0 = r0 else self.r0 = 1.0



        if n_elements(Qx) eq 1 then self.Qx = Qx else self.Qx = 0.0
        if n_elements(Qy) eq 1 then self.Qy = Qy else self.Qy = 0.0
        if n_elements(kix) eq 1 then self.kix = kix else self.kix = 0.0
        if n_elements(kiy) eq 1 then self.kiy = kiy else self.kiy = 0.0
        if n_elements(kfx) eq 1 then self.kfx = kfx else self.kfx = 0.0
        if n_elements(kfy) eq 1 then self.kfy = kfy else self.kfy = 0.0


    ;    if n_elements(q)  ge 3 then self.Q  = q[0:2]  else self.Q  = [1.0,0.0,0.0]
    ;    if n_elements(orient1) eq 3 then self.orient1 = orient1 else self.orient1 = [1.0,0.0,0.0]
    ;    if n_elements(orient2) eq 3 then self.orient2 = orient2 else self.orient2 = [0.0,1.0,0.0]
    ;
    ;    if n_elements(astar) eq 1 then self.astar = astar else self.astar = 1.0
    ;    if n_elements(bstar) eq 1 then self.bstar = bstar else self.bstar = 1.0
    ;    if n_elements(cstar) eq 1 then self.cstar = cstar else self.cstar = 1.0
    ;
    ;    if n_elements(alphastar) eq 1 then self.alphastar = alphastar else self.alphastar = 90.0
    ;    if n_elements( betastar) eq 1 then self.betastar  = betastar  else self.betastar  = 90.0
    ;    if n_elements(gammastar) eq 1 then self.gammastar = gammastar else self.gammastar = 90.0

        if n_elements(showki) eq 1 then self.showki = showki else  self.showki = 1
        if n_elements(showkf) eq 1 then self.showkf = showkf else  self.showkf = 1
        if n_elements(showQ) eq 1 then self.showQ = showQ else  self.showQ = 1
        if n_elements(showproj) eq 1 then self.showproj = showproj else  self.showproj = 1
        if n_elements(showcut) eq 1 then self.showcut = showcut else  self.showcut = 1
        if n_elements(showellipse) eq 1 then self.showellipse = showellipse else self.showellipse = 1
        if n_elements(showsymbol) eq 1 then self.showsymbol = showsymbol else self.showsymbol = 0



        ;SELECT DRAW PLANE OF OBJECT
        if n_elements(xy) eq 0 then xy = 0
        if n_elements(xw) eq 0 then xw = 0
        if n_elements(yw) eq 0 then yw = 0

        if xw eq 0 and yw eq 0 and xy eq 0 then xy = 1  ;DEFAULT CASE IS XY PLANE


        if xy+xw+yw gt 1 then begin

            void = dialog_message('spurion_scanqpoint_data::init  Multiple planes chosen, setting to x-y.')
            xw = 0
            yw = 0
            xy = 1                    ;DEFAULT IN
        endif


        self.xy = xy
        self.xw = xw
        self.yw = yw

        self->calculate;,rm,r0,xy=xy,xw=xw,yw=yw


        self.cutcolor = self.white
        self.projcolor = 150L

        return,1
    endif else begin
        return,ret
    endelse

end;spurion_scanqpoint_data

;###############################################################################
;
;NAME:
;        spurion_scanqpoint_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion_scanqpoint_data__define,class

    class = {   spurion_scanqpoint_data,$
                inherits cwo_drawplot_data,$
                xproj:ptr_new(),$
                yproj:ptr_new(),$
                xcut:ptr_new(),$
                ycut:ptr_new(),$
                ;
                ;THE NEXT 5 VALUES SHOULD BE SIMPLY PASSED INTO THE OBJECT
                ;AND CALCULATED IN THE ScanPoint OBJECT
                rm:dblarr(4,4),$
                r0:0.0,$
                Qx:0.0,$            ;Qx,Qy IN THE u,v COORDINATES, i.e. IN THE SCATTERING PLANE.
                Qy:0.0,$
                kix:0.0,$
                kiy:0.0,$
                kfx:0.0,$
                kfy:0.0,$
                E:0.0,$
                ;THE NEXT 5 ITEMS STAY IN THIS CLASS
                projcolor:0L,$
                cutcolor:0L,$
                xy:0,$
                xw:0,$
                yw:0,$
                showki:0,$
                showkf:0,$
                showQ:0,$
                showproj:0,$
                showcut:0,$
                showellipse:0,$
                showsymbol:0}


;                ;THE NEXT 3 ITEMS SHOULD NOT BE USED IN THIS CLASS
;                Q: dblarr(3),$
;                orient1:dblarr(3),$
;                orient2:dblarr(3),$
;                ;THE NEXT 6 ITEMS SHOULD NOT BE USED IN THIS CLASS.
;                astar:0.0,$
;                bstar:0.0,$
;                cstar:0.0,$
;                alphastar:0.0,$
;                betastar:0.0,$
;                gammastar:0.0}
end;spurion_scanqpoint_data__define
