; $Id$
; 
; Inherits cwo_drawplot_data
; Computes and draws, reciprical lattice points in scattering plane.
; 
;###############################################################################
;
;
;CLASS NAME:
;    spurion2_2dlattice_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;METHODS:
;    spurion2_2dlattice_data::calculate
;    spurion2_2dlattice_data::getSpurions
;    spurion2_2dlattice_data::draw
;    spurion2_2dlattice_data::xrange
;    spurion2_2dlattice_data::yrange
;    spurion2_2dlattice_data::getproperty
;    spurion2_2dlattice_data::setproperty
;    spurion2_2dlattice_data::cleanup
;    spurion2_2dlattice_data::init
;    spurion2_2dlattice_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################


;pro calc_incoherent,ki,kf,Qana,Qmon
;
;
;    kix = ki[0]
;    kiy = ki[1]
;    kfx = kf[0]
;    kfy = kf[1]
;
;    kixincoherent = sqrt(kf[0]^2 + kf[1]^2)*ki[0]/sqrt(ki[0]^2 + ki[1]^2)
;    kiyincoherent = sqrt(kf[0]^2 + kf[1]^2)*ki[1]/sqrt(ki[0]^2 + ki[1]^2)
;
;    kfxincoherent = sqrt(ki[0]^2 + ki[1]^2)*kf[0]/sqrt(kf[0]^2 + kf[1]^2)
;    kfyincoherent = sqrt(ki[0]^2 + ki[1]^2)*kf[1]/sqrt(kf[0]^2 + kf[1]^2)
;
;    Qxanaincoherent = kix - kfxincoherent
;    Qyanaincoherent = kiy - kfyincoherent
;    Qxmonoincoherent = kixincoherent - kfx
;    Qymonoincoherent = kiyincoherent - kfy
;
;    Qana = [Qxanaincoherent,Qyanaincoherent]
;    Qmon = [Qxmonoincoherent,Qymonoincoherent]
;
;
;end;calc_incoherent

;###############################################################################
;
;NAME:
;        spurion2_2dlattice_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_2dlattice_data::calculate,_ref_extra=extra

;NO CALCULATIONS SHOULD BE NECESSARY HERE.
;

end;calculate


;###############################################################################
;
;NAME:
;        spurion2_2dlattice_data::getSpurions
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
function spurion2_2dlattice_data::getSpurions,qtol,etol,hvec,kvec,lvec,$
                                                    a,b,c,alpha,beta,gamma,$
                                                    o1,o2,evec,efix,eif,$
                                                    sym=sym,$
                                                    latspurQ=latspurQ,$
                                                    latspursym=latspursym,$
                                                    latspurincsym=latspurincsym,$
                                                    latspurcap=latspurcap,$
                                                    pointnumber=pointnumber,$
                                                    harmcheckboxstate=harmcheckboxstate,$
                                                    spurcheckboxstate=spurcheckboxstate,$
                                                    pointchoice=pointchoice


    if n_elements(pointchoice) eq 0 then pointchoice = -1   ;OPTIONAL INDEX FOR SELECTING ONLY ONE POINT FOR SPURION LISTING
                                                            ;THIS IS JEFF'S PREFERENCE

    ;if n_elements(pointnumber) eq 0 then pointnumber = -1

    npts = n_elements(hvec)
    nharm = 4

    if n_elements(harmcheckboxstate) eq 0 then harmcheckboxstate = intarr(nharm^2) + 1
    ;print,'spurion2_2dlattice_data::getSpurions harmcheckboxstate=',harmcheckboxstate
    if n_elements(spurcheckboxstate) eq 0 then spurcheckboxstate = intarr(8) + 1


    pointnumber = intarr(npts)         ;PLACE NUMBER OF SPURIONS AT EACH POINT NUMBER HERE.
    latspurcap = ['Begin Spurions']    ;APPEND THE LATEST CAPTION AT END.
    latspursym = [0]
    latspurcolor = [0L]
    latspurenergy = [0.0]
    latspurq      = [0.0]

    red = 255L
    green = 256L*red
    blue = 256L*green
    black = 0L
    yellow = red + green
    purple = blue + green
    violet = red + blue

    harmcolor = [red,blue,green,black,yellow,$
                  100L,100L*256L,100L*256L*256L,100L*256L*256L,$
                  red,blue,green,purple,100L,100L*256L,100L*256L*256L]

    harmcolor = spurion2_harmonic_colors()
    spurioncolor = spurion2_spurion_colors()
    spurionsymbol = spurion2_spurion_symbols()
    spurionlabel = spurion2_spurion_labels()


    time_o = systime(/seconds)
    for i=0,npts-1 do begin

        if (pointchoice eq i) or (pointchoice eq -1) then begin
                ;print,systime(/seconds)-time_o
                h = hvec[i]
                k = kvec[i]
                l = lvec[i]
                e = evec[i]

                Qxy = hkl_to_Qxy(h,k,l,$
                                 a,b,c,alpha,beta,gamma,o1,o2,$
                                 zhat_hkl=zhat_hkl,$
                                 /invang)

            ;    if eif eq 0 then init = 1
            ;    if eif eq 1 then final = 1

                if eif eq 0 then begin
                    init = 1
                    final = 0
                    ei = efix
                    ef = ei - e
                endif else begin
                    init = 0
                    final = 1
                    ef = efix
                    ei = e + ef
                endelse

                x = *self.x
                y = *self.y

                kikf = getkikf_from_efixed_etran(Efix,E,Qxy,init=init,final=final)
                ki = kikf.ki
                kf = kikf.kf

                format = '(g7.3)'
                FirstEntry = 'Q=['+strtrim( string(h,format=format),2)+','+ $
                                   strtrim( string(k,format=format),2)+','+ $
                                   strtrim( string(l,format=format),2)+']'

                list = [FirstEntry,'Bragg Peaks:']

            ;    latspursym    = 4
            ;    latspurincsym = 5

            ;    latspurQ = [0.0]
            ;    latspurcap = ['']


                for ii=0,n_elements(x)-1 do begin
                    hkl = (*self.hkl)[*,ii]
                    for jj=1,nharm do begin
                        for kk=1,nharm do begin
                            if harmcheckboxstate[(jj-1) + nharm*(kk-1)] eq 1 then begin
                                Q = jj*ki - kk*kf
                                Eeff = (jj^2)*Ei - (kk^2)*Ef

                                r = sqrt((Q[0] - x[ii])^2 + (Q[1] - y[ii])^2)
                                if r le qtol then begin

                                    sh = strtrim(string(hkl[0]),2)
                                    sk = strtrim(string(hkl[1]),2)
                                    sl = strtrim(string(hkl[2]),2)
                ;print,'test'
                                    ;print,h
                                    h = clearjunk(h)
                                    ;print,h
                                    k = clearjunk(k)
                                    l = clearjunk(l)
                                    e = clearjunk(e)

                                    s = '     ('  +strtrim(string(jj),2)+ $
                                        'ki,'+strtrim(string(kk),2)+ $
                                        'kf) at RL ['+sh+','+sk+','+sl+']'+ ', Qo = [' + $
                                        strtrim(string(h,format='(g6.2)'),2) + ',' + $
                                        strtrim(string(k,format='(g6.2)'),2) + ',' + $
                                        strtrim(string(l,format='(g6.2)'),2) + ',' + $
                                        strtrim(string(e,format='(g6.2)'),2) + ']'

                                        pointnumber[i] += 1
                                        latspurcap = [latspurcap,s]
                                        latspursym = [latspursym,spurionsymbol[5]];4]
                                        latspurenergy = [latspurenergy,Eeff]
                                        latspurq      = [latspurq,sqrt(dotp(ki-kf,ki-kf))]

                    ;COLORS BY FEATURE, NOT HARMONIC????

                ;111506
                ;FIRST TRY COLOR COMBO OF HARMONICS INSTEAD OF FEATURES
                                        if jj eq 1 and kk eq 1 then begin
                                            latspurcolor = [latspurcolor,spurioncolor[5]];red];harmcolor[(jj-1)+(kk-1)*nharm]]
                                        endif else begin
                                            latspurcolor = [latspurcolor,spurioncolor[6]];purple];harmcolor[(jj-1)+(kk-1)*nharm]]
                                        endelse

                ;                    list = [list,s]
                ;
                ;                    QLat_PointNumber[jj+(kk-1)*nharm,i] = jj+(kk-1)*nharm
                ;                    QLat_Labels[jj+(kk-1)*nharm,i] = s
                ;                    QLat_Syms[jj+(kk-1)*nharm,i] = 3

                ;                    latspurQ = [latspurQ,pointnumber];sqrt((ki-kf)[0]^2 + (ki-kf)[1]^2)]
                ;                    latspurCap = [latspurcap,s]
                                endif;r le qtol
                            endif;harmcheckboxstate
                        endfor;kk
                    endfor;jj
                endfor;ii

                ;check incoherent spurions
                ;list = [list,'      Incoherent spurions from Bragg peaks:']

                if E ne 0 then begin
                    calc_incoherent,ki,kf,Qana,Qmon
                    for ii=0,n_elements(x)-1 do begin
                        hkl = (*self.hkl)[*,ii]

                        r = sqrt((Qmon[0] - x[ii])^2 + (Qmon[1] - y[ii])^2)
                        if r le qtol then begin
                            sh = strtrim(string(hkl[0]),2)
                            sk = strtrim(string(hkl[1]),2)
                            sl = strtrim(string(hkl[2]),2)
                            s = '     Qmono incoherent at RL ['+sh+','+sk+','+sl+']'+ ', Qo = [' + $
                                    strtrim(string(h,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(k,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(l,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(e,format='(g7.3)'),2) + ']'

                            pointnumber[i] += 1
                            latspurcap = [latspurcap,s]
                            latspursym = [latspursym,6]
                            latspurcolor = [latspurcolor,spurioncolor[7]];green]
                            latspurenergy = [latspurenergy,0.0] ;NO ENERGY TRANSFER AT INCOHERENT POINTS
                            latspurq      = [latspurq,sqrt(dotp(ki-kf,ki-kf))]
                        endif
                        r = sqrt((Qana[0] - x[ii])^2 + (Qana[1] - y[ii])^2)
                        if r le qtol then begin
                            sh = strtrim(string(hkl[0]),2)
                            sk = strtrim(string(hkl[1]),2)
                            sl = strtrim(string(hkl[2]),2)
                            s = '     Qana  incoherent at RL ['+sh+','+sk+','+sl+']'+ ', Qo = [' + $
                                    strtrim(string(h,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(k,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(l,format='(g7.3)'),2) + ',' + $
                                    strtrim(string(e,format='(g7.3)'),2) + ']'

                            pointnumber[i] += 1
                            latspurcap = [latspurcap,s]
                            latspursym = [latspursym,spurionsymbol[7]];6]
                            latspurcolor = [latspurcolor,spurioncolor[7]];green]
                            latspurenergy = [latspurenergy,0.0] ;NO ENERGY TRANSFER AT INCOHERENT POINTS
                            latspurq      = [latspurq,sqrt(dotp(ki-kf,ki-kf))]
                        endif
                    endfor;ii
                endif;E
        endif;pointchoice
    endfor;i

    if total(pointnumber) gt 0 then begin
        latspurCap = latspurCap[1:*]
        latspursym = latspursym[1:*]
        latspurcolor = latspurcolor[1:*]
        latspurenergy = latspurenergy[1:*]
        latspurq      = latspurq[1:*]
    endif

    return,{pointnumber:pointnumber,$
            latspurcap:latspurcap,$
            latspursym:latspursym,$
            latspurcolor:latspurcolor,$
            latspurenergy:latspurenergy,$
            latspurq:latspurq}

end;getSpurions
;###############################################################################
;
;NAME:
;        spurion2_2dlattice_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;       xscale  Multiplicative scale factors.
;       yscale
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_2dlattice_data::draw,win,xscale=xscale,yscale=yscale,_ref_extra=extra
;print,'spurion2_2dlattice_data::draw'
        if n_elements(xscale) eq 0 then xscale = 1.0
        if n_elements(yscale) eq 0 then yscale = 1.0

;THE NEXT SECTION WOULDBE USED TO CREATE xscale AND yscale LOCALLY.
;#######################
;;;;;;;;;;    val = recip_lattice(a,b,c,alpha,beta,gamma)
;;;;;;;;;;    b1    = val.b123.b1
;;;;;;;;;;    b2    = val.b123.b2
;;;;;;;;;;    b3    = val.b123.b3
;;;;;;;;;;
;;;;;;;;;;;THE FOLLOWING SETS THE AXES ALONG o1,o2
;;;;;;;;;;    o1vec = (o1[0]*b1 + o1[1]*b2 + o1[2]*b3)
;;;;;;;;;;    o2vec = (o2[0]*b1 + o2[1]*b2 + o2[2]*b3)
;;;;;;;;;;
;;;;;;;;;;
;;;;;;;;;;    mago1vec = sqrt(dotp(o1vec,o1vec))
;;;;;;;;;;    mago2vec = sqrt(dotp(o2vec,o2vec))
;;;;;;;;;;
;;;;;;;;;;    ;CREATE UNIT VECTORS ALONG THE o1,o2 DIRECTIONS ---  THIS SHOULD NOT BE USED IN
;;;;;;;;;;    xhat_o1 = o1vec/mago1vec                            ;GENERAL SINCE THEY ARE ALONG
;;;;;;;;;;    yhat_o2 = o2vec/mago2vec                            ;THE ORIENTATION VECTOR DIRECTIONS
;;;;;;;;;;                                                        ;AND MAY NOT BE ORTHOGONAL.
;;;;;;;;;;
;;;;;;;;;;    xhat = xhat_o1
;;;;;;;;;;    xhat = xhat/sqrt(dotp(xhat,xhat))
;;;;;;;;;;    zhat = crossp(xhat_o1,yhat_o2)
;;;;;;;;;;    zhat = zhat/sqrt(dotp(zhat,zhat))
;;;;;;;;;;    yhat = crossp(zhat,xhat)
;;;;;;;;;;    yhat = yhat/sqrt(dotp(yhat,yhat))
;;;;;;;;;;
;;;;;;;;;;;    xtitle = 'X ['+angstrom()+'^-1]  || ['+ $
;;;;;;;;;;    xtitle = 'X [1/Ang]  || ['+ $
;;;;;;;;;;                strtrim(string(o1[0],format='(f4.1)'),2)+','+ $
;;;;;;;;;;                strtrim(string(o1[1],format='(f4.1)'),2)+','+ $
;;;;;;;;;;                strtrim(string(o1[2],format='(f4.1)'),2)+']';o1[0]*b1+o1[1]*b2+o1[2]*b3'
;;;;;;;;;;    ;ytitle = 'Y ['+angstrom()+'^-1]  || Z x X';perp o1.[b1,b2,b3],coplanar w/o1.[b1,b2,b3]&o2.[b1,b2,b3]'
;;;;;;;;;;;    ytitle = 'Y ['+angstrom()+'^-1]  || '+ $
;;;;;;;;;;    ytitle = 'Y [1/Ang]  || ['+ $
;;;;;;;;;;                strtrim(string(yhat[0],format='(f5.2)'),2)+','+ $
;;;;;;;;;;                strtrim(string(yhat[1],format='(f5.2)'),2)+','+ $
;;;;;;;;;;                strtrim(string(yhat[2],format='(f5.2)'),2)+']'
;;;;;;;;;;
;;;;;;;;;;    overalltitle = 'Plane perp to Z = O1 x O2'
;;;;;;;;;;
;;;;;;;;;;
;;;;;;;;;;    xtitle0 = 'X [rlu]  || ['+ $
;;;;;;;;;;                strtrim(string(o1[0],format='(f4.1)'),2)+','+ $
;;;;;;;;;;                strtrim(string(o1[1],format='(f4.1)'),2)+','+ $
;;;;;;;;;;                strtrim(string(o1[2],format='(f4.1)'),2)+']'
;;;;;;;;;;;    ytitle0 = 'Y [rlu]  || Z x X'
;;;;;;;;;;
;;;;;;;;;;
;;;;;;;;;;    ytitle0 = 'Y [rlu]  || ['+ $
;;;;;;;;;;                strtrim(string(yhat[0],format='(f5.2)'),2)+','+ $
;;;;;;;;;;                strtrim(string(yhat[1],format='(f5.2)'),2)+','+ $
;;;;;;;;;;                strtrim(string(yhat[2],format='(f5.2)'),2)+']'
;;;;;;;;;;    ;THESE AXES ARE THE PRIMARY AXES IN spurion
;;;;;;;;;;    ;THEY ARE IN UNITS OF hkl, i.e. DIMENSIONLESS!!!
;;;;;;;;;;    xscale = mago1vec
;;;;;;;;;;
;;;;;;;;;;
;;;;;;;;;;    ;GET ANGLE OF o2 WRT X AXIS
;;;;;;;;;;    o2theta = acos(dotp(o2vec,xhat)/mago2vec)
;;;;;;;;;;    ;CALCULATE THE COMPONENT OF o2 ALONG Y
;;;;;;;;;;    yscale  = mago2vec/sin(o2theta)
;####################






        self->calculate,_extra=extra
        wset,win

        device,get_decomposed=dc
        device,decomposed=1


        self->getproperty,x=px,y=py,sy=psy,strf=pstrf,color=color,psym=psym,$
                linestyle=linestyle,legend=legend,showdata=showdata,$
                showlegend=showlegend,ebshow=ebshow,thesymsize=symsize

symsize = 0.4*symsize


        if showdata ne 0 then begin

            x    = (*px)*xscale
            y    = (*py)*yscale
            strf = *pstrf

            strf = (strf/max(strf))*255.0  ;HOW ABOUT bytscl()?????

            ;LOOP OVER THE LATTICE POINTS AND PLACE A MARK A
            ;COLOR-CODED OR SIZE CODED SYMBOL AT EACH LATTICE
            ;POINT.
setCircleSymbol
            showstrf = 0
            if showstrf eq 1 then begin
                for i=0,n_elements(strf)-1 do begin
                    oplot,[x[i]],[y[i]],$
                          color = long(strf[i]),$
                          psym =  8,$;psym,$
                          linestyle=linestyle,$
                          symsize=symsize
                endfor;i
            endif else begin
                oplot,[x],[y],$
                      color = self.red,$
                      psym =  8,$
                      symsize=symsize
            endelse

        endif;show

        device, decomposed = dc

end;spurion2_2dlattice_data::draw

;###############################################################################
;
;NAME:
;        spurion2_2dlattice_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_2dlattice_data::getproperty,$
                            strf=strf,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _ref_extra=extra



                if arg_present(strf) gt 0 then strf = self.strf

                self->cwo_drawplot_data::getproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _extra=extra


end;getproperty
;###############################################################################
;
;NAME:
;        spurion2_2dlattice_data::setcheckboxproperties
;
;PURPOSE:
;        SET PROPERTIES BASED ON CHECKBOX CONDITIONS IN ONE CALL.
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion2_2dlattice_data::setcheckboxproperties,vals

    self.showdata = vals[0]
    ;ALSO COLOR CODING, RADIUS CODING,

end;setcheckboxproperties


;###############################################################################
;
;NAME:
;        spurion2_2dlattice_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_2dlattice_data::setproperty,$
                            strf=strf,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _ref_extra=extra

                self->cwo_drawplot_data::setproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _extra=extra

                if n_elements(strf) gt 0 then self.strf = strf

end;setproperty




;###############################################################################
;
;NAME:
;        spurion2_2dlattice_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_2dlattice_data::cleanup

    ;print,'spurion2_2dlattice_data::cleanup'
    ptr_free,self.hkl
    ptr_free,self.strf

    self->cwo_drawplot_data::cleanup

end;spurion2_2dlattice_data::cleanup
;###############################################################################
;
;NAME:
;        spurion2_2dlattice_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_2dlattice_data::init,$;x,y,sy,strf,$
                                 o1,o2,a,b,c,alpha,beta,gamma,$
                                 legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,id=id,$
                                 hkl=hkl,invang=invang,hklunits=hklunits,$
                                 scanqmax=scanqmax,$
                                 scanqxmax=scanqxmax,$
                                 scanqymax=scanqymax,$
                                 _ref_extra=extra

    if n_elements(hklunits) eq 0 then hklunits = 0
    if n_elements(invang) eq 0 then invang = 0
    if hklunits eq 0 and invang eq 0 then invang = 1

    if n_elements(scanqmax) eq 0 then scanqmax = 0.0
    if n_elements(scanqxmax) eq 0 then scanqxmax = 0.0
    if n_elements(scanqymax) eq 0 then scanqymax = 0.0


    val = recip_lattice(a,b,c,alpha,beta,gamma)
    b1    = val.b123.b1
    b2    = val.b123.b2
    b3    = val.b123.b3

    vec1 = o1[0]*b1+o1[1]*b2+o1[2]*b3
    vec2 = o2[0]*b1+o2[1]*b2+o2[2]*b3
    alewald,al,dum


;HOW DO I HANDLE THE CASES WHERE o1 AND/OR o2 HAVE non-integer COMPONENTS?



    o1xy = hkl_to_Qxy(o1[0],o1[1],o1[2],$
                      a,b,c,alpha,beta,gamma,o1,o2,$
                      /invang,$
                      zhat_hkl=zhat_hkl);/hklunits
    o2xy = hkl_to_Qxy(o2[0],o2[1],o2[2],$
                      a,b,c,alpha,beta,gamma,o1,o2,$
                      /invang,zhat_hkl=zhat_hkl);/hklunits



;UPDATE THIS TO SET RANGE TO MAX([SCAN RANGES,alrings])
;    datarange = max([al[n_elements(al)-1],scanqmax])
;    nmakehkl = 2*long(datarange/min([sqrt(dotp(o1xy,o1xy)),sqrt(dotp(o2xy,o2xy))]))


    dataxrange = max([al[n_elements(al)-1],scanqxmax])
    datayrange = max([al[n_elements(al)-1],scanqymax])

    mmakehkl = 3 + 2*long(dataxrange/max([abs(o1xy[0]),abs(o2xy[0])]))
    nmakehkl = 3 + 2*long(datayrange/max([abs(o1xy[1]),abs(o2xy[1])]))



;NEED A MORE SENSIBLE WAY TO SELECT hkl VALUES.
;    print,nmakehkl

    if n_elements(hkl) eq 0 then begin
;        hkl = intarr(3,nmakehkl^2)
;        for i=0,nmakehkl-1 do begin
;            for j=0,nmakehkl-1 do begin
;                hkl[*,i+j*nmakehkl] = (i-nmakehkl/2)*o1 + (j-nmakehkl/2)*o2
;            endfor;j
;        endfor;i
 ;print,'spurion2_2dlattice_data::init  ',mmakehkl,nmakehkl
        hkl = intarr(3,mmakehkl*nmakehkl)
        for i=0,mmakehkl-1 do begin
            for j=0,nmakehkl-1 do begin
                hkl[*,i+j*mmakehkl] = (i-mmakehkl/2)*o1 + (j-nmakehkl/2)*o2
            endfor;j
        endfor;i
    endif

    self.hkl = ptr_new(hkl)

    sz = size(hkl)
    x = [0.0]
    y = [0.0]
    for i=0L,sz[2]-1 do begin
        h = hkl[0,i]
        k = hkl[1,i]
        l = hkl[2,i]
        Qxy = hkl_to_Qxy(h,k,l,a,b,c,alpha,beta,gamma,o1,o2,$
                         hklunits=hklunits,invang=invang)
        if total(finite(Qxy,/nan)) eq 0 then begin
            if Qxy[2] eq 0 then begin
                x = [x,Qxy[0]]
                y = [y,Qxy[1]]
            endif else print,Qxy
        endif
    endfor;i

    if n_elements(x) gt 1 then begin
        x = x[1:*]
        y = y[1:*]
    endif
    sy = 0.0*x
    strf = [sy] + 1.0


    ret = self->cwo_drawplot_data::init(x,y,sy,legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,$
                                 id=id,_extra=extra)

    if ptr_valid(self.strf) gt 0 then ptr_free,self.strf
    self.strf = ptr_new([strf])

    self.ebshow = 0

    return,1
end;spurion2_2dlattice_data

;###############################################################################
;
;NAME:
;        spurion2_2dlattice_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_2dlattice_data__define,class

    class = {   spurion2_2dlattice_data,$
                inherits cwo_drawplot_data,$
                hkl:ptr_new(),$
                strf:ptr_new()}

end;spurion2_2dlattice_data__define
