; $Id$
;###############################################################################
;
;CLASS NAME:
;    pro ooEchoMagnetic__define
;
;PURPOSE:
;   Extend the ooEcho class to handle magnetic systems.
;CATEGORY:
;
;SUPERCLASSES:
;       ooecho
;METHODS:
;    ooEchoMagnetic::term
;    ooEchoMagnetic::SQ1D
;    ooEchoMagnetic::chirpAll
;    ooEchoMagnetic::calculateIQT  --- UNNEEDED HERE IF MAGNETIC Iup/down ARE STORED IN OLD Iup/down
;    ooEchoMagnetic::chirpMaskedAll
;    ooEchoMagnetic::chirpExtrema
;    ooEchoMagnetic::chirpIdown
;    ooEchoMagnetic::chirpIup
;    ooEchoMagnetic::helpchirpIup_down_XYZ
;    ooEchoMagnetic::threeMplusNoverSix
;    ooEchoMagnetic::startparms
;    ooEchoMagnetic::setproperty
;    ooEchoMagnetic::getproperty
;    ooEchoMagnetic::cleanup
;    ooEchoMagnetic::cloneSetMagnetic
;    ooEchoMagnetic::blankObjMagnetic
;    ooEchoMagnetic::read
;    ooEchoMagnetic::deadTime
;    ooEchoMagnetic::readMagnetic
;    ooEchoMagnetic::cloneSet
;    ooEchoMagnetic::removeT
;    ooEchoMagnetic::blankObj
;    ooEchoMagnetic::clone
;    ooEchoMagnetic::mergeSet
;    ooEchoMagnetic::merge
;    ooEchoMagnetic::init
;    ooEchoMagnetic__define
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Dec 01,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################



function ooEchoMagnetic::term
;
;NAME:
;        ooEchoMagnetic::term
;
;PURPOSE:
;       Return the "term" value of the data, i.e. the first point_to_up/down
;       value after the data.
;
;       This method overrides the ooEcho term method.
;       point_to_up/down_x,y,z not available in superclass
;       so I must override here.  This should take care of
;       most of the term calls and avoid overriding a lot
;       of methods.
;PARAMETERS:
;       none.
;KEYWORDS:
;       none
;RETURN VALUE:
;   The term value.
;
;print,'TERM in ooEchoMagnetic'
        if self.magnetic eq 1 then begin
            term = min([self.point_to_down_x,self.point_to_up_x,$
                        self.point_to_down_y,self.point_to_up_y,$
                        self.point_to_down_z,self.point_to_up_z])
        endif else begin
            term = self->ooEcho::term();min([self.point_to_down,self.point_to_up])

        endelse
        return,term
end;term
function ooEchoMagnetic::SQ1D,narcs = narcs,sq=sq,mag=mag,tot=tot,coh=coh,incoh=incoh,timeaverage=timeaverage;
;NAME:
;        ooEchoMagnetic::SQ1D
;
;PURPOSE:
;           CALCULATE A 1D S(Q,t=0) FOR PLOTTING IN cw_nse_sqplot.
;PARAMETERS:
;           none
;KEYWORDS:
;           narcs       Number of Q arcs.
;
;           sq          Return S(Q)
;           tot         Return tot (Same as S(Q))
;           coh         Return coherent part (Calculation different for magnetic and non-magnetic)
;           incoh       Return incoherent part (Calculation different for magnetic and non-magnetic)
;           mag         Available for magnetic only. --- Objects should be presorted.
;           timeaverage Flag to time average the up and down values.
;
;RETURNS:
;           struct  A structure containing pointer to the appropriate component of S(Q,t=0),sS, q
;
    ;self->addTreatment,'ooEcho::SQ1D'

    if n_elements(narcs) eq 0 then narcs = self.narcs
    if n_elements(sq) eq 0 then sq = 0
    if n_elements(tot) eq 0 then tot = 0
    if n_elements(coh) eq 0 then coh = 0
    if n_elements(incoh) eq 0 then incoh = 0
    if n_elements(mag) eq 0 then mag = 0
    if n_elements(timeaverage) eq 0 then timeaverage = 0    ;THIS SHOULD HAVE NO EFFECT IN THIS METHOD

print,'TEST ooEchoMagnetic::SQ1D'
    ;PROVIDE OPTION TO GET ALL MAGNETIC COMPONENTS IF MAGNETIC
    if self.magnetic eq 1 then begin



        ;111306
        ;THIS IS THE ONLY PLACE IN THIS FILE WHICH CALLS F_PolAnalysisGeneral
        ;
        ;DROP IN THE NEW VERSION AND SEE WHAT HAPPENS!!!

        dum = self->F_PolAnalysisGeneral(0,$
                                         sq1dtotal=tot,$
                                         sq1dmagnetic=mag,$
                                         sq1dspinIncoherent=incoh,$
                                         sq1dCoherentAndIsotopeIncoherent=coh);,$
                                         ;timeaverage=timeaverage)



;IT LOOKS LIKE WHAT IS ACTUALLY USED IS:
;pro NSEDiffractionViewer_readAltMagnetic,fn,x,y,sy,t,inc,c,m,st,sinc,sc,sm,$
;                                         narcs,xcen,ycen,detxrange,detyrange,lambda,$
;                                         results,psym

;THIS MEANS THAT




       ; print,'TEST'

;IT LOOKS LIKE THE NEXT FUNCTION MAY HAVE REPLACED F_POLANALYSISGENERAL IN DIFFRACTION VIEWER.
;;;;;;;;;;function NSEDiffractionViewer_sortAltMagneticByQArcs,narcs,$
;;;;;;;;;;                                            theQVals,$
;;;;;;;;;;                                            dumXup,dumXdn,$
;;;;;;;;;;                                            dumZup,dumZdn,$
;;;;;;;;;;                                            dumYup,dumYdn,$
;;;;;;;;;;                                            mask,mat,self_q,self_preset,f
;;;;;;;;;;

;;;;;;help,/traceback
;;;;;;print,'FINISH NSEDiffractionViewer_sortByQArcs'
;;;;;    return,{s:ptr_new(s),ss:ptr_new(ss),q:ptr_new(q),$
;;;;;            s_tot:ptr_new(s_tot),s_stot:ptr_new(s_stot),$
;;;;;            s_coh:ptr_new(s_coh),s_scoh:ptr_new(s_scoh),$
;;;;;            s_incoh:ptr_new(s_incoh),s_sincoh:ptr_new(s_sincoh),$
;;;;;            s_mag:ptr_new(s_mag),s_smag:ptr_new(s_smag)}





;;;;;;;;;;;;;;;;        dum = NSEDiffractionViewer_f_polanalysisgeneral(0,$
;;;;;;;;;;;;;;;;                                                self.p,$
;;;;;;;;;;;;;;;;                                                self.no_of_fourier_times,$
;;;;;;;;;;;;;;;;                                                self.Eff_BPW,$
;;;;;;;;;;;;;;;;                                                self.f,$
;;;;;;;;;;;;;;;;                                                self.xyzupdownscale,$
;;;;;;;;;;;;;;;;                                                *self.xdown,$
;;;;;;;;;;;;;;;;                                                *self.xup,$
;;;;;;;;;;;;;;;;                                                *self.ydown,$
;;;;;;;;;;;;;;;;                                                *self.yup,$
;;;;;;;;;;;;;;;;                                                *self.zdown,$
;;;;;;;;;;;;;;;;                                                *self.zup,$
;;;;;;;;;;;;;;;;                                                *self.mask2d,$   ;I BET THIS IS A POINTER
;;;;;;;;;;;;;;;;                                                self.preset,$
;;;;;;;;;;;;;;;;                                                self.q,$
;;;;;;;;;;;;;;;;                                                *self.qvals,$    ;I BET THIS IS A POINTER
;;;;;;;;;;;;;;;;                                                self.narcs,$
;;;;;;;;;;;;;;;;                                                *self.arcmat,$   ;I BET THIS IS A POINTER
;;;;;;;;;;;;;;;;;CALL THIS WITH THE ABOVE ARGUMENTS EACH TIME A NEW SET OF SIX ARRAYS IS READ
;;;;;;;;;;;;;;;;;                                                xvals=xvals,$
;;;;;;;;;;;;;;;;;                                                plotdata=plotdata,$
;;;;;;;;;;;;;;;;;                                                eplotdata=eplotdata,$
;;;;;;;;;;;;;;;;;                                                image=image,$
;;;;;;;;;;;;;;;;;                                                eimage=eimage,$
;;;;;;;;;;;;;;;;;                                                theimageindex=theimageindex,$
;;;;;;;;;;;;;;;;;                                                magneticImage=magneticImage,$
;;;;;;;;;;;;;;;;;                                                emagneticImage=emagneticImage,$
;;;;;;;;;;;;;;;;;                                                spinCoherentImage=spinCoherentImage,$
;;;;;;;;;;;;;;;;;                                                espinCoherentImage=espinCoherentImage,$
;;;;;;;;;;;;;;;;;                                                CoherentAndIsotopeIncoherentImage=CoherentAndIsotopeIncoherentImage,$
;;;;;;;;;;;;;;;;;                                                eCoherentAndIsotopeIncoherentImage=eCoherentAndIsotopeIncoherentImage,$
;;;;;;;;;;;;;;;;;                                                TotalImage=TotalImage,$
;;;;;;;;;;;;;;;;;                                                eTotalImage=eTotalImage,$
;;;;;;;;;;;;;;;;;                                                pixel=pixel,$
;;;;;;;;;;;;;;;;;                                                magq1d=magq1d,$
;;;;;;;;;;;;;;;;                                                sq1dtotal=tot,$
;;;;;;;;;;;;;;;;                                                sq1dmagnetic=mag,$
;;;;;;;;;;;;;;;;                                                sq1dspinIncoherent=incoh,$
;;;;;;;;;;;;;;;;                                                sq1dCoherentAndIsotopeIncoherent=coh);,$
;;;;;;;;;;;;;;;;                                                ;timeaverage=timeaverage)
;;;;;;;;;;;;;;;;



        sq = tot
;        print,*(tot.s)
;        print,*(mag.s)
;        print,*(incoh.s)
;        print,*(coh.s)
        sq1d = tot
    endif else begin
    ;USE VERSION FROM ooEcho IF NOT MAGNETIC
        if narcs ne self.narcs then begin
            sq1d = self->ooEcho::SQ1D(narcs=narcs)
        endif else begin
            sq1d = self->ooEcho::SQ1D()
        endelse
    endelse


;        sq1d = self->ooEcho::SQ1D(narcs=narcs)
    return,sq1d



;
;
;    ;GET THE DATA AND THE 2D MASK
;    e = *(self->getproperty(tag='e'))
;    mask = *(self->getproperty(tag='mask2d'))
;
;    sze = size(e)
;    szm = size(mask)
;
;    whrmask = where(mask le 0,count)
;    if count ne 0 then begin
;        mask[whrmask] = 0
;    endif
;
;
;;SET UP 5 CASES HERE
;
;;TOT/S(Q) --- UPDATE THIS TO USE AVE OF UP/DOWN.
;;    etot = total(e[*,0:self->term()-1,*],2)
;;    setot = sqrt(etot)
;
;if obj_isa(self,'ooEchoMagnetic') gt 0 then begin
;
;    if self.magnetic eq 0 then begin
;        p2up    = self.point_to_up
;        p2down  = self.point_to_down
;
;        e_a = e[*,self->term():min([p2up,p2down])-1,*]
;        e_b = e[*,min([p2up,p2down]),max([p2up,p2down])-1,*]
;        etot_a = total(e_a,2)/((min([p2up,p2down])-1)-self->term())
;        etot_b = total(e_b,2)/((max([p2up,p2down])-1)-min([p2up,p2down]))
;
;        setot_a = sqrt(total(e_a^2.0,2))/((min([p2up,p2down])-1)-self->term())
;        setot_b = sqrt(total(e_b^2.0,2))/((max([p2up,p2down])-1)-min([p2up,p2down]))
;
;        etot = (etot_a+etot_b)/2.0
;        setot = sqrt(setot_a^2.0 + setot_b^2.0)/2.0
;    endif else begin
;        p2upx    = self.point_to_up_x
;        p2downx  = self.point_to_down_x
;        p2upz    = self.point_to_up_z
;        p2downz  = self.point_to_down_z
;        p2upy    = self.point_to_up_y
;        p2downy  = self.point_to_down_y
;
;        arr = [self.point_to_up_x,self.point_to_up_y,self.point_to_up_z,$
;               self.point_to_down_x,self.point_to_down_y,self.point_to_down_z]
;
;        arr = arr[sort(arr)]
;
;        e_0 = e[*,arr[0]:arr[1]-1,*]
;        e_1 = e[*,arr[1]:arr[2]-1,*]
;        e_2 = e[*,arr[2]:arr[3]-1,*]
;        e_3 = e[*,arr[3]:arr[4]-1,*]
;        e_4 = e[*,arr[4]:arr[5]-1,*]
;        e_5 = e[*,arr[5]:self.no_of_phases-1,*]
;
;        etot_0 = total(e_0,2)/((arr[1]-1)-arr[0])
;        etot_1 = total(e_1,2)/((arr[2]-1)-arr[1])
;        etot_2 = total(e_2,2)/((arr[3]-1)-arr[2])
;        etot_3 = total(e_3,2)/((arr[4]-1)-arr[3])
;        etot_4 = total(e_4,2)/((arr[5]-1)-arr[4])
;        etot_5 = total(e_5,2)/((self.no_of_phases-1)-arr[5])
;
;        setot_0 = sqrt(total(e_0^2.0,2))/((arr[1]-1)-arr[0])
;        setot_1 = sqrt(total(e_0^2.0,2))/((arr[2]-1)-arr[1])
;        setot_2 = sqrt(total(e_0^2.0,2))/((arr[3]-1)-arr[2])
;        setot_3 = sqrt(total(e_0^2.0,2))/((arr[4]-1)-arr[3])
;        setot_4 = sqrt(total(e_0^2.0,2))/((arr[5]-1)-arr[4])
;        setot_5 = sqrt(total(e_0^2.0,2))/((self.no_of_phases-1)-arr[5])
;
;        etot = (etot_0+etot_1+etot_2+etot_3+etot_4+etot_5)/6.0
;        setot = sqrt(setot_0^2.0 + setot_1^2.0 + setot_2^2.0 + $
;                     setot_3^2.0 + setot_4^2.0 + setot_5^2.0)/6.0
;
;    endelse
;
;endif else begin
;    ;ooEcho
;        p2up    = self.point_to_up
;        p2down  = self.point_to_down
;
;        e_a = e[*,self->term():min([p2up,p2down])-1,*]
;        e_b = e[*,min([p2up,p2down]),max([p2up,p2down])-1,*]
;        etot_a = total(e_a,2)/((min([p2up,p2down])-1)-self->term())
;        etot_b = total(e_b,2)/((max([p2up,p2down])-1)-min([p2up,p2down]))
;
;        setot_a = sqrt(total(e_a^2.0,2))/((min([p2up,p2down])-1)-self->term())
;        setot_b = sqrt(total(e_b^2.0,2))/((max([p2up,p2down])-1)-min([p2up,p2down]))
;
;        etot = (etot_a+etot_b)/2.0
;        setot = sqrt(setot_a^2.0 + setot_b^2.0)/2.0
;
;endelse
;
;    self->calculateArcsQMatrix,narcs=narcs,arcmat=mat
;
;    theQvals = *(self->getproperty(tag='Qvals'))
;
;    s = dblarr(narcs)
;    sS = dblarr(narcs)
;    q = dblarr(narcs)
;    qcount = intarr(narcs)
;
;;    help,etot
;;    help,mask
;;    help,mat
;    sz = size(etot)
;    for i=0,sz[1]-1 do begin
;        for j=0,sz[2]-1 do begin
;            for k=0,narcs-1 do begin
;                if mat[i] eq k and mask[i,j] ne 0 then begin
;                    s[k] += etot[i,j]/setot[i,j]^2
;                    ss[k] += 1.0d/setot[i,j]^2
;
;                    q[k] += theQVals[i,j]
;                    qcount[k] += 1
;
;                endif
;            endfor;k
;        endfor;j
;    endfor;i
;
;
;    qmin = min(theqvals)
;    qmax = max(theqvals)
;
;    for i=0,narcs-1 do begin
;        if qcount[i] ne 0 then begin
;            s[i] = s[i]/ss[i]
;            ss[i] = 1.0d/sqrt(ss[i])
;            q[i] = q[i]/double(qcount[i])
;        endif else begin
;        print,'ooEchoMagnetic::SQ1D test'
;            s[i] = 0.0
;            ss[i] = 0.0
;            if narcs ne 1 then begin
;                qstep = (qmax-qmin)/double(narcs-1)
;                q[i] = qmin + (double(i)+0.5)*qstep
;            endif else begin
;                q[i] = self->getproperty(tag='q')
;            endelse
;        endelse
;    endfor;i
;
;
;    ;NORMALIZE ALL DATA BY THE PRESET TO FACILITATE CAMPARISON OF SCANS
;    s = s/double(self.preset)
;    ss = ss/double(self.preset)
;
end;SQ1D


function ooEchoMagnetic::chirpAll,xind,yind,tauind
;
;NAME:
;        ooEchoMagnetic::chirpAll
;
;PURPOSE:
;       Return the echo and Iup,down values.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;   The echo values.
    ;;self->addTreatment,'ooEcho::chirpAll'
    ;THIS FUNCTION RETURNS THE ECHO DATA ('CHIRP') FOR A GIVEN
    ;DETECTOR PIXEL AT A GIVEN FOURIER TIME INCLUDING THE
    ;FLIPPER UP/DOWN DATA USED TO CALCULATE THE AMPLITUDES.
;    print,'_________________________'
;    print,'ooEchoMagnetic::chirpAll'

;print,'WHEN IS THIS CALLED?  ooEchoMagnetic::chirpAll  --- DOUBLE xyzupdownscale USAGE????'
;help,/traceback

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim,self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)

    ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
    ys = s[xind,yind,0:*,tauind]

        term = self->term()

;120805
;print,file_basename(self.filename)
       ; if n_elements(ys) le term then $
            ys[term:*] = self.xyzupdownscale*ys[term:*]

    ;RETURN THE SLICE AS A 1D ARRAY
    return,reform(ys,self.no_of_phases)
end;chirpAll

function ooEchoMagnetic::chirpMaskedAll,xind,yind,tauind
;
;NAME:
;        ooEcho::chirpMaskedAll
;
;PURPOSE:
;       Return the masked echo with Iup,down points.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The echo with Iup,down points.

    ;;self->addTreatment,'ooEcho::chirpMaskedAll'

;    print,'_________________________'
;    print,'ooEchoMagnetic::chirpMaskedAll'

        ;THIS FUNCTION RETURNS THE ECHO DATA ('CHIRP') FOR A GIVEN
        ;DETECTOR PIXEL AT A GIVEN FOURIER TIME
        ;
        ;THIS FUNCTION APPLIES THE CURRENT mask1d TO THE DATA



        ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
        s=reform(*self.emask,self.x_dim,self.y_dim,$
            self.no_of_phases,self.no_of_fourier_times)

        ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
        ys = reform(s[xind,yind,0:self.no_of_phases-1,tauind], $
                                            self.no_of_phases)

        term = self->term()

        ;print,ys
        ys[term:*] = self.xyzupdownscale*ys[term:*]
        ;print,ys

        ysmask = 0



        unmasked = where((*self.mask1d)[*,tauind] gt 0,count)
;        print,'_________________________'
;        print,'ooEcho::chirpPhasesMasked'
;        print,'count=',count
;        print,'unmasked=',unmasked
        if count gt 0 then begin
            return,ys[unmasked]
        endif else begin
            return,ys
        endelse



end;chirpMaskedAll



;THE NEXT ITEMS NEED TO BE OVERRIDDEN HERE.


;    ooEchoMagnetic::chirpExtrema
;    ooEchoMagnetic::chirpExtremaMasked
;    ooEchoMagnetic::chirpIdown
;    ooEchoMagnetic::chirpIup
;    ooEchoMagnetic::checkHydrogenated  --- I DON'T KNOW IF THIS IS AFFECTED.
;    ooEchoMagnetic::chirpOffset

function ooEchoMagnetic::chirpExtrema,xind,yind,tauind,tavestate=tavestate
;
;NAME:
;        ooEchoMagnetic::chirpExtrema
;
;PURPOSE:
;           Return both Iup and Idown in one call.
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;           A 2 element array with the down and up values.

    ;;self->addTreatment,'ooEchoMagnetic::chirpExtrema'

if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()

    ;GET THE DATA VALUES IN A CHIRP FOR THE FLIPPER DOWN
    ;AND FLIPPER UP STATES.
    ;RETURN A 2D VECTOR OF THE AVERAGES OF THESE DATA

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim,self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)


;092705
;PLACE NEXT CONDITIONAL TO TEST WHERE UP AND DOWN BEGIN.

;101205
;NEED TO CONVERT THE NEXT STATEMENTS INTO THE MAGNETIC FORM

if self.magnetic eq 0 then begin
    if self.point_to_down lt self.point_to_up then begin
        ysdown = s[xind,yind,self.point_to_down:self.point_to_up-1,tauind]
        ysup = s[xind,yind,self.point_to_up:*,tauind]

        ;REFORM SLICES INTO 1D MATRICES
        ysdown1d = reform(ysdown,(self.point_to_up - self.point_to_down))
        ysup1d = reform(ysup,(self.no_of_phases - self.point_to_up))
    endif else begin
        ysdown = s[xind,yind,self.point_to_up:self.point_to_down-1,tauind]
        ysup = s[xind,yind,self.point_to_down:*,tauind]

        ;REFORM SLICES INTO 1D MATRICES
        ysdown1d = reform(ysdown,(self.point_to_down - self.point_to_up))
        ysup1d = reform(ysup,(self.no_of_phases - self.point_to_down))

    endelse
    ;GET MEAN VALUES OF UP AND DOWN
    ydown = mean(ysdown1d)
    yup = mean(ysup1d)
endif else begin    ;magnetic eq 1

    yup = self->chirpIup(xind,yind,tauind,tavestate=tavestate)
    ydown = self->chirpIdown(xind,yind,tauind,tavestate=tavestate)


endelse

    return,[ydown,yup]
end;chirpExtrema
function ooEchoMagnetic::chirpExtremaMasked,xind,yind,tauind,tavestate=tavestate
;
;NAME:
;        ooEchoMagnetic::chirpExtremaMasked
;
;PURPOSE:
;           Return both Iup and Idown with masking taken into account in one call.
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;           A 2 element array with the down and up values.
    ;;self->addTreatment,'ooEchoMagnetic::chirpExtremaMasked'
if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()

    yup = self->chirpIup(xind,yind,tauind,tavestate=tavestate)
    ydown = self->chirpIdown(xind,yind,tauind,tavestate=tavestate)

    return,[ydown,yup]
end;chirpExtremaMasked

function ooEchoMagnetic::generate3DMask

    ;GET THE 1D MASK (ASSUMES ALL DATA AT A SINGLE PHASE
    ;ARE MASKED FOR ALL PIXELS OVER ENTIRE DETECTOR)
    mask1d = *self.mask1d

    ;GET THE 2D MASK (ASSUMES DATA FOR A SINGLE PIXEL AT A SINGLE
    ;TIME ARE MASKED FOR ALL PHASES)
    mask2d = *self.mask2d

    sz1 = size(mask1d)
    sz2 = size(mask2d)

    npix = sz2[1]
    nphs = sz1[1]
    nt = sz2[2]

    ;RESULTING MASK ARRAY IS A 1 OR 0 AT EACH PIXEL, PHASE VALUE, AND TIME.
    ;IS THIS THE INTERSECTION OF THE TWO MASKS?????
    arr = dblarr(npix,nphs,nt)
    
    ;ZERO OUT ALL POSITIONS IN THE MASKS THAT ARE NOT 1
    whmasked1 = where(mask1d ne 1,count1)
    if count1 ne 0 then begin
      mask1d[whmasked1] = 0
    endif;count1

    whmasked2 = where(mask2d ne 1,count2)
    if count2 ne 0 then begin
      mask2d[whmasked2] = 0
    endif;count2

    for j=0,nt-1 do begin
      for i=0,nphs-1 do begin
        arr[*,i,j] = mask1d[i,j]*mask2d[*,j]
      endfor;i
    endfor;j

    return,arr

end;ooEchoMagnetic::generate3DMask

function ooEchoMagnetic::figureOrder,i1,iend
;RETURN THE ARRAY OF NEXT VALUES
      order = sort(i1)
      i2 = i1[order]
      next = 0*i1

      for k=0,n_elements(i1)-1 do begin
        a = i1[k]
        ib = where(a eq i2);order eq k+1)
        if ib eq n_elements(i1)-1 then b = iend else b = i2[ib+1]
        next[k] = b-1
      endfor;k
      return,next
end;figureOrder


function ooEchoMagnetic::getNumberOfUpDownContributingPoints,xind,yind,tauind,tavestate=tavestate
to = systime(1)
;1) GET tAve state:
    if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()

;print,'1',(to1=(systime(1)-to))

;2) Get masking in t direction for each pixel used
    mask1d = *self.mask1d
    mask2d = *self.mask2d

    sz1 = size(mask1d)
    sz2 = size(mask2d)

    npix = sz2[1]
    nphs = sz1[1]
    nt = sz2[2]

    npts = 0.0
;print,'2',(to2=(systime(1)-to))

    ;CREATE THE MASK FOR ALL PIXELS, PHASES AND TIMES
    arr = self->generate3DMask()
;print,'3',(to3=(systime(1)-to))

    ;SET THE TIME INDICES TO LOOP OVER BASED ON WHETHER DATA ARE TIME-AVERAGED.
    if tavestate eq 0 then begin
      t1 = tauind
      t2 = tauind
    endif else begin
      t1 = 0
      t2 = nt-1     
    endelse
;print,'4',(to4=systime(1)-to)

    ;IN MASK ARRAYS, 1 is unmasked, anything else is masked.   
    if self.magnetic eq 0 then begin
        i1 = [self.point_to_down,self.point_to_up]
        i2 = self->figureorder(i1,self.no_of_phases)
        npts = dblarr(n_elements(i1))
    endif else begin    ;MAGNETIC
        i1 = [ self.point_to_down_x,$
               self.point_to_up_x,$
               self.point_to_down_y,$
               self.point_to_up_y,$
               self.point_to_down_z,$
               self.point_to_up_z $
               ]
        i2 = self->figureOrder(i1,self.no_of_phases)
        npts = dblarr(n_elements(i1)) 
    endelse;IF magnetic
;print,'5',(to5=systime(1)-to)



    for k=0,n_elements(npts)-1 do begin
      for j=t1,t2 do begin
        for i=i1[k],i2[k] do begin;self.point_to_down,self.point_to_up-1 do begin
            npts[k] += arr[xind+yind*self.x_dim,i,j]
        endfor;i
      endfor;j        
    endfor;k

;print,'6',(to6=systime(1)-to)
;print,systime(1)-to
   
    return,npts
end;getNumberOfUpDownContributingPoints



function ooEchoMagnetic::chirpIdown,xind,yind,tauind,tavestate=tavestate
;
;NAME:
;        ooEchoMagnetic::chirpIdown
;
;PURPOSE:   Calculate the Idown (F_on) values and their error bars and
;           store them in the
;
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;           The flipper on value.

    ;self->addTreatment,'ooEchoMagnetic::chirpIdown'
;help,/traceback
    ;APPLY 1D MASK HERE

    ;GET ALL OF THE CHIRP VALUES
    ;NOTE: FOR TIME-AVERAGED Up/Down DATA, THE AVERAGED DATA ARE STORED IN THE
    ;      DATA THAT chirpAll RETURNS, SO THERE IS NO NEED TO SUM IT ALL UP HERE.
    ;      HOWEVER, IF YOU WANT THE ERROR BARS TO BE CORRECT YOU NEED TO GET THE 
    ;      NUMBER OF CONTRIBUTING POINTS BELOW.
    yarr = self->chirpAll(xind,yind,tauind)

    ;GET THE MASK VALUES
    ymask = self->getMask1D(tauind)

    ;CREATE AN ARRAY OF THE UNMASKED VALUES
    meanarr = [0]

;1) GET tAve state:
    if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()
;2) Get masking in t direction for each pixel used
;    if tavestate eq 1 then begin
;      print,'ooEchoMagnetic::chirpIdown'
;      help,*self.e
;      help,*self.emask      
;    endif
  
;3) Create a t-averaged Iup value
;4) Calculate the error bars properly based on the 
;number of pixels actually used.  


    nContrib = self->getNumberOfUpDownContributingPoints(xind,yind,tauind,tavestate=tavestate)

    

    if self.magnetic eq 0 then begin

        ;042505
        ;ADD THE NEXT STATEMENT TO ALLOW FOR Iup,Idown TO BE IN
        ;EITHER ORDER IN THE DATA
        i1 = self.point_to_down
        if self.point_to_down lt self.point_to_up then begin
            i2 = self.point_to_up-1
        endif else begin
            i2 = self.no_of_phases-1
        endelse
        for i=i1,i2 do begin;self.point_to_down,self.point_to_up-1 do begin
            if ymask[i] ne 0 then begin
                meanarr = [meanarr,yarr[i]]
            endif
        endfor;i
        if n_elements(meanarr) gt 1 then begin
            meanarr = meanarr[1:*]
            ydown = mean(meanarr)
            if n_elements(meanarr) gt 1 then begin
                ;051305
                ;THE FOLLOWING LINE HAS BEEN CHANGED TO MATCH THE IGOR EB CALCULATIONS
                sydown = sqrt(total(meanarr))/n_elements(meanarr);stddev(meanarr)
            endif else begin
                sydown = sqrt(ydown)
            endelse
            ;031708
            ;ADJUST ERROR BARS BASED ON THE ACTUAL NUMBER OF POINTS USED TO 
            ;COMPUTE THE AVERAGE VALUES 
            if tavestate eq 1 then sydown = sydown/sqrt(nContrib[0])
        endif else begin
            ydown = 0.0
            sydown = 1.0
        endelse


        ;GET MEAN VALUES OF UP AND DOWN
    ;;;;;    ydown = mean(ysdown1d)
    ;;;;;    sydown = stddev(ysdown1d)

    endif else begin    ;MAGNETIC

        ;print,'INSERT MAGNETIC Idown CODE HERE.'
        ;print,'PROBABLY THIS WILL JUST SET THE VALUE TO 0.0, BUT WE WILL SEE.'

        ;print,'PLACE MAGNETIC yup CODE HERE FOR ooEchoMagnetic::chirpIup'
        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]

        ;print,'x_up'
        ret = self->helpChirpIup_downXYZ(self.point_to_up_x,xind,yind,tauind)
        xup = ret[0] & sxup = ret[1]
        ;print,'x_down'
        ret = self->helpChirpIup_downXYZ(self.point_to_down_x,xind,yind,tauind)
        xdown = ret[0] & sxdown = ret[1]

        ;print,'y_up'
        ret = self->helpChirpIup_downXYZ(self.point_to_up_y,xind,yind,tauind)
        yup = ret[0] & syup = ret[1]
        ;print,'y_down'
        ret = self->helpChirpIup_downXYZ(self.point_to_down_y,xind,yind,tauind)
        ydown = ret[0] & sydown = ret[1]

        ;print,'z_up'
        ret = self->helpChirpIup_downXYZ(self.point_to_up_z,xind,yind,tauind)
        zup = ret[0] & szup = ret[1]
        ;print,'z_down'
        ret = self->helpChirpIup_downXYZ(self.point_to_down_z,xind,yind,tauind)
        zdown = ret[0] & szdown = ret[1]

;031708
;ADJUST ERROR BARS BASED ON THE ACTUAL NUMBER OF POINTS USED TO 
;COMPUTE THE AVERAGE VALUES 
if tavestate eq 1 then begin
  sxdown = sxdown/sqrt(nContrib[0])
  sxup = sxup/sqrt(nContrib[1])
  sydown = sydown/sqrt(nContrib[2])
  syup = syup/sqrt(nContrib[3])
  szdown = szdown/sqrt(nContrib[4])
  szup = szup/sqrt(nContrib[5])
endif






;        denom = (xup+xdown+yup+ydown+zup+zdown)/3.0 ;=M+N
;        sdenom = sqrt((sxup)^2.0+(sxdown)^2.0 $
;                      +(syup)^2.0+(sydown)^2.0 $
;                      +(szup)^2.0+(szdown)^2.0)/3.0
;
;        fmp_2 = 2*zup - xup - yup
;        sfmp_2 = sqrt((sxup)^2.0 + (syup)^2.0 + (2.0*szup)^2.0)
;
;        mp_2  = xdown + ydown - 2*zdown
;        smp_2 = sqrt((sxdown)^2.0 + (sydown)^2.0 + (2.0*szdown)^2.0)
;
;        ;f = fmp_2/mp_2
;        ;HOW DO I SOLVE FOR M?  WHAT ARE p AND f?????
;
;        ;I THINK ANTONIO MUST ENTER THESE VALUES MANUALLY.
;        ;THEY SHOULD BE ACCESSIBLE FROM AN nse PARAMETERS FILE.
;
;;
;;I ONLY NEED self.f or self.p TO MAKE THE NEXT LINES WORK.
;;
;        M = mp_2/self.p
;        sM = smp_2/self.p
;
;
;;I CAN DETERMINE f THIS WAY:
;
;
;        self.f = fmp_2/(mp_2)
;
;        result = 0.5*M/denom
;        sresult = 0.5*sqrt(sM^2.0 + (sdenom*M/denom^2.0)^2.0 )
;

;110305
;REPLACE THE ABOVE CALCULATION WITH THE EXTENSIVE VALUES FROM HERE DOWN:


;111605
;need to update the next few lines with separate eff_bpw for x,y, and z



;11/30/07
;self.xyzupdownscale IS APPLIED IN THE METHOD self->chirpAll(xind,yind,tauind)
;WHICH IS CALLED IN self->helpChirpIup_downXYZ(self.point_to_down_z,xind,yind,tauind)
;
;THE CALL IS NEEDED THERE BECAUSE OTHER METHODS GRAB THE DATA FOR CALCULATION
;OR DISPLAY AND NEED THE ALREADY-SCALED DATA.
;
;
;BECAUSE OF THAT APPLICATION, self.xyzupdownscale IS DOUBLE APPLIED HERE!!!!!!!!
;REMOVE IT HERE!!!!! (ALSO IN self->chirpIUp(-----))


;        xx = self.xyzupdownscale*(xup-xdown)/(self.p*self.eff_bpw*(self.f+1.0))
;        sxx = self.xyzupdownscale*sqrt(sxup^2.0 + sxdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
;        yy = self.xyzupdownscale*(yup-ydown)/(self.p*self.eff_bpw*(self.f+1.0))
;        syy = self.xyzupdownscale*sqrt(syup^2.0 + sydown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
;        zz = self.xyzupdownscale*(zup-zdown)/(self.p*self.eff_bpw*(self.f+1.0))
;        szz = self.xyzupdownscale*sqrt(szup^2.0 + szdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        xx = (xup-xdown)/(self.p*self.eff_bpw*(self.f+1.0))
        sxx = sqrt(sxup^2.0 + sxdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        yy = (yup-ydown)/(self.p*self.eff_bpw*(self.f+1.0))
        syy = sqrt(syup^2.0 + sydown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        zz =(zup-zdown)/(self.p*self.eff_bpw*(self.f+1.0))
        szz = sqrt(szup^2.0 + szdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))

;;121405
;        xx = self.xyzupdownscale*(xup-xdown)/(self.p*self.eff_bpw_x*(self.f+1.0))
;        sxx = self.xyzupdownscale*sqrt(sxup^2.0 + sxdown^2.0)/(self.p*self.eff_bpw_x*(self.f+1.0))
;        yy = self.xyzupdownscale*(yup-ydown)/(self.p*self.eff_bpw_y*(self.f+1.0))
;        syy = self.xyzupdownscale*sqrt(syup^2.0 + sydown^2.0)/(self.p*self.eff_bpw_y*(self.f+1.0))
;        zz = self.xyzupdownscale*(zup-zdown)/(self.p*self.eff_bpw_z*(self.f+1.0))
;        szz = self.xyzupdownscale*sqrt(szup^2.0 + szdown^2.0)/(self.p*self.eff_bpw_z*(self.f+1.0))
;
        SC4 = 4.0*zz - 2.0*xx - 2.0*yy
        sSC4 = sqrt((2.0*sxx)^2.0 + (2.0*syy)^2.0 +(4.0*szz)^2.0)


        ;
        ;SINCE WE ONLY DEAL WITH Idown-Iup IN THE CALCULATIONS NORMALLY,
        ;I CAN STORE THE TOTAL MAGNETIC NORMALIZATION FACTOR IN THE
        ;Iup OR Idown VARIABLES.
        ;
        ;THE ONLY ISSUE I CAN SEE HERE IS THAT ooDisplayEcho MAY REQUIRE
        ;BOTH Idown AND Iup.
        ;
        ;

        MagInt = SC4/2.0
        sMagInt = sSC4/2.0

        ;if result lt 0.0 then result = -1.0*result
        ydown = self->chirpOffset(xind,yind,tauind) + MagInt/2.0
        sydown = sMagInt/2.0


    endelse

    (*self.Idown)[xind+yind*self.x_dim,tauind] = ydown
    (*self.sIdown)[xind+yind*self.x_dim,tauind] = sydown
    
    
    
    
;print,'Idown'
;print,xup
;print,xdown
;print,yup
;print,ydown
;print,zup
;print,zdown

    return,ydown
end;chirpIdown
function ooEchoMagnetic::chirpIup,xind,yind,tauind,tavestate=tavestate
;
;NAME:
;        ooEchoMagnetic::chirpIup
;
;PURPOSE:
;           Return the Iup (flipper off) value
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;       The Iup (flipper off) value at this pixel

;if tauind gt 10 then print,*p
    ;GET ALL OF THE CHIRP VALUES
    yarr = self->chirpAll(xind,yind,tauind)

    ;GET THE MASK VALUES
    ymask = self->getMask1D(tauind)

    ;CREATE AN ARRAY OF THE UNMASKED VALUES
    meanarr = [0.0]

;help,/traceback
;1) GET tAve state:
    if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()
;2) Get masking in t direction for each pixel used
;    if tavestate eq 1 then begin
;      print,'ooEchoMagnetic::chirpIup'
;      help,'e',*self.e,min(*self.e),max(*self.e)
;      help,'emask',*self.emask,min(*self.emask),max(*self.emask)      
;      help,*self.mask1d
;      help,*self.mask2d
;      help,self.no_of_fourier_times
;      ;*self.mask2d
;      
;
;    endif
  
;3) Create a t-averaged Iup value



;4) Calculate the error bars properly based on the 
;number of pixels actually used.  

;Note: Check what ooEcho::chirpExtrema does.  Is it doing and average?

    nContrib = self->getNumberOfUpDownContributingPoints(xind,yind,tauind,tavestate=tavestate)



    if self.magnetic eq 0 then begin
        ;042505
        ;ADD THE NEXT STATEMENT TO ALLOW FOR Iup,Idown TO BE IN
        ;EITHER ORDER IN THE DATA
        i1 = self.point_to_up
        if self.point_to_up lt self.point_to_down then begin
            i2 = self.point_to_down-1
        endif else begin
            i2 = self.no_of_phases-1
        endelse


        for i=i1,i2 do begin;self.point_to_up,self.no_of_phases-1 do begin
            if ymask[i] ne 0 then begin
                meanarr = [meanarr,yarr[i]]
            endif
        endfor;i

        ;GET MEAN VALUES OF UP AND DOWN
        if n_elements(meanarr) gt 1 then begin
            meanarr = meanarr[1:*]
            yup = mean(meanarr)
            if n_elements(meanarr) gt 1 then begin
        
;012908  
;THIS IS WHERE I NEED TO MODIFY THE ERROR BAR CALCULATION FOR TIME AVERAGING
;NON-MAGNETIC SYSTEMS
    
    
                ;051305
                ;THE FOLLOWING LINE HAS BEEN CHANGED TO MATCH THE IGOR EB CALCULATIONS
                syup = sqrt(total(meanarr))/n_elements(meanarr);stddev(meanarr)
            endif else begin
                syup = sqrt(yup)
            endelse
            ;031708
            ;ADJUST ERROR BARS BASED ON THE ACTUAL NUMBER OF POINTS USED TO 
            ;COMPUTE THE AVERAGE VALUES 
            if tavestate eq 1 then syup = syup/sqrt(nContrib[1])
        endif else begin
            yup = 0.0
            syup = 1.0
        endelse
    endif else begin    ;MAGNETIC eq 1

        ;print,'PLACE MAGNETIC yup CODE HERE FOR ooEchoMagnetic::chirpIup'
        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]

;print,'ooEchoMagnetic::chirpIup'
t0 = systime(1,/seconds)
        ;print,'x_up'


;        
;012908  
;FOR MAGNETIC SYSTEMS I NEED TO MODIFY THE ERROR BAR CALCULATION 
;INSIDE helpChirpIup_downXYZ
;

;print,systime(1,/seconds)-t0
        ret = self->helpChirpIup_downXYZ(self.point_to_up_x,xind,yind,tauind)
;print,systime(1,/seconds)-t0
        xup = ret[0] & sxup = ret[1]
        ;print,'x_down'
        ret = self->helpChirpIup_downXYZ(self.point_to_down_x,xind,yind,tauind)
        xdown = ret[0] & sxdown = ret[1]

        ;print,'y_up'
        ret = self->helpChirpIup_downXYZ(self.point_to_up_y,xind,yind,tauind)
        yup = ret[0] & syup = ret[1]
        ;print,'y_down'
        ret = self->helpChirpIup_downXYZ(self.point_to_down_y,xind,yind,tauind)
        ydown = ret[0] & sydown = ret[1]

        ;print,'z_up'
        ret = self->helpChirpIup_downXYZ(self.point_to_up_z,xind,yind,tauind)
        zup = ret[0] & szup = ret[1]
        ;print,'z_down'
        ret = self->helpChirpIup_downXYZ(self.point_to_down_z,xind,yind,tauind)
        zdown = ret[0] & szdown = ret[1]

;031708
;ADJUST ERROR BARS BASED ON THE ACTUAL NUMBER OF POINTS USED TO 
;COMPUTE THE AVERAGE VALUES 
if tavestate eq 1 then begin
  sxdown = sxdown/sqrt(nContrib[0])
  sxup = sxup/sqrt(nContrib[1])
  sydown = sydown/sqrt(nContrib[2])
  syup = syup/sqrt(nContrib[3])
  szdown = szdown/sqrt(nContrib[4])
  szup = szup/sqrt(nContrib[5])
endif



;        denom = (xup+xdown+yup+ydown+zup+zdown)/3.0 ;=M+N
;        sdenom = sqrt((sxup)^2.0+(sxdown)^2.0 $
;                      +(syup)^2.0+(sydown)^2.0 $
;                      +(szup)^2.0+(szdown)^2.0)/3.0
;
;        fmp_2 = 2*zup - xup - yup
;        sfmp_2 = sqrt((sxup)^2.0 + (syup)^2.0 + (2.0*szup)^2.0)
;
;        mp_2  = xdown + ydown - 2*zdown
;        smp_2 = sqrt((sxdown)^2.0 + (sydown)^2.0 + (2.0*szdown)^2.0)
;
;        ;f = fmp_2/mp_2
;        ;HOW DO I SOLVE FOR M?  WHAT ARE p AND f?????
;
;        ;I THINK ANTONIO MUST ENTER THESE VALUES MANUALLY.
;        ;THEY SHOULD BE ACCESSIBLE FROM AN nse PARAMETERS FILE.
;
;;
;;I ONLY NEED self.f or self.p TO MAKE THE NEXT LINES WORK.
;;
;        M = mp_2/self.p
;        sM = smp_2/self.p
;
;
;;I CAN DETERMINE f THIS WAY:
;        self.f = fmp_2/(mp_2)
;
;        result = 0.5*M/denom
;        sresult = 0.5*sqrt(sM^2.0 + (sdenom*M/denom^2.0)^2.0 )
;
;        ;
;        ;SINCE WE ONLY DEAL WITH Idown-Iup IN THE CALCULATIONS NORMALLY,
;        ;I CAN STORE THE TOTAL MAGNETIC NORMALIZATION FACTOR IN THE
;        ;Iup OR Idown VARIABLES.
;        ;
;        ;THE ONLY ISSUE I CAN SEE HERE IS THAT ooDisplayEcho MAY REQUIRE
;        ;BOTH Idown AND Iup.
;        ;
;        ;


;111605
;need to update the next few lines with separate eff_bpw for x,y, and z


;11/30/07
;self.xyzupdownscale IS APPLIED IN THE METHOD self->chirpAll(xind,yind,tauind)
;WHICH IS CALLED IN self->helpChirpIup_downXYZ(self.point_to_down_z,xind,yind,tauind)
;
;THE CALL IS NEEDED THERE BECAUSE OTHER METHODS GRAB THE DATA FOR CALCULATION
;OR DISPLAY AND NEED THE ALREADY-SCALED DATA.
;
;
;BECAUSE OF THAT APPLICATION, self.xyzupdownscale IS DOUBLE APPLIED HERE!!!!!!!!
;REMOVE IT HERE!!!!!
;        xx = self.xyzupdownscale*(xup-xdown)/(self.p*self.eff_bpw*(self.f+1.0))
;        sxx = self.xyzupdownscale*sqrt(sxup^2.0 + sxdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
;        yy = self.xyzupdownscale*(yup-ydown)/(self.p*self.eff_bpw*(self.f+1.0))
;        syy = self.xyzupdownscale*sqrt(syup^2.0 + sydown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
;        zz = self.xyzupdownscale*(zup-zdown)/(self.p*self.eff_bpw*(self.f+1.0))
;        szz = self.xyzupdownscale*sqrt(szup^2.0 + szdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        xx = (xup-xdown)/(self.p*self.eff_bpw*(self.f+1.0))
        sxx = sqrt(sxup^2.0 + sxdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        yy = (yup-ydown)/(self.p*self.eff_bpw*(self.f+1.0))
        syy = sqrt(syup^2.0 + sydown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        zz = (zup-zdown)/(self.p*self.eff_bpw*(self.f+1.0))
        szz = sqrt(szup^2.0 + szdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))


;;121405
;        xx = self.xyzupdownscale*(xup-xdown)/(self.p*self.eff_bpw_x*(self.f+1.0))
;        sxx = self.xyzupdownscale*sqrt(sxup^2.0 + sxdown^2.0)/(self.p*self.eff_bpw_x*(self.f+1.0))
;        yy = self.xyzupdownscale*(yup-ydown)/(self.p*self.eff_bpw_y*(self.f+1.0))
;        syy = self.xyzupdownscale*sqrt(syup^2.0 + sydown^2.0)/(self.p*self.eff_bpw_y*(self.f+1.0))
;        zz = self.xyzupdownscale*(zup-zdown)/(self.p*self.eff_bpw_z*(self.f+1.0))
;        szz = self.xyzupdownscale*sqrt(szup^2.0 + szdown^2.0)/(self.p*self.eff_bpw_z*(self.f+1.0))


        SC4 = 4.0*zz - 2.0*xx - 2.0*yy

;if xind eq 2 and yind eq 1 and tauind eq 0 then print,xind,yind,tauind,SC4

        sSC4 = sqrt((2.0*sxx)^2.0 + (2.0*syy)^2.0 +(4.0*szz)^2.0)


        ;
        ;SINCE WE ONLY DEAL WITH Idown-Iup IN THE CALCULATIONS NORMALLY,
        ;I CAN STORE THE TOTAL MAGNETIC NORMALIZATION FACTOR IN THE
        ;Iup OR Idown VARIABLES.
        ;
        ;THE ONLY ISSUE I CAN SEE HERE IS THAT ooDisplayEcho MAY REQUIRE
        ;BOTH Idown AND Iup.
        ;
        ;

        MagInt = SC4/2.0
        ;print,*p
;if xind eq 2 and yind eq 1 and tauind eq 0 then begin
;    print,xind,yind,tauind,MagInt
;    print,self.point_to_down_x
;    print,self.point_to_up_x
;    print,self.point_to_down_y
;    print,self.point_to_up_y
;    print,self.point_to_down_z
;    print,self.point_to_up_z
;    print,self.xyzupdownscale*(xup-xdown)
;    print,self.xyzupdownscale*(yup-ydown)
;    print,self.xyzupdownscale*(zup-zdown)
;endif


        sMagInt = sSC4/2.0
;if (yind*self.x_dim + xind) eq 36 then print,'xind,yind,tauind,MagInt=',xind,yind,tauind,MagInt
        ;if result lt 0.0 then result = -1.0*result
;print,'a',systime(1,/seconds)-t0
        yup = self->chirpOffset(xind,yind,tauind) - MagInt/2.0
;print,'b',systime(1,/seconds)-t0
        syup = sMagInt/2.0


    endelse

    ;NOW I HAVE yup CORRECTLY CALULATED REGARDLESS OF Tave, BUT NOW
    ;I NEED syup:
    ;
    ;BASICALLY I NEED TO COUNT HOW MANY POINTS WERE INCLUDED IN THE 
    ;AVERAGE AND DIVIDE syup BY sqrt(THAT NUMBER) IF tave IS DONE!!!



    (*self.Iup)[xind+yind*self.x_dim,tauind] = yup
    (*self.sIup)[xind+yind*self.x_dim,tauind] = syup
    

    return,yup
end;chirpIup
function ooEchoMagnetic::helpChirpIup_downXYZ,pt,xind,yind,tauind


        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]

    yarr = self->chirpAll(xind,yind,tauind)
    ymask = self->getMask1D(tauind)
    meanarr = [0.0]



        i1 = pt
        wh = where(steps gt pt)
;print,'ooEchoMagnetic::helpChirpIup_downXYZ',wh

        if wh[0] eq -1 then begin
            i2 = self.no_of_phases  ;i2 = self.no_of_phases-1
        endif else begin
            i2 = steps(wh[0])
        endelse


;THIS ACCOUNTS FOR THE MASKING.
        for i=i1,i2-1 do begin
            if ymask[i] ne 0 then begin
                meanarr = [meanarr,yarr[i]]
            endif
        endfor;i

        ;GET MEAN VALUES OF UP AND DOWN
        if n_elements(meanarr) gt 1 then begin
            meanarr = meanarr[1:*]
            yup = total(meanarr)/double(n_elements(meanarr))
            ;yup = mean(meanarr)
;help,yup
            if n_elements(meanarr) gt 1 then begin
                syup = sqrt(total(meanarr))/double(n_elements(meanarr));stddev(meanarr)
            endif else begin
                syup = sqrt(yup)
            endelse
        endif else begin
            yup = 0.0
            syup = 1.0
        endelse

    return,[yup,syup]
end;helpChirpIup_downXYZ
function ooEchoMagnetic::helpChirpIup_downXYZArray,pt,tauind
;RETURN AN ARRAY CONTAINING THE xyxUp/down values for a tauind
print,'ooEchoMagnetic::helpChirpIup_downXYZArray'
        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]

        e = *self.e

        sz = size(e)

        ymask = self->getMask1D(tauind)


        meanarr = [0.0]

        i1 = pt
        wh = where(steps gt pt)
        if wh[0] eq -1 then begin
            i2 = self.no_of_phases-1
        endif else begin
            i2 = steps(wh[0])-1
        endelse

        ymask_needed = ymask[i1:i2]

        e_needed = e[*,i1:i2,tauind]

        wh_mask = where(ymask_needed lt 1,count)
        if count gt 0 then begin
            for i=0,count-1 do begin
                e_needed[*,wh_mask[i],*] = 0.0
            endfor;i
        endif

        if i2-i1-count gt 0 then begin
            e_mean = total(e_needed,2)/(i2-i1-count)
        endif else begin
            e_mean = dblarr(sz[1])
        endelse


    return,e_mean
end;helpChirpIup_downXYZArray

function ooEchoMagnetic::helpChirpIup_downXYZArray_eb,pt,tauind


        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]

        e = double(*self.e)

        sz = size(e)


        ymask = self->getMask1D(tauind)


        meanarr = [0.0]

        i1 = pt
        wh = where(steps gt pt)
        if wh[0] eq -1 then begin
            i2 = self.no_of_phases-1
        endif else begin
            i2 = steps(wh[0])-1
        endelse

        ymask_needed = ymask[i1:i2]

        e_needed = e[*,i1:i2,tauind]

        wh_mask = where(ymask_needed lt 1,count)
        if count gt 0 then begin
            for i=0,count-1 do begin
                e_needed[*,wh_mask[i],*] = 0.0
            endfor;i
        endif

        if i2-i1-count gt 0 then begin
            e_mean_eb = sqrt(total(e_needed^2.0,2))/(i2-i1-count)
        endif else begin
            e_mean_eb = 1.0 + dblarr(sz[1])
        endelse

    return,e_mean_eb
end;helpChirpIup_downXYZArray_eb


function ooEchoMagnetic::threeMplusNoverSix,xind,yind,tauind
;
;NAME:
;        ooEchoMagnetic::threeMplusNoverSix
;

;PURPOSE:
;           Return 3*(M+N) as a check to see that this is 2*(echo average)
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;       [3*(M+N).error bar]


    ;GET ALL OF THE CHIRP VALUES
    yarr = self->chirpAll(xind,yind,tauind)

    ;GET THE MASK VALUES
    ymask = self->getMask1D(tauind)

    ;CREATE AN ARRAY OF THE UNMASKED VALUES
    meanarr = [0.0]

    if self.magnetic eq 1 then begin
        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]


        ret = self->helpChirpIup_downXYZ(self.point_to_up_x,xind,yind,tauind)
        xup = ret[0] & sxup = ret[1]

        ret = self->helpChirpIup_downXYZ(self.point_to_down_x,xind,yind,tauind)
        xdown = ret[0] & sxdown = ret[1]


        ret = self->helpChirpIup_downXYZ(self.point_to_up_y,xind,yind,tauind)
        yup = ret[0] & syup = ret[1]

        ret = self->helpChirpIup_downXYZ(self.point_to_down_y,xind,yind,tauind)
        ydown = ret[0] & sydown = ret[1]

        ret = self->helpChirpIup_downXYZ(self.point_to_up_z,xind,yind,tauind)
        zup = ret[0] & szup = ret[1]

        ret = self->helpChirpIup_downXYZ(self.point_to_down_z,xind,yind,tauind)
        zdown = ret[0] & szdown = ret[1]



        MplusNoverSix = (xup+xdown+yup+ydown+zup+zdown)/6.0 ;=M+N
        sMplusNoverSix = sqrt((sxup)^2.0+(sxdown)^2.0 $
                        +(syup)^2.0+(sydown)^2.0 $
                        +(szup)^2.0+(szdown)^2.0)/6.0

        result = [MplusNoverSix,sMplusNoverSix]
        ;print,result
                        ;120105
                        ;THE SCALE FACTOR IS APPLIED IN ooEchoMagnetic::chirpAll
        result=result   ;*self.xyzupdownscale
        ;print,result
    endif else begin
        result = [0.0,0.0]
    endelse

    return,result
end;ThreeMPlusNoverSix




function ooEchoMagnetic::startParms,i,j,k,fixed=fixed,$
                                startparms=startparms,$
                                sigma=sigma,$
                                hydrogenated=hydrogenated,$
                                noborrow=noborrow,tavestate=tavestate,_Extra=extra
;
;NAME:
;        ooEcho::startParms
;
;PURPOSE:
;        Get approximate starting parameters for fitting.
;PARAMETERS:
;       i
;       j
;       k
;KEYWORDS:
;       fixed
;       startparms
;       sigma
;       hydrogenated
;RETURN VALUE:
;       the starting parameters.

    ;self->addTreatment,'ooEcho::startparms'

    ;PRODUCE A SET OF PARAMETERS TO BEGIN FITTING
    ;FOR EACH INDIVIDUAL ECHO

    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(noborrow) eq 0 then noborrow = 0
    if n_elements(hydrogenated) eq 0 then hydrogenated = 0

    ;GET SOME INFORMATION FROM THE DATA

    x = self->chirpPhases(k)
    y = self->chirp(i,j,k)
    sy= sqrt(y)


;083105
;CHECKING FOR HYDROGENATED SAMPLES.
;PLACING THIS HERE MAY ELIMINATE THE NEED FOR
;Iup,down CALCULATIONS IN THE INDIVIDUAL
;chirpFit METHODS.

    if self.magnetic ne 0 then begin
        hydrogenated = 0
    endif else begin
        dum_up = self->chirpIup(i,j,k,tavestate=tavestate);xind,yind,tauind)
        dum_down = self->chirpIdown(i,j,k,tavestate=tavestate);xind,yind,tauind)
        if dum_up gt dum_down then begin
            hydrogenated = 1
        endif else hydrogenated = 0
    endelse


    ;CALCULATE AMPLITUDE STARTING POINT
    if (n_elements(fixed) gt 0) then begin
        if(fixed[1] eq 1 and n_elements(startparms) gt 0) then begin
            ampStart = startparms[1]
        endif else begin
            ampstart = (*self.fitparms)[1,self.x_dim*j+i,k]
        endelse
    endif else begin
        ampStart = self->chirpAmplitude(i,j,k,hydrogenated=hydrogenated,tavestate=tavestate)
    endelse


    if hydrogenated eq 1 then begin
        if ampstart gt 0.0 then ampstart = -1.0*ampstart
    endif

    ;CALCULATE OFFSET STARTING POINT
    if (n_elements(fixed) gt 0) then begin
        if(fixed[0] eq 1 and n_elements(startparms) gt 0) then begin
            offsetStart = startparms[0]
        endif else begin
            offsetStart = (*self.fitparms)[0,self.x_dim*j+i,k]
        endelse
    endif else begin
        offsetStart = self->chirpOffset(i,j,k,hydrogenated=hydrogenated)
    endelse

    if noborrow eq 0 then begin
        ;SELECT A POSSIBILITY FOR THE PHASE
        if (n_elements(fixed) gt 0) then begin
            if(fixed[2] eq 1 and n_elements(startparms) gt 0) then begin
                phaseStart = startparms[2]
            endif else begin
                phaseStart = (*self.fitparms)[2,self.x_dim*j+i,k]
            endelse
        endif else begin
            if hydrogenated eq 1 then begin
                dum = max(y,phaseStartIndex)
            endif else begin
                dum = min(y,phaseStartIndex)
            endelse
            phaseStart = x[phaseStartIndex]
            ;print,'phaseStart = ',phaseStart
        endelse
    endif

    if (n_elements(fixed) gt 0) then begin
        if(fixed[4] eq 1 and n_elements(startparms) gt 0) then begin
            omegaStart = startparms[4]
        endif else begin
            omegaStart = (*self.fitparms)[4,self.x_dim*j+i,k]
        endelse
    endif else begin
        omegaStart = 360.0/360.0
    endelse


    if n_elements(sigma) eq 0 then begin
        if (n_elements(fixed) gt 0) then begin
            if(fixed[4] eq 1 and n_elements(startparms) gt 0) then begin
                sigmaStart = startparms[3]
            endif else begin
                sigmaStart = (*self.fitparms)[3,self.x_dim*j+i,k]
            endelse
        endif else begin
            sigmaStart = 702.0
        endelse
    endif else begin
        sigmaStart = sigma
    endelse

;    if i*j*k eq 1 then print,'sigmaStart = ',sigmaStart

    if (n_elements(fixed) gt 0) then begin
        if(fixed[5] eq 1 and n_elements(startparms) gt 0) then begin
            ;IF startparms ARE PASSED AND PARM IS FIXED USE THAT ONE
            dphaseStart = startparms[5]
        endif else begin
            ;IF startparms ARE NOT PASSED AND NOT FIXED,
            ;USE CURRENT VALUE IN ARRAY
            dphaseStart = (*self.fitparms)[5,self.x_dim*j+i,k]
        endelse
    endif else begin
        ;
        dphaseStart = 0.0
    endelse

    parms = [offsetStart, ampStart, phaseStart, sigmaStart, omegaStart,dphaseStart]
    (*self.fitparms)[0:5,self.x_dim*j+i,k] = parms

    return,parms
end;startParms

;
;###############################################################################

pro ooEchoMagnetic::setProperty,tag,value,_Extra=extra

    tag0 = tag
    tag = strupcase(tag)

    case tag of
    'MAGNETIC':begin
        self.magnetic = value
    end;MAGNETIC
    'EXTENSIONS':begin
        self.extensions = value
    end;EXTENSIONS
    'P':begin
        self.p = value
    end;P
    'F':begin
        self.f = value
    end;F
    'EFF_BPW':begin
        self.eff_bpw = value
    end;EFF_BPW
;    'EFF_BPW_X':begin
;        self.eff_bpw_x = value
;    end;EFF_BPW_X
;    'EFF_BPW_Y':begin
;        self.eff_bpw_y = value
;    end;EFF_BPW_Y
;    'EFF_BPW_Z':begin
;        self.eff_bpw_z = value
;    end;EFF_BPW_Z
    'XYZUPDOWNSCALE':begin
        self.XYZUPDOWNSCALE = value
    end;XYZUPDOWNSCALE
    'POINT_TO_UP_X':begin
        self.point_to_up_x = value
    end;POINT_TO_UP_X
    'POINT_TO_DOWN_X':begin
        self.point_to_down_x = value
    end;POINT_TO_DOWN_X
    'POINT_TO_UP_Y':begin
        self.point_to_up_y = value
    end;POINT_TO_UP_Y
    'POINT_TO_DOWN_Y':begin
        self.point_to_down_y = value
    end;POINT_TO_DOWN_Y
    'POINT_TO_UP_Z':begin
        self.point_to_up_z = value
    end;POINT_TO_UP_Z
    'POINT_TO_DOWN_Z':begin
        self.point_to_down_z = value
    end;POINT_TO_DOWN_Z
    'MASK1DPIXELS':begin
        self.mask1dpixels = value
    end;MASK1DPIXELS
;DON'T ALLOW USER ACCESS TO MODIFY tags.
;    'MAGTAGS':begin
;        self.magtags = value
;    end;MAGTAGS
    else:begin

        self->ooEcho::setProperty,tag0,value
    end
    endcase


end;setProperty

function ooEchoMagnetic::getProperty,tag=tag,_Extra=extra

    if n_elements(tag) eq 0 then tag = ''

    tag0 = tag
    tag = strupcase(tag)

    case tag of
    'MAGNETIC':begin
        return,self.magnetic
    end
    'P':begin
        return,self.p
    end;P
    'F':begin
        return,self.f
    end;F
    'EFF_BPW':begin
        return,self.eff_bpw
    end;EFF_BPW
;    'EFF_BPW_X':begin
;        return,self.eff_bpw_x
;    end;EFF_BPW
;    'EFF_BPW_Y':begin
;        return,self.eff_bpw_y
;    end;EFF_BPW
;    'EFF_BPW_Z':begin
;        return,self.eff_bpw_z
;    end;EFF_BPW_Z
;
    'XYZUPDOWNSCALE':begin
        return,self.XYZUPDOWNSCALE
    end;XYZUPDOWNSCALE
    'EXTENSIONS':begin
        return,self.extensions
    end;EXTENSIONS
    'POINT_TO_UP_X':begin
        return,self.point_to_up_x
    end;POINT_TO_UP_X
    'POINT_TO_DOWN_X':begin
        return,self.point_to_down_x
    end;POINT_TO_DOWN_X
    'POINT_TO_UP_Y':begin
        return,self.point_to_up_y
    end;POINT_TO_UP_Y
    'POINT_TO_DOWN_Y':begin
        return,self.point_to_down_y
    end;POINT_TO_DOWN_Y
    'POINT_TO_UP_Z':begin
        return,self.point_to_up_z
    end;POINT_TO_UP_Z
    'POINT_TO_DOWN_Z':begin
        return,self.point_to_down_z
    end;POINT_TO_DOWN_Z
    'MASK1DPIXELS':begin
        return,self.mask1dpixels
    end;MASK1DPIXELS
    'MAGTAGS':begin
        return,self.magtags
    end;MAGTAGS
;    'TAGS':begin
;        tags = self->ooEcho::getproperty(tag='tags')
;        return,[tags,self.magtags]
;    end;TAGS
    else:begin
        return, self->ooEcho::getProperty(tag=tag0)
    end
    endcase

end;getProperty
pro ooEchoMagnetic::cleanup
    ;print,'ooEchoMagnetic::Cleanup'
    if ptr_valid(self.extensions) gt 0 then ptr_free,self.extensions
    if ptr_valid(self.mask1dpixels) gt 0 then ptr_free,self.mask1dpixels
    self->ooEcho::cleanup

end;cleanup
pro ooEchoMagnetic::cloneSetMagnetic,obj,modtime=modtime
;THIS WILL DO THE PARTS OF CLONING UNAVAILABLE IN ooEcho::cloneSet.
        if n_elements(modtime) eq 0 then modtime = 0

        self.magnetic = obj->getproperty(tag='magnetic')
        self.p = obj->getproperty(tag='p')
        self.f = obj->getproperty(tag='f')
        self.eff_bpw =  obj->getproperty(tag='eff_bpw')

;        if modtime gt 1134604600.0d then begin
;            self.eff_bpw_x =  obj->getproperty(tag='eff_bpw_x')
;            self.eff_bpw_y =  obj->getproperty(tag='eff_bpw_y')
;            self.eff_bpw_z =  obj->getproperty(tag='eff_bpw_z')
;        endif

        self.xyzupdownscale = obj->getproperty(tag='xyzupdownscale')
        self.point_to_up_x=obj->getproperty(tag='point_to_up_x')
        self.point_to_up_y=obj->getproperty(tag='point_to_up_y')
        self.point_to_up_z=obj->getproperty(tag='point_to_up_z')
        self.point_to_down_x=obj->getproperty(tag='point_to_down_x')
        self.point_to_down_y=obj->getproperty(tag='point_to_down_y')
        self.point_to_down_z=obj->getproperty(tag='point_to_down_z')
        self->checkAndUpdateExtensionsPtr,extensions = obj->getproperty(tag='extensions')
end;cloneSetMagnetic
pro ooEchoMagnetic::blankObjMagnetic
        self.p = 1.0
        self.f = 1.0
        self.eff_bpw = 1.0
;        self.eff_bpw_x = 0.81
;        self.eff_bpw_y = 0.81
;        self.eff_bpw_z = 0.81


        self.xyzupdownscale = 1.0
        self.point_to_down_x=self.no_of_phases-12
        self.point_to_up_x=self.no_of_phases-10
        self.point_to_down_z=self.no_of_phases-8
        self.point_to_up_z=self.no_of_phases-6
        self.point_to_down_y=self.no_of_phases-4
        self.point_to_up_y=self.no_of_phases-2

        ;LRK - 05/22/09
        self->checkAndUpdateExtensionsPtr
end;blankObjMagnetic


;#################################################
function ooEchoMagnetic::isNICEFile,filename

if (n_elements(filename) eq 0) then return, 0

;get_lun, lun
;catch, theError
;if (theError ne 0) then begin
;  if ((fstat(lun)).open eq 1) then free_lun, lun, /force
;  print,!ERROR_STATE.msg
;  catch, /cancel
;  return, 0
;endif
;
;openr, lun, filename
;line = ''
;readf, lun, line
;free_lun, lun, /force
;  
;return, strcmp(line,'#NICE',5,/fold)


if ~File_test(filename) then begin
  errmsg = 'File '+filename+' not found'
  Return,0B
endif
nlines = File_lines(filename)
dstring = Strarr(nlines)

get_lun, lun
catch, theError
if (theError ne 0) then begin
  if ((fstat(lun)).open eq 1) then free_lun, lun, /force
  print,!ERROR_STATE.msg
  catch, /cancel
  return, 0
endif

Openr,lun,filename,/get_lun
Readf,lun,dstring
Free_lun,lun,/force
i = 0
while ((i lt nlines) && (Strmid(dstring[i],0,1) eq '#')) do begin
  split = Strsplit(dstring[i],/extract, count=nSplit)
  if (Strupcase(split[0]) eq '#NICE') then begin    ; #NICE 0.2 : 73 header lines
    errmsg = ''
    Return,1B
  endif
  if (nSplit gt 1 && (Strupcase(split[1]) eq 'NICE')) then begin     ; # NICE 0.2 : 102 header lines
    errmsg = ''
    Return,1B
  endif
  i++
endwhile

Return,0B

end


;#################################################
function ooEchoMagnetic::read,filename=filename,facility=facility


fileFormat = (Self->isNICEFile(filename))? 'NICE' : ''

case fileFormat of
  'NICE': return, Self->readNICE(filename=filename, facility=facility, fileFormat=fileFormat)
  else: return, Self->readOldEcho(filename=filename, facility=facility, fileFormat=fileFormat)
endcase

end


;##################################################################################################
function ooEchoMagnetic::readNICE,filename=filename,facility=facility, fileFormat=fileFormat
compile_opt idl2

get_lun, lun
catch, theError
if (theError ne 0) then begin
  if ((fstat(lun)).open eq 1) then free_lun, lun, /force
  print,!ERROR_STATE.msg
  catch, /cancel
  return, 0
endif

openr, lun, filename

line = ''
readf, lun, line
toks = strsplit(line, /extract)
;if ((toks[0] ne '#NICE') && (toks[0] ne '# NICE')) then begin
;  free_lun, lun, /force
;  return, 0
;endif

if (Stregex(line,'# NICE',/bool,/fold_case)) then begin  ;# NICE 0.2 : 102 header lines
  toks = Strsplit(line,' ',count=nToks,/extract)
  if (nToks ge 5) then begin
    n = Fix(toks[4])
  endif else begin
    errmsg = 'NICE file has improper format - cannot determine length of header block'
    Return, 0B
  endelse
endif
if (Stregex(line,'#NICE',/bool,/fold_case)) then begin  ; #NICE 0.2 : 73 header lines
  toks = Strsplit(line,' ',count=nToks,/extract)
  if (nToks ge 4) then begin
    n = Fix(toks[3])
  endif else begin
    errmsg = 'NICE file has improper format - cannot determine length of header block'
    Return, 0B
  endelse
endif
header = strarr(n-1)
readf, lun, header
header = [line,header]

titles = strsplit(header[n-1],/extract)
nCol = n_elements(titles)
titles = titles[1:nCol-1]
nCol--

; determine measurement type: only proceed if "FourierTime.FourierTime" is found
void = where(stregex(header,'FourierTime.FourierTime',/bool,/fold_case),fourierPresent)
;measurementType = (fourierPresent)? 'echo' : 'diffraction'
if (fourierPresent le 0) then begin
  free_lun, lun, /force
  return, 0  
endif

; determine whether this is a magnetic scan
magneticTrue = 0
magIndex = where(stregex(header,'trajectoryData.SpinEchoTrajParameters_magnetic',/bool,/fold_case),magneticKeyPresent)
if (magneticKeyPresent) then begin
  void = where(stregex(header[magIndex],'True',/bool,/fold_case),magneticTrue)
endif
Self.magnetic = magneticTrue
no_of_magnetic_phases = (magneticTrue)? 12 : 0

configIndex = (where(titles eq 'config', configFound))[0]
if (~configFound) then begin
  free_lun, lun, /force
  return, 0
endif
ftIndex = (where(strcmp(titles,'fourierTime',strlen('fourierTime'),/fold)))[0]
phaseIndex = (where(strcmp(titles,'phase',strlen('phase'),/fold)))[0]
lambdaIndex = (where(strcmp(titles,'wavelength(Ang)',/fold)))[0]
dlambdaIndex = (where(strcmp(titles,'wavelengthSpread',strlen('wavelengthSpread'),/fold)))[0]
timeIndex = (where(strcmp(titles,'time(s)',strlen('time(s)'),/fold)))[0]
monIndex = (where(strcmp(titles,'monitor',/fold)))[0]
presetIndex = (where(strcmp(titles,'mon.set',strlen('mon.set'),/fold)))[0]
qIndex = (Where(Strcmp(titles,'q(',Strlen('q('),/fold)))[0]

iec_mult_index = lonarr(10)
iec_mult_index[0] = where(strcmp(titles,'temperature.CC1R1',strlen('temperature.CC1R1'),/fold))
iec_mult_index[1] = where(strcmp(titles,'PiFlipperMagnetometer.y',strlen('PiFlipperMagnetometer.y'),/fold))
iec_mult_index[2] = where(strcmp(titles,'Pi2Flipper1Magnetometer.x',strlen('Pi2Flipper1Magnetometer.x'),/fold))
iec_mult_index[3] = where(strcmp(titles,'Pi2Flipper1Magnetometer.z',strlen('Pi2Flipper1Magnetometer.z'),/fold))
iec_mult_index[4] = where(strcmp(titles,'Pi2Flipper2Magnetometer.y',strlen('Pi2Flipper2Magnetometer.y'),/fold))
iec_mult_index[5] = where(strcmp(titles,'PiFlipperMagnetometer.x',strlen('PiFlipperMagnetometer.x'),/fold))
iec_mult_index[6] = where(strcmp(titles,'PiFlipperMagnetometer.z',strlen('PiFlipperMagnetometer.z'),/fold))
iec_mult_index[7] = where(strcmp(titles,'Pi2Flipper1Magnetometer.y',strlen('Pi2Flipper1Magnetometer.y'),/fold))
iec_mult_index[8] = where(strcmp(titles,'Pi2Flipper2Magnetometer.x',strlen('Pi2Flipper2Magnetometer.x'),/fold))
iec_mult_index[9] = where(strcmp(titles,'Pi2Flipper2Magnetometer.z',strlen('Pi2Flipper2Magnetometer.z'),/fold))

iec_multimeter = {NSE_METERS_STRUCT,$
  Temperatur:0.0,$    ; temp.CC1R1(degC)
  BSpiy:0.0,$         ; PiFlipperMagnetometer.y
  BSpi21x:0.0,$       ; Pi2Flipper1Magnetometer.x
  BSpi21z:0.0,$       ; Pi2Flipper1Magnetometer.z
  BSpi22y:0.0,$       ; Pi2Flipper2Magnetometer.y
  BSpix:0.0,$         ; PiFlipperMagnetometer.x
  BSpiz:0.0,$         ; PiFlipperMagnetometer.z
  BSpi21y:0.0,$       ; Pi2Flipper1Magnetometer.y
  BSpi22x:0.0,$       ; Pi2Flipper2Magnetometer.x
  BSpi22z:0.0 $       ; Pi2Flipper2Magnetometer.z
}
monitor_struct = {NSE_MONITOR_STRUCT,m1:0.0,m2:0.0,m3:0.0}
nMulti = N_TAGS(iec_multimeter)

; number of fourier times in dataset
nosFTimes = 30  ; estimate
keyIndex = where(stregex(header,'trajectoryData.SpinEchoTrajParameters_fourierTime',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = strsplit(header[keyIndex],',',count=ntok,/extract)
  nosFTimes = ntok
  
  ; ????????????????
  ; in readOldEcho(), whenever nosFTimes is 1, it is set to 2!!!
  ; Do the same here for consistency
  if (nosFTimes eq 1) then nosFTimes++
endif

; nunber of phases in dataset
nosPhases = 150
keyIndex = where(stregex(header,'trajectoryData.SpinEchoTrajParameters_numPoints',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = strsplit(header[keyIndex],count=ntok,/extract)
  nosPhases = float(toks[2])
endif

; nunber of NSF in dataset
nosNSF = 15
keyIndex = where(stregex(header,'trajectoryData.SpinEchoTrajParameters_NSF',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = strsplit(header[keyIndex],count=ntok,/extract)
  nosNSF = float(toks[2])
endif

; nunber of NSF in dataset
nosSF = 15
keyIndex = where(stregex(header,'trajectoryData.SpinEchoTrajParameters_SF',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = strsplit(header[keyIndex],count=ntok,/extract)
  nosSF = float(toks[2])
endif

; phase step value
phaseStep = 45.0
keyIndex = where(stregex(header,'trajectoryData.SpinEchoTrajParameters_step',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = strsplit(header[keyIndex],count=ntok,/extract)
  phaseStep = float(toks[2])
endif

; No longer read q from data block!
; Use the requested q value from the header using the Parameters_q keyword
q = 0.0
keyIndex = Where(Stregex(header,'trajectoryData.SpinEchoTrajParameters_q',/bool,/fold_case),qPresentInHeader)
if (qPresentInHeader) then begin
  toks = Strsplit(header[keyIndex],count=ntok,/extract)
  q = Float(toks[2])
endif


; Comment
Self.comment = ''
index = where(stregex(header,'trajectoryData.SpinEchoTrajParameters_description',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = strsplit(header[index],count=ntok,/extract)
  if (ntok gt 2) then begin
    Self.comment = strjoin(toks[2:ntok-1], ' ')
  endif
endif else begin
  ; old style comment
  index = where(stregex(header,'trajectoryData.description',/bool,/fold_case),keyPresent)
  if (keyPresent) then begin
    toks = strsplit(header[index],count=ntok,/extract)
    if (ntok gt 2) then begin
      Self.comment = strjoin(toks[2:ntok-1], ' ')
    endif
  endif
endelse


detDim = [32,32]
nosPixels = 1024
x_dim_orig = 32
y_dim_orig = 32

point_to_down = 0.
point_to_up = 0.
phase_step = 0.
lambda = 0.0
dlambda = 0.0


nosPhases = (Self.magnetic)? nosPhases + 3*(nosNSF + nosSF) : nosPhases + nosNSF + nosSF

phase = fltarr(nosPhases, nosFTimes)
fourierTime = fltarr(nosFTimes)
meters = replicate(iec_multimeter,nosPhases,nosFTimes)
counters = dblarr(10,nosPhases,nosFTimes)
monitors=replicate(monitor_struct,nosFTimes)
data = lonarr(nosPixels,nosPhases,nosFTimes)
line = ''
dline = fltarr(nCol)
image = lonarr(32,32)
dBuf = lonarr(nosPixels)
iFT = -1
iP = -1
iNSF = -1
iSF = -1
iXNSF = -1
iXSF = -1
iYNSF = -1
iYSF = -1
iZNSF = -1
iZSF = -1
readingEcho = 0
readingSF = 0
readingNSF = 0
readingXSF = 0
readingXNSF = 0
readingYSF = 0
readingYNSF = 0
readingZSF = 0
readingZNSF = 0

; INFO:
; For non magnetic data , possible config values are: 
;   ECHO, NSF, SF, ECHO_shorty, NSF_shorty, SF_shorty.
; The magnetic data config can have the following: 
;   MAGNETIC_ECHO, MAGNETIC_ECHO_shorty, X_NSF, X_NSF_shorty,  X_SF, X_SF_shorty, 
;   Y_NSF, Y_NSF_shorty, Y_SF, Y_SF_shorty, Z_NSF, Z_NSF_shorty, Z_SF, Z_SF_shorty

; Read the first fourierTime block data
tempPhase = 0.0

while (~eof(lun) && iFT le 0) do begin
  readf, lun, line
  readf, lun, image
  image = rotate(temporary(image),4); transpose data                                                                                                                                           
  dbuf = reform(image,nosPixels)
  iP++
  toks = strsplit(line,/extract)
  config = toks[configIndex]
  
  if (Self.magnetic) then begin
  ;; Make magnetic specific checks and recordings
    
    if (~readingEcho && strcmp(config,'MAGNETIC_ECHO',13,/fold)) then begin
      iFT++
      readingEcho = 1 & readingXNSF = 0 & readingXSF = 0 & readingYNSF = 0 & readingYSF = 0 & readingZNSF = 0 & readingZSF = 0
      if (iP gt 0) then nosPhases = iP
      if (~qPresentInHeader) then begin
        ; Unless it is missing, use the requested q value from the header (using the Parameters_q keyword) that was read earlier.
        ; If it was not found then use the one from the data block. 
        q = double(toks[qIndex])
      endif
      lambda = double(toks[lambdaIndex])
      dLambda = double(toks[dlambdaIndex])
      preset = float(toks[presetIndex])
      if (iFT gt 0) then GOTO, FIRST_FT_DONE
    endif

    ;; X_NSF || X_SF config follows MAGNETIC_ECHO in the data file
    if (readingEcho && strcmp(config,'X_',2,/fold)) then begin
      readingEcho = 0  & readingYNSF = 0 & readingYSF = 0 & readingZNSF = 0 & readingZSF = 0
      if (strcmp(config,'X_NSF',5,/fold)) then begin
        iXNSF = iP
        readingXNSF = 1 & readingXSF = 0  
      endif else begin
        iXSF = iP
        readingXNSF = 0 & readingXSF = 1
      endelse
    endif
    if (readingXNSF && strcmp(config,'X_SF',4,/fold)) then begin
      readingXNSF = 0 & readingEcho = 0 & readingXSF = 1 & readingYNSF = 0 & readingYSF = 0 & readingZNSF = 0 & readingZSF = 0
      iXSF = iP
    endif
    if (readingXSF && strcmp(config,'X_NSF',5,/fold)) then begin
      readingXNSF = 1 & readingEcho = 0 & readingXSF = 0 & readingYNSF = 0 & readingYSF = 0 & readingZNSF = 0 & readingZSF = 0
      iXNSF = iP
    endif
    

    ;; Z_NSF || Z_SF config follows X_NSF || X_SF in the data file
    if ((readingXNSF || readingXSF) && strcmp(config,'Z_',2,/fold)) then begin
      readingXNSF = 0 & readingEcho = 0 & readingXSF = 0 & readingYNSF = 0 & readingYSF = 0 
      if (strcmp(config,'Z_NSF',5,/fold)) then begin
        iZNSF = iP
        readingZNSF = 1 & readingZSF = 0
      endif else begin
        iZSF = iP
        readingZNSF = 0 & readingZSF = 1
      endelse
    endif
    if (readingZNSF && strcmp(config,'Z_SF',4,/fold)) then begin
      readingXNSF = 0 & readingEcho = 0 & readingXSF = 0 & readingYNSF = 0 & readingYSF = 0 & readingZNSF = 0 & readingZSF = 1
      iZSF = iP
    endif
    if (readingZSF && strcmp(config,'Z_NSF',5,/fold)) then begin
      readingXNSF = 0 & readingEcho = 0 & readingXSF = 0 & readingYNSF = 0 & readingYSF = 0 & readingZNSF = 1 & readingZSF = 0
      iZNSF = iP
    endif

    ;; Y_NSF || Y_SF config follows Z_NSF || Z_SF in the data file
    if ((readingZNSF || readingZSF) && strcmp(config,'Y_',2,/fold)) then begin
      readingXNSF = 0 & readingEcho = 0 & readingXSF = 0 & readingZNSF = 0 & readingZSF = 0
      if (strcmp(config,'Y_NSF',5,/fold)) then begin
        iYNSF = iP
        readingYNSF = 1 & readingYSF = 0
      endif else begin
        iYSF = iP
        readingYNSF = 0 & readingYSF = 1
      endelse
    endif
    if (readingYNSF && strcmp(config,'Y_SF',4,/fold)) then begin
      readingXNSF = 0 & readingEcho = 0 & readingXSF = 0 & readingYNSF = 0 & readingYSF = 1 & readingZNSF = 0 & readingZSF = 0
      iYSF = iP
    endif
    if (readingYSF && strcmp(config,'Y_NSF',5,/fold)) then begin
      readingXNSF = 0 & readingEcho = 0 & readingXSF = 0 & readingYNSF = 1 & readingYSF = 0 & readingZNSF = 0 & readingZSF = 0
      iYNSF = iP
    endif
  endif else begin 
  ;; Make non-magnetic specific checks and recordings
    if (~readingEcho && strcmp(config,'ECHO',4,/fold)) then begin
      iFT++
      readingEcho = 1 & readingNSF = 0 & readingSF = 0
      if (iP gt 0) then nosPhases = iP
      if (~qPresentInHeader) then begin
        ; Unless it is missing, use the requested q value from the header (using the Parameters_q keyword) that was read earlier.
        ; If it was not found then use the one from the data block. 
        q = double(toks[qIndex])
      endif
      lambda = double(toks[lambdaIndex])
      dLambda = double(toks[dlambdaIndex])
      preset = float(toks[presetIndex])
      if (iFT gt 0) then GOTO, FIRST_FT_DONE
    endif
    if (readingEcho && strcmp(config,'NSF',3,/fold)) then begin
      readingNSF = 1 & readingEcho = 0 & readingSF = 0
      iNSF = iP
    endif
    if (readingEcho && strcmp(config,'SF',2,/fold)) then begin
      readingNSF = 0 & readingEcho = 0 & readingSF = 1
      iSF = iP
    endif
    if (readingNSF && strcmp(config,'SF',2,/fold)) then begin
      readingNSF = 0 & readingEcho = 0 & readingSF = 1
      iSF = iP
    endif
    if (readingSF && strcmp(config,'NSF',3,/fold)) then begin
      readingNSF = 1 & readingEcho = 0 & readingSF = 0
      iNSF = iP
    endif
  endelse
  
  ; the fouriertime value
  fourierTime[iFT] = float(toks[ftIndex])
  
  ; monitors
  
  ; meter values
  iec_multimeter_values = float(toks[iec_mult_index])
  for i=0,nMulti-1 do meters[iP,iFT].(i) = iec_multimeter_values[i]
  
  ; counters
  counters[[0,4],iP,iFT] = [float(toks[timeIndex]),float(toks[monIndex])]
  
  ; phase values
  tempPhase = float(toks[phaseIndex])
  if (~finite(tempPhase)) then begin
    tempPhase = phase[iP-1,iFT] + phaseStep
  endif
  phase[iP,iFT] = tempPhase
  if (ip eq 2) then phaseStep = phase[iP,iFT] - phase[iP-1,iFT]
  
  ; data
  counters0 = counters[0,iP,iFT]
  counters4 = counters[4,iP,iFT]
  data[*,iP,iFT] = self->deadTime(dBuf,counters[0,iP,iFT],counters[4,iP,iFT],preset, 0.0,0.0,0.0,fileFormat=fileFormat)
endwhile

FIRST_FT_DONE:
if (eof(lun)) then begin
  ; means only one FT is present in datafile
  iFT++
  if (iP gt 0) then nosPhases = iP + 1
endif

; Read remaining data
while (~eof(lun)) do begin
  for iP = 0, nosPhases-1 do begin
    if (eof(lun)) then begin
      ; check again for eof b/c the dataset could have been terminated before a complete set of phases in an FT
      free_lun, lun, /force
      iFT++
      goto, READ_COMPLETE
    endif  
    if ~(iFT eq 1 && iP eq 0) then begin ; first phase data previously read for iFT eq 1 in last repeat loop
      readf, lun, line
      readf, lun, image
      image = rotate(temporary(image),4); transpose data
      dbuf = reform(image,nosPixels)
    endif
    toks = strsplit(line,/extract)
    
    ; meter values
    iec_multimeter_values = float(toks[iec_mult_index])
    for i=0, nMulti-1 do meters[iP,iFT].(i) = iec_multimeter_values[i]
    
    ; counters
    counters[[0,4],iP,iFT] = [float(toks[timeIndex]),float(toks[monIndex])]
    
    
    ; phase values
    tempPhase = float(toks[phaseIndex])
    if (~finite(tempPhase)) then begin
      tempPhase = phase[iP-1,iFT] + phaseStep
    endif
    phase[iP,iFT] = tempPhase
    
    ; data
    data[*,iP,iFT] = self->deadTime(dBuf,counters[0,iP,iFT],counters[4,iP,iFT],preset, 0.0,0.0,0.0,fileFormat=fileFormat)
  endfor
  
  ; monitors
  ;monitors[iFT].(0) = 0.0
  
  ; fourierTime value
  fourierTime[iFT] = float(toks[ftIndex])
  
  iFT++
endwhile
free_lun, lun, /force

READ_COMPLETE:
nosFTimes = iFT

; ????????????????
; in readOldEcho(), whenever nosFTimes is 1, it is set to 2!!!
; Do the same here for consistency
if (nosFTimes eq 1) then nosFTimes++

phase = temporary(phase[0:nosPhases-1,0:nosFTimes-1])
data = temporary(data[*,0:nosPhases-1,0:nosFTimes-1])
meters = temporary(meters[0:nosPhases-1,0:nosFTimes-1])
counters = temporary(counters[*,0:nosPhases-1,0:nosFTimes-1])
monitors = temporary(monitors[0:nosFTimes-1])
fourierTime = temporary(fourierTime[0:nosFTimes-1])
mask2d = intarr(x_dim_orig, y_dim_orig, nosFTimes) + 1
mask1d = intarr(nosPhases, nosFTimes) + 1

;im,monitor,time,preset
;im,counter0,counter4,preset
;==> counter0=monitor, counter4 = time, preset=preset

if (Self.magnetic) then begin
  if ((iXNSF eq -1) || (iXSF eq -1)) then Return, 0
  if ((iZNSF eq -1) || (iZSF eq -1)) then Return, 0
  if ((iYNSF eq -1) || (iYSF eq -1)) then Return, 0
  self.point_to_down_x = iXNSF
  self.point_to_up_x = iXSF
  self.point_to_down_z = iZNSF
  self.point_to_up_z = iZSF
  self.point_to_down_y = iYNSF
  self.point_to_up_y = iYSF
endif else begin
  if ((iNSF eq -1) || (iSF eq -1)) then Return, 0
  Self.point_to_down = iNSF
  Self.point_to_up = iSF
endelse


phase_step = phase[1,0] - phase[0,0]

Self.q = q
Self.qactual = q
Self.qy = q
Self.lambda = lambda * 1.0e-10
Self.dlambda = dLambda * 1.0e-10


Self.mask1d = ptr_new(mask1d, /no_copy)
Self.mask2d = ptr_new(mask2d, /no_copy)

Self.x_dim_orig = x_dim_orig
Self.y_dim_orig = y_dim_orig
Self.no_of_pixels = nosPixels

Self.no_of_phases = nosPhases
Self.phase_step = phase_step
Self.no_of_fourier_times = nosFTimes

;index = where(~finite(phase),finiteCount)
;if (finiteCount gt 0) then phase[index] = 0.0

Self.preset = preset
Self.phase = ptr_new(phase, /no_copy)
Self.meters = ptr_new(meters, /no_copy)
Self.counters = ptr_new(counters, /no_copy)
Self.fourierTime = ptr_new(FourierTime*1.0e-9, /no_copy)
Self.monitors = ptr_new(monitors, /no_copy)
Self.e = ptr_new(data, /no_copy)
;Self.comment = file_basename(filename)
self.filename = filename

Self.scanHeader = ptr_new('')
Self.sampleHeader = ptr_new('')
Self.techHeader = ptr_new('')
Self.physicsHeader = ptr_new('')

;if Self.magnetic eq 1 then begin
;  Self.point_to_down_x = nosPhases
;  Self.point_to_up_x = nosPhases + 2
;  Self.point_to_down_z = nosPhases + 4
;  Self.point_to_up_z = nosPhases + 6
;  Self.point_to_down_y = nosPhases + 8
;  Self.point_to_up_y = nosPhases + 10
;  nosPhases = nosPhases + no_of_magnetic_phases
;endif else begin
;  Self.point_to_down_x = Self.no_of_phases-12
;  Self.point_to_up_x = Self.no_of_phases-10
;  Self.point_to_down_z = Self.no_of_phases-8
;  Self.point_to_up_z = Self.no_of_phases-6
;  Self.point_to_down_y = Self.no_of_phases-4
;  Self.point_to_up_y = Self.no_of_phases-2
;endelse
;

return, 1

end


;#################################################
function ooEchoMagnetic::readOldEcho,filename=filename,facility=facility, fileFormat=fileFormat
;
;NAME:
;        ooEchoMagnetic::read
;
;PURPOSE:
;       Read in a raw .echo file.  Overrides the method in
;       ooEcho and reads magnetic polarizations if they
;       have been measured using the postmacro.
;PARAMETERS:
;       none
;KEYWORDS:
;       filename    An optional filename to open.
;RETURN VALUE:
;       1 for success
;       0 for failure

    ;self->addTreatment,'ooEcho::read'

;LRK 12/09/10
;FACILITY INDEX DEFAULT IS 1 (NCNR).
;ALTERNATIVE VALUE IS 2 (FRM-II).
;THE "Try File" option will not be used any more since it was 
;incorrectly flagging the data.
if n_elements(facility) eq 0 then facility = 1;0

;;
;READ IN AN ECHO FILE.  TURN THIS INTO A FUNCTION
;WHICH WILL RETURN A STRUCTURE CONTAINING ALL OF
;THE IMPORTANT PARAMETERS FROM THE FILE.
;
;
;;
;
;USES THE ooEcho::readSampleHeader METHOD
;
;;;

;LRK 11/20/09
;    SOME MORE USEFUL VARIABLES FOR INITIALIZING extensions VALUES FOR ALL FACILITIES
;
SDNCNR = 4.35  ;meters
SDFRMII = 4.33
pixelxsizeNCNR = 0.01  ;meters
pixelysizeNCNR = 0.01
pixelxsizeFRMII = 0.01
pixelysizeFRMII = 0.01
GAUSSIANWIDTH = 702.00 ;degrees - "MEASURED" VALUE FOR FIT PARAMETER --- NEEDS TO BE INPUT SOMEHOW.
reversedImage=0      ;WE NEED TO FIGURE OUT WHY THE OLD NSE IMAGES ARE READ IN LEFT-RIGHT BACKWARD FROM THE OLD ONES.
                     ;THE NCNR IMAGES PRE-200802 ARE REVERSE FROM THE CURRENT ONES, AND FRM-II DATA SEEMS DIFFERENT VARIABLE.

;INITIALIZE SOME USEFUL VARIABLES
scanHeaderSize = 27
sampleHeaderSize = 11   ;THIS FINAL VALUE WILL CHANGE
                        ;DEPENDING ON COMMENT SIZE
techHeaderSize = 54
physicsHeaderSize = 16
physicsParametersHeaderSize = 45 ;44?
phaseHeaderSize = 4
no_of_phases = 27
point_to_down = 19
point_to_up = 24
phase_step = 45.0

fn = ''
line = ''
segs = ['test1','test2']

;INITIALIZE GENERAL HEADERS
scanHeader = [''];strarr(scanHeaderSize)
sampleHeader = [''];strarr(sampleHeaderSize) ;17


;SELECT FILE TO OPEN
if (n_elements(filename) ne 0) then begin
    fn = filename
endif else begin
    fn=dialog_pickfile(/read,filter=['*.nse','*.echo'],/must_exist)
endelse
;print,'fn=',fn
to = systime(1,/seconds)

;################################################
CATCH, Error_status
;HANDLE INITIAL ERRORS IN READING THE DATA
;FILE.
IF (Error_status NE 0) THEN BEGIN
  free_lun,lun,/force
  print,'1554 ooEchoMagnetic::read DATA FILE IS INCOMPLETE.'
  CATCH, /CANCEL
  return,0
ENDIF

;################################################

if (fn eq '') then begin
    ;if (err ne 0) then begin
    print,'1564 ooEchoMagnetic::read ', !error_state.msg
    return, 0
endif 

;READ FILE'S SAMPLE AND SCAN HEADERS
openr,lun,fn,/get_lun,error = err
self.filename = fn
;print,lun

;#######################################
;READ SCAN HEADER AND EXTRACT VALUES
;#######################################
line = ''
while_count = 0
while stregex(line,'eof',/fold_case,/boolean) eq 0 do begin
  while_count++
  readf,lun,line
  ;print,line
  scanheader = [scanheader,line]
  
  if stregex(line,'post_macro',/fold_case,/boolean) gt 0 then begin
    postmacro = (strsplit(line,/extract))[2]
    postmacro = strlowcase(postmacro)
    if postmacro ne 'none' then begin
        self.magnetic = 1
        no_of_magnetic_phases = 12
    endif else begin
        self.magnetic = 0
        no_of_magnetic_phases = 0
    endelse
  endif
  
  if stregex(line,'preset',/fold_case,/boolean) then begin
    psegs = strsplit(line,/extract)
    if strcmp(psegs[1],'preset',/fold_case) ne 0 then $
      preset = long((double(psegs[2])))
  endif
  if stregex(line,'no_of_phases',/fold_case,/boolean) then begin
    no_of_phases = fix((strsplit(line,/extract))[2])
  endif
  if stregex(line,'point_to_down',/fold_case,/boolean) then begin
    point_to_down = fix((strsplit(line,/extract))[2])
    ;point_to_down = fix((strsplit(scanHeader[10],/extract))[2])
  endif
  if stregex(line,'point_to_up',/fold_case,/boolean) then begin
    point_to_up = fix((strsplit(line,/extract))[2])
    ;point_to_up = fix((strsplit(scanHeader[11],/extract))[2])
  endif

  ;120805
  ;SAFETY MEASURE:
  if point_to_down eq no_of_phases then point_to_down = no_of_phases-2
  if point_to_up eq no_of_phases then point_to_up = no_of_phases-1

  if while_count eq 1 and self.magnetic eq 0 then $
  ;void = dialog_message('point_to_up eq point_to_down = no_of_phases!!!!  Making up values . . . ')
    if stregex(line,'phase_step',/fold_case,/boolean) then begin
      phase_step = fix((strsplit(line,/extract))[2])
      ;phase_step = float((strsplit(scanHeader[12],/extract))[2])
    endif
    if stregex(line,'scantype',/fold_case,/boolean) then begin
      scantype = (strsplit(line,/extract))[2]
      ;scantype = (strsplit(scanHeader[18],/extract))[2]
    endif
    if stregex(line,'end',/fold_case,/boolean) then begin
      ;print,'GETTING THE NO_OF_FOURIER_TIMES:'
      segs = strsplit(line,/extract)
      no_of_fourier_times = fix((segs)[n_elements(segs)-1])
      q = double(segs[3])
      ;print,line
      ;print,'q=',q
      ;help,q
      self.q = q
      ;help,self.q
    endif

endwhile;line

;110205
;DO NOT READ BLANK LINES.  THESE CAN BE FOLDED INTO THE NEXT HEADER WITH NO
;NEED TO CHANGE CODE LATER ON!!!!

;readf,lun,line        ;READ BLANK LINE AFTER eof

scanheader = scanheader[1:*]
scanheadersize = n_elements(scanheader)

if (ptr_valid(self.scanHeader) gt 1) then ptr_free,self.scanHeader
self.scanHeader = ptr_new(scanHeader)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
self.preset = preset
self.no_of_phases = no_of_phases    ;THIS VALUE MAY BE ALTERED BASED ON MAGNETIC SCANS
self.point_to_down = point_to_down
self.point_to_up = point_to_up
self.phase_step = phase_step
self.no_of_fourier_times = no_of_fourier_times
self.no_of_pixels = 0  ;INITIALIZE HERE
;self.q = q
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;print,';#####################################'
;print,';READ SAMPLE HEADER'
;print,';#####################################'
sampleheader = ['']
line = ''
while not stregex(line,'eof',/boolean,/fold_case) do begin
    readf,lun,line
    ;print,line
    sampleHeader = [sampleHeader,line]
    if stregex(line,'comment',/fold_case,/boolean) then commentpos = n_elements(sampleheader)
endwhile

;    readf,lun,line  ;READ BLANK LINE AFTER eof LINE
sampleheader = sampleheader[1:*]

sampleHeaderSize = n_elements(sampleHeader)

;EXTRACT SAMPLE COMMENT
segsTemp = strsplit(sampleHeader[commentpos],/extract)

self.comment = segsTemp[1]
self.comment = ''
for ii = commentpos,n_elements(sampleheader)-2 do begin
    self.comment = self.comment + ' ' + sampleheader[ii];segsTemp[ii]
endfor;ii

;print,'self.comment = '+self.comment
if (ptr_valid(self.sampleHeader) gt 1) then ptr_free,self.sampleHeader
self.sampleHeader = ptr_new(sampleHeader)
;###############################################################################

;102805
if self.magnetic eq 1 then begin
  self.point_to_down_x = no_of_phases
  self.point_to_up_x = no_of_phases + 2
  self.point_to_down_z = no_of_phases + 4
  self.point_to_up_z = no_of_phases + 6
  self.point_to_down_y = no_of_phases + 8
  self.point_to_up_y = no_of_phases + 10
  no_of_phases = no_of_phases + no_of_magnetic_phases
endif else begin
  self.point_to_down_x=self.no_of_phases-12
  self.point_to_up_x=self.no_of_phases-10
  self.point_to_down_z=self.no_of_phases-8
  self.point_to_up_z=self.no_of_phases-6
  self.point_to_down_y=self.no_of_phases-4
  self.point_to_up_y=self.no_of_phases-2
endelse

;#######$$$$$$$$$$$$$$$$$$*$$$$$$$$$$$$$$$$$$$$####
;NOTE:
;#######################################################################
;IF THERE IS JUST ONE FOURIER TIME, DECLARE THE ARRAYS TO HAVE TWO AND
;REMOVE T MANUALLY.
;#######################################################################
if no_of_fourier_times le 1 then begin
  no_of_fourier_times = 2
  ;void = dialog_message('Less than 2 Fourier Times.')
  print,'Less than 2 Fourier Times Supported by Kluge.'
endif



;102805
;FOR MAGNETIC SAMPLES THERE WILL BE 6*no_of_fourier_times ADDITIONAL
;physics and tech headers!!!
;


;102805
;FOR MAGNETIC MEASUREMENTS, THERE WILL BE 6 EXTRA tech AND physics HEADERS
;AT EACH FOURIER TIME.


;110105
;ELIMINATE THESE HEADER ARRAYS FROM clone, merge
;DETERMINE THESE AT READ TIME!!!!
if self.magnetic eq 1 then begin
  techHeaderSize += 10;3
  techHeader = strarr(techHeaderSize,no_of_fourier_times+6*no_of_fourier_times)
  physicsHeader = strarr(physicsHeaderSize,no_of_fourier_times+6*no_of_fourier_times)
endif else begin
  techHeader = strarr(techHeaderSize,no_of_fourier_times)
  physicsHeader = strarr(physicsHeaderSize,no_of_fourier_times)
endelse

;        physicsParametersHeader = strarr(physicsParametersHeaderSize,$
;                                        no_of_fourier_times)

;DEFINE PARAMETERS THAT OCCUR FOR EACH PHASE
;PHASE HEADERS OCCUR WITH EACH PHASE VALUE
phaseHeader = strarr(phaseHeaderSize,$
                    no_of_phases,$
                    no_of_fourier_times)

;102805
;phaseHeader WILL NOT OCCUR AT THE xyz_up/down MEASUREMENTS
;IN MAGNETIC SCANS BUT....
;
;WE NEED TO DEFINE PHASES THERE
;no_of_phases IS CORRECTED ABOVE FOR MAGNETIC SYSTEMS
;SO NO NEED TO FIX DIMENSIONS HERE.

phase = findgen(no_of_phases,no_of_fourier_times)


;103105
if ptr_valid(self.phase) gt 0 then ptr_free,self.phase
self.phase = ptr_new(phase)

fourierTime = fltarr(no_of_fourier_times)


;040804: THE NEXT INITIALIZATION WILL NEED TO
;        BE FIXED FOR 128x64 DETECTORS, ETC.

;INITIALIZE THE etemp ARRAY
etemp = lindgen(1024,no_of_phases,no_of_fourier_times)

iec_multimeter = {NSE_METERS_STRUCT,$
    Temperatur:0.0,$
    BSpiy:0.0,$
    BSpi21x:0.0,$
    BSpi21z:0.0,$
    BSpi22y:0.0,$
    BSpix:0.0,$
    BSpiz:0.0,$
    BSpi21y:0.0,$
    BSpi22x:0.0,$
    BSpi22z:0.0 $
    }


;102605
;meters WILL BE OK SINCE no_of_phases IS SET ABOVE FOR THE MAGNETIC STATE
;OF THE MEASUREMENT.
;
;HAVE 12*no_of_phases MORE ENTRIES DUE TO
;THE xyz/up,down MEASUREMENTS.
;
;THIS WILL BE FIXED ABOVE WHEN no_of_phases IS SET TO
;no_of_phases + no_of_magnetic_phases
;
meters=replicate(iec_multimeter,no_of_phases,no_of_fourier_times)

for iiec=0,n_elements(meters)-1 do begin
  ;meters[iiec].BSpi22y = 0.0
  for jiec = 0,9 do begin
      meters[iiec].(jiec) = 0.0
  endfor
endfor;iiec
counters=dblarr(10,no_of_phases,no_of_fourier_times)

monitor_struct = {NSE_MONITOR_STRUCT,m1:0.0,m2:0.0,m3:0.0}
monitors=replicate(monitor_struct,no_of_fourier_times)

;;
;DEFINE THIS CATCH STATEMENT TO TAKE CARE OF
;SUDDEN END OF FILE
;;;

CATCH, Error_status
;This statement begins the error handler:
IF (Error_status NE 0) THEN BEGIN

  ;help,error_status
  ;help,!error_state
  ;print,tag_names(!error_state,/structure_name)
  ;print,tag_names(!error_state)
  ;print,!error_state.msg
  free_lun,lun,/force
  help,self.e,output=out,struct=0
  if stregex(out,'NULL',/fold_case,/boolean) then begin
    print,'1320 ooEchoMagnetic::read INSUFFICIENT DATA IN FILE'
    return,0
  endif else begin
    if self. magnetic eq 1 then begin
      ;void = dialog_message('If this is a magnetic file, XYZ-UP/DOWN deadtime correction is approximate.')
      PRINT,'If this is a magnetic file, XYZ-UP/DOWN deadtime correction is approximate.'
    endif
    print,'1326 ooEchoMagnetic::read FILE READ AS WELL AS I COULD!'
    return,1
  endelse
  
  CATCH, /CANCEL
  return,1
ENDIF

;if self.magnetic eq 1 then techHeaderSize = 57

;;
;MAIN READ LOOPS
;;;
for j=0,no_of_fourier_times-1 do begin

  ;READ techHeader
  print,j,"READING TECH HEADER:"
  lines = strarr(techHeaderSize)
  
  templine = ''
  ssth = ['']
  techcount = 0
  monpos = 0

  ;################################
  ;JUST REUSE techHeader SINCE IT WILL NOT BE ACCESSED AFTER EACH PASS!!!
  ;################################

  ;print,';###############################'
  ;print,';READ TECH HEADER j = '+strtrim(string(j),2)
  ;print,';###############################'
  techheader = ['']

  while not stregex(templine,'eof',/fold_case,/boolean) do begin;templine
    readf,lun,templine
    ;       print,templine
    techheader = [techheader,templine]
    if not stregex(templine,'eof',/fold_case,/boolean) then begin
        if n_elements(ssth) gt 1 then begin
            ;print,templine
            if ssth[1] eq 'monitors' then begin
                monpos = techcount
            endif
        endif
    endif
    techcount++
  endwhile

  thsz = size(techHeader)


  ;GET THE MONITOR VALUES FROM EACH TECH HEADER   ;THESE ARE NOT "MONITORS" --USE preset
  ;GET MONPOS ABOVE
  for nn=0,n_tags(monitor_struct)-1 do begin;42,44 do begin
    ;I DON'T USE THESE, SO JUST SET THEM TO VALUES AND IGNORE THEM.
    ;segs = strtrim(strsplit(techHeader[monpos+nn,j],/extract),2)
    
    monitors[j].(nn) = 8;long(segs[3])
  endfor;nn


  ;print,';#########################################'
  print,j,';READ PHYSICS HEADER
  ;print,';#########################################'
  physicsheader = ['']
  templine = ''
  while not stregex(templine,'eof',/fold_case,/boolean) do begin;templine
    readf,lun,templine
    ;        print,templine
    physicsheader = [physicsheader,templine]
    if stregex(templine,'lambda',/fold_case,/boolean) then begin
        ;EXTRACT LAMBDA AND DLAMBDA VALUES FROM DATA
        segs = strsplit(templine,/extract)
        case strlowcase(segs[1]) of
        'lambda':begin
            self.lambda = double(segs[2])
        end
        'dlambda':begin
            self.dlambda = double(segs[2])
        end
        else:
        endcase
    endif
  endwhile

;print,';##########################################################'
;print,';READ PHYSICS PARAMETERS HEADER'
;print,';##########################################################'
  qActualIndex = 14
  fourierTimeIndex = 28
  if self.magnetic eq 1 then fouriertimeindex += 1

  physicsParametersHeader = ['']
  line = ''
  while not stregex(line,'eof',/fold_case,/boolean) do begin
    readf,lun,line
    ;print,line
    physicsParametersHeader = [physicsParametersHeader,line]
    segs = strsplit(line,/extract)
    case strlowcase(segs[0]) of
      'fouriertime':begin
        fourierTime[j] = double(segs[2])
        ;print,'######FOURIER TIME = ',fouriertime[j]
      end;fouriertime
  
      'q':begin
        if j eq 0 then begin
            qactual = double(segs[2])/(10.0d^10.0d)
            qy = double(segs[6])/(10.0d^10.0d)
            self.qactual = qactual
            self.qy = qy
            ;print,'#####qactual = ',self.qactual
            ;print,'#####qy = ',self.qy
        endif
      end;q
  
      else:

    endcase  
  endwhile
  physicsParametersHeaderSize = n_elements(physicsParametersHeader)

  ;THIS IS THE ONE SPOT WHERE I MUST READ THE BLANK LINE ----
  ;I.E. JUST BEFORE THE DATA BEGIN
  readf,lun,line





  ;;
  ;READ IN ALL PHASES FOR THE jTH FOURIER TIME
  ;;;
  lines = strarr(4);phaseHeaderSize)     ;phaseHeaderSize is 4
  for i=0,no_of_phases - no_of_magnetic_phases-1 do begin
    ;print,';;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;'
    ;print,'       ;;'
    ;print,'        ;READ THE PHASE HEADER'
    ;print,';;;'
    ;print,';;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;'
    
    ;READ PHASE HEADER ASSOCIATED WITH THIS PHASE
    segs[0] = ''
    readf,lun,lines
    phaseHeader[*,i,j] = lines
    ;030805
    ;
    ;THERE IS A FEATURE IN THE NSE CONTROL SOFTWARE THAT CAUSES IT
    ;TO WRITE THE TECH, PHYSICS AND PHYSICS PARAMETERS HEADERS MULTIPLE
    ;TIMES IF THE IS A GLITCH IN A HARDWARE COMPONENT.
    ;ACCOUNT FOR THAT HERE BY TESTING THE FIRST LINE OF THE PHASE
    ;HEADER FOR 'phase' AND 3 SEGMENTS.    
    segs = strsplit(phaseHeader[0,i,j],/extract)
    if n_elements(segs) ne 2 or segs[0] ne 'phase' then begin
      print,'THERE WAS A PROBLEM WITH THE PHASE HEADER, PROBABLY A HARDWARE GLITCH.'
      print,'2106 ooEchoMagnetic::read    I "fixed" the glitch.'
      glitchline = ''
      postglitchline = strarr(3)
      while segs[0] ne 'phase' do begin
        readf,lun,glitchline
        segs = strsplit(glitchline,/extract)
      endwhile
      ;NOW GET THE REST OF THE CORRECT PHASE HEADER.
      phaseheader[0,i,j] = glitchline
      readf,lun,postglitchline
      phaseheader[1:*,i,j] = postglitchline
    endif
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;;
    ;PARSE THE PHASE HEADER INFORMATION
    ;;;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    ;GET THE PHASE FOR THIS PHASE
    segs = strsplit(phaseHeader[0,i,j],/extract)

    ;103105
    ;TAKE CARE OF INITIALIZATION OF THE ARRAY AT THIS POINT TO AVOID
    ;STRAY FLIPPER OFF POINT.

    if j eq 0 then begin
        (*self.phase)[i,*] = float(segs[1])
    endif else begin
        (*self.phase)[i,j] = float(segs[1])
    endelse
    ;GET THE COUNTERS FOR THIS PHASE
    segs = strsplit(phaseHeader[1,i,j],/extract)
    counters[*,i,j] = double(segs[1:10])

    ;LRK 120808
    ;IN CASE WE ARE LOOKING AT FRM-II DATA, THERE WILL BE 14 COUNTERS:
    ;print,'n_elements(segs) = ',n_elements(segs)
    if facility ne 0 then begin  
      if facility eq 1 then begin
        FRMII = 0  ;NIST FILES  ---- NOTE: THE REAL TEST SEEMS TO BE COUNT BY MONITOR (AS AT NIST WITH counters[1] BEING THE MON
                   ;                       VS. COUNT BY TIME WITH counters[5] BEING THE MONITOR. --- IS THAT THE GENERAL TEST
        self->checkAndUpdateExtensionsPtr,facility='NCNR',$ 
                                          instrument='NSE',$
                                          sd=sdNCNR,$  
                                          pixelxsize=pixelxsize,$
                                          pixelysize=pixelysixe,$
                                          reversedImage=0,$
                                          gaussianWidth=gaussianwidth        

      endif;facility eq 1
      if facility eq 2 then begin
        FRMII = 1
        mon = double(segs[5])
        if i eq 0 and j eq 0 then begin
          mon0 = mon
          if n_elements(segs) le 11 then reversedImage = 0
          self->checkAndUpdateExtensionsPtr,facility='FRM II',$ 
                                            instrument='JNSE',$
                                            sd=sdFRMII,$  
                                            pixelxsize=pixelxsize,$
                                            pixelysize=pixelysixe,$
                                            reversedImage=reversedImage,$
                                            gaussianWidth=gaussianWidth        
        endif
      endif;facility eq 2
        
    endif else begin
      if n_elements(segs) gt 11 then begin
        FRMII = 1
        mon = double(segs[5])
        if i eq 0 and j eq 0 then begin
          mon0 = mon
      
          self->checkAndUpdateExtensionsPtr,facility='FRM II',$ 
                                            instrument='JNSE',$
                                            sd=sdFRMII,$  
                                            pixelxsize=pixelxsize,$
                                            pixelysize=pixelysixe,$
                                            reversedImage=reversedImage,$
                                            gaussianWidth=gaussianWidth        
        endif
      endif else begin
        ;LRK 12/09/10
        ;THIS BLOCK IS NOT CORRECT SINCE THE segs[5] COULD BE non-zero FOR EITHER FACILITY.
        if abs(double(segs[5])) lt 0.000000001 then begin 
          if i eq 0 and j eq 0 then begin
            FRMII = 0  ;NIST FILES  ---- NOTE: THE REAL TEST SEEMS TO BE COUNT BY MONITOR (AS AT NIST WITH counters[1] BEING THE MON
                       ;                       VS. COUNT BY TIME WITH counters[5] BEING THE MONITOR. --- IS THAT THE GENERAL TEST
            self->checkAndUpdateExtensionsPtr,facility='NCNR',$ 
                                              instrument='NSE',$
                                              sd=sdNCNR,$  
                                              pixelxsize=pixelxsize,$
                                              pixelysize=pixelysixe,$
                                              reversedImage=0,$
                                              gaussianWidth=gaussianwidth        
          endif;FIRST PASS
        endif else begin
          FRMII = 1  ;ANOTHER FRMII FORMAT
          mon = double(segs[5])
          reversedImage = 0
          if i eq 0 and j eq 0 then begin
            mon0 = mon
            self->checkAndUpdateExtensionsPtr,facility='FRM II',$ 
                                              instrument='JNSE',$
                                              sd=sdFRMII,$  
                                              pixelxsize=pixelxsize,$
                                              pixelysize=pixelysixe,$
                                              reversedImage=reversedImage,$
                                              gaussianWidth=gaussianWidth        
            
          endif;first pass            
        endelse
      endelse;facility
    endelse

    ;;
    ;GET THE METER VALUES FOR THIS PHASE
    print,j,'GET THE METER VALUES FOR THIS PHASE'
    ;;;
    segs = strsplit(phaseHeader[2,i,j],/extract)
    ;METERS MAY NOT INCLUDE A TEMPERATURE VALUE
    if (segs[1] ne 'Temperatur') then begin
        meters_offset = 2
    endif else begin
        meters_offset = 1
    endelse
    for ii=0,n_tags(iec_multimeter)-meters_offset do begin
        meters[i,j].(ii) = float(segs[3*ii+2])     ;REFER TO TAG BY ELEMENT INDEX
    endfor

    ;GET THE NUMBER OF PIXELS IN DETECTOR
    segs = strsplit(phaseHeader[3,i,j],/extract)
    no_of_pixels = fix(segs[1])

    ;10/20/04
    ;
    ;THIS IS ONE OF THE CRITICAL POINTS WHERE THE OPTION
    ;FOR DIFFERENT DETECTOR SIZES WOULD NEED TO BE ENABLED.
    case no_of_pixels of
        1024:begin
            self.x_dim_orig = 32 & self.y_dim_orig = 32
            end;1024
        else:begin
            self.x_dim_orig = 32 & self.y_dim_orig = 32
            end;else
    endcase;no_of_pixels

    ;THEN REPLACE THE SQUARE ROOTS BELOW WITH self.x,y_dim_orig

    ;DECLARE e (THE 3-D DATA MATRIX) THE FIRST TIME THROUGH
    if ((j eq 0) and (i eq 0)) then begin
        ;etemp = lindgen(no_of_pixels,no_of_phases,no_of_fourier_times)
        etemp = lonarr(no_of_pixels,no_of_phases,no_of_fourier_times)
        if ptr_valid(self.e) gt 0 then ptr_free,self.e

        ;040804: DATA ARRAY SIZE _IS_ SET WHEN NECESSARY
        self.e = ptr_new(etemp,/no_copy)


        mask2dtemp = intarr(self.x_dim_orig,$
                            self.y_dim_orig,$
                            no_of_fourier_times)+1

        if ptr_valid(self.mask2d) gt 0 then ptr_free,self.mask2d
        self.mask2d = ptr_new(mask2dtemp)


        if self.magnetic eq 1 then begin
            mask1dtemp = intarr(no_of_phases,no_of_fourier_times) + 1
        endif else begin
            mask1dtemp = intarr(no_of_phases,no_of_fourier_times) + 1
        endelse
        if ptr_valid(self.mask1d) gt 0 then ptr_free,self.mask1d
        self.mask1d = ptr_new(mask1dtemp)
    endif

    ims = lonarr(no_of_pixels)
    readf,lun,ims

    print,min(ims),max(ims),counters[0,i,j],counters[4,i,j],preset,counters[1,i,j],counters[2,i,j],counters[3,i,j]

    ;NEED TO FIX deadTime TO ACCOUNT FOR THE x,y,x Up/Down CASES.

    ;LRK 120808
    ;PLACE AN IF STATEMENT TO DECIDE IF WE HAVE FRMII DATA
    if FRMII eq 0 then begin
      ims = self->deadTime(ims,counters[0,i,j],counters[4,i,j],preset, $
                  counters[1,i,j],counters[2,i,j],counters[3,i,j])
    endif else begin
      ;FIRST REVERSE THE ARRAY LEFT-RIGHT
      ims = reform(ims,self.x_dim_orig,self.y_dim_orig);reform(ims,32,32)
      ims = reverse(ims,1)  ;THE 1 INDEX IS THE DIRECTION OF REVERSAL.
      ims = reform(ims,no_of_pixels);1024)
      ims = long(ims*mon0/mon)
    endelse                        
    print,min(ims),max(ims),counters[0,i,j],counters[4,i,j],preset,counters[1,i,j],counters[2,i,j],counters[3,i,j]

    (*self.e)[*,i,j] = ims
    print,i,j,'READ AND CORRECTED A DETECTOR IMAGE'


    ;120805
    ;COPY THE NEXT ITEMS INTO readMagnetic()
    if ptr_valid(self.meters) gt 0 then ptr_free,self.meters
    self.meters = ptr_new(meters)

    if ptr_valid(self.counters) gt 0 then ptr_free,self.counters
    self.counters = ptr_new(counters)

    if ptr_valid(self.monitors) gt 0 then ptr_free,self.monitors
    self.monitors = ptr_new(monitors)

    self->setProperty,'no_of_phases',no_of_phases
    self->setProperty,'point_to_down',point_to_down
    self->setProperty,'point_to_up',point_to_up
    self->setProperty,'phase_step',phase_step
    self->setProperty,'no_of_fourier_times',no_of_fourier_times
    self->setProperty,'no_of_pixels',no_of_pixels
    self->setProperty,'q',q
    self->setProperty,'qactual',qactual
    self->setProperty,'qy',qy
    if (ptr_valid(self.fourierTime) gt 0) then $
                                ptr_free,self.fourierTime
    self.fourierTime = ptr_new(fourierTime)
    self.qactual = qactual
    if (ptr_valid(self.techHeader) gt 0) then $
                                ptr_free,self.techHeader
    self.techHeader = ptr_new(techHeader)
    if (ptr_valid(self.physicsHeader) gt 0) then $
                                ptr_free,self.physicsHeader
    self.physicsHeader = ptr_new(physicsHeader)
    if (ptr_valid(self.physicsParametersHeader) gt 0) then $
                                ptr_free,self.physicsParametersHeader
    self.physicsParametersHeader = ptr_new(physicsParametersHeader)
    if (ptr_valid(self.phaseHeader) gt 0) then $
                                ptr_free,self.phaseHeader
    self.phaseHeader = ptr_new(phaseHeader)
    print,i,j,systime(1,/seconds)-to,self.no_of_phases

    ;040105
    ;ooEcho::read CRASHES OUT HERE ON LAST FOURIER TIME AND ERROR IS CAUGHT ABOVE.
    ;IS IT NECESSARY TO DO IT THIS WAY?
    ;
    ;PLACING THE SETTING OF POINTERS/VALUES ABOVE THIS LINE TAKES CARE OF THE
    ;READ PROBLEM FOR THE FIELDS.

    ;READ BLANK LINE --- THIS IS PROBABLY WHERE THE READ CRASHES


    ;IN THE CASE OF A MAGNETIC SAMPLE THERE IS NO BLANK LINE TO READ HERE
    ;JUST BEFORE STARTING THE up/down VALUES.
    if self.magnetic eq 1 then begin
      if i ne no_of_phases - no_of_magnetic_phases-1 then begin
        readf,lun,line
      endif
    endif else begin
      readf,lun,line
    endelse
  endfor;i

  ;NOW READ MAGNETIC
  dum = self->readMagnetic(lun,lastphase,phase_step,no_of_magnetic_phases,i,j,$
                                                                meters=meters,counters=counters)
                                                                
  ;120805
  ;ADDED THESE HERE SINCE THEY MAY BE MODIFIED IN readMagnetic
  if ptr_valid(self.meters) gt 0 then ptr_free,self.meters
  self.meters = ptr_new(meters)

  if ptr_valid(self.counters) gt 0 then ptr_free,self.counters
  self.counters = ptr_new(counters)
endfor;j
free_lun,lun,/force

return,1
end;ooEcho::read
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

function ooEchoMagnetic::deadTime,im,counter0,counter4,preset,counter1,counter2,counter3,fileFormat=fileFormat
;
;NAME:
;        ooEchoMagnetic::deadTime
;
;PURPOSE:
;           PERFORM THE DEADTIME AND MONITOR CORRECTIONS FOR A SINGLE DETECTOR IMAGE.
;PARAMETERS:
;           im      A SINGLE DETECTOR IMAGE TO CORRECT.
;KEYWORDS:
;           none
;RETURN VALUE:
;           THE CORRECTED DETECTOR IMAGE.
;;
;print,'counter0,counter4,preset,counter1,counter2,counter3=',counter0,counter4,preset,counter1,counter2,counter3
;print,'preset,counter0,counter4=',preset,counter0,counter4

;
;print,'counter0,counter4,preset,counter1,counter2,counter3'
;print,counter0,counter4,preset,counter1,counter2,counter3
;print,total(im)
    ;self->addTreatment,'ooEcho::deadTime'


    ;042505
    ;VALUES HERE ARE TAKEN DIRECTLY FROM IGOR CODE

;print,'____________________'
;print,'preset=',preset
;print,'counter0=',counter0
;print,'counter4=',counter4


if (n_elements(fileFormat) eq 0) then fileFormat = ''

;111505
;
;IF counter4 is 0, THEN COUNTS ARE RECORDED IN counter0
frequency_meter_rate = strcmp(fileFormat,'NICE',/fold)?  1 : 9871.5d
if counter0 eq 0 and counter4 eq 0 then begin
  ;print,'###############'
  ;111505
  ;SETTING UP THE CASE WHERE COUNTERS ARE NOT AVAILABLE.
  ;THIS IS THE CASE WHEN READING THE MAGNETIC XYZ-UP/DOWN IMAGES.
  DeadTime = 0.7e-6
  
  ;countrate = ave_counts_per_pixel*npixels/(totaltime_in_cycles/(frequency_meter_rate))
  CountRate = mean(im)*double(n_elements(im))/(double(preset)/frequency_meter_rate)
  deadScale = 1.0/(1-DeadTime*CountRate)
  newim = long(im*deadScale)
endif else begin
  if (~strcmp(fileFormat,'NICE',/fold)) then begin
    ;LATER ADD TEST FOR FILE NUMBER OR OTHER PARAMETERS.
    filename = file_baseName(self.filename)
    sfilenum = strmid(filename,1,strpos(filename,'.'))
    filenum = fix(sfilenum)
    if filenum ge 4158 then begin  
      ;AT THIS POINT counter0 AND counter 3 WILL ALWAYS BE THE ONES
      ;WE WANT, magnetic or not.
      ;USING counter4 AS A CHECK FOR THIS MEANS THAT IF
      ;counter4 IS LATER USED FOR SOMETHING ELSE, THIS WILL CAUSE A PROBLEM.
      ;if counter4 eq 0.0 then begin
      counter4 = counter0
      counter0 = counter3
      ;endif
    endif
  endif  
  
  ;SCALE DATA TO ACTUAL NUMBER OF MONITOR COUNTS.
  monitorscale = (double(preset)/double(counter4))
  DeadTime = 0.7e-6
  
  ;CountRate = double(double(total(long64(im*preset/counter4)))/double((double(counter0)/9871.5d)))
  ;countrate = ave_counts_per_pixel*npixels/(totaltime_in_cycles/(frequency_meter_rate))
  CountRate = mean(im)*double(n_elements(im))/(double(counter0)/frequency_meter_rate)
  deadScale = 1.0/(1-DeadTime*CountRate)
  
  ;021306
  ;MOVED MONITOR SCALE OUT OF CountRate, WHERE IT SHOULD NOT HAVE BEEN, BUT SHOULD NOT
  ;HAVE HAD A SIGNIFICANT EFFECT ON THE deadTime CORRECTION,
  ;MOVED INTO THE OVERALL SCALE BELOW.
  ;print,'mean(im),min(im),max(im),counter0,frequency_meter_rate,countrate=',mean(im),min(im),max(im),counter0,frequency_meter_rate,countrate
  ;print,',deadscale,monitorscale=',deadscale,monitorscale
  newim = long(im*deadScale*monitorscale)
endelse

return,newim

end;deadTime


;
;monitorscale = (double(preset)/double(counter4)) ; this should always be 1
;DeadTime = 0.7e-6
;
;CountRate = mean(im)*double(n_elements(im))/( Counter0)
;deadScale = 1.0/(1-DeadTime*CountRate)
;
;newim = long(im*deadScale*monitorscale)
;
;return,newim



;###########################################################################
function ooEchoMagnetic::readMagnetic,lun,lastphase,phase_step,no_of_magnetic_phases,i,j,$
                            meters=meters,counters=counters,_Extra=extra
;
;NEED THE LAST PHASE , no_of_magnetic_phases AND THE lun TO READ THE FILE.
;
;;FOR NOW JUST READ ALL OF THE LINES IN THE MAGNETIC RANGE.


;THIS WILL BE USED TO READ ACTUAL DATA, AND ARRAY SIZES WILL ALREADY BE DEFINED FROM
;READING THE NORMAL STUFF.

;121405
;ADD THE CAPABILITY TO DETERMINE THE Iup/DownXYZ SCALE FACTOR DURING FILE READ.


;WORK WITH self.e DURING INITIALIZATION.
if self.magnetic eq 1 then begin
    self.f = 0.97;/.03;5.0
    self.p = 1.0;(self.f - 1.0)/(self.f + 1.0)
    self.eff_bpw = 0.81
;    self.eff_bpw_x = 0.81
;    self.eff_bpw_y = 0.81
;    self.eff_bpw_z = 0.81

    self->readXYZUpDownTechPhysics,lun

    ;SET fflag SO THAT THE WHOLE IMAGE IS READ IN ONE SHOT FOR THE FIRST
    ;DETECTOR IMAGE AFTER THE HEADER
    fflag = -1.0

    ;XUP
    self->readOneUpDownImage,lun,fflag,i+0,j,counters=counters,meters=meters

    ;XDOWN
    self->readOneUpDownImage,lun,fflag,i+2,j,counters=counters,meters=meters

    ;ZUP
    self->readOneUpDownImage,lun,fflag,i+4,j,counters=counters,meters=meters

    ;ZDOWN
    self->readOneUpDownImage,lun,fflag,i+6,j,counters=counters,meters=meters

    ;YUP
    self->readOneUpDownImage,lun,fflag,i+8,j,counters=counters,meters=meters

    ;YDOWN
    self->readOneUpDownImage,lun,fflag,i+10,j,counters=counters,meters=meters

    ;INTERMEDIATE HEADERS
    self->readXYZUpDownTechPhysics,lun
    ;XUP
    ;SET fflag TO -1.0 TO READ WHOLE IMAGE IN readOneUpDownImage
    fflag = -1.0
    self->readOneUpDownImage,lun,fflag,i+1,j,counters=counters,meters=meters

    ;XDOWN
    self->readOneUpDownImage,lun,fflag,i+3,j,counters=counters,meters=meters

    ;ZUP
    self->readOneUpDownImage,lun,fflag,i+5,j,counters=counters,meters=meters

    ;ZDOWN
    self->readOneUpDownImage,lun,fflag,i+7,j,counters=counters,meters=meters

    ;YUP
    self->readOneUpDownImage,lun,fflag,i+9,j,counters=counters,meters=meters

    ;YDOWN
    self->readOneUpDownImage,lun,fflag,i+11,j,counters=counters,meters=meters

    return,1
endif else begin
    ;print,'self.magnetic SAYS THIS IS NOT A MAGNETIC FILE.'
        self.f = 5.0
        self.p = 1.0;(self.f - 1.0)/(self.f + 1.0)

        self.point_to_down_x=self.no_of_phases-12
        self.point_to_up_x=self.no_of_phases-10
        self.point_to_down_z=self.no_of_phases-8
        self.point_to_up_z=self.no_of_phases-6
        self.point_to_down_y=self.no_of_phases-4
        self.point_to_up_y=self.no_of_phases-2
    return,1

endelse

end;readMagnetic
pro ooEchoMagnetic::readXYZUpDownTechPhysics,lun
;READ THE TWO HEADERS BEFORE THE UP AND DOWN VALUES
    line = ''
    while not stregex(line,'eof',/fold_case,/boolean) do begin
        readf,lun,line
        ;print,line
    endwhile
    line = ''
    while not stregex(line,'eof',/fold_case,/boolean) do begin
        readf,lun,line
        ;print,line
    endwhile
end;readXYZUpDownTechPhysics

pro ooEchoMagnetic::readOneUpDownImage,lun,fflag,i,j,counters=counters,meters=meters
;READ ONE MAGNETIC XYZUp/Down IMAGE AND ITS FOOTER (IF AVAILABLE)
    if n_elements(fflag) eq 0 then fflag = -1.0

    ims = dblarr(1024)

    if fflag ne -1.0 then begin
        ;print,'HI'

        imstemp = dblarr(1023)
        ims[0] = double(fflag)
        readf,lun,imstemp
        ims[1:*] = imstemp
    endif else begin
        readf,lun,ims
        ;print,'HI Integer max(ims) = ',max(ims)
    endelse




    fflag = self->readFooterXYZ(i,j,lun,counters=counters,meters=meters)

;print,i,j,fflag
    ims = self->deadTime(ims,counters[0,i,j],counters[4,i,j],self.preset,$
                            counters[1,i,j],counters[2,i,j],counters[3,i,j])
;print,'After deadTime, max(ims)=',max(ims)
    ;PUT ims INTO DATA ARRAY
    (*self.e)[*,i,j] = long(ims)

    ;PUT ASSOCIATED PHASE VALUE INTO ARRAY.
    (*self.phase)[i,j] = (*self.phase)[self->term()-1,j] + (i-self->term()+1)*self.phase_step

end;readOneUpDownImage


function ooEchoMagnetic::readFooterXYZ,i,j,lun,counters=counters,meters=meters

    ;READ FOOTERS AFTER XYZ Up/Down (IF AVAILABLE)
    CATCH, Error_status
       IF (Error_status NE 0) THEN BEGIN
            ;CATCHING DOUBLE CONVERSION PROBLEMS
          ;print,error_status
          CATCH, /CANCEL
          return,-1.0
       ENDIF

    line = ''
    ;CHECK FOR HEADER FOLLOWING EACH IMAGE
    readf,lun,line

    if strtrim(string(line),2) eq '' then begin $


        readf,lun,line

        segs = strsplit(line,/extract)

        counters[0:4,i,j] = double(segs[0:4])


        readf,lun,line
;print,'Line=',line
        segs = strsplit(line,/extract)
        if stregex(segs[1],'Temperatur') gt 0 then begin
            newsegs = strsplit(segs[1],'.',/extract)
            if n_elements(newsegs) ge 2 then begin
              meters[i,j].temperatur = double(newsegs[2])
            endif
        endif

        readf,lun,line
        segs = strsplit(line,/extract)
        meters[i,j].bspi21x = double(segs[1])
        meters[i,j].bspi21y = double(segs[3])
        meters[i,j].bspi21z = double(segs[5])

        readf,lun,line

        segs = strsplit(line,/extract)
        meters[i,j].bspix = double(segs[1])
        meters[i,j].bspiy = double(segs[3])
        meters[i,j].bspiz = double(segs[5])


        readf,lun,line
        segs = strsplit(line,/extract)
        meters[i,j].bspi22x = double(segs[1])
        meters[i,j].bspi22y = double(segs[3])
        meters[i,j].bspi22z = double(segs[5])


        return,-1.0d

    endif else begin
        ;print,double(line)
        ;print,line

        ;IF tech IS IN THIS LINE, THEN THIS WAS THE LAST XYZup/down VALUE IN THE
        ;SET, SO RETURN -1 SO THAT THE CALLING ROUTINE RECEIVES THE SIGNAL
        ;TO READ AN ENTIRE IMAGE IN ONE SHOT NEXT.
        if stregex(line,'tech',/fold_case,/boolean) then line = '-1'
        return,double(line)
    endelse
end;readFooterXYZ

;ADD THE NEXT ITEMS WHEN READY TO MESS WITH THEM.
;FOR NOW FOCUS ON magnetic ANALYSIS.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ooEchoMagnetic::cloneSet,obj,tremove=tremove,modtime=modtime;RemoveT,obj,tremove=tremove
;
;NAME:
;        ooEchoMagnetic::cloneSet
;
;PURPOSE:
;           Populate a cloned object, and do it with a Fourier time removed
;           if desired.
;PARAMETERS:
;           obj     The object to clone.
;KEYWORDS:
;           tremove The Fourier time to remove.
;           modtime The modification time of the save file being restored.


    ;011205
    ;
    ;SET VALUES IN CLONE OF obj CREATED IN ooEcho::init(obj=ref)
    ;
    ;
    ;ARGUMENTS:
    ;
    ;   obj - THE OBJECT TO BE CLONED
    ;
    ;
    ;KEYWORDS
    ;
    ;   tremove -   THE FOURIER TIME TO BE REMOVED. IF IT IS AVAILABLE IN obj.
    ;               WHEN THE tremove KEYWORD IS PRESENT, THE CLONE IS DEFINED WITH
    ;               THE FOURIER TIME REMOVED, IF IT MATCHES ONE OF THE FOURIER TIMES
    ;               IN obj.
    ;


    self.filename = obj->getProperty(tag='filename')
    self.workdir = obj->getProperty(tag='workdir')
    self.datadir = obj->getProperty(tag='datadir')
    if n_elements(modtime) eq 0 then modtime = systime(/julian,/utc)

;011205
;
;DON'T LET NUMBER OF FOURIER TIMES DROP BELOW 2!!!!!
;ooDisplayEcho CANNOT CURRENTLY HANDLE THAT.
;ALSO ooDisplayEcho IS HAVING A PROBLEM SELECTING THE CORRECT
;SET OF FOURIER TIMES.
;
;
;ALSO, LOOK FOR THE COMMENTS BELOW: "WHY ISN'T THIS BINNED?"



    ;NOW SELECT REMOVAL index FOR t:
    if n_elements(tremove) ne 0 then begin


;        print,'ooecho::cloneset   tremove=',tremove
        fourierTimes = *(obj->getProperty(tag='fourierTime'))
;        print,'ooecho::cloneset   fourierTime=',fourierTimes

;        aindex = where(*(obj->getProperty(tag='fourierTime')) eq tremove)
;print,abs(fourierTimes-tremove)/tremove

        if tremove ne 0.0 then begin

            ;081406
            ;TIGHTEN TOLERANCE IN CASE OF MULTIPLE SELECTIONS.
            ;IF THIS TOLERANCE IS NOT ADEQUATE, SIMPLY TAKE FIRST
            ;INDEX.
            aindex = where(abs(fourierTimes-tremove)/tremove lt 0.001)
            if n_elements(aindex) gt 1 then begin
                aindex = where(abs(fourierTimes-tremove)/tremove lt 0.0001)
                if n_elements(aindex) gt 1 then begin
                    aindex = where(abs(fourierTimes-tremove)/tremove lt 0.00001)
                endif
            endif
        endif else begin
            aindex = where(fourierTimes eq tremove)
        endelse

;print,'ooEchoMagnetic::cloneSet'
;print,'aindex=',aindex

        ntimes = n_elements(*(obj->getProperty(tag='fourierTime')))
        if ntimes le 2 then aindex[0] = -2

        index = aindex[0]
        if index eq -1 then begin
;            dum = dialog_message('Invalid Fourier time selected for removal.'+ $
;                                     string(13b)+" ooEcho::cloneSetRemoveT")
            remove = 0
        endif else begin
            if index eq -2 then begin
;                dum = dialog_message("Currently can't support less than 2 Fourier times." + $
;                                     string(13b)+" ooEcho::cloneSetRemoveT")
                remove = 0
;print,*p
;PROBLEM AT THIS POINT IS THAT MOST OF THE ITEMS HAVE NOT BEEN SET!!!!!

;REMOVING return SEEMS TO TAKE CARE OF THE PROBLEM!!!
;WHY WAS RETURN PLACED HERE IN THE FIRST PLACE!!!!???????

                ;return
            endif else begin
;                print,'REMOVAL INDEX = ',index
                remove = 1
            endelse

        endelse
    endif else begin
        remove = 0
    endelse



;print,"obj_isa(self,'ooEchoMagnetic') =   ",obj_isa(self,'ooEchoMagnetic')
    if obj_isa(self,'ooechomagnetic') ne 0 then begin
;message = dialog_message('ooEchoMagnetic::CloneSet Test1')

        self.magnetic = obj->getproperty(tag='magnetic')
;message = dialog_message('ooEchoMagnetic::CloneSet Test2')
        self.p = obj->getproperty(tag='p')
;message = dialog_message('ooEchoMagnetic::CloneSet Test3')
        self.f = obj->getproperty(tag='f')
;message = dialog_message('ooEchoMagnetic::CloneSet Test4')
        self.eff_bpw = obj->getproperty(tag='eff_bpw')
;message = dialog_message('ooEchoMagnetic::CloneSet Test5')
;
;        ;121405
;        ;CHECK THAT THE DATE SUGGESTS THAT THESE VALUES ARE IN ooEchoMagnetic
;        CALDAT, SYSTIME( /JULIAN,/utc ), Month , Day , Year , Hour , Minute , Second
;        CALDAT, modtime, Month , Day , Year , Hour , Minute , Second
;message = dialog_message('ooEchoMagnetic::CloneSet Test6')
;        ;print, month,day,year,hour,minute,second
;        if modtime gt 1134604600.0d then begin
;;        if year ge 2005 then begin
;;
;message = dialog_message('ooEchoMagnetic::CloneSet Test7')
;;            if (year eq 2005 and month eq 12 and day ge 14) or year ge 2006 then begin
;                self.eff_bpw_x = obj->getproperty(tag='eff_bpw_x')
;message = dialog_message('ooEchoMagnetic::CloneSet Test8')
;                self.eff_bpw_y = obj->getproperty(tag='eff_bpw_y')
;                self.eff_bpw_z = obj->getproperty(tag='eff_bpw_z')
;;            endif
;;        endif
;        endif
;message = dialog_message('ooEchoMagnetic::CloneSet Test9')


        self.point_to_up_x = obj->getproperty(tag='point_to_up_x')
        self.point_to_up_y = obj->getproperty(tag='point_to_up_y')
        self.point_to_up_z = obj->getproperty(tag='point_to_up_z')
        self.point_to_down_x = obj->getproperty(tag='point_to_down_x')
        self.point_to_down_y = obj->getproperty(tag='point_to_down_y')
        self.point_to_down_z = obj->getproperty(tag='point_to_down_z')
        self.xyzupdownscale =  obj->getproperty(tag='xyzupdownscale')
        if ptr_valid(obj->getproperty(tag='mask1dPixels')) gt 0 then begin
            self.mask1dpixels = ptr_new(*(obj->getproperty(tag='mask1dPixels')))
        endif else self.mask1dpixels = ptr_new()
        if ptr_valid(obj->getproperty(tag='extensions')) gt 0 then begin
            self.extensions = ptr_new(*(obj->getproperty(tag='extensions')))
        endif else self.extensions = ptr_new()

    endif;isa magnetic


    ;ITEMS UNCHANGED BY t REMOVAL
    self.type = obj->getProperty(tag='type')
    self.reduced = obj->getProperty(tag='reduced')
    self.reducedOld = obj->getProperty(tag='reducedOld')
    self.lambda = obj->getProperty(tag='lambda')
    self.dlambda = obj->getProperty(tag='dlambda')
    narcs = obj->getProperty(tag='narcs')
    self.QValsSwitch = obj->getProperty(tag='QValsSwitch')
    self.IupdownSwitch = obj->getProperty(tag='IupdownSwitch')
    self.currentPhaseIndex = obj->getProperty(tag='currentPhaseIndex')
    self.preset = (obj->getProperty(tag='preset'))
    self.no_of_phases = obj->getProperty(tag='no_of_phases')
    self.point_to_down = obj->getProperty(tag='point_to_down')
    self.point_to_up = obj->getProperty(tag='point_to_up')
    self.phase_step = obj->getProperty(tag='phase_step')
    self.no_of_pixels = obj->getProperty(tag='no_of_pixels')
    self.transmission = obj->getProperty(tag='transmission')
    self.volfrac = obj->getProperty(tag='volfrac')
    self.x_dim = obj->getProperty(tag='x_dim')
    self.y_dim = obj->getProperty(tag='y_dim')
    self.x_dim_orig = obj->getProperty(tag='x_dim_orig')
    self.y_dim_orig = obj->getProperty(tag='y_dim_orig')
    self.x_cen = obj->getProperty(tag='x_cen')
    self.y_cen = obj->getProperty(tag='y_cen')
    self.x_cen_orig = obj->getProperty(tag='x_cen_orig')
    self.y_cen_orig = obj->getProperty(tag='y_cen_orig')
    self.colorTable = obj->getProperty(tag='colorTable')
    self.width = obj->getProperty(tag='width')
    self.period = obj->getProperty(tag='period')
;print,'_______________'
;print,'ooechomagnetic::cloneset'
;print,'self.q=',self.q
;print,obj->getProperty(tag='q')
    self.q = obj->getProperty(tag='q')
;print,'self.q=',self.q

    self.qactual = obj->getProperty(tag='qactual')
    self.qy = obj->getProperty(tag='qy')

;110305
;DO I REALLY NEED TO SET TAGS HERE??? CHECK init --- DON'T NEED IT, BUT LEAVE IT FOR nonMAGNETIC CASE.

    if n_elements(self.tags) eq n_elements(obj->getProperty(tag='tags')) then $
            self.tags = obj->getProperty(tag='tags')

    ;THE IQTInfo POINTER WILL NOT CHANGE WITH THE NUMBER OF FOURIER TIMES.
    IQTInfotemp = *(obj->getProperty(tag='IQTInfo'))
        if ptr_valid(self.IQTInfo) gt 0 then ptr_free,self.IQTInfo
        self.IQTInfo = ptr_new(IQTInfotemp)


    treatmentTemp = *(obj->getProperty(tag='treatment'));['ooEcho::cloneSet tremove='+string(tremove)];
        if ptr_valid(self.treatment) gt 0 then ptr_free,self.treatment
        self.treatment = ptr_new(treatmentTemp)



    ;011205
    ;THE SIZE OF THE SCAN HEADER IS RELATED TO THE NUMBER OF PHASES FOR SOME REASON.
    ;WHY IS THAT?????
    scanHeadertemp = *(obj->getProperty(tag='scanHeader'))
        if ptr_valid(self.scanHeader) gt 0 then ptr_free,self.scanHeader
        self.scanHeader = ptr_new(scanHeaderTemp)

    sampleHeadertemp = *(obj->getProperty(tag='sampleHeader'))
        if ptr_valid(self.sampleHeader) gt 0 then ptr_free,self.sampleHeader
        self.sampleHeader = ptr_new(sampleHeadertemp)




    ;ITEMS CHANGED BY t REMOVAL
    if remove eq 0 then begin
        ;NO REMOVAL, REGULAR cloneSet
        self.comment = obj->getProperty(tag='comment')

        self.no_of_fourier_times = obj->getProperty(tag='no_of_fourier_times')
        self.currentFourierTimeIndex = $
                    obj->getProperty(tag='currentFourierTimeIndex')




        etemp = *(obj->getProperty(tag='e'))
        if ptr_valid(self.e) gt 0 then ptr_free,self.e
        self.e = ptr_new(etemp)
        emasktemp = *(obj->getProperty(tag='emask'))
        if ptr_valid(self.emask) gt 0 then ptr_free,self.emask
        self.emask = ptr_new(emasktemp)
        eorigtemp = *(obj->getProperty(tag='eorig'))
        if ptr_valid(self.eorig) gt 0 then ptr_free,self.eorig
        self.eorig = ptr_new(eorigtemp)
        mask2dtemp = *(obj->getProperty(tag='mask2d'))
        if ptr_valid(self.mask2d) gt 0 then ptr_free,self.mask2d
        self.mask2d = ptr_new(mask2dtemp)
        mask2dtempOld = *(obj->getProperty(tag='mask2dOld'))
        if ptr_valid(self.mask2dOld) gt 0 then ptr_free,self.mask2dOld
        self.mask2dOld = ptr_new(mask2dtempOld)
        fitdisplaymasktemp = *(obj->getProperty(tag='fitdisplaymask'))
        if ptr_valid(self.fitdisplaymask) gt 0 then ptr_free,self.fitdisplaymask
        self.fitdisplaymask = ptr_new(fitdisplaymasktemp)
        fitdisplaymasktempOld = *(obj->getProperty(tag='fitdisplaymaskOld'))
        if ptr_valid(self.fitdisplaymaskOld) gt 0 then ptr_free,self.fitdisplaymaskOld
        self.fitdisplaymaskOld = ptr_new(fitdisplaymasktempOld)
        mask1dtemp = *(obj->getProperty(tag='mask1d'))
        if ptr_valid(self.mask1d) gt 0 then ptr_free,self.mask1d
        self.mask1d = ptr_new(mask1dtemp)


;;082205
;        ;CHECK THAT THE OBJECT HAS THE NEW MASK, IF NOT
;        ;THE OBJECT IS FROM AN OLD RESTORED FILE AND THIS
;        ;STEP MUST BE SET UP WITH A DUMMY MASK BASED ON THE
;        ;mask1d.
;        tags = (obj->getProperty(tag='tags'))
;        wtags = where(tags eq 'mask1dPixels')
;        if wtags[0] ne -1 then begin
;            mask1dpixelstemp = *(obj->getProperty(tag='mask1dPixels'))
;            if ptr_valid(self.mask1dpixels) gt 0 then ptr_free,self.mask1dpixels
;            self.mask1d = ptr_new(mask1dpixelstemp)
;        endif else begin
;            mask1dpixelstemp = intarr(self.x_dim*self.y_dim,self.no_of_phases,self.no_of_fourier_times)
;            for ii=0,self.x_dim*self.y_dim-1 do begin
;                mask1dpixelstemp[ii,*,*] = mask1dtemp
;            endfor;ii
;            if ptr_valid(self.mask1dpixels) gt 0 then ptr_free,self.mask1dpixels
;            self.mask1dpixels = ptr_new(mask1dpixelstemp)
;        endelse
;;##########

        fixedtemp = *(obj->getProperty(tag='fixed'))
        if ptr_valid(self.fixed) gt 0 then ptr_free,self.fixed
        self.fixed = ptr_new(fixedtemp)
        fitparmstemp = *(obj->getProperty(tag='fitparms'))
        if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
        self.fitparms = ptr_new(fitparmstemp)

        if ptr_valid(obj->getProperty(tag='fitparmsOld')) eq 0 then begin
            ;NO FITTING DONE YET, SO ptr NOT INITIALIZED.  DO SO NOW.
            obj->setproperty,'fitparmsOld',ptr_new(fitparmstemp)
        endif

        fitparmstempOld = *(obj->getProperty(tag='fitparmsOld'))
        if ptr_valid(self.fitparmsOld) gt 0 then ptr_free,self.fitparmsOld
        self.fitparmsOld = ptr_new(fitparmstempOld)
        Iuptemp = *(obj->getProperty(tag='Iup'))
        if ptr_valid(self.Iup) gt 0 then ptr_free,self.Iup
        self.Iup = ptr_new(Iuptemp)
        Idowntemp = *(obj->getProperty(tag='Idown'))
        if ptr_valid(self.Idown) gt 0 then ptr_free,self.Idown
        self.Idown = ptr_new(Idowntemp)
        sIuptemp = *(obj->getProperty(tag='sIup'))
        if ptr_valid(self.sIup) gt 0 then ptr_free,self.sIup
        self.sIup = ptr_new(sIuptemp)
        sIdowntemp = *(obj->getProperty(tag='sIdown'))
        if ptr_valid(self.sIdown) gt 0 then ptr_free,self.sIdown
        self.sIdown = ptr_new(sIdowntemp)
        Stemp = *(obj->getProperty(tag='S'))
        if ptr_valid(self.S) gt 0 then ptr_free,self.S
        self.S = ptr_new(Stemp)
        sStemp = *(obj->getProperty(tag='sS'))
        if ptr_valid(self.sS) gt 0 then ptr_free,self.sS
        self.sS = ptr_new(sStemp)
        IQTInfotemp = *(obj->getProperty(tag='IQTInfo'))
        if ptr_valid(self.IQTInfo) gt 0 then ptr_free,self.IQTInfo
        self.IQTInfo = ptr_new(IQTInfotemp)
        IQTtemp = *(obj->getProperty(tag='IQT'))
        if ptr_valid(self.IQT) gt 0 then ptr_free,self.IQT
        self.IQT = ptr_new(IQTtemp)
        sIQTtemp = *(obj->getProperty(tag='sIQT'))
        if ptr_valid(self.sIQT) gt 0 then ptr_free,self.sIQT
        self.sIQT = ptr_new(sIQTtemp)

        IQTFitparmstemp = *(obj->getProperty(tag='IQTFitparms'))
        if ptr_valid(self.IQTFitparms) gt 0 then ptr_free,self.IQTFitparms
        self.IQTFitparms = ptr_new(IQTFitparmstemp)

        qarcstemp = *(obj->getProperty(tag='qarcs'))
        if ptr_valid(self.qarcs) gt 0 then ptr_free,self.qarcs
        self.qarcs = ptr_new(qarcstemp)
        QValstemp = *(obj->getProperty(tag='QVals'))
        if ptr_valid(self.QVals) gt 0 then ptr_free,self.QVals
        self.QVals = ptr_new(QValstemp)
        ;HOW DOES self.chisq BECOME DEREFERENCED?!?
        chisqtemp = *(obj->getProperty(tag='chisq'))
        ;chisqtemp = (*self.chisq)
        if ptr_valid(self.chisq) gt 0 then ptr_free,self.chisq
        self.chisq = ptr_new(chisqtemp)

        if ptr_valid(obj->getProperty(tag='chisqOld')) eq 0 then begin
            ;NO FITTING DONE YET, SO INITIALIZE ptr
            obj->setProperty,'chisqOld',ptr_new(chisqtemp)
        endif
        chisqtempOld = *(obj->getProperty(tag='chisqOld'))
        if ptr_valid(self.chisqOld) gt 0 then ptr_free,self.chisqOld
        self.chisqOld = ptr_new(chisqtempOld)
        phasetemp = *(obj->getProperty(tag='phase'))
        if ptr_valid(self.phase) gt 0 then ptr_free,self.phase
        self.phase = ptr_new(phasetemp)
        meterstemp = *(obj->getProperty(tag='meters'))
        if ptr_valid(self.meters) gt 0 then ptr_free,self.meters
        self.meters = ptr_new(meterstemp)
        counterstemp = *(obj->getProperty(tag='counters'))
        if ptr_valid(self.counters) gt 0 then ptr_free,self.counters
        self.counters = ptr_new(counterstemp)
        monitorstemp = *(obj->getProperty(tag='monitors'))
        if ptr_valid(self.monitors) gt 0 then ptr_free,self.monitors
        self.monitors = ptr_new(monitorstemp)
        fourierTimetemp = *(obj->getProperty(tag='fourierTime'))
        if ptr_valid(self.fourierTime) gt 0 then ptr_free,self.fourierTime
        self.fourierTime = ptr_new(fourierTimetemp)
        sampleHeadertemp = *(obj->getProperty(tag='sampleHeader'))
        if ptr_valid(self.sampleHeader) gt 0 then ptr_free,self.sampleHeader
        self.sampleHeader = ptr_new(sampleHeadertemp)
        techHeadertemp = *(obj->getProperty(tag='techHeader'))
        if ptr_valid(self.techHeader) gt 0 then ptr_free,self.techHeader
        self.techHeader = ptr_new(techHeadertemp)
        physicsHeadertemp = *(obj->getProperty(tag='physicsHeader'))
        if ptr_valid(self.physicsHeader) gt 0 then ptr_free,self.physicsHeader
        self.physicsHeader = ptr_new(physicsHeadertemp)
        physicsParametersHeadertemp = ['REMOVING HEADER!!!'];*(obj->getProperty(tag='physicsParametersHeader'))
        if ptr_valid(self.physicsParametersHeader) gt 0 then ptr_free,self.physicsParametersHeader
        self.physicsParametersHeader = ptr_new(physicsParametersHeadertemp)
        phaseHeadertemp = ['REMOVING HEADER'];*(obj->getProperty(tag='phaseHeader'))
        if ptr_valid(self.phaseHeader) gt 0 then ptr_free,self.phaseHeader
        self.phaseHeader = ptr_new(phaseHeadertemp)


    endif else begin

        ;NOW REMOVE EVERYTHING WHERE THE FOURIER TIME IS
        ;AT THE SELECTED INDEX.

;121905
;ADDING A FORMAT TO THE FOLLOWING COMMAND TO MINIMIZE THE ADDED TEXT
        self.comment = strtrim(obj->getProperty(tag='comment'),2) + $
                        ': Removed t = ' + $
                        strtrim(string(tremove*(10.0^9),format='(f9.4)'),2) + 'ns. '


        nftorig = obj->getProperty(tag='no_of_fourier_times')
        self.no_of_fourier_times = nftorig - 1
        self.currentFourierTimeIndex = 0


        bin = self.x_dim_orig/self.x_dim
        linbinned = (self.x_dim_orig*self.y_dim_orig)/(bin*bin)         ;SET ABOVE
        linnobin  = self.no_of_pixels                                   ;SET ABOVE
        nphs = self.no_of_phases                                        ;SET ABOVE
        nft = self.no_of_fourier_times                                  ;SET ABOVE




        ;CREATE POINTERS TO THE NEW-SIZED ARRAYS
        if ptr_valid(self.e) gt 0 then ptr_free,self.e
        self.e = ptr_new(lonarr(linbinned, nphs, nft))

        if ptr_valid(self.emask) gt 0 then ptr_free,self.emask
        self.emask = ptr_new(lonarr(linbinned, nphs, nft))

        if ptr_valid(self.eorig) gt 0 then ptr_free,self.eorig
        self.eorig = ptr_new(lonarr(linnobin, nphs, nft))

        if ptr_valid(self.mask2d) gt 0 then ptr_free,self.mask2d
        self.mask2d = ptr_new(intarr(linbinned,nft))

        if ptr_valid(self.fitdisplaymask) gt 0 then ptr_free,self.fitdisplaymask
        self.fitdisplaymask = ptr_new(intarr(linbinned,nft))




        ;GET SIZE OF SAVED PARAMETER IN CASE THE BINNING HAS CHANGED SINCE
        ;THE LAST SAVE.
        mask2dtempOld = *(obj->getProperty(tag='mask2dOld'))
        sz = size(mask2dtempOld)
        if ptr_valid(self.mask2dOld) gt 0 then ptr_free,self.mask2dOld
        self.mask2dOld = ptr_new(intarr(sz[1],nft))

        fitdisplaymaskTempOld = *(obj->getProperty(tag='fitdisplaymaskOld'))
        sz = size(fitdisplaymaskTempOld)
        if ptr_valid(self.fitdisplaymaskOld) gt 0 then ptr_free,self.fitdisplaymaskOld
        self.fitdisplaymaskOld = ptr_new(intarr(sz[1],nft))

        if ptr_valid(self.mask1d) gt 0 then ptr_free,self.mask1d
        self.mask1d = ptr_new(intarr(nphs,nft))


;;082205
;        if ptr_valid(self.mask1dPixels) gt 0 then ptr_free,self.mask1dPixels
;        self.mask1dPixels = ptr_new(intarr(sz[1],nphs,nft))



        if ptr_valid(self.fixed) gt 0 then ptr_free,self.fixed
        self.fixed = ptr_new(intarr(6,linbinned,nft))

        if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
        self.fitparms = ptr_new(dblarr(12,linbinned,nft))

        fitparmsTempOld =  *(obj->getProperty(tag='fitparmsOld'))
        sz = size(fitparmsTempOld)
        if ptr_valid(self.fitparmsOld) gt 0 then ptr_free,self.fitparmsOld
        self.fitparmsOld = ptr_new(dblarr(12,sz[2],nft))
        ;self.fitparmsOld = ptr_new(dblarr(12,linbinned,nft))

        if ptr_valid(self.chisq) gt 0 then ptr_free,self.chisq
        self.chisq = ptr_new(dblarr(linbinned,nft))


        chisqOld =  *(obj->getProperty(tag='chisqOld'))
        sz = size(chisqOld)
        if ptr_valid(self.chisqOld) gt 0 then ptr_free,self.chisqOld
        self.chisqOld = ptr_new(dblarr(sz[1],nft))
        ;self.chisqOld = ptr_new(dblarr(linbinned,nft))

        if ptr_valid(self.Iup) gt 0 then ptr_free, self.Iup
        self.Iup = ptr_new(dblarr(linbinned,nft))

        if ptr_valid(self.Idown) gt 0 then ptr_free, self.Idown
        self.Idown = ptr_new(dblarr(linbinned,nft))

        sIuptemp = *(obj->getProperty(tag='sIup'))
        sz = size(sIuptemp)
        if ptr_valid(self.sIup) gt 0 then ptr_free, self.sIup
        self.sIup = ptr_new(dblarr(sz[1],nft))

        sIdowntemp = *(obj->getProperty(tag='sIdown'))
        sz = size(sIuptemp)
        if ptr_valid(self.sIdown) gt 0 then ptr_free, self.sIdown
        self.sIdown = ptr_new(dblarr(sz[1],nft))


        stemp = *(obj->getProperty(tag='S'))
        sz = size(stemp)
        if ptr_valid(self.S) gt 0 then ptr_free, self.S
        self.S = ptr_new(dblarr(sz[1],nft))

        sstemp = *(obj->getProperty(tag='sS'))
        sz = size(sstemp)
        if ptr_valid(self.sS) gt 0 then ptr_free, self.sS
        self.sS = ptr_new(dblarr(sz[1],nft))

        if ptr_valid(self.IQT) gt 0 then ptr_free,self.IQT
        self.IQT = ptr_new(dblarr(self.narcs,nft))

        if ptr_valid(self.sIQT) gt 0 then ptr_free,self.sIQT
        self.sIQT = ptr_new(dblarr(self.narcs,nft))

        if ptr_valid(self.QVals) gt 0 then ptr_free,self.QVals
        self.QVals = ptr_new(dblarr(linbinned,nft))

        if ptr_valid(self.qarcs) gt 0 then ptr_free,self.qarcs
        self.qarcs = ptr_new(dblarr(self.narcs))

        if ptr_valid(self.phase) gt 0 then ptr_free,self.phase
        self.phase = ptr_new(fltarr(nphs,nft))

        iec_multimeter = {$
            Temperatur:0.0,$
            BSpiy:0.0,$
            BSpi21x:0.0,$
            BSpi21z:0.0,$
            BSpi22y:0.0,$
            BSpix:0.0,$
            BSpiz:0.0,$
            BSpi21y:0.0,$
            BSpi22x:0.0,$
            BSpi22z:0.0 $
            }
        meters=replicate(iec_multimeter,nphs,nft)
        if ptr_valid(self.meters) gt 0 then ptr_free,self.meters
        self.meters = ptr_new(meters)

        if ptr_valid(self.counters) gt 0 then ptr_free,self.counters
        self.counters = ptr_new(dblarr(10,nphs,nft))


        monitor_struct = {NSE_MONITOR_STRUCT,m1:0.0,m2:0.0,m3:0.0}
        monitors=replicate(monitor_struct,nft)
        if ptr_valid(self.monitors) gt 0 then ptr_free,self.monitors
        self.monitors = ptr_new(monitors)


        self.fourierTime = ptr_new(fltarr(nft))

        self.sampleHeader = ptr_new(strarr(17))
        self.techHeader = ptr_new(strarr(54,nft))
        self.physicsHeader = ptr_new(strarr(16,nft))

;070605
;NEED TO ALLOW FOR POSSIBLE EXTRA LINES DUE TO TEMPERATURE PROBE
        physicsParametersHeadertemp = ['omiting headers'];*(obj->getProperty(tag='physicsParametersHeader'))
        szppht = size(physicsParametersHeadertemp)
        self.physicsParametersHeader = ptr_new(strarr(szppht[1],nft))
;        self.physicsParametersHeader = ptr_new(strarr(44,nft))

        self.phaseHeader = ptr_new(strarr(4,nphs,nft))




        ;ASSIGN THE VALUES TO THE ARRAYS AT THE POINTERS.
        etemp = *(obj->getProperty(tag='e'))
        ;help,etemp
        ;help,*self.e
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.e))[*,*,j] = etemp[*,*,i]
                j++
            endif
        endfor;i



        emasktemp = *(obj->getProperty(tag='emask'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.emask))[*,*,j] = emasktemp[*,*,i]
                j++
            endif
        endfor;i


        eorigtemp = *(obj->getProperty(tag='eorig'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.eorig))[*,*,j] = eorigtemp[*,*,i]
                j++
            endif
        endfor;i



        mask2dtemp = *(obj->getProperty(tag='mask2d'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.mask2d))[*,j] = mask2dtemp[*,i]
                j++
            endif
        endfor;i


        mask2dtempOld = *(obj->getProperty(tag='mask2dOld'))
        ;help,mask2dtempOld
        ;help,*self.mask2dOld
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.mask2dOld))[*,j] = mask2dtempOld[*,i]
                j++
            endif
        endfor;i


        fitdisplaymasktemp = *(obj->getProperty(tag='fitdisplaymask'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fitDisplayMask))[*,j] = fitDisplayMasktemp[*,i]
                j++
            endif
        endfor;i

        fitdisplaymasktempOld = *(obj->getProperty(tag='fitdisplaymaskOld'))
        ;help,fitdisplaymasktempOld
        ;help,*self.fitdisplaymask
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fitDisplayMaskOld))[*,j] = fitDisplayMasktempOld[*,i]
                j++
            endif
        endfor;i


        mask1dtemp = *(obj->getProperty(tag='mask1d'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.mask1d))[*,j] = mask1dtemp[*,i]
                j++
            endif
        endfor;i

;;082205
;        mask1dpixelstemp = *(obj->getProperty(tag='mask1dPixels'))
;        j=0
;        for i=0,nftorig-1 do begin
;            if i ne index then begin
;                (*(self.mask1dPixels))[*,*,j] = mask1dpixelstemp[*,*,i]
;                j++
;            endif
;        endfor;i
;;########

        fixedtemp = *(obj->getProperty(tag='fixed'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fixed))[*,*,j] = fixedtemp[*,*,i]
                j++
            endif
        endfor;i


        fitparmstemp = *(obj->getProperty(tag='fitparms'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fitparms))[*,*,j] = fitparmstemp[*,*,i]
                j++
            endif
        endfor;i


        fitparmstempOld = *(obj->getProperty(tag='fitparmsOld'))
        ;help,fitparmstempOld
        ;help,*(self.fitparmsOld)
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fitparmsOld))[*,*,j] = fitparmstempOld[*,*,i]
                j++
            endif
        endfor;i


        Iuptemp = *(obj->getProperty(tag='Iup'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.Iup))[*,j] = Iuptemp[*,i]
                j++
            endif
        endfor;i


        Idowntemp = *(obj->getProperty(tag='Idown'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.Idown))[*,j] = Idowntemp[*,i]
                j++
            endif
        endfor;i


        ;WHY ISN'T THIS BINNED????? ---- IT APPEARS TO BE BINNED NOW (011805).
        sIuptemp = *(obj->getProperty(tag='sIup'))
        ;help,sIuptemp
        ;help,*self.sIup
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.sIup))[*,j] = sIuptemp[*,i]
                j++
            endif
        endfor;i



        sIdowntemp = *(obj->getProperty(tag='sIdown'))
        ;help,sIuptemp
        ;help,*self.sIup
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.sIdown))[*,j] = sIdowntemp[*,i]
                j++
            endif
        endfor;i





;011405
;PROGRAM CRASHES HERE WHEN FOURIER TIME REMOVED FROM MERGED FILES!
;
;S MUST BE HANDLED INCORRRECTLY IN THE MERGE!!!

;GO TO LINE 10410 ;AND FIX INTERLEAVING OF S AND FOLLOWING DATA MEMBERS!!!!



        stemp = *(obj->getProperty(tag='S'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.S))[*,j] = stemp[*,i]
                j++
            endif
        endfor;i


        sstemp = *(obj->getProperty(tag='sS'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.sS))[*,j] = sstemp[*,i]
                j++
            endif
        endfor;i


        iqttemp = *(obj->getProperty(tag='IQT'))

        j=0
        if ptr_valid(self.IQT) ne 0 then ptr_free,self.IQT
        newIQT = iqttemp[*,1:*]
        self.IQT = ptr_new(newIQT)
;        for i=0,nftorig-1 do begin
;            if i ne index then begin
;;042105
;;PROGRAM CRASHED HERE BECAUSE I(Q,t) WAS THE WRONG SIZE.
;;FIX THIS BY ELIMINATING THIS LOOP.  I(Q,t) IS CALCULATED AS NEEDED.
;                (*(self.IQT))[*,j] = iqttemp[*,i]
;                j++
;            endif
;        endfor;i


        siqttemp = *(obj->getProperty(tag='sIQT'))
        j=0
        if ptr_valid(self.sIQT) ne 0 then ptr_free,self.sIQT
        newsIQT = siqttemp[*,1:*]
        self.sIQT = ptr_new(newsIQT)

;042105
;        for i=0,nftorig-1 do begin
;            if i ne index then begin
;                (*(self.sIQT))[*,j] = siqttemp[*,i]
;                j++
;            endif
;        endfor;i


        qarcstemp = *(obj->getProperty(tag='qarcs'))
;        j=0
;        for i=0,nftorig-1 do begin
;            if i ne index then begin
                (*(self.qarcs)) = $;[*] = $
                                qarcstemp;[*]
;                j++
;            endif
;        endfor;i


        qvalstemp = *(obj->getProperty(tag='QVals'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.qvals))[*,j] = qvalstemp[*,i]
                j++
            endif
        endfor;i


        phasetemp = *(obj->getProperty(tag='phase'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.phase))[*,j] = phasetemp[*,i]
                j++
            endif
        endfor;i



        meterstemp = *(obj->getProperty(tag='meters'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.meters))[*,j] = meterstemp[*,i]
                j++
            endif
        endfor;i


        counterstemp = *(obj->getProperty(tag='counters'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.counters))[*,*,j] = counterstemp[*,*,i]
                j++
            endif
        endfor;i


        monitorstemp = *(obj->getProperty(tag='monitors'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.monitors))[j] = monitorstemp[i]
                j++
            endif
        endfor;i


        chisqtemp = *(obj->getProperty(tag='chisq'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.chisq))[*,j] = chisqtemp[*,i]
                j++
            endif
        endfor;i


        chisqtempOld = *(obj->getProperty(tag='chisqOld'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.chisqOld))[*,j] = chisqtempOld[*,i]
                j++
            endif
        endfor;i


        fourierTimetemp = *(obj->getProperty(tag='fourierTime'))
        j=0
        for i=0,nftorig-1 do begin
            if i ne index then begin
                (*(self.fourierTime))[j] = fourierTimetemp[i]
                j++
            endif
        endfor;i


        techHeadertemp = *(obj->getProperty(tag='techHeader'))
        if (size(techheadertemp))[0] ne 2 then begin
            if ptr_valid(self.techheader) gt 0 then ptr_free,self.techheader
            self.techheader = ptr_new(['TECH REMOVED ON t REMOVAL.'])

        endif else begin
            j=0
            for i=0,nftorig-1 do begin
                if i ne index then begin
                    (*(self.techHeader))[*,j] = techHeadertemp[*,i]
                    j++
                endif
            endfor;i
        endelse


        physicsHeadertemp = *(obj->getProperty(tag='physicsHeader'))
        if (size(physicsheadertemp))[0] ne 2 then begin
            if ptr_valid(self.physicsheader) gt 0 then ptr_free,self.physicsheader
            self.physicsheader = ptr_new(['physics REMOVED ON t REMOVAL.'])

        endif else begin
            j=0
            for i=0,nftorig-1 do begin
                if i ne index then begin
                    (*(self.physicsHeader))[*,j] = physicsHeadertemp[*,i]
                    j++
                endif
            endfor;i
        endelse

;070605
;NEED TO MAKE SURE THIS SIZE IS FLEXIBLE TO ALLOW FOR POSSIBLE EXTRA LINE(S) FROM
;THE TEMPERATURE SENSOR/CONTROLLER
        physicsParametersHeadertemp = ['omitting headers'];*(obj->getProperty(tag='physicsParametersHeader'))
        if (size(physicsParametersheadertemp))[0] ne 2 then begin
            if ptr_valid(self.physicsParametersheader) gt 0 then ptr_free,self.physicsParametersheader
            self.physicsParametersheader = ptr_new(['physicsParameters REMOVED ON t REMOVAL.'])

        endif else begin

            j=0
            for i=0,nftorig-1 do begin
                if i ne index then begin
                    (*(self.physicsParametersHeader))[*,j] = physicsParametersHeadertemp[*,i]
                    j++
                endif
            endfor;i
        endelse

        phaseHeadertemp = ['Phase Headers REMOVED ON t REMOVAL.'];*(obj->getProperty(tag='phaseHeader'))
        ;help,phaseHeaderTemp
        ;print," remove ne 0"
        phsz = size(phaseHeaderTemp)
        if (size(phaseheadertemp))[0] ne 3 then begin
            if ptr_valid(self.phaseheader) gt 0 then ptr_free,self.phaseheader
            self.phaseheader = ptr_new(['Phase Headers REMOVED ON t REMOVAL.'])

        endif else begin

            j=0
            for i=0,nftorig-1 do begin
                if i ne index then begin
                    for kk = 0,phsz[2]-1 do begin
                        (*(self.phaseHeader))[*,kk,j] = phaseHeadertemp[*,kk,i]
                    endfor;kk
                    j++
                endif
            endfor;i
        endelse

    endelse; cloneSetRemoveT LOOP

    ;LRK 11/20/09  WILL THIS PROPERLY CLONE ALL THE EXTENSION IN THE POINTER?  
    ;              I BELIEVE SO SINCE THE NEXT METHOD DIGS THROUGH THE STRUCTURE.
    self->checkAndUpdateExtensionsPtr,extensions=obj->getProperty(tag='extensions')
end;cloneSet   ;RemoveT

function ooEchoMagnetic::removeT,t,firstread=firstread,_Extra=extra
;
;NAME:
;        ooEchoMagnetic::removeT
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;           firstread   If the time removal is at the initial read, set this switch.
;                       Typically you would use this to remove t=0.0 for incomplete files.
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;
        ;THIS FUNCTION CREATES A NEW OBJECT WITH THE SELECTED FOURIER TIME
        ;REMOVED.
        ;
        ;ooEcho::init WILL CALL THE NEW METHOD, ooEcho::cloneSetRemoveT
;print,'REMOVING T VALUES IN OOECHOMAGNETIC'
        nft = self.no_of_fourier_times
        nphs = self.no_of_phases
        xdim = self.x_dim_orig
        ydim = self.y_dim_orig
        bin = self.x_dim_orig/self.y_dim_orig

        ;pro ooEcho::cloneSetRemoveT,obj,tremove=tremove

;LRK 110708
;CHECK TO SEE HOW MANY t'S THERE ARE OR SORT THIS OUT OUTSIDE OF THIS METHOD.
;print,'ooEchoMagnetic::removeT n_elements(t)=',n_elements(t)

        ;070605
        ;CHECK IF t = 0.  IF SO, REMOVE ALL t eq 0.
        if t eq 0.0 then begin
            otemp = obj_new('ooechoMagnetic',nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,removetobj=self,tremove=t,blank=1)
            oft = *(otemp->getProperty(tag='fourierTime'))


            whr = where(t eq oft)
            multicom = 'Removed t = 0.00000000 ns.'
            ;multicom = ': Removed t = 0.0 ns.'

            while whr[0] ne -1 do begin
                ;CLEAN UP THE COMMENT SO ONLY ONE 0.0 ns IS LISTED
                com = otemp->getproperty(tag='comment')
;print,'________'
;print,com
                pos = strpos(com,multicom)
;print,pos
                if pos ne -1 then begin
                    com = strmid(com,0,pos);,strlen(multicom))
                endif
;print,com

                ;print,'com = ',com
                otemp->setproperty,'comment',com

                ;CREATE A NEW OBJECT WITH ANOTHER t=0.0 REMOVED
                o = obj_new('ooEchoMagnetic',nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,removetobj=otemp,tremove=t,blank=1)

                ;DESTROY THE PREVIOUS OBJECT
                obj_destroy,otemp


                ;TEST FOR MORE t=0.0
                oft = *(o->getProperty(tag='fourierTime'))
                whr = where(t eq oft)

                if n_elements(oft) le 2 then whr[0] = -1

                otemp = o
            endwhile
            o = otemp
        endif else begin
            o = obj_new('ooechoMagnetic',nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,removetobj=self,tremove=t,blank=1)
        endelse

        ;print,oft
        return,o
end;removeT


pro ooEchoMagnetic::blankObj,nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,bin=bin;,obj
;
;NAME:
;        ooEchoMagnetic::blankObj
;
;PURPOSE:
;           Populate self as a blank ooEchoMagnetic object.
;PARAMETERS:
;           none
;KEYWORDS:
;           nft
;           nphs
;           xdim
;           ydim
;           bin


    ;101304
    ;CREATE A BLANK OBJECT WITH ARRAYS OF PROPER SIZES
    ;BUT NO VALUES.

    ;THIS OBJECT WILL BE USED TO INITIALIZE THE
    ;ooDisplayEcho GUI.

    ;TAKE CARE ON DETAILS LIKE point_to_up AND point_to_down
    ;etc.


    ;011105
    ;
    ;SET UP A BLANK OBJECT WITH A SPECIFIC NUMBER OF FOURIER TIMES
    ;TO FACILITATE DELETION OF A SINGLE FOURIER TIME.

    if n_elements(nft) eq 0 then nft = 14
    if n_elements(nphs) eq 0 then nphs = 27
    if n_elements(xdim) eq 0 then xdim = 32
    if n_elements(ydim) eq 0 then ydim = 32
    if n_elements(bin) eq 0 then bin = 4

    linbinned = (xdim*ydim)/(bin*bin)
    linnobin =  (xdim*ydim)

    treatment = [*self.treatment,'ooEchoMagnetic::blankObj']
    if ptr_valid(self.treatment) gt 0 then ptr_free,self.treatment
    self.treatment = ptr_new(treatment)



   tags= [ 'filename',$
            'workdir',$
            'datadir',$
            'type',$
            'reduced',$
            'reducedOld',$
            'e',$
            'emask',$
            'eorig',$
            'mask2d',$
            'mask2dOld',$
            'fitdisplaymask',$
            'fitdisplaymaskOld',$
            'mask1d',$
;;082205
;            'mask1dPixels',$
            'lambda',$
            'dlambda',$
            'comment',$
            'fixed',$
            'fitparms',$
            'fitparmsOld',$
            'chisq',$
            'chisqOld',$
            'Iup',$
            'Idown',$
            'sIup',$
            'sIdown',$
            'IupdownSwitch',$
            'S',$
            'sS',$
            'IQTInfo',$
            'IQT',$
            'sIQT',$
            'QVals',$
            'QValsSwitch',$
            'narcs',$
            'qarcs',$
            'phase',$
            'currentPhaseIndex',$
            'meters',$
            'counters',$
            'monitors',$
            'preset',$
            'no_of_phases',$
            'point_to_down',$
            'point_to_up',$
            'phase_step',$
            'no_of_fourier_times',$
            'no_of_pixels',$
            'beam_cen_x',$
            'beam_cen_y',$
            'transmission',$
            'volfrac',$
            'x_dim',$
            'y_dim',$
            'x_cen',$
            'y_cen',$
            'x_dim_orig',$
            'y_dim_orig',$
            'x_cen_orig',$
            'y_cen_orig',$
            'width',$
            'period',$
            'colorTable',$
            'q',$
            'qactual',$
            'qy',$
            'fourierTime',$
            'currentFourierTimeIndex',$
            'scanHeader',$
            'sampleHeader',$
            'techHeader',$
            'physicsHeader',$
            'physicsParametersHeader',$
            'phaseHeader',$
            'treatment',$
            'IQTFitparms',$
            'tags']

self.tags = tags
self.filename = 'null'
self.workdir = ''
self.datadir = ''
self.type = 0
self.reduced = 0
self.reducedOld = 0
self.e = ptr_new(lonarr(linbinned, nphs, nft))
self.emask = ptr_new(lonarr(linbinned, nphs, nft))
self.eorig = ptr_new(lonarr(linnobin, nphs, nft))
self.mask2d = ptr_new(intarr(linbinned,nft))
self.fitdisplaymask = ptr_new(intarr(linbinned,nft))
self.mask2dOld = ptr_new(intarr(linbinned,nft))
self.fitdisplaymaskOld = ptr_new(intarr(linbinned,nft))
self.mask1d = ptr_new(intarr(nphs,nft))

;;082205
;self.mask1dPixels = ptr_new(intarr(64,nphs,nft))

self.lambda = double(1.0e-10)
self.dlambda = double(1.0e-10)
self.comment = 'none'
self.fixed = ptr_new(intarr(6,linbinned,nft))
self.fitparms = ptr_new(dblarr(12,linbinned,nft))
self.fitparmsOld = ptr_new(dblarr(12,linbinned,nft))
self.chisq = ptr_new(dblarr(linbinned,nft))
self.chisqOld = ptr_new(dblarr(linbinned,nft))
self.Iup = ptr_new(dblarr(linbinned,nft))
self.Idown = ptr_new(dblarr(linbinned,nft))
self.sIup = ptr_new(dblarr(linbinned,nft))
self.sIdown = ptr_new(dblarr(linbinned,nft))
self.IupdownSwitch = 0
self.S = ptr_new(dblarr(linbinned,nft))
self.sS = ptr_new(dblarr(linbinned,nft))
self.IQTInfo = ptr_new('')
self.IQT = ptr_new(dblarr(5,nft))
self.sIQT = ptr_new(dblarr(5,nft))
self.IQTFitparms = ptr_new(dblarr(5,2))


self.QVals = ptr_new(dblarr(linbinned,nft))
self.QValsSwitch = 0
self.narcs = 7
self.qarcs = ptr_new(dblarr(5))
self.phase = ptr_new(fltarr(nphs,nft))
self.currentPhaseIndex = 0

        iec_multimeter = {$
            Temperatur:0.0,$
            BSpiy:0.0,$
            BSpi21x:0.0,$
            BSpi21z:0.0,$
            BSpi22y:0.0,$
            BSpix:0.0,$
            BSpiz:0.0,$
            BSpi21y:0.0,$
            BSpi22x:0.0,$
            BSpi22z:0.0 $
            }
        meters=replicate(iec_multimeter,nphs,nft)


self.meters = ptr_new(meters)
;<PtrHeapVar219663>
;                STRUCT    = -> <Anonymous> Array[nphs, nft]
self.counters = ptr_new(dblarr(10,nphs,nft))
self.monitors = ptr_new()
;<PtrHeapVar219665>
;                STRUCT    = -> <Anonymous> Array[nft]
self.preset = 10000
self.no_of_phases = nphs
self.point_to_down = 19
self.point_to_up = 24
self.phase_step = 45
self.no_of_fourier_times = nft
self.no_of_pixels = linnobin
self.beam_cen_x = 16.00
self.beam_cen_y = 16.00
self.transmission = 1.0
self.volfrac = 0.0
self.x_dim = 8
self.y_dim = 8
self.x_cen = 4.0
self.y_cen = 3.75
self.x_dim_orig = 32
self.y_dim_orig = 32
self.x_cen_orig = 16.0
self.y_cen_orig = 15.0
self.width = 702.0
self.period = 373.0
self.colorTable = 3
self.q = 0.0
self.qactual = 0.0
self.qy = 0.0
self.fourierTime = ptr_new(fltarr(nft))
self.currentFourierTimeIndex = 0
self.scanHeader = ptr_new(strarr(nphs))
self.sampleHeader = ptr_new(strarr(17))
self.techHeader = ptr_new(strarr(54,nft))
self.physicsHeader = ptr_new(strarr(16,nft))
self.physicsParametersHeader = ptr_new(strarr(44,nft))
self.phaseHeader = ptr_new(strarr(4,nphs,nft))
self.tags = tags

    if obj_isa(self,'ooechomagnetic') ne 0 then begin

        self.magnetic = 0
        self.f = 0.97;1.0

        self.p = 1.0;(5.0 - 1.0)/(5.0 + 1.0)

        self.eff_bpw = 0.81
;        self.eff_bpw_x = 0.81
;        self.eff_bpw_y = 0.81
;        self.eff_bpw_z = 0.81

        self.point_to_down_x = self.no_of_phases - 12
        self.point_to_up_x = self.no_of_phases - 10
        self.point_to_down_z = self.no_of_phases - 8
        self.point_to_up_z = self.no_of_phases - 6
        self.point_to_down_y = self.no_of_phases - 4
        self.point_to_up_y = self.no_of_phases - 2
        self.xyzupdownscale =  1.0
        self.mask1dpixels = ptr_new()
        self.extensions = ptr_new()

    endif;isa magnetic



end;blankObj
;;;;;;;;;;;;;;;;;;;;;
function ooEchoMagnetic::clone,modtime=modtime
;
;NAME:
;        ooEchoMagnetic::clone
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;
    return,obj_new('ooEchoMagnetic',obj=self,modtime=modtime)
end



function ooEchoMagnetic::mergeSet,obj
;
;NAME:
;        ooEchoMagnetic::mergeSet
;
;PURPOSE:
;               Produce a merging of self and obj.
;PARAMETERS:
;               obj     The object to merge with self.
;RETURN VALUE:
;               onew    The new merged object.


; RTA
; Both datasets should have the same phase structure, don't proceed if they are not
if (Self.magnetic) then begin
  same = Self.point_to_down_x eq obj->GetProperty(tag='point_to_down_x') && $
         Self.point_to_down_y eq obj->GetProperty(tag='point_to_down_y') && $
         Self.point_to_down_z eq obj->GetProperty(tag='point_to_down_z') && $
         Self.point_to_up_x eq obj->GetProperty(tag='point_to_up_x') && $
         Self.point_to_up_y eq obj->Getproperty(tag='point_to_up_y') && $
         Self.point_to_up_z eq obj->Getproperty(tag='point_to_up_z')
endif else begin
  same = Self.point_to_down eq obj->Getproperty(tag='point_to_down') && $
         Self.point_to_up eq obj->Getproperty(tag='point_to_up')
endelse
if (~same) then begin
  msg = 'The two datasets have different phases. Cannot Proceed with merge'
  title = 'Dataset Merge'
  void = dialog_message(msg,/error,title=title)
  return, obj_new()
endif

    ;SET VALUES IN OBJECT'S CLONE

    ;CREATE A NEW DATA OBJECT AND SET UP ITS DATA
    ;MEMBERS AS THE MERGE OF THE TWO DATA OBJECTS.

    ;print,'TEST'
    ;CREATE A NEW ooEchoMagnetic OBJECT (REPLACE VALUES IN THIS METHOD)
    ;PROBLEM HERE IS THAT I NEED setProperty TO ACCESS THE DATA
    ;MEMBERS --- AND THIS IS THE DATA CLASS SO THE ACCESSOR
    ;METHODS ARE ALREADY AVAILABLE.
    ;onew = self->blankObj(obj)
    onew = self->clone()    ;PRESET, self.qactual, etc ARE NOW SET

    myType = self.type
    myQ = self.q
    myX_dim = self.x_dim
    myY_dim = self.y_dim
    myPreset = self.preset

    objType = obj->getProperty(tag='type')
    objQ = obj->getProperty(tag='q')
    objX_dim = obj->getProperty(tag='x_dim')
    objY_dim = obj->getProperty(tag='y_dim')
    objPreset = obj->getProperty(tag='preset')

;    print,'myPreset,objPreset=',myPreset,objPreset

    yn = 'YES'
    if objPreset ne myPreset then $
        yn = dialog_message('The objects have different monitor/preset values! Procede with merge?',/question)
    yn = strupcase(yn)

    if yn eq 'YES' then begin
        presetscaling = double(mypreset)/double(objpreset)
        if presetscaling ne 1.0d then $
            void = dialog_message('Scaling all counts for preset = '+strtrim(string(mypreset),2))
        ;presetscaling = mypreset/objpreset
    endif





    if (mytype eq objtype) and $
        (myQ eq objQ) and $
        (myX_dim eq objX_dim) and $
        (myY_dim eq objY_dim) and $
        (yn eq 'YES') then begin

    if obj_isa(onew,'ooechomagnetic') ne 0 then begin

        onew->setproperty,'magnetic',self.magnetic
        onew->setproperty,'p',self.p
        onew->setproperty,'f',self.f
        onew->setproperty,'eff_bpw',self.eff_bpw

;        ;121405
;        ;CHECK THAT THE DATE SUGGESTS THAT THESE VALUES ARE IN ooEchoMagnetic
;        CALDAT, SYSTIME( /JULIAN,/utc ), Month , Day , Year , Hour , Minute , Second
;        ;print, month,day,year,hour,minute,second
;        if year ge 2005 then begin
;            if (year eq 2005 and month eq 12 and day ge 14) or year ge 2006 then begin
;                onew->setproperty,'eff_bpw_x',self.eff_bpw_x
;                onew->setproperty,'eff_bpw_y',self.eff_bpw_y
;                onew->setproperty,'eff_bpw_z',self.eff_bpw_z
;            endif
;        endif


;        onew->setproperty,'point_to_down_x',self.no_of_phases - 12
;        onew->setproperty,'point_to_up_x',self.no_of_phases - 10
;        onew->setproperty,'point_to_down_z',self.no_of_phases - 8
;        onew->setproperty,'point_to_up_z',self.no_of_phases - 6
;        onew->setproperty,'point_to_down_y',self.no_of_phases - 4
;        onew->setproperty,'point_to_up_y',self.no_of_phases - 2
        onew->setproperty,'xyzupdownscale', self.xyzupdownscale
        onew->setproperty,'mask1dpixels',ptr_new()
        onew->setproperty,'extensions',ptr_new()

    endif;isa magnetic

            fn1 = self.filename
            fn2 = obj->getProperty(tag='filename')
            workdir = self.workdir
            datadir = self.datadir

            version = float(!version.release)
            if version ge 6.0 then begin
                fn = file_basename(fn1)+'+'+file_basename(fn2)
            endif else begin
                fn = fn1+'+'+fn2
            endelse
            ;print,'fn=',fn
            onew->setProperty,'filename',fn
            onew->setproperty,'workdir',workdir
            onew->setproperty,'datadir',datadir

    ;040805
    ;I THINK THIS WAS OMITTED PREVIOUSLY!!!
            onew->setProperty,'preset',mypreset

            type1 = self.type
            type2 = obj->getProperty(tag='type')
            if type1 eq type2 then begin
                type = type1
            endif else begin
                print,'9298 ooEchoMagnetic::mergeset WARNING: TYPES DO NOT MATCH! CONTINUING ANYWAY.'
            endelse
            onew->setProperty,'type',self.type
            ;self.reduced = obj->getProperty(tag='reduced')

            ;GET THE FOURIER TIMES FOR BOTH OBJECTS
            tau1 = *self.fourierTime
            tau2 = *(obj->getProperty(tag='fourierTime'))
            taunewtemp = [tau1,tau2]

            phase1 = *self.phase
            phase2 = *(obj->getProperty(tag='phase'))
            szphs1 = size(phase1)
            szphs2 = size(phase2)
            phasenewtemp = fltarr(max([szphs1[1],szphs2[1]]), $
                                       szphs1[2]+szphs2[2])

            ;help,phasenewtemp

            ;CREATE ORDERING ARRAY FOR ALL OF THE MERGING OPERATIONS.
            order = intarr(n_elements(tau1) + n_elements(tau2))
            order = self->orderEm(tau1,tau2,order,0,0,0)



            etemp1 = *self.eorig

            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                etemp2 = long(presetscaling*(*(obj->getProperty(tag='eorig'))))
            endif else begin
                etemp2 = *(obj->getProperty(tag='eorig'))
            endelse
            sz1 = size(etemp1)
            sz2 = size(etemp2)
            ;INITIALIZE A NEW COMBINED DATA ARRAY
            etempnew = lonarr( sz1[1], $
                                max([sz1[2],sz2[2]]), $
                                sz1[3]+sz2[3])

            ;MERGE THE TWO DATA ARRAYS
            if (sz1[1] eq sz2[1]) then begin

                ;INTERLEAVE THE TWO DATA ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        taunewtemp[i] = tau1[i1]
                        phasenewtemp[*,i] = phase1[*,i1]
                        etempnew[*,0:sz1[2]-1,i] = etemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        taunewtemp[i] = tau2[i2]
                        phasenewtemp[*,i] = phase2[*,i2]
                        etempnew[*,0:sz2[2]-1,i] = etemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i

                ;help,etempnew
                ;help,taunewtemp
                ;help,phasenewtemp

                ;PUT THE NEW DATA SET INTO THE NEW DATA OBJECT
                if ptr_valid(onew->getProperty(tag='eorig')) gt 0 then $
                    ptr_free,(onew->getProperty(tag='eorig'))
                onew->setProperty,'eorig',ptr_new(etempnew)

                if ptr_valid(onew->getProperty(tag='fourierTime')) gt 0 then $
                    ptr_free,(onew->getProperty(tag='fourierTime'))
                onew->setProperty,'fourierTime',ptr_new(taunewtemp)

                if ptr_valid(onew->getProperty(tag='phase')) gt 0 then begin
                    ;print,'FREEING THE onew POINTER.'
                    ptr_free,(onew->getProperty(tag='phase'))
                endif

                onew->setProperty,'phase',ptr_new(phasenewtemp)

                ;help,onew->getProperty(tag='phase')
                ;help,*(onew->getProperty(tag='phase'))

                onew->setProperty,'no_of_fourier_times',szphs1[2]+szphs2[2]

                iec_multimeter = {$
                    Temperatur:0.0,$
                    BSpiy:0.0,$
                    BSpi21x:0.0,$
                    BSpi21z:0.0,$
                    BSpi22y:0.0,$
                    BSpix:0.0,$
                    BSpiz:0.0,$
                    BSpi21y:0.0,$
                    BSpi22x:0.0,$
                    BSpi22z:0.0 $
                    }

            meterstemp1 = *self.meters
            meterstemp2 = *(obj->getProperty(tag='meters'))
            szmt1 = size(*self.meters)
            szmt2 = size(*(obj->getProperty(tag='meters')))


        ;    meterstempnew = [meterstemp1,meterstemp2]
            meterstempnew=replicate(iec_multimeter,szmt1[1],szmt1[2]+szmt2[2])
                ;INTERLEAVE THE TWO meters ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        meterstempnew[*,i] = meterstemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        meterstempnew[*,i] = meterstemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,meterstempnew
                if ptr_valid(onew->getProperty(tag='meters')) gt 0 then $
                    ptr_free,onew->getProperty(tag='meters')
                onew->setProperty,'meters',$
                    ptr_new(meterstempnew)


                counterstemp1 = *self.counters
                counterstemp2 = *(obj->getProperty(tag='counters'))
                szct1 = size(*self.counters)
                szct2 = size(*(obj->getProperty(tag='counters')))
        ;        counterstempnew = [counterstemp1,counterstemp2]
                counterstempnew=dblarr(10,szct1[2],szct1[3]+szct2[3])
                ;INTERLEAVE THE TWO counters ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        counterstempnew[*,*,i] = counterstemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        counterstempnew[*,*,i] = counterstemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,counterstempnew
                if ptr_valid(onew->getProperty(tag='counters')) gt 0 then $
                    ptr_free,onew->getProperty(tag='counters')
                onew->setProperty,'counters',$
                    ptr_new(counterstempnew)



                monitor_struct = {m1:0.0,m2:0.0,m3:0.0}

                monitorstemp1 = *self.monitors
                ;help,monitorstemp1
                monitorstemp2 = *(obj->getProperty(tag='monitors'))
                ;help,monitorstemp2
                szmon1 = size(*self.monitors)
                szmon2 = size(*(obj->getProperty(tag='monitors')))
        ;        counterstempnew = [counterstemp1,counterstemp2]
                monitorstempnew=replicate(monitor_struct,szmon1[1]+szmon2[1])
        ;        monitorstempnew=replicate(monitor_struct,szmon1[1],$
        ;                                    szmon1[2]+szmon2[2])

                ;help,monitorstempnew
                print,'n_elements(order)=',n_elements(order)
                ;INTERLEAVE THE TWO counters ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        monitorstempnew[i] = monitorstemp1[i1]
                        ;monitorstempnew[*,*,i] = monitorstemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        monitorstempnew[i] = monitorstemp2[i2]
                        ;monitorstempnew[*,*,i] = monitorstemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,counterstempnew
                if ptr_valid(onew->getProperty(tag='monitors')) gt 0 then $
                    ptr_free,onew->getProperty(tag='monitors')
                onew->setProperty,'monitors',$
                    ptr_new(monitorstempnew)

;        ;THERE IS A PROBLEM HERE SINCE THE "PRESET" VALUE IS LIKELY TO
;        ;DIFFER BETWEEN THE TWO MERGED FILES.  I SINGLE PRESET SHOULD BE
;        ;CHOSEN AND THE OTHER FILE SCALED FOR THAT.
;        print,'9897 ooEchoMagnetic::MergeSet WARNING!   WARNING!    WARNING!    WARNING!'
;        print,'9898 ooEchoMagnetic::MergeSet THERE IS AN ISSUE WITH SETTING preset FOR'
;        print,'9899 ooEchoMagnetic::MergeSet TWO DIFFERENT SETS.'
;        print,'9900 ooEchoMagnetic::MergeSet NEED TO SCALE ONE SET TO THE OTHER.'


                ;DO REST OF MERGING HERE SO THAT IT ONLY OCCURS IF
                ;THE ORIGINAL DATA ARRAY DETECTORS ARE THE SAME SIZE

            etemp1 = *self.e

            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                etemp2 = long(presetscaling*(*(obj->getProperty(tag='e'))))
            endif else begin
                etemp2 = *(obj->getProperty(tag='e'))
            endelse
            ;etemp2 = *(obj->getProperty(tag='e'))

            szx1 = size(etemp1)
            szx2 = size(etemp2)
            ;INITIALIZE A NEW COMBINED DATA ARRAY
            etempnew = lonarr( szx1[1], $
                                max([szx1[2],szx2[2]]), $
                                szx1[3]+szx2[3])


                ;INTERLEAVE THE TWO DATA ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        etempnew[*,0:szx1[2]-1,i] = etemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        etempnew[*,0:szx2[2]-1,i] = etemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i

                ;help,etempnew
                ;PUT THE NEW DATA SET INTO THE NEW DATA OBJECT
                if ptr_valid(onew->getProperty(tag='e')) gt 0 then $
                    ptr_free,(onew->getProperty(tag='e'))
                onew->setProperty,'e',ptr_new(etempnew)


            etemp1 = *self.emask

            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                etemp2 = long(presetscaling*(*(obj->getProperty(tag='emask'))))
            endif else begin
                etemp2 = *(obj->getProperty(tag='emask'))
            endelse
;            etemp2 = *(obj->getProperty(tag='emask'))
            szm1 = size(etemp1)
            szm2 = size(etemp2)
            ;INITIALIZE A NEW COMBINED DATA ARRAY
            etempnew = lonarr( szm1[1], $
                                max([szm1[2],szm2[2]]), $
                                szm1[3]+szm2[3])


                ;INTERLEAVE THE TWO DATA ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        etempnew[*,0:szm1[2]-1,i] = etemp1[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        etempnew[*,0:szm2[2]-1,i] = etemp2[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i

                ;help,etempnew
                ;PUT THE NEW DATA SET INTO THE NEW DATA OBJECT
                if ptr_valid(onew->getProperty(tag='emask')) gt 0 then $
                    ptr_free,(onew->getProperty(tag='emask'))
                onew->setProperty,'emask',ptr_new(etempnew)



                mask2dtemp1 = *self.mask2d
                mask2dtemp2 = *(obj->getProperty(tag='mask2d'))
                szfp1 = size(*self.mask2d)
                szfp2 = size(*(obj->getProperty(tag='mask2d')))
                mask2dtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,mask2dtempnew
                ;INTERLEAVE THE TWO mask2d ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        mask2dtempnew[*,i] = mask2dtemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        mask2dtempnew[*,i] = mask2dtemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,mask2dtempnew
                if ptr_valid(onew->getProperty(tag='mask2d')) gt 0 then $
                    ptr_free,onew->getProperty(tag='mask2d')
                onew->setProperty,'mask2d',$
                    ptr_new(mask2dtempnew)


                mask2dOldtemp1 = *self.mask2dOld
                mask2dOldtemp2 = *(obj->getProperty(tag='mask2dOld'))
                szfp1 = size(*self.mask2dOld)
                szfp2 = size(*(obj->getProperty(tag='mask2dOld')))
                mask2dOldtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,mask2dOldtempnew
                ;INTERLEAVE THE TWO mask2dOld ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        mask2dOldtempnew[*,i] = mask2dOldtemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        mask2dOldtempnew[*,i] = mask2dOldtemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,mask2dOldtempnew
                if ptr_valid(onew->getProperty(tag='mask2dOld')) gt 0 then $
                    ptr_free,onew->getProperty(tag='mask2dOld')
                onew->setProperty,'mask2dOld',$
                    ptr_new(mask2dOldtempnew)






                ;INTERLEAVE THE TWO fitdisplaymask ARRAYS
                fitdisplaymasktemp1 = *self.fitdisplaymask
                fitdisplaymasktemp2 = *(obj->getProperty(tag='fitdisplaymask'))
                szfp1 = size(*self.fitdisplaymask)
                szfp2 = size(*(obj->getProperty(tag='fitdisplaymask')))
                fitdisplaymasktempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,fitdisplaymasktempnew
                ;INTERLEAVE THE TWO fitdisplaymask ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        fitdisplaymasktempnew[*,i] = fitdisplaymasktemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        fitdisplaymasktempnew[*,i] = fitdisplaymasktemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,fitdisplaymasktempnew
                if ptr_valid(onew->getProperty(tag='fitdisplaymask')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fitdisplaymask')
                onew->setProperty,'fitdisplaymask',$
                    ptr_new(fitdisplaymasktempnew)


                ;INTERLEAVE THE TWO fitdisplaymaskOld ARRAYS
                fitdisplaymaskOldtemp1 = *self.fitdisplaymaskOld
                fitdisplaymaskOldtemp2 = *(obj->getProperty(tag='fitdisplaymaskOld'))
                szfp1 = size(*self.fitdisplaymaskOld)
                szfp2 = size(*(obj->getProperty(tag='fitdisplaymaskOld')))
                fitdisplaymaskOldtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,fitdisplaymaskOldtempnew
                ;INTERLEAVE THE TWO fitdisplaymaskOld ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        fitdisplaymaskOldtempnew[*,i] = fitdisplaymaskOldtemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        fitdisplaymaskOldtempnew[*,i] = fitdisplaymaskOldtemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,fitdisplaymaskOldtempnew
                if ptr_valid(onew->getProperty(tag='fitdisplaymaskOld')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fitdisplaymaskOld')
                onew->setProperty,'fitdisplaymaskOld',$
                    ptr_new(fitdisplaymaskOldtempnew)



        ;;
        ;mask1d NEEDS TO HAVE THE SAME NUMBER OF ELEMENTS FOR BOTH SETS.
        ;AND IT MUST BE INTERLEAVED
        ;;;
        ;;    mask1dtemp = *(obj->getProperty(tag='mask1d'))
        ;;    if ptr_valid(self.mask1d) gt 0 then ptr_free,self.mask1d
        ;;    self.mask1d = ptr_new(mask1dtemp)
        ;;

                mask1dtemp1 = *self.mask1d
                mask1dtemp2 = *(obj->getProperty(tag='mask1d'))
                szfp1 = size(*self.mask1d)
                szfp2 = size(*(obj->getProperty(tag='mask1d')))
                mask1dtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,mask1dtempnew
                ;INTERLEAVE THE TWO mask1d ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        mask1dtempnew[*,i] = mask1dtemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        mask1dtempnew[*,i] = mask1dtemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,mask1dtempnew
                if ptr_valid(onew->getProperty(tag='mask1d')) gt 0 then $
                    ptr_free,onew->getProperty(tag='mask1d')
                onew->setProperty,'mask1d',$
                    ptr_new(mask1dtempnew)

;;082205
;                mask1dpixelstemp1 = *self.mask1dpixels
;                mask1dpixelstemp2 = *(obj->getProperty(tag='mask1dPixels'))
;                szfp1 = size(*self.mask1dPixels)
;                szfp2 = size(*(obj->getProperty(tag='mask1dPixels')))
;                mask1dpixelstempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
;                ;help,mask1dpixelstempnew
;                ;INTERLEAVE THE TWO mask1dpixels ARRAYS
;                i1 = 0 & i2 = 0
;                for i=0,n_elements(order)-1 do begin
;
;                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
;                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
;                    ;DATA ARRAYS
;                    if order[i] eq 1 then begin
;                        mask1dpixelstempnew[*,i] = mask1dpixelstemp1[*,i1]
;                        i1 = i1 + 1
;                    endif else begin
;                        mask1dpixelstempnew[*,i] = mask1dpixelstemp2[*,i2]
;                        i2 = i2 + 1
;                    endelse
;                endfor;i
;                ;help,mask1dpixelstempnew
;                if ptr_valid(onew->getProperty(tag='mask1dPixels')) gt 0 then $
;                    ptr_free,onew->getProperty(tag='mask1dPixels')
;                onew->setProperty,'mask1dPixels',$
;                    ptr_new(mask1dpixelstempnew)
;;########################




            onew->setProperty,'lambda', $
                        obj->getProperty(tag='lambda')
            onew->setProperty,'dlambda', $
                        obj->getProperty(tag='dlambda')
            onew->setProperty,'comment', $
                        'MERGED FILES'

            treatmentnew = ['MERGED FILES']
            if ptr_valid(onew->getProperty(tag='treatment')) gt 0 then $
                ptr_free,onew->getProperty(tag='treatment')
            onew->setProperty,'treatment',ptr_new(treatmentnew)




        ;;    fitparmstemp = *(obj->getProperty(tag='fitparms'))
        ;;    if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
        ;;    self.fitparms = ptr_new(fitparmstemp)
        ;;
                fixedtemp1 = *self.fixed
                help,fixedtemp1
                fixedtemp2 = *(obj->getProperty(tag='fixed'))
                help,fixedtemp2

                fitparmstemp1 = *self.fitparms
                fitparmstemp2 = *(obj->getProperty(tag='fitparms'))
                fitparmstemp2[0,*,*] = presetscaling*fitparmstemp2[0,*,*]
                fitparmstemp2[6,*,*] = presetscaling*fitparmstemp2[6,*,*]
                fitparmstemp2[1,*,*] = presetscaling*fitparmstemp2[1,*,*]
                fitparmstemp2[7,*,*] = presetscaling*fitparmstemp2[7,*,*]

                fitparmstemp1Old = *self.fitparmsOld
                fitparmstemp2Old = *(obj->getProperty(tag='fitparmsOld'))
                fitparmstemp2Old[0,*,*] = presetscaling*fitparmstemp2Old[0,*,*]
                fitparmstemp2Old[6,*,*] = presetscaling*fitparmstemp2Old[6,*,*]
                fitparmstemp2Old[1,*,*] = presetscaling*fitparmstemp2Old[1,*,*]
                fitparmstemp2Old[7,*,*] = presetscaling*fitparmstemp2Old[7,*,*]


                szfp1 = size(*self.fitparms)
                szfp2 = size(*(obj->getProperty(tag='fitparms')))
;                print,'ooEchoMagnetic::mergeSet  szfp1=',szfp1
;                print,'ooEchoMagnetic::mergeSet  szfp2=',szfp2
                szfp1Old = size(*self.fitparmsOld)
                szfp2Old = size(*(obj->getProperty(tag='fitparmsOld')))
                fixedtempnew = intarr(6,szfp1[2],szfp1[3]+szfp2[3])
;                help,fixedtempnew

                fitparmstempnew = dblarr(12,szfp1[2],szfp1[3]+szfp2[3])
                fitparmstempOldnew = dblarr(12,szfp1[2],szfp1[3]+szfp2[3])
                ;help,fitparmstempnew
                ;INTERLEAVE THE TWO fitparms ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        fixedtempnew[*,*,i] = fixedtemp1[*,*,i1]
                        fitparmstempnew[*,*,i] = fitparmstemp1[*,*,i1]
                        fitparmstempOldnew[*,*,i] = fitparmstemp1Old[*,*,i1]
                        i1 = i1 + 1
                    endif else begin
                        fixedtempnew[*,*,i] = fixedtemp2[*,*,i2]
                        fitparmstempnew[*,*,i] = fitparmstemp2[*,*,i2]
                        fitparmstempOldnew[*,*,i] = fitparmstemp2Old[*,*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,fitparmstempnew
                if ptr_valid(onew->getProperty(tag='fixed')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fixed')
                onew->setProperty,'fixed',$
                    ptr_new(fixedtempnew)

                if ptr_valid(onew->getProperty(tag='fitparms')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fitparms')
                onew->setProperty,'fitparms',$
                    ptr_new(fitparmstempnew)

                if ptr_valid(onew->getProperty(tag='fitparmsOld')) gt 0 then $
                    ptr_free,onew->getProperty(tag='fitparmsOld')
                onew->setProperty,'fitparmsOld',$
                    ptr_new(fitparmstempOldnew)


        ;;    Iuptemp = *(obj->getProperty(tag='Iup'))
        ;;    if ptr_valid(self.Iup) gt 0 then ptr_free,self.Iup
        ;;    self.Iup = ptr_new(Iuptemp)
                Iuptemp1 = *self.Iup

            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                Iuptemp2 = presetscaling*(*(obj->getProperty(tag='Iup')))
            endif else begin
                Iuptemp2 = *(obj->getProperty(tag='Iup'))
            endelse


                szfp1 = size(*self.Iup)
                szfp2 = size(*(obj->getProperty(tag='Iup')))
                Iuptempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,Iuptempnew
                ;INTERLEAVE THE TWO Iup ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        Iuptempnew[*,i] = Iuptemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        Iuptempnew[*,i] = Iuptemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,Iuptempnew
                if ptr_valid(onew->getProperty(tag='Iup')) gt 0 then $
                    ptr_free,onew->getProperty(tag='Iup')
                onew->setProperty,'Iup',$
                    ptr_new(Iuptempnew)



                Idowntemp1 = *self.Idown
            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                Idowntemp2 = presetscaling*(*(obj->getProperty(tag='Idown')))
            endif else begin
                Idowntemp2 = *(obj->getProperty(tag='Idown'))
            endelse
                szfp1 = size(*self.Idown)
                szfp2 = size(*(obj->getProperty(tag='Idown')))
                Idowntempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,Idowntempnew
                ;INTERLEAVE THE TWO Idown ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        Idowntempnew[*,i] = Idowntemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        Idowntempnew[*,i] = Idowntemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,Idowntempnew
                if ptr_valid(onew->getProperty(tag='Idown')) gt 0 then $
                    ptr_free,onew->getProperty(tag='Idown')
                onew->setProperty,'Idown',$
                    ptr_new(Idowntempnew)


        ;ARE THESE ERROR BARS CALCULATED WHEN Iup/down ARE CALCULATED??!!??

                sIuptemp1 = *self.sIup
            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                sIuptemp2 = presetscaling*(*(obj->getProperty(tag='sIup')))
            endif else begin
                sIuptemp2 = *(obj->getProperty(tag='sIup'))
            endelse
                szfp1 = size(*self.sIup)
                szfp2 = size(*(obj->getProperty(tag='sIup')))
                sIuptempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,sIuptempnew
                ;INTERLEAVE THE TWO sIup ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        sIuptempnew[*,i] = sIuptemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        sIuptempnew[*,i] = sIuptemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,sIuptempnew
                if ptr_valid(onew->getProperty(tag='sIup')) gt 0 then $
                    ptr_free,onew->getProperty(tag='sIup')
                onew->setProperty,'sIup',$
                    ptr_new(sIuptempnew)



                sIdowntemp1 = *self.sIdown
            ;SCALE THE FOLLOWING ARRAY IF THE PRESETS ARE DIFFERENT.
            if presetscaling ne 1.0d then begin
                sIdowntemp2 = presetscaling*(*(obj->getProperty(tag='sIdown')))
            endif else begin
                sIdowntemp2 = *(obj->getProperty(tag='sIdown'))
            endelse
                szfp1 = size(*self.sIdown)
                szfp2 = size(*(obj->getProperty(tag='sIdown')))
                sIdowntempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,sIdowntempnew
                ;INTERLEAVE THE TWO sIdown ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        sIdowntempnew[*,i] = sIdowntemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        sIdowntempnew[*,i] = sIdowntemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,sIdowntempnew
                if ptr_valid(onew->getProperty(tag='sIdown')) gt 0 then $
                    ptr_free,onew->getProperty(tag='sIdown')
                onew->setProperty,'sIdown',$
                    ptr_new(sIdowntempnew)



            onew->setProperty,'IupdownSwitch',obj->getProperty(tag='IupdownSwitch')




        ;;
        ;ARE THE DIMENSIONS CORRECT FOR S???????

        ;    Stemp = $
        ;        *(obj->getProperty(tag='S'))
        ;    if ptr_valid(onew->getProperty(tag='S')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='S')
        ;    onew->setProperty,'S',$
        ;        ptr_new(Stemp)

                Stemp1 = *self.S
                Stemp2 = *(obj->getProperty(tag='S'))
                szfp1 = size(*self.S)
                szfp2 = size(*(obj->getProperty(tag='S')))
                Stempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,S
                ;INTERLEAVE THE TWO S ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        Stempnew[*,i] = Stemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        Stempnew[*,i] = Stemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,Stempnew
                if ptr_valid(onew->getProperty(tag='S')) gt 0 then $
                    ptr_free,onew->getProperty(tag='S')
                onew->setProperty,'S',$
                    ptr_new(Stempnew)



        ;    sStemp = $
        ;        *(obj->getProperty(tag='sS'))
        ;    if ptr_valid(onew->getProperty(tag='sS')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='sS')
        ;    onew->setProperty,'sS',$
        ;        ptr_new(sStemp)



                sStemp1 = *self.sS
                sStemp2 = *(obj->getProperty(tag='sS'))
                szfp1 = size(*self.sS)
                szfp2 = size(*(obj->getProperty(tag='sS')))
                sStempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
                ;help,sS
                ;INTERLEAVE THE TWO sS ARRAYS
                i1 = 0 & i2 = 0
                for i=0,n_elements(order)-1 do begin

                    ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                    ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                    ;DATA ARRAYS
                    if order[i] eq 1 then begin
                        sStempnew[*,i] = sStemp1[*,i1]
                        i1 = i1 + 1
                    endif else begin
                        sStempnew[*,i] = sStemp2[*,i2]
                        i2 = i2 + 1
                    endelse
                endfor;i
                ;help,sStempnew
                if ptr_valid(onew->getProperty(tag='sS')) gt 0 then $
                    ptr_free,onew->getProperty(tag='sS')
                onew->setProperty,'sS',$
                    ptr_new(sStempnew)







            IQTInfotemp = $
                *(obj->getProperty(tag='IQTInfo'))
            if ptr_valid(onew->getProperty(tag='IQTInfo')) gt 0 then $
                ptr_free,onew->getProperty(tag='IQTInfo')
            onew->setProperty,'IQTInfo',$
                ptr_new(IQTInfotemp)





        ;    IQTtemp = $
        ;        *(obj->getProperty(tag='IQT'))
        ;    if ptr_valid(onew->getProperty(tag='IQT')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='IQT')
        ;    onew->setProperty,'IQT',$
        ;        ptr_new(IQTtemp)

            ;IQT = DOUBLE  Array[narcs, no_of_fourier_times]
            IQTtemp1 = *self.IQT
            IQTtemp2 = *(obj->getProperty(tag='IQT'))
            szfp1 = size(*self.IQT)
            szfp2 = size(*(obj->getProperty(tag='IQT')))
            IQTtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])

;041305
;DO NOT INTERLEAVE THESE ARRAYS SINCE THE VALUES WILL NEVER BE ACCESSED UNTIL
;CALCULATED FOR DISPLAYIQT.,
;;;;;
;;;;;
;;;;;            ;help,IQT
;;;;;            ;INTERLEAVE THE TWO IQT ARRAYS
;;;;;            i1 = 0 & i2 = 0
;;;;;            for i=0,n_elements(order)-1 do begin
;;;;;
;;;;;                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
;;;;;                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
;;;;;                ;DATA ARRAYS
;;;;;                if order[i] eq 1 then begin
;;;;;                    IQTtempnew[*,i] = IQTtemp1[*,i1]
;;;;;                    i1 = i1 + 1
;;;;;                endif else begin
;;;;;                    IQTtempnew[*,i] = IQTtemp2[*,i2]
;;;;;                    i2 = i2 + 1
;;;;;                endelse
;;;;;            endfor;i
            ;help,IQTtempnew
            if ptr_valid(onew->getProperty(tag='IQT')) gt 0 then $
                ptr_free,onew->getProperty(tag='IQT')
            onew->setProperty,'IQT',$
                ptr_new(IQTtempnew)





        ;    sIQTtemp = $
        ;        *(obj->getProperty(tag='sIQT'))
        ;    if ptr_valid(onew->getProperty(tag='sIQT')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='sIQT')
        ;    onew->setProperty,'sIQT',$
        ;        ptr_new(sIQTtemp)


            sIQTtemp1 = *self.sIQT
            sIQTtemp2 = *(obj->getProperty(tag='sIQT'))
            szfp1 = size(*self.sIQT)
            szfp2 = size(*(obj->getProperty(tag='sIQT')))
            sIQTtempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])

;;;;;            ;help,IQT
;;;;;            ;INTERLEAVE THE TWO IQT ARRAYS
;;;;;            i1 = 0 & i2 = 0
;;;;;            for i=0,n_elements(order)-1 do begin
;;;;;
;;;;;                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
;;;;;                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
;;;;;                ;DATA ARRAYS
;;;;;                if order[i] eq 1 then begin
;;;;;                    sIQTtempnew[*,i] = sIQTtemp1[*,i1]
;;;;;                    i1 = i1 + 1
;;;;;                endif else begin
;;;;;                    sIQTtempnew[*,i] = sIQTtemp2[*,i2]
;;;;;                    i2 = i2 + 1
;;;;;                endelse
;;;;;            endfor;i
;;;;;            ;help,IQTtempnew
            if ptr_valid(onew->getProperty(tag='sIQT')) gt 0 then $
                ptr_free,onew->getProperty(tag='sIQT')
            onew->setProperty,'sIQT',$
                ptr_new(sIQTtempnew)

            IQTFitparmsnew = dblarr(szfp1[1],2)
            if ptr_valid(onew->getProperty(tag='IQTFitparms')) gt 0 then $
                ptr_free,onew->getProperty(tag='IQTFitparms')
            onew->setProperty,'IQTFitparms',ptr_new(IQTFitparmsnew)



            narcs = obj->getProperty(tag='narcs')
            onew->setProperty,'narcs',narcs

            qarcstemp = $
                *(obj->getProperty(tag='qarcs'))
            if ptr_valid(onew->getProperty(tag='qarcs')) gt 0 then $
                ptr_free,onew->getProperty(tag='qarcs')
            onew->setProperty,'qarcs',$
                ptr_new(qarcstemp)



        ;    QValstemp = $
        ;        *(obj->getProperty(tag='QVals'))
        ;    if ptr_valid(onew->getProperty(tag='QVals')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='QVals')
        ;    onew->setProperty,'QVals',$
        ;        ptr_new(QValstemp)



            QValstemp1 = *self.QVals
            QValstemp2 = *(obj->getProperty(tag='QVals'))
            szfp1 = size(*self.QVals)
            szfp2 = size(*(obj->getProperty(tag='QVals')))
            QValstempnew = dblarr(szfp1[1],szfp1[2]+szfp2[2])
            ;help,IQT
            ;INTERLEAVE THE TWO IQT ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    QValstempnew[*,i] = QValstemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    QValstempnew[*,i] = QValstemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i
            ;help,IQTtempnew
            if ptr_valid(onew->getProperty(tag='QVals')) gt 0 then $
                ptr_free,onew->getProperty(tag='QVals')
            onew->setProperty,'QVals',$
                ptr_new(QValstempnew)




            ;THIS MAKES SURE THAT ALL QVals ARE CALCULATED
            onew->setProperty,'QValsSwitch',obj->getProperty(tag='QValsSwitch')*self.QValsSwitch

            chisqtemp1 = (*self.chisq)
            chisqtemp2 = *(obj->getProperty(tag='chisq'))
            szchsq1 = size(chisqtemp1)
            szchsq2 = size(chisqtemp2)
;            print,'szchsq1 = ',szchsq1
;            print,'szchsq2 = ',szchsq2

            chisqtempnew = dblarr(szchsq1[1],szchsq1[2]+szchsq2[2])
            ;help,chisqtempnew
            ;INTERLEAVE THE TWO chisq ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    chisqtempnew[*,i] = chisqtemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    chisqtempnew[*,i] = chisqtemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i


            if ptr_valid(onew->getProperty(tag='chisq')) gt 0 then $
                ptr_free,onew->getProperty(tag='chisq')
            onew->setProperty,'chisq',$
                ptr_new(chisqtempnew)



         ;DOUBLE    = Array[self.detxdim*self.detydim, no_of_fourier_times]
            chisqOldtemp1 = (*self.chisqOld)
            chisqOldtemp2 = *(obj->getProperty(tag='chisqOld'))
            szchsq1 = size(chisqOldtemp1)
            szchsq2 = size(chisqOldtemp2)
;            print,'szchsq1 = ',szchsq1
;            print,'szchsq2 = ',szchsq2

            chisqOldtempnew = dblarr(szchsq1[1],szchsq1[2]+szchsq2[2])
            ;help,chisqOldtempnew
            ;INTERLEAVE THE TWO chisqOld ARRAYS
            i1 = 0 & i2 = 0
            for i=0,n_elements(order)-1 do begin

                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
                ;DATA ARRAYS
                if order[i] eq 1 then begin
                    chisqOldtempnew[*,i] = chisqOldtemp1[*,i1]
                    i1 = i1 + 1
                endif else begin
                    chisqOldtempnew[*,i] = chisqOldtemp2[*,i2]
                    i2 = i2 + 1
                endelse
            endfor;i


            if ptr_valid(onew->getProperty(tag='chisqOld')) gt 0 then $
                ptr_free,onew->getProperty(tag='chisqOld')
            onew->setProperty,'chisqOld',$
                ptr_new(chisqOldtempnew)





            onew->setProperty,'currentPhaseIndex', $
                        obj->getProperty(tag='currentPhaseIndex')




        ;CAN THE no_of_phases,point_to_down, point_to_up AND
        ;phase_step CHANGE FROM SET TO SET????
            onew->setProperty,'no_of_phases',obj->getProperty(tag='no_of_phases')
            onew->setProperty,'point_to_down',obj->getProperty(tag='point_to_down')
            onew->setProperty,'point_to_up',obj->getProperty(tag='point_to_up')
            onew->setProperty,'phase_step',obj->getProperty(tag='phase_step')

            ;THE NEW NUMBER OF FOURIER TIMES IS THE SUM OF THE
            ;NUMBERS OF FOURIER TIMES FOR THE MERGED SETS.
            onew->setProperty,'no_of_fourier_times', $
                (obj->getProperty(tag='no_of_fourier_times')+ $
                    self.no_of_fourier_times)


            onew->setProperty,'no_of_pixels', $
                                obj->getProperty(tag='no_of_pixels')

            onew->setProperty,'x_dim',obj->getProperty(tag='x_dim')
            onew->setProperty,'y_dim',obj->getProperty(tag='y_dim')
            onew->setProperty,'x_dim_orig',obj->getProperty(tag='x_dim_orig')
            onew->setProperty,'y_dim_orig',obj->getProperty(tag='y_dim_orig')

;031705
;TAKE THE NEXT VALUES FROM SELF!!!

;            onew->setProperty,'x_cen',obj->getProperty(tag='x_cen')
;            onew->setProperty,'y_cen',obj->getProperty(tag='y_cen')
;            onew->setProperty,'x_cen_orig',obj->getProperty(tag='x_cen_orig')
;            onew->setProperty,'y_cen_orig',obj->getProperty(tag='y_cen_orig')
;
;            onew->setProperty,'colorTable',obj->getProperty(tag='colorTable')
;            onew->setProperty,'q',obj->getProperty(tag='q')
;            onew->setProperty,'qactual',obj->getProperty(tag='qactual')
;            onew->setProperty,'qy',obj->getProperty(tag='qy')
;            onew->setProperty,'currentFourierTimeIndex', $
;                        obj->getProperty(tag='currentFourierTimeIndex')

            onew->setProperty,'x_cen',self->getProperty(tag='x_cen')
            onew->setProperty,'y_cen',self->getProperty(tag='y_cen')
            onew->setProperty,'x_cen_orig',self->getProperty(tag='x_cen_orig')
            onew->setProperty,'y_cen_orig',self->getProperty(tag='y_cen_orig')

            onew->setProperty,'colorTable',self->getProperty(tag='colorTable')
            onew->setProperty,'q',self->getProperty(tag='q')
            onew->setProperty,'qactual',self->getProperty(tag='qactual')
            onew->setProperty,'qy',self->getProperty(tag='qy')
            onew->setProperty,'currentFourierTimeIndex', $
                        self->getProperty(tag='currentFourierTimeIndex')


        ;; FILL IN THE HEADER POINTERS WITH DATA FROM THE INPUT OBJECT.
            scanHeadertemp = $
                *(obj->getProperty(tag='scanHeader'))
            if ptr_valid(onew->getProperty(tag='scanHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='scanHeader')
            onew->setProperty,'scanHeader',$
                ptr_new(scanHeadertemp)


            sampleHeadertemp = $
                *(obj->getProperty(tag='sampleHeader'))
            if ptr_valid(onew->getProperty(tag='sampleHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='sampleHeader')
            onew->setProperty,'sampleHeader',$
                ptr_new(sampleHeadertemp)


            ;STRING    = Array[54, no_of_fourier_times]
        ;    techHeadertemp = $
        ;        *(obj->getProperty(tag='techHeader'))
        ;    if ptr_valid(onew->getProperty(tag='techHeader')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='techHeader')
        ;    onew->setProperty,'techHeader',$
        ;        ptr_new(techHeadertemp)
        ;

;            techHeadertemp1 = (*self.techHeader)
;            techHeadertemp2 = *(obj->getProperty(tag='techHeader'))
;            szchsq1 = size(techHeadertemp1)
;            szchsq2 = size(techHeadertemp2)
;;            print,'szchsq1 = ',szchsq1
;;            print,'szchsq2 = ',szchsq2

            techHeadertempnew = ['Removed tech header on merge.']

;            techHeadertempnew = strarr(max([szchsq1[1],szchsq2[1]]),szchsq1[2]+szchsq2[2])
;            ;help,techHeadertempnew
;            ;INTERLEAVE THE TWO techHeader ARRAYS
;            i1 = 0 & i2 = 0
;            for i=0,n_elements(order)-1 do begin
;
;                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
;                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
;                ;DATA ARRAYS
;                if order[i] eq 1 then begin
;                    techHeadertempnew[0:szchsq1[1]-1,i] = techHeadertemp1[*,i1]
;                    i1 = i1 + 1
;                endif else begin
;                    techHeadertempnew[0:szchsq2[1]-1,i] = techHeadertemp2[*,i2]
;                    i2 = i2 + 1
;                endelse
;            endfor;i


            if ptr_valid(onew->getProperty(tag='techHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='techHeader')
            onew->setProperty,'techHeader',$
                ptr_new(techHeadertempnew)









            ;STRING    = Array[16, no_of_fourier_times]
        ;    physicsHeadertemp = $
        ;        *(obj->getProperty(tag='physicsHeader'))
        ;    if ptr_valid(onew->getProperty(tag='physicsHeader')) gt 0 then $
        ;        ptr_free,onew->getProperty(tag='physicsHeader')
        ;    onew->setProperty,'physicsHeader',$
        ;        ptr_new(physicsHeadertemp)
        ;


;            physicsHeadertemp1 = (*self.physicsHeader)
;            physicsHeadertemp2 = *(obj->getProperty(tag='physicsHeader'))
;            szchsq1 = size(physicsHeadertemp1)
;            szchsq2 = size(physicsHeadertemp2)
;;            print,'szchsq1 = ',szchsq1
;;            print,'szchsq2 = ',szchsq2

            physicsHeadertempnew = ['physicsHeader removed on merge.']
;            physicsHeadertempnew = strarr(max([szchsq1[1],szchsq2[1]]),szchsq1[2]+szchsq2[2])
;            ;help,physicsHeadertempnew
;            ;INTERLEAVE THE TWO physicsHeader ARRAYS
;            i1 = 0 & i2 = 0
;            for i=0,n_elements(order)-1 do begin
;
;                ;IT SEEMS LIKE no_of_phases WILL NEED TO BE AN ARRAY
;                ;IN CASE OF DIFFERENT NUMBERS OF PHASES FOR THE TWO
;                ;DATA ARRAYS
;                if order[i] eq 1 then begin
;                    physicsHeadertempnew[0:szchsq1[1]-1,i] = physicsHeadertemp1[*,i1]
;                    i1 = i1 + 1
;                endif else begin
;                    physicsHeadertempnew[0:szchsq2[1]-1,i] = physicsHeadertemp2[*,i2]
;                    i2 = i2 + 1
;                endelse
;            endfor;i


            if ptr_valid(onew->getProperty(tag='physicsHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='physicsHeader')
            onew->setProperty,'physicsHeader',$
                ptr_new(physicsHeadertempnew)



            if ptr_valid(onew->getProperty(tag='physicsParametersHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='physicsParametersHeader')
            onew->setProperty,'physicsParametersHeader',$
                ptr_new(physicsParametersHeadertempnew)




            phaseHeadertemp = ['Phase Header removed on merge.']


            if ptr_valid(onew->getProperty(tag='phaseHeader')) gt 0 then $
                ptr_free,onew->getProperty(tag='phaseHeader')
            onew->setProperty,'phaseHeader',$
                ptr_new(phaseHeadertempnew)



            ;help,*(onew->getProperty(tag='phase'))
            return,onew
            endif else begin
                print,'14560 ooEchoMagnetic::mergeset THE OBJECTS HAVE DIFFERENT DETECTOR/BINNING SIZES!!!!!'
                return,0
            endelse
            self->checkAndUpdateExtensionsPtr
        ;NOW DO OTHER 3D ARRAYS
        ;---011805 WHICH OTHER 3D ARRAYS???
    endif else begin
        void = dialog_message('The sizes, types and/or q values do not match.  No merge.')
    endelse


end;mergeSet
;;;;;;;;;;;;;;;;;;;;;
function ooEchoMagnetic::merge,obj
;
;NAME:
;        ooEchoMagnetic::merge
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;

    ;CHECK THE DIMENSIONS OF obj TO SEE THAT THEY
    ;MATCH self, AND IF THEY DO THEN
        return,self->mergeSet(obj)   ;NOTE THAT THIS "mergeSet" REFERS TO DATA SETS, AND NOT A SET OF DATA OBJECTS.
    ;ELSE

    ;

    ;return,obj_new('ooEchoMagnetic',obj=self)
end;merge
;;;;;;;;;;;;;;;;;;;;;






function ooEchoMagnetic::init,magnetic=magnetic,$
                        filename=filename,obj = obj, $
                        blank = blank, mobj = mobj, $
                        nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,bin=bin, $ ;BLANK OBJECT PARAMETERS
                        removetobj=removetobj, tremove=tremove,$ ;TO CREATE A CLONE OF AN OBJECT WITH A FOURIER TIME REMOVED.
                        narcs = narcs,modtime=modtime,facility=facility,_Extra=extra

;                    ,filename=filename,obj = obj, $
;                      blank = blank, mobj = mobj, $
;                      nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,bin=bin, $ ;BLANK OBJECT PARAMETERS
;                      removetobj=removetobj, tremove=tremove,$ ;TO CREATE A CLONE OF AN OBJECT WITH A FOURIER TIME REMOVED.
;                      narcs = narcs
;

;LRK - 12/09/10
;SET DEFAULT FACILITY TO 1.
if n_elements(facility) eq 0 then facility = 1;0
if facility ne 1 and facility ne 2 then facility = 1


    ;ATTEMPTING TO EXTEND THE DATA CLASS FOR THE NSE PROGRAM TO
    ;INCLUDE THE NECESSARY VARIABLES FOR MAGNETIC SCATTERING IN
    ;A WAY THAT FURTHER EXTENSIONS ARE EASILY IMPLEMENTED.
    ;MY IDEA IS TO USE A POINTER TO AN UNNAMED STRUCTURE AS THE
    ;EXTENSION SO THAT FURTHER ELEMENTS CAN BE ADDED AT WILL.

    ;THE NECESSARY METHODS THAT WILL HAVE TO DIFFER FROM THE
    ;ORIGINAL CLASS WILL NEED TO BE REDEFINED HERE SO THAT THEY
    ;CAN OVERRIDE THE ORIGINALS. (E.g. CLONE METHODS, Iup,down
    ;CALCULATIONS, etc.  MOST METHODS SHOULD BE IDENTICAL!!!)


    ;CLONE PROBABLY COULD USE THE SUPERCLASS VERSION AND
    ;OVERRIDE/CALL cloneSet

    ;chirpIup AND chirpIdown NEED TO BE OVERRIDDEN.
    ;

    if n_elements(blank) eq 0 then blank = 0
    if n_elements(magnetic) eq 0 then magnetic = 0
    self.magnetic = magnetic

;;    ret = self->ooecho::init(filename=filename,obj = obj, $
;;                            blank = blank, mobj = mobj, $
;;                            nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,bin=bin, $ ;BLANK OBJECT PARAMETERS
;;                            removetobj=removetobj, tremove=tremove,$ ;TO CREATE A CLONE OF AN OBJECT WITH A FOURIER TIME REMOVED.
;;                            narcs = narcs,magnetic=magnetic,$
;;                            _Extra=extra)



;DO NOT CALL THE SUPERCLASS init METHOD.
;USE ooEchoMagnetic::init AND ooEchoMagnetic::Read


;103105
;ORIGINAL INIT
    theTreatment = ['ooEchoMagnetic::init']
    self.treatment = ptr_new(theTreatment)

    ;print,"obj_isa(self.'ooEchoMagnetic') = ",obj_isa(self,'ooEchoMagnetic')
    magnetic = obj_isa(self,'ooEchoMagnetic')

    tags= [ 'filename',$
            'workdir',$
            'datadir',$
            'type',$
            'reduced',$
            'reducedOld',$
            'e',$
            'emask',$
            'eorig',$
            'mask2d',$
            'mask2dOld',$
            'fitdisplaymask',$
            'fitdisplaymaskOld',$
            'mask1d',$
;            'mask1dPixels',$    ;082205
            'lambda',$
            'dlambda',$
            'comment',$
            'fixed',$
            'fitparms',$
            'fitparmsOld',$
            'chisq',$
            'chisqOld',$
            'Iup',$
            'Idown',$
            'sIup',$
            'sIdown',$
            'IupdownSwitch',$
            'S',$
            'sS',$
            'IQTInfo',$
            'IQT',$
            'sIQT',$
            'QVals',$
            'QValsSwitch',$
            'narcs',$
            'qarcs',$
            'phase',$
            'currentPhaseIndex',$
            'meters',$
            'counters',$
            'monitors',$
            'preset',$
            'no_of_phases',$
            'point_to_down',$
            'point_to_up',$
            'phase_step',$
            'no_of_fourier_times',$
            'no_of_pixels',$
            'beam_cen_x',$
            'beam_cen_y',$
            'transmission',$
            'volfrac',$
            'x_dim',$
            'y_dim',$
            'x_cen',$
            'y_cen',$
            'x_dim_orig',$
            'y_dim_orig',$
            'x_cen_orig',$
            'y_cen_orig',$
            'width',$
            'period',$
            'colorTable',$
            'q',$
            'qactual',$
            'qy',$
            'fourierTime',$
            'currentFourierTimeIndex',$
            'scanHeader',$
            'sampleHeader',$
            'techHeader',$
            'physicsHeader',$
            'physicsParametersHeader',$
            'phaseHeader',$
            'treatment',$
            'IQTFitparms',$
            'tags']

    self.tags = tags

    if n_elements(narcs) eq 0 then narcs = 7
    if n_elements(blank) eq 0 then blank = 0


        self.magtags = [ $
                'magnetic',$
                'p',$
                'f',$
                'eff_bpw',$
                'point_to_up_x',$
                'point_to_up_y',$
                'point_to_up_z',$
                'point_to_down_x',$
                'point_to_down_y',$
                'point_to_down_z',$
                'xyzupdownscale',$
                'mask1dPixels',$
                'extensions',$
                'magtags']


    ;102705 CHANGE THE NEXT TEST
    if blank ne 0 then begin;(n_elements(blank)) gt 0 then begin
        ;print,'TEST BLANK'
        self->blankObj,nft=nft,nphs=nphs,xdim=xdim,ydim=ydim,bin=bin

        if obj_valid(removetobj) then begin
            ;self->cloneSetRemoveT,removetobj,tremove=tremove
            self->cloneSet,removetobj,tremove=tremove,modtime=modtime
        endif


        ;help,obj
        ;help,mobj

        if (n_elements(obj) gt 0) and (obj_valid(mobj) gt 0) then begin
            ;print,'TEST INIT'
            return,0
        endif
        return,1
    endif else begin


        if (n_elements(obj) ne 0) then begin
            ;COPY OBJECT HERE FOR CLONE METHOD AND INITIALIZATION WITH
            ;OTHER OBJECT
            self->cloneSet,obj
            return,1
        endif else begin


    ;103105
    ;FOR NOW REQUIRE THAT FILENAME BE PASSED AS PARAMETER
                if (n_elements(filename) ne 0) then begin
                    ;print,'READING WITH A FILENAME.'
                    ret = self->read(filename=filename,facility=facility)
                endif else begin
                    ret = self->read(facility=facility)
                endelse

                ;ret = self->ooEcho::init(_Extra=extra)
                ;NOW READ IN THE 6 MAGNETIC FILES ASSOCIATED WITH THIS ONE.
        ;                    magfilename = filename+'_UP_DOWN_XYZ'
        ;                    retm = self->readMagnetic() ;THIS WILL BE CALLED FROM OVERRIDDEN read



    ;103105
    ;INSERT CODE FROM ret eq 1 HERE:

                if ret eq 1 then begin
                    if (ptr_valid(self.e) ne 0) then begin
                        if ptr_valid(self.emask) gt 0 then ptr_free,self.emask
                        if ptr_valid(self.eorig) gt 0 then ptr_free,self.eorig


                        self->setProperty,'emask',ptr_new(*(self->getProperty(tag='e')))
                        self->setProperty,'eorig',ptr_new(*(self->getProperty(tag='e')))
                        sz = size(*(self.e))
                        if ptr_valid(self.fixed) gt 0 then ptr_free,self.fixed
                        self->setProperty,'fixed',$
                                    ptr_new(intarr(6,sz[1],sz[3]))
                        (*(self.fixed))[0,*,*] = 0    ;VARY p1
                        (*(self.fixed))[1,*,*] = 0
                        (*(self.fixed))[2,*,*] = 0
                        (*(self.fixed))[3,*,*] = 1    ;FIX p4
                        (*(self.fixed))[4,*,*] = 0
                        (*(self.fixed))[5,*,*] = 1

                        if ptr_valid(self.fitparms) gt 0 then ptr_free,self.fitparms
                        self->setProperty,'fitparms',$
                                    ptr_new(dblarr(12,sz[1],sz[3])+1.0)
                        (*self.fitparms)[0,*,*] = (*self.fitparms)[0,*,*] + 199.0
                        (*self.fitparms)[1,*,*] = (*self.fitparms)[1,*,*] + 99.0
                        (*self.fitparms)[2,*,*] = (*self.fitparms)[2,*,*] + 199.0
                        (*self.fitparms)[3,*,*] = (*self.fitparms)[3,*,*] + 702.0
                        (*self.fitparms)[4,*,*] = (*self.fitparms)[4,*,*] + 0.0
                        (*self.fitparms)[5,*,*] = (*self.fitparms)[5,*,*] - 1.0


                        if ptr_valid(self.chisq) gt 0 then ptr_free,self.chisq
                        self->setProperty,'chisq',$
                                        ptr_new(dblarr(sz[1],sz[3]))

                        ;FOR SOME REASON AN OPERATION IS REQUIRED TO
                        ;MAKE self.chisq A VALID POINTER.
                        (*self.chisq)[*,*,*] = (*self.chisq)[*,*,*] + 100000000.0
                        ;;help,self.fitparms
                        ;;help,self.chisq
                        ;;help,*self.chisq

                        if ptr_valid(self.mask1D) then ptr_free,self.mask1D
                        self.mask1D = ptr_new(intarr(self.no_of_phases,self.no_of_fourier_times)+1)

    ;                    ;082205
    ;                    if ptr_valid(self.mask1DPixels) then ptr_free,self.mask1DPixels
    ;                    self.mask1DPixels = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_phases,self.no_of_fourier_times)+1)



                        if ptr_valid(self.mask2D) then ptr_free,self.mask2D
                        if ptr_valid(self.fitdisplaymask) then ptr_free,self.fitdisplaymask
                        self.x_dim = sqrt(sz[1])
                        self.y_dim = sqrt(sz[1])
                        ;print,self.x_dim
                        ;print,self.y_dim
                        ;print,self.no_of_fourier_times
                        self.mask2D = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1)
                        self.mask2DOld = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1)
                        self.fitdisplaymask = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+0)
                        self.fitdisplaymaskOld = ptr_new(intarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+0)
                        self.Iup = ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                        self.Idown=ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                        self.sIup = ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                        self.sIdown=ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                        self.IupdownSwitch = 0
                        self.S=ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                        self.sS=ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                        self.QVals = ptr_new(dblarr(self.x_dim*self.y_dim,self.no_of_fourier_times)+1.0)
                        self.QValsSwitch = 0
                        self.narcs = narcs
                        self.qarcs = ptr_new(dblarr(5))
                        self.IQTInfo = ptr_new(['#','#'])
                        self.IQT = ptr_new(dblarr(self.narcs,self.no_of_fourier_times))
                        self.sIQT = ptr_new(dblarr(self.narcs,self.no_of_fourier_times))
                        self.IQTFitparms = ptr_new(dblarr(self.narcs,2))

                        self.transmission=1.0
                        self.width=702.0
                        self.period = 373.0

                        self.f = 0.97
                        self.p = 1.0;0.80
                        self.eff_bpw = 0.81
;                        self.eff_bpw_x = 0.81
;                        self.eff_bpw_y = 0.81
;                        self.eff_bpw_z = 0.81

                    endif else begin
                        print,'11313 ooecho::init THE DATA ARRAY WAS NOT INITIALIZED!!!'
                    endelse
                    ;THESE NEXT LINES NEED TO BE GENERALIZED
                    ;SO OTHER TYPES OF DETECTORS CAN BE USED
                    self->setProperty,'x_dim',sqrt(self.no_of_pixels)
                    self->setProperty,'y_dim',sqrt(self.no_of_pixels)
                    self->setProperty,'x_dim_orig',sqrt(self.no_of_pixels)
                    self->setProperty,'y_dim_orig',sqrt(self.no_of_pixels)

                    self->setProperty,'x_cen',16.0
                    self->setProperty,'y_cen',15.0
                    self->setProperty,'x_cen_orig',16.0
                    self->setProperty,'y_cen_orig',15.0
                    self->setProperty,'colorTable',3
                    self->setproperty,'xyzupdownscale',1.0

                return,1
            endif else begin
                ;void = dialog_message('ret = 0; ooEchoMagnetic Object Not Created.')
                print,'ret = 0; ooEchoMagnetic Object Not Created.'
                return,0
            endelse

        endelse;no object to copy
    endelse;not blank



end;ooEchoMagnetic::init


pro ooechoMagnetic__define,class


    class = {ooEchoMagnetic, $
                inherits ooecho,$
                magnetic:0,$
                p:0.0,$     ;POLARIZATION
                f:0.0,$     ;FLIPPING RATIO
                eff_bpw:0.0,$
;                eff_bpw_x:0.0,$
;                eff_bpw_y:0.0,$
;                eff_bpw_z:0.0,$
                point_to_up_x:0,$
                point_to_up_y:0,$
                point_to_up_z:0,$
                point_to_down_x:0,$
                point_to_down_y:0,$
                point_to_down_z:0,$
                xyzupdownscale:1.0,$
                mask1dPixels:ptr_new(),$    ;THE NEW 1D MASK FOR EACH PIXEL.
                extensions:ptr_new(),$      ;POINTER TO ALLOW EXTENDING THE VARIABLES IN THE CLASS STRUCTURE WITHOUT EXTENDING THE CLASS.
                magtags:strarr(14) $
                }


end;ooechoMagnetic__define
