; $Id$
;###############################################################################
;
;CLASS NAME:
;    ooDisplayEcho__automaskSomething
;
;PURPOSE:
;               Apply and automask with some user criteria.
;CATEGORY:
;               Data Visualization, Analysis and Manipulation.
;
;METHODS:
;    ooDisplayEcho::automaskSomething
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jul 28,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
pro oodisplayecho::automask,opt,gtlt,tol,pstate
;
;NAME:
;           oodisplayecho::automask
;
;PURPOSE:
;           THE MAIN ROUTINE.
;PARAMETERS:
;           opt     INDEX OF OPTION TO MASK
;           gtlt    GREATER THAN OR LESS THAN
;           tol     THE TOLERANCE OF THE MASKING
;           pstate  THE POINTER TO THE STATE STRUCTURE
;KEYWORDS:
;
;

    ;print,'opt=',opt[0]
    ;print,'gtlt=',gtlt[0]
    ;print,'tol=',tol



    ;WHAT SHOULD BE MASKABLE?
    ;
    ;AMPLITUDE
    ;SIGNAL
    ;ePHASE
    ;ChiSq
    ;
    ;
    ;
    ;

    options = [ 'Total Echo Counts',$
                'Amplitude',$
                'eAmplitude',$
                'Phase',$
                'ePhase',$
                'Width',$
                'eWidth',$
                'Period',$
                'ePeriod',$
                'Chi Squared',$
                'Signal',$
                'eSignal',$
                'mask2d' $
                ]



    ref = (self.datacontainer)->get(position=self.QChoiceIndex)
    mask2d = (*(ref->getproperty(tag='mask2d')))
    mask2dorig = mask2d

    if ptr_valid((*pstate).mask2d_orig) gt 0 then ptr_free,(*pstate).mask2d_orig

    (*pstate).mask2d_orig = ptr_new(mask2dorig)

;092905
;OPT IS A 1 ELEMENT ARRAY, SO USE THE ZEROTH VALUE.
    case opt[0] of
    0:begin;total counts
        ;print,options[opt[0]]
        lim = min([ref->getproperty(tag='point_to_down'),ref->getproperty(tag='point_to_up')])
        echoes = (*(ref->getproperty(tag='e')))[*,0:lim-1,*]
        echoes = total(echoes,2)

        ;help,echoes
        vals = echoes
        ;help,mask2d
        ;help,vals
    end;
    1:begin;amplitude
        ;print,options[opt[0]]
        vals = (*(ref->getproperty(tag='fitparms')))[1,*,*]
        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end;
    2:begin;eamplitude
        ;print,options[opt[0]]
        vals = (*(ref->getproperty(tag='fitparms')))[7,*,*]/(*(ref->getproperty(tag='fitparms')))[1,*,*]
        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end
    3:begin;phase
        ;print,options[opt[0]]
        vals = (*(ref->getproperty(tag='fitparms')))[2,*,*]
        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end;
    4:begin;ephase
        ;print,options[opt[0]]
        vals = (*(ref->getproperty(tag='fitparms')))[8,*,*]
        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end;
    5:begin;width
        ;print,options[opt[0]]
        vals = (*(ref->getproperty(tag='fitparms')))[3,*,*]
        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end;
    6:begin;ewidth
        ;print,options[opt[0]]
        vals = (*(ref->getproperty(tag='fitparms')))[9,*,*]/(*(ref->getproperty(tag='fitparms')))[3,*,*]
        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end;
    7:begin;period
        ;print,options[opt[0]]

        ;DUE TO HISTORICAL REASONS, THIS WAS STORED AS omega INSTEAD OF PERIOD
        vals = 360.0d/(*(ref->getproperty(tag='fitparms')))[4,*,*]
        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end;
    8:begin;eperiod
        ;print,options[opt[0]]
        som = (*(ref->getproperty(tag='fitparms')))[10,*,*]
        om = (*(ref->getproperty(tag='fitparms')))[4,*,*]
        vals = som/om

        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end;
    9:begin;chisq

        ;WHY DO ALL PIXELS HAVE A CHISQ VALUE???????
        ;ESPECIALLY THE MASKED ONES?????????????????
        ;

        ;print,options[opt[0]]
        vals = (*(ref->getproperty(tag='chisq')))[*,*]
        ;help,mask2d
        ;help,vals

    end;
    10:begin;signal
        ;print,options[opt[0]]
        amp = (*(ref->getproperty(tag='fitparms')))[1,*,*]
        iup = (*(ref->getproperty(tag='Iup')))
        idown = (*(ref->getproperty(tag='Idown')))

        vals = 2.0*amp/(idown-iup)

        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end;
    11:begin;esignal
        ;print,options[opt[0]]

        amp = (*(ref->getproperty(tag='fitparms')))[1,*,*]
        iup = (*(ref->getproperty(tag='Iup')))
        idown = (*(ref->getproperty(tag='Idown')))
        samp = (*(ref->getproperty(tag='fitparms')))[7,*,*]
        siup = (*(ref->getproperty(tag='sIup')))
        sidown = (*(ref->getproperty(tag='sIdown')))

        vals = sqrt((2.0*samp/(idown-iup))^2.0 + (2.0*amp*sidown/(idown-iup)^2.0)^2.0 + $
                            (2.0*amp*siup/(idown-iup)^2.0)^2.0)

        vals = vals/(2.0*amp/(idown-iup))

        szvals = size(vals)
        vals = reform(vals,szvals[2],szvals[3])
        ;help,mask2d
        ;help,vals
    end;
    12:begin
        vals = mask2d
    end;
    else:begin
        ;print,'opt=',opt[0]
    end
    endcase


    ;UNMASK EVERYTHING
    mask2d[*,*] = 1
    the_count = 0

    factor = ref->getproperty(tag='x_dim_orig')/ref->getproperty(tag='x_dim')
    ;APPLY STANDARD MASK
    ;THE IMPLEMENTATAION WILL BE A FOR LOOP:
    if opt[0] ne 0 then begin
        for m = 0,ref->getproperty(tag='no_of_fourier_times')-1 do begin
           mask2d[*,m] = ref->defaultMask(binfactor=factor)
        endfor;m
    endif;opt

    ;LRK - 08/20/09
    ;UPDATE THE CHECK FOR NaN's.
    case gtlt[0] of
    0:begin ;GT
        ;loc = where(vals gt tol or vals eq 'nan' or mask2d le 0)
        loc = where(vals gt tol or finite(vals,/nan) eq 1 or mask2d le 0)  ;<------ AM I CHECKING FOR THE RIGHT MASK VALUE AND UPDATING THE MASK PROPERLY?????
        ;affected = where(vals gt tol or vals eq 'nan' and mask2d gt 0,the_count)
        affected = where(vals gt tol or finite(vals,/nan) eq 1 and mask2d gt 0,the_count)
        if loc[0] ne -1 then begin
            mask2d[loc] = 0
        endif
    end
    1:begin ;LT
        ;loc = where(vals lt tol or vals eq 'nan' or mask2d le 0)
        loc = where(vals lt tol or finite(vals,/nan) eq 1 or mask2d le 0)
        ;affected = where(vals lt tol or vals eq 'nan' and mask2d gt 0,the_count)
        affected = where(vals lt tol or finite(vals,/nan) eq 1 and mask2d gt 0,the_count)
        if loc[0] ne -1 then begin
            mask2d[loc] = 0
        endif
    end
    2:begin ;EQ
        ;loc = where(vals eq tol or vals eq 'nan' or mask2d le 0)
        loc = where(vals eq tol or finite(vals,/nan) eq 1 or mask2d le 0)
        ;affected = where(vals eq tol or vals eq 'nan' and mask2d gt 0,the_count)
        affected = where(vals eq tol or finite(vals,/nan) eq 1 and mask2d gt 0,the_count)
        if loc[0] ne -1 then begin
            mask2d[loc] = 0
        endif
    end
    else:begin
    end
    endcase

    widget_control,(*pstate).count,set_value=the_count

;082205
;ANTONIO REQUESTS THAT THE AUTOMASKING APPLY ONLY TO
;CURRENTLY NON-MASKED POINTS.
;

    widget_control,(*pstate).UnDoIt,sensitive = 1
    mask2d_orig = *(ref->getproperty(tag='mask2d'))

    ;help,mask2d_orig
    ;help,mask2d

    sav_loc = where(mask2d_orig lt 1)
    if sav_loc[0] ne -1 then mask2d[sav_loc] = mask2d_orig[sav_loc]


    if ptr_valid((ref->getproperty(tag='mask2d'))) gt 0 then ptr_free,ref->getproperty(tag='mask2d')


    ref->setproperty,'mask2d',ptr_new(mask2d)
    self->draw

end;automask

pro automaskSomething_event,event
;
;NAME:
;           automasksomething_event
;
;PURPOSE:
;           Event handler.
;PARAMETERS:
;           event   The event to handle.
;KEYWORDS:
;
;

    widget_control,event.top,get_uvalue = pstate
    ;print,tag_names(*pstate)

    case event.id of
    (*pstate).Quit:begin
        widget_control,(*pstate).tlb,/destroy
    end;Quit
    (*pstate).DoIt:begin
        opt = nse_comboindex((*pstate).optioncombo)
        gtlt = nse_comboindex((*pstate).gtltcombo)
        widget_control,(*pstate).field,get_value=tol
        (*pstate).obj->automask,opt[0],gtlt[0],tol,pstate
    end;DoIt
    (*pstate).UnDoIt:begin
        widget_control,(*pstate).UnDoIt,sensitive = 0
        mask2dorig = *(*pstate).mask2d_orig

        self = (*pstate).obj
        ref = (((*pstate).obj)->getproperty(/datacontainer))->get(position=self->getProperty(/QChoiceIndex))

        if ptr_valid((ref->getproperty(tag='mask2d'))) gt 0 then $
                ptr_free,ref->getproperty(tag='mask2d')

        ref->setproperty,'mask2d',ptr_new(mask2dorig)

        widget_control,(*pstate).count,set_value=0

        self->draw
    end;DoIt
;    (*pstate).DoItPlusDefault:begin
;        opt = nse_comboindex((*pstate).optioncombo)
;        gtlt = nse_comboindex((*pstate).gtltcombo)
;        widget_control,(*pstate).field,get_value=tol
;        (*pstate).obj->automask,opt[0],gtlt[0],tol
;    end;DoIt
    else:begin
    end;else
    endcase

end;automaskSomething_event,event
pro automaskSomething_cleanup,id
;
;NAME:
;           automasksomething_cleanup
;
;PURPOSE:
;           Cleanup routine.
;PARAMETERS:
;           id  id of the tlb
;KEYWORDS:
;
;

    print,'automaskSomething_cleanup'
    widget_control,id,get_uvalue=pstate
    if ptr_valid(pstate) gt 0 then ptr_free,pstate

end;automaskSomething_cleanup,id

pro ooDisplayEcho::automaskSomething
;
;NAME:
;           ooDisplayEcho::automaskSomething
;
;PURPOSE:
;           Automask data based on selected user criteria.
;PARAMETERS:
;           none
;KEYWORDS:
;
;

    b = widget_base(group_leader = self.atlb,/col,title='Automask',/floating)

;    IgorOpts = ['IQTMask',$
;             'signale',$
;             'signal',$
;             'Phi0e',$
;             'Phi0',$
;             'Widthe',$
;             'Width',$
;             'Periode',$
;             'Period',$
;             'SigFone',$
;             'SigFon',$
;             'SigFoffe',$
;             'SigFoff',$
;             'SigDiffe',$
;             'SigDiff',$
;             'SigMeane',$
;             'SigMean',$
;             'Iqtrawe',$
;             'Iqtraw',$
;             'ChiSq',$
;             'l1w',$
;             'RelativeAmpErr' $
;             ]
;



    opts =    [ 'Total Echo Counts',$
                'Amplitude',$
                'eAmplitude (Fractional)',$
                'Phase',$
                'ePhase',$
                'Width',$
                'eWidth (Fractional)',$
                'Period',$
                'ePeriod (Fractional)',$
                'Chi Squared',$
                'Signal',$
                'eSignal', $
                'mask2d' $
                ]

    gtlt = ['greater than','less than','equal to']

    l1 = widget_label(b,value = 'Value to use')
    dl1 = widget_combobox(b,value=opts)
    l1 = widget_label(b,value='Mask pixels with values GREATER, LESS or EQUAL TO tolerance')
    dl2 = widget_combobox(b,value=gtlt)

    field = cw_field(b,/column,/floating,value = 0.0,title='Tolerance')

    count = cw_field(b,/column,/integer,value = 0,title='# Pixels Affected')

    doIt = widget_button(b,value='Do It')
    UnDoIt = widget_button(b,value='Undo It',sensitive = 0)
    Quit = widget_button(b,value='Done')



    state = {obj:self,tlb:b,optioncombo:dl1,gtltcombo:dl2,field:field, $
                doIt:doIt,UnDoIt:UnDoIt,Count:Count,Quit:quit,mask2d_orig:ptr_new()}
    pstate = ptr_new(state)

    widget_control,b,/realize
    widget_control,b,set_uvalue=pstate

    xmanager,'automaskSomething',b,/no_block,cleanup = 'automasksomething_cleanup'

end;autoMaskSomething