; $Id$
;###############################################################################
;
;FILENAME:
;        cw_nse_sqplot.pro
;
;
;PURPOSE:
;   Plot 1D S(Q,t=0) for NSE data.
;
;CATEGORY:
;   Quick check of data.
;
;METHODS IN FILE:
;
;METHODS:
;    cw_nse_sqplot_helpstring
;    cw_nse_sqplot_event
;    cw_nse_sqplot_resize
;    cw_nse_sqplot_emptycontainer
;    cw_nse_sqplot_draw
;    cw_nse_sqplot_cleanup
;    cw_nse_sqplot_realize
;    cw_nse_sqplot
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri Oct 21 15:09:09 2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cw_nse_sqplot_helpstring
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
function cw_nse_sqplot_helpstring

    s = [ $
         'This program displays the average total echo counts ',$
         'per pixel divided by the monitor counts for each ',$
         'available ooEcho or ooEchoMagnetic data object.' $
        ]
    return,s
end;cw_nse_sqplot_helpstring
;###############################################################################
;
;NAME:
;        cw_nse_sqplot_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cw_nse_sqplot_event,event

    widget_control,event.top,get_uvalue=pstate

    case event.id of
    (*pstate).quit:begin
        widget_control,(*pstate).tlb,/destroy
    end;quit
    (*pstate).closebutton:begin
        widget_control,(*pstate).tlb,/destroy
    end;closebutton
    (*pstate).open:begin
        s = strarr(1)
        ;ncount =
        count = checkforobjinstance('ooecho',ref=ref)

        ;NO NEED TO DISTINGUISH MAGNETIC AND NON MAGNETIC IN CURRENT STATE
        if count gt 0 then begin
            s = strarr(count)
            for i=0,count-1 do begin
                s[i] = file_basename(ref[i]->getproperty(tag='filename'))
            endfor;i
            s = s[sort(s)]
        endif else begin
            s = ['NO OBJECTS AVAILABLE']
        endelse
        widget_control,(*pstate).list,set_value=s,set_uvalue=s

    end;open
    (*pstate).xlog:begin
        widget_control,(*pstate).xlog,get_value=val
        cw_nse_sqplot_draw,pstate
    end;xlog
    (*pstate).xmin:begin
        widget_control,(*pstate).xmin,get_value = xmin
        cw_nse_sqplot_draw,pstate
    end;xmin
    (*pstate).xmax:begin

        widget_control,(*pstate).xmax,get_value = xmax
        print,xmax
        cw_nse_sqplot_draw,pstate
    end;xmax
    (*pstate).ylog:begin
;        widget_control,(*pstate).ylog,get_uvalue=loglin
;        if loglin eq 0 then begin
;            widget_control,(*pstate).ylog,set_uvalue = 1, set_value = 'lin y'
;        endif else begin
;            widget_control,(*pstate).ylog,set_uvalue = 0, set_value = 'log y'
;        endelse

        cw_nse_sqplot_draw,pstate
    end;ylog
    (*pstate).ymin:begin
        widget_control,(*pstate).ymin,get_value = ymin
        print,ymin

        cw_nse_sqplot_draw,pstate
    end;ymin
    (*pstate).ymax:begin

        widget_control,(*pstate).ymax,get_value = ymax
        print,ymax
        cw_nse_sqplot_draw,pstate
    end;ymax
    (*pstate).writeascii:begin
        fn = dialog_pickfile()

        if fn ne '' then begin
            (*pstate).work_dir = file_dirname(fn)
            if (*pstate).datacontainer->count() gt 0 then begin
                names = strarr((*pstate).datacontainer->count())
                for i=0,(*pstate).datacontainer->count()-1 do begin
                    ref = (*pstate).datacontainer->get(position=i)
                    names[i] = ref->getproperty(/name)
                endfor;i
                order = sort(names)
                print,fn
                openw,lun,fn,/get_lun
                printf,lun,'#   Q        S(Q,t=0)        sS(Q,t=0)'
                for i=0,(*pstate).datacontainer->count()-1 do begin
                    ref = (*pstate).datacontainer->get(position=order[i])
                    q = *(ref->getproperty(/q))
                    s = *(ref->getproperty(/s))
                    ss = *(ref->getproperty(/ss))
                    printf,lun,ref->getproperty(/name)
                    for j=0,n_elements(q)-1 do begin
                        printf,lun,q[j],s[j],ss[j]
                    endfor;j
                endfor;i
                free_lun,lun
            endif
        endif


    end;writeascii
    (*pstate).printbutton:begin
        wset,(*pstate).winvis
        image = tvrd(true=3)
        nse_ps_plotter,image,directory=(*pstate).work_dir,filename='SQ_plot.ps'
    end;printbutton
    (*pstate).closebutton:begin
        passevent = event
        passevent.id = (*pstate).quit
        cw_nse_sqplot_emptycontainer,passevent
    end;closebutton
    (*pstate).list:begin

        cw_nse_sqplot_emptycontainer,pstate
        widget_control,(*pstate).list,get_uvalue=s
        sel = widget_info((*pstate).list,/list_select)

        ;CHECK THAT SELECTED OBJECT IS STILL AVAILABLE.
        count = checkforobjinstance('ooecho',ref=ref)

        ;CREATE AN ORDERED FILE LIST AND REF LIST
        if count ne 0 then begin
            firstplot = 1
            filelist = strarr(count)
            qlist = dblarr(count)
            for i=0,count-1 do begin
                filelist[i] = file_basename(ref[i]->getproperty(tag='filename'))
                qlist[i] = ref[i]->getproperty(tag='q')
            endfor;i
            ;ORDER THE OBJECTS BY Q
            filelist = filelist[sort(qlist)]
            ref = ref[sort(qlist)]
            qlist = qlist[sort(qlist)]
            for i=0,n_elements(ref)-1 do begin
                whr = where(filelist[i] eq s[sel])
                if whr[0] ne -1 then begin


                    if obj_isa(ref[i],'ooEchoMagnetic') gt 0 then begin

                        if ref[i]->getproperty(tag='magnetic') eq 1 then begin

                            dum = ref[i]->SQ1D(sq=tot,mag=mag,tot=tot,coh=coh,incoh=incoh)

                            ;SET UP NEW NAMES
                            ext  = ['_tot','_mag','_incoh','_coh']
                            sq1d = [tot,mag,incoh,coh]
                            pos = strpos(filelist[i],'.')
                            if pos ne -1 then begin
                                shortname = strmid(filelist[i],0,pos)
                            endif else begin
                                shortname = filelist[i]
                            endelse

    ;TEST FIRST WITH JUST TOT, THEN SET UP THE PLOTTING FOR ALL 4;
    ;USE SYMBOLS TO DISTINGUISH SAMPLES AND COLORS TO DISTINGUISH ITEMS.
                            for j=0,3 do begin
    ;                            print,'TEST'
                                obj = obj_new('oonseSQ1D',shortname+ext[j],sq1d[j])
                                (*pstate).datacontainer->add,obj
                            endfor;j
                        endif else begin
                            ;IF NOT MAGNETIC
                            obj = obj_new('oonseSQ1D',filelist[i],ref[i]->SQ1D())
                            (*pstate).datacontainer->add,obj
                        endelse
                    endif else begin
                        obj = obj_new('oonseSQ1D',filelist[i],ref[i]->SQ1D())
                        (*pstate).datacontainer->add,obj
                    endelse

                    ;print,obj->getproperty(/name)
                    ;help,obj
                endif
            endfor;i
            if n_elements(firstplot) eq 0 then firstplot = 0
            cw_nse_sqplot_draw,pstate,zoombox=0,firstplot = firstplot
        endif else begin
            void = dialog_message('NO VALID ooEcho OBJECTS in list.')
        endelse
    end;list
    (*pstate).draw:begin

        if (*pstate).press ne 0 then begin
            case (*pstate).press of
            1:begin
                ;print,'event.x,event.y=',event.x,event.y
                coords = convert_coord(event.x,event.y,/device,/to_data)
                ;print,coords
                (*pstate).releasex = coords[0]
                (*pstate).releasey = coords[1]

                zoombox = 1
            end;1
            4:begin

            end;4
            else:
            endcase

            if n_elements(zoombox) eq 0 then zoombox = 0
            if n_elements(firstplot) eq 0 then firstplot = 0
            cw_nse_sqplot_draw,pstate,zoombox=zoombox,firstplot = firstplot
        endif else begin

;DO NOTHING FOR MOTION ONLY, NO DRAG, NO BUTTON PRESS
            if event.press ne 0 then begin
                (*pstate).press = event.press
                ;print,'event.x,event.y=',event.x,event.y
                coords = convert_coord(event.x,event.y,/device,/to_data)
                (*pstate).pressx = coords[0]
                (*pstate).pressy = coords[1]
            endif

        endelse

        if event.release ne 0 then begin

            case (*pstate).press of
            1:begin
                (*pstate).press = 0
                zoombox = 0

                xvals = [(*pstate).pressx,(*pstate).releasex]
                yvals = [(*pstate).pressy,(*pstate).releasey]

                widget_control,(*pstate).xmin,set_value=min(xvals)
                widget_control,(*pstate).xmax,set_value=max(xvals)
                widget_control,(*pstate).ymin,set_value=min(yvals)
                widget_control,(*pstate).ymax,set_value=max(yvals)
            end;1
            4:begin
                (*pstate).press = 0
                zoombox = -1    ;TELL DRAW TO USE DEFAULT AXIS RANGES BASED ON DATA
                if ptr_valid((*pstate).q) eq 0 and ptr_valid((*pstate).s) eq 0 then begin
                    firstplot = 1
;                    widget_control,(*pstate).xmin,set_value=0.0
;                    widget_control,(*pstate).xmax,set_value=1.0
;                    widget_control,(*pstate).ymin,set_value=0.0
;                    widget_control,(*pstate).ymax,set_value=1.0
                endif
            end
            else:
            endcase
            if n_elements(zoombox) eq 0 then zoombox = 0
            if n_elements(firstplot) eq 0 then firstplot = 0
            cw_nse_sqplot_draw,pstate,zoombox=zoombox,firstplot = firstplot
        endif
    end;draw
    (*pstate).tlb:begin
        cw_nse_sqplot_resize,event
    end;tlb
    (*pstate).help:begin
        (*pstate).helpbase = widget_base(title='About cw_nse_sqplot:',/floating,/modal,$
                                            group_leader = (*pstate).tlb,/col,$
                                            uvalue=pstate)
        text = cw_nse_sqplot_helpstring()
        xsize = max(strlen(cw_nse_sqplot_helpstring()))
        ysize = n_elements(text)
        t1 = widget_text((*pstate).helpbase,ysize=ysize,xsize=xsize,value=text)
        (*pstate).helpclose = widget_button((*pstate).helpbase,value='Close')
        widget_control,(*pstate).helpbase,/realize
        xmanager,'cw_nse_sqplot',(*pstate).helpbase
    end;help
    (*pstate).helpclose:begin
        widget_control,(*pstate).helpbase,/destroy
    end;helpclose
    else:
    endcase
end;cw_nse_sqplot_event
;###############################################################################
;
;NAME:
;        cw_nse_sqplot_resize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cw_nse_sqplot_resize,event
    print,'RESIZING TLB'
    widget_control,event.top,get_uvalue=pstate

    padx = 33
    pady = 14

    xsize = event.x - 150 - padx
    ysize = event.y - pady

    if xsize lt 300 then xsize = 300
    if ysize lt 300 then ysize = 300
    widget_control,(*pstate).draw,xsize=xsize,ysize=ysize
    wdelete,(*pstate).winpix
    ;wdelete,(*pstate).winvis

    window,/free,/pixmap,xsize=xsize,ysize=ysize
    (*pstate).winpix = !d.window

    cw_nse_sqplot_draw,pstate

end;cw_nse_sqplot_resize



;###############################################################################
;
;NAME:
;        cw_nse_sqplot_emptycontainer
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cw_nse_sqplot_emptycontainer,pstate
    for i=0,(*pstate).datacontainer->count()-1 do begin
        ref = (*pstate).datacontainer->get(position=0)
        (*pstate).datacontainer->remove,position=0
        obj_destroy,ref
    endfor;i
end;cw_nse_sqplot_emptycontainer
;#########################################################
;###############################################################################
;
;NAME:
;        cw_nse_sqplot_draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cw_nse_sqplot_draw,pstate,zoombox=zoombox,firstplot=firstplot,_Extra=extra

    device,get_decomposed = dc
    device,decomposed = 1

    if n_elements(zoombox) eq 0 then zoombox = 0
    if n_elements(firstplot) eq 0 then firstplot = 0

    widget_control,(*pstate).xlog,get_value=xlog;get_uvalue=xlog
    widget_control,(*pstate).ylog,get_value=ylog;get_uvalue=ylog
    widget_control,(*pstate).xmin,get_value = xmin
    widget_control,(*pstate).xmax,get_value = xmax
    widget_control,(*pstate).ymin,get_value = ymin
    widget_control,(*pstate).ymax,get_value = ymax

;    if ptr_valid((*pstate).q) gt 0 and ptr_valid((*pstate).s) gt 0 then begin
;        y = *(*pstate).s
;        x = *(*pstate).q
    container = (*pstate).datacontainer
    count = container->count()
    if count gt 0 then begin
        npoints = intarr(count)
        x = [0.0d]
        y = [0.0d]
        sy = [0.0d]
        for i=0,count-1 do begin
            ref = container->get(position=i)
            x = [x,*(ref->getproperty(/q))]
            y = [y,*(ref->getproperty(/s))]
            sy = [sy,*(ref->getproperty(/ss))]
            npoints[i] = n_elements(*(ref->getproperty(/q)))
        endfor;i
        x = x[1:*]
        y = y[1:*]
        sy = sy[1:*]

        nodata = 1
    endif else begin
        x = [xmin,xmax]
        y = [ymin,ymax]
        nodata = 1
    endelse
    if zoombox eq -1 then begin
        xstyle = 0
        ystyle = 0
    endif else begin
        xstyle = 1
        ystyle = 1
    endelse

    wset,(*pstate).winpix
    if firstplot eq 1 then begin
        xmin = min(x)
        xmax = max(x)
        ymin = min(y)
        ymax = max(y)
        xstyle = 0
        ystyle = 0
        plot,x,y,nodata=nodata,color=(*pstate).black, background = (*pstate).white,$
                     xtitle=(*pstate).xtitle, ytitle=(*pstate).ytitle,$
                     title=(*pstate).title,$
                     xrange=[xmin,xmax], yrange=[ymin,ymax],$
                     xstyle=xstyle,ystyle=ystyle,xlog=xlog,ylog=ylog

        widget_control,(*pstate).xmin,set_value=min(!x.crange)
        widget_control,(*pstate).xmax,set_value=max(!x.crange)
        widget_control,(*pstate).ymin,set_value=min(!y.crange)
        widget_control,(*pstate).ymax,set_value=max(!y.crange)
        erase,(*pstate).winpix
    endif
    plot,x,y,nodata=nodata,color=(*pstate).black, background = (*pstate).white,$
                 xtitle=(*pstate).xtitle, ytitle=(*pstate).ytitle,$
                 title=(*pstate).title,$
                 xrange=[xmin,xmax], yrange=[ymin,ymax],$
                 xstyle=xstyle,ystyle=ystyle,xlog=xlog,ylog=ylog


    thesyms = [1,2,4,5,6,7]
    black = (*pstate).black
    red = (*pstate).red
    green = (*pstate).green
    blue = (*pstate).blue

    thecolors = [black,red,green,blue,red+green,red+blue,blue+green]
    if count ne 0 then begin

        ;NEED TO SORT BY MAGNETIC AND GROUP HERE.
        for i=0,count-1 do begin
            ref = container->get(position=i)
            name = ref->getproperty(/name)
            q = *(ref->getproperty(/q))
            s = *(ref->getproperty(/s))
            ss = *(ref->getproperty(/ss))
            color = thecolors[i mod 4]
            psym = thesyms[i mod 5]
            oplot,q,s,color = color,psym = -psym
            errplot,q,s-ss,s+ss,color = color
            nse_legend,(*pstate).winpix,0.7,0.9-0.05*i,name,$
                            color=color,psym=psym,symsize=symsize


        endfor;i
    endif



    ;PUT RANGES INTO min max FIELDS
    if zoombox eq -1 then begin
        widget_control,(*pstate).xmin,set_value = (!x.crange)[0]
        widget_control,(*pstate).xmax,set_value = (!x.crange)[1]
        widget_control,(*pstate).ymin,set_value = (!y.crange)[0]
        widget_control,(*pstate).ymax,set_value = (!y.crange)[1]
    endif

    if nodata eq 0 then oplot,x,y,color=(*pstate).black,psym=3


    if zoombox eq 1 then begin
        plots,[(*pstate).pressx,(*pstate).pressx],$
                [(*pstate).pressy,(*pstate).releasey],$
                color=(*pstate).black,/data
        plots,[(*pstate).pressx,(*pstate).releasex],$
                [(*pstate).releasey,(*pstate).releasey],$
                color=(*pstate).black,/data
        plots,[(*pstate).releasex,(*pstate).releasex],$
                [(*pstate).releasey,(*pstate).pressy],$
                color=(*pstate).black,/data
        plots,[(*pstate).releasex,(*pstate).pressx],$
                [(*pstate).pressy,(*pstate).pressy],$
                color=(*pstate).black,/data

    endif;zoombox
    geom = widget_info((*pstate).draw,/geom)

    wset,(*pstate).winvis
    device,copy=[0,0,geom.xsize,geom.ysize,0,0,(*pstate).winpix]

    device,decomposed = dc

end;cw_nse_sqplot_draw
;#########################################################


;###############################################################################
;
;NAME:
;        cw_nse_sqplot_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cw_nse_sqplot_cleanup,id
    print,'cw_nse_sqplot_cleanup'

    widget_control,id,get_uvalue=pstate

    if ptr_valid((*pstate).q) then ptr_free,(*pstate).q
    if ptr_valid((*pstate).s) then ptr_free,(*pstate).s
    obj_destroy,(*pstate).datacontainer

    if ptr_valid(pstate) gt 0 then ptr_free,pstate

end;cw_nse_sqplot_cleanup
;#########################################################
;###############################################################################
;
;NAME:
;        cw_nse_sqplot_realize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cw_nse_sqplot_realize,tlb
    print,'cw_nse_sqplot_realize'

    widget_control,tlb,get_uvalue=pstate

    widget_control,(*pstate).draw,get_value=winvis
    (*pstate).winvis = winvis

    geom = widget_info((*pstate).draw,/geom)

    window,/free,/pixmap,xsize=geom.xsize,ysize=geom.ysize
    (*pstate).winpix = !d.window

    cw_nse_sqplot_draw,pstate

end;cw_nse_sqplot_realize
;#########################################################
;###############################################################################
;
;NAME:
;        cw_nse_sqplot
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cw_nse_sqplot,group_leader=group_leader, work_dir=work_dir,_Extra=extra

    if n_elements(group_leader) eq 0 then return

    if n_elements(work_dir) eq 0 then work_dir = ''

    datacontainer = obj_new('idl_container')

    tlb = widget_base(mbar=bar,group_leader=group_leader,$
                        /row,title='CW_NSE_SQPLOT: PLOT S(Q)',$
                        notify_realize='cw_nse_sqplot_realize',$
                        /floating,/tlb_size_events)


    file = widget_button(bar,value='File',/menu)
;    open = widget_button(file,value='List Valid ooEcho Objects')
    quit = widget_button(file,value='Quit')
    helpmenu = widget_button(bar,value='Help',/menu)
;    open = widget_button(file,value='List Valid ooEcho Objects')
    helpitem = widget_button(helpmenu,value='About cw_nse_sqplot')

    b1 = widget_base(tlb,/col)
    b2 = widget_base(tlb,/col)

    xlog = cw_bgroup(b1,$
                      'LOG X',$
                      /nonexclusive,$
                      set_value=0,$
                      uvalue=0)
            ;widget_button(b1,value='Log x',uvalue=0)
    xmin = cw_field(b1,value=0.0,title='X min',/floating,/return_events)
    xmax = cw_field(b1,value=1.0,title='X max',/floating,/return_events)

    ylog = cw_bgroup(b1,$
                      'LOG Y',$
                      /nonexclusive,$
                      set_value=0,$
                      uvalue=0)

            ;widget_button(b1,value='Log y',uvalue=0)
    ymin = cw_field(b1,value=0.0,title='Y min',/floating,/return_events)
    ymax = cw_field(b1,value=1.0,title='Y max',/floating,/return_events)
    open = widget_button(b1,value='List Valid ooEcho Objects')

    count = checkforobjinstance('ooecho',ref=ref)
    if count gt 0 then begin
        s = strarr(count)
        for i=0,count-1 do begin
            s[i] = file_basename(ref[i]->getproperty(tag='filename'))
        endfor;i
        s = s[sort(s)]
    endif else begin
        s = ['NO OBJECTS AVAILABLE.']
    endelse
    list = widget_list(b1,value=s,/multiple,ysize=6,uvalue=s)

    writeascii = widget_button(b1,value='WRITE ASCII')
    printbutton = widget_button(b1,value='PRINT')
    closebutton =  widget_button(b1,value='CLOSE')

    draw = widget_draw(b2,xsize=400,ysize=400,/button_events,/motion_events)

    black = 0L
    red = 255L
    green = 256L*red
    blue = 256L*green
    white = red + green + blue


    state = { $
            datacontainer:datacontainer,$
            tlb:tlb,$
            open:open,$
            quit:quit,$
            xlog:xlog,$
            xmin:xmin,$
            xmax:xmax,$
            ylog:ylog,$
            ymin:ymin,$
            ymax:ymax,$
            writeascii:writeascii,$
            printbutton:printbutton,$
            closebutton:closebutton,$
            list:list,$
            help:helpitem,$
            helpbase:-1L,$
            helpclose:-1L,$
            press:0.0,$
            pressx:0.0,$
            pressy:0.0,$
            releasex:0.0,$
            releasey:0.0,$
            q:ptr_new(),$
            s:ptr_new(),$
            draw:draw,$
            winvis:0L,$
            winpix:0L,$
            black:black, $
            red:red,$
            green:green,$
            blue:blue,$
            white:white,$
            xtitle:'Q',$
            ytitle:'S' ,$
            title:'S(Q) (UNNORMALIZED)',$
            work_dir:work_dir $
            }

    pstate = ptr_new(state)
    widget_control,tlb,set_uvalue=pstate

    widget_control,tlb,/realize
    xmanager,'cw_nse_sqplot',tlb,cleanup='cw_nse_sqplot_cleanup',/no_block
end;cw_nse_sqplot
