; $Id$

;CLASS TO STORE A FILENAME, AND NOTHING ELSE, FOR NOW.
pro MACSRunner_v1_data::restore

  print,'MACSRunner_v1_data::restore'

end;MACSRunner_v1_data::restore

pro MACSRunner_v1_data::getProperty,filename=filename,contents=contents,_Extra=extra

  filename = self.filename
  contents=''
  if ptr_valid(self.contents) ne 0 then contents = *self.contents 

end;MACSRunner_v1_data::getProperty
pro MACSRunner_v1_data::setProperty,filename=filename,contents=contents,_Extra=extra

  if n_elements(filename) gt 0 then self.filename = filename
  if n_elements(contents) gt 0 then begin
    if ptr_valid(self.contents) gt 0 then ptr_free,self.contents
    self.contents = ptr_new(contents)
  endif

end;MACSRunner_v1_data::setProperty

function MACSRunner_v1_data::filename

  return,self.filename

end;MACSRunner_v1_data::filename

function MACSRunner_v1_data::Contents

  if ptr_valid(self.contents) gt 0 then begin
    return,*self.contents
  endif else begin
    return,''
  endelse

end;MACSRunner_v1_data::filename

pro MACSRunner_v1_data::cleanup
  if ptr_valid(self.contents) then ptr_free,self.contents
end;MACSRunner_v1_data::cleanup

function MACSRunner_v1_data::clone
  o = obj_new('MACSRunner_v1_data',self.filename)
  self->getproperty,filename=filename,contents=contents
  o->setProperty,filename=filename,contents=contents

  
  return,o
end;MACSRunner_v1_data::clone
function MACSRunner_v1_data::validateData,temps
  
 
  s = temps
  if n_elements(s) le 1 then return,0
  
  endcheck = 0
  retval = 1
  while n_elements(s) gt 0 and endcheck eq 0 do begin
    poundlines = where(stregex(s,'#',/boolean) ne 0,pcount)
  
    if pcount eq n_elements(s) then return,0    ;ALL LINES ARE COMMENTED

    ;REMOVE ENDING COMMENT LINES
    if max(poundlines) ge n_elements(s)-1 then begin
      s = s[0:n_elements(s)-2]
    endif else begin
      endcheck = 1
    endelse
  endwhile

  if n_elements(s) le 1 then return,0
  poundlines = where(stregex(s,'#',/boolean) ne 0,pcount)
  otherlines = where(stregex(s,'#',/boolean) eq 0,ocount) 
  

  if pcount gt 0 and ocount gt 0 then begin
    whdat = where(otherlines gt max(poundlines),datcount)
    
    if datcount gt 0 then begin
      datlines = otherlines[whdat]
      segs = strsplit(s[datlines[0]],' ',/extract)
      nsegs = n_elements(segs)
      for i=1,n_elements(datlines)-1 do begin
        segs = strsplit(s[datlines[i]],' ',/extract)
        ;print,i,datlines[i],n_elements(segs),nsegs
        if n_elements(segs) ne nsegs then begin
          ;print,i,nsegs,n_elements(segs)
          retval = 0
          break
        endif 
      endfor;i
    endif else begin
      retval = 0
    endelse    
  endif else begin
    retval = 0
  endelse
  return,retval

end;MACSRunner_v1_data::validateData
function MACSRunner_v1_data::parseDetectorEfficiencies,s
  IndexLabels = ['01','02','03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20']
  speclabels = 'SPEC'+ IndexLabels
  diffLabels = 'DIFF'+ IndexLabels
  specDetectorLabel = 'SPECDetector'
  diffDetectorLabel = 'DIFFDetector'
  spareLabel = 'SPARE'
  timeLabel = 'Time'
  monitorLabel = 'Monitor'
  
  
  retVal = {specWeights:fltarr(20)+1.0,$
            diffWeights:fltarr(20)+1.0,$
            spare:1.0,$
            time:1.0,$
            monitor:1.0,$
            specDetector:1.0,$
            diffDetector:1.0}
  
;  SPEC08=0.996664 DIFF08=1.0 
;  SPEC13=0.924309 DIFF12=1.0 
;  DIFF06=1.0 SPECDetector=1.0 
;  DIFF20=1.0 SPEC18=0.755619 
;  DIFF13=1.0 DIFF14=1.0 
;  DIFF15=1.0 DIFF16=1.0 
;  DIFF17=1.0 DIFF10=1.0 
;  DIFF11=1.0 DIFF18=1.0 
;  DIFF19=1.0 DIFF03=1.0 
;  DIFF02=1.0 DIFF01=1.0 
;  DIFF07=1.0 DIFF05=1.0 
;  DIFF04=1.0 DIFF09=1.0 
;  SPEC19=0.866581 SPARE=1.0 
;  SPEC20=0.954378 Time=1.0 
;  SPEC01=0.970934 SPEC10=0.79402 
;  SPEC11=0.955316 SPEC14=1.24542 
;  SPEC15=1.6998 SPEC16=0.973981 
;  SPEC17=0.842949 SPEC12=1.04715 
;  DIFFDetector=1.0 SPEC06=0.908471 
;  SPEC05=1.19156 SPEC04=0.947967 
;  SPEC03=0.877702 SPEC02=1.05554 
;  SPEC09=1.05641 SPEC07=0.93525 
;  Monitor=1.0 
  
  segs = strsplit(s,' ',/extract)
  for i=0,n_elements(difflabels)-1 do begin 
    wh = where(stregex(segs,difflabels[i],/fold_case,/boolean) gt 0,ct)
    if ct ne 0 then begin
      subsegs = strsplit(segs[wh],'=',/extract)
      retval.diffWeights[i] = float(subsegs[1])
    endif
  endfor;i
  for i=0,n_elements(speclabels)-1 do begin 
    wh = where(stregex(segs,speclabels[i],/fold_case,/boolean) gt 0,ct)
    if ct ne 0 then begin
      subsegs = strsplit(segs[wh],'=',/extract)
      retval.specWeights[i] = float(subsegs[1])
    endif
  endfor;i


  wh = where(stregex(segs,'SPARE',/fold_case,/boolean) gt 0,ct)
  if ct ne 0 then begin
    subsegs = strsplit(segs[wh],'=',/extract)
    retval.spare = float(subsegs[1])
  endif
  wh = where(stregex(segs,'MONITOR',/fold_case,/boolean) gt 0,ct)
  if ct ne 0 then begin
    subsegs = strsplit(segs[wh],'=',/extract)
    retval.monitor = float(subsegs[1])
  endif
  wh = where(stregex(segs,'TIME',/fold_case,/boolean) gt 0,ct)
  if ct ne 0 then begin
    subsegs = strsplit(segs[wh],'=',/extract)
    retval.time = float(subsegs[1])
  endif
  wh = where(stregex(segs,'DIFFDETECTOR',/fold_case,/boolean) gt 0,ct)
  if ct ne 0 then begin
    subsegs = strsplit(segs[wh],'=',/extract)
    retval.diffDetector = float(subsegs[1])
  endif
  wh = where(stregex(segs,'SPECDETECTOR',/fold_case,/boolean) gt 0,ct)
  if ct ne 0 then begin
    subsegs = strsplit(segs[wh],'=',/extract)
    retval.specDetector = float(subsegs[1])
  endif
  
  return,retval
end;MACSRunner_v1_data::parseDetectorEfficiencies

function MACSRunner_v1_data::init,fn,abc=abc,abg=abg,o1=o1,o2=o2,$
                                     weights=weights
                                     
  ;print,'MACSRunner_v1_data::init: '+file_basename(fn)
  abc = fltarr(3)+2*!PI
  abg = fltarr(3)+90.0
  
  self.filename = fn
  if file_test(self.filename) gt 0 then begin
    nlines = file_lines(self.filename)
    if nlines gt 1 then begin
      s = strarr(nlines)
      openr,lun,fn,/get_lun
      readf,lun,s
      free_lun,lun
      check = self->validateData(s)
      if check le 0 then begin
        void = dialog_message('MACSRunner_v1_data::init --- '+file_basename(self.filename)+' is missing columns in some rows.')
        return,0
      endif
      self.contents = ptr_new(s)
      latticeline = where(stregex(s,'#Lattice',/fold_case,/boolean),count)
      if count ne 0 then begin
        segs = strsplit(s[latticeline],/extract)
        abc = float(segs[1:3])
        abg = float(segs[4:6])
      endif
      orientline = where(stregex(s,'#Orient',/fold_case,/boolean),count)
      if count ne 0 then begin
        segs = strsplit(s[orientline],/extract)
        o1 = float(segs[1:3])
        o2 = float(segs[4:6])
      endif
      detectorEfficienciesline = where(stregex(s,'#DetectorEfficiencies',/fold_case,/boolean),count)
      if count ne 0 then begin  
        weights = self->parseDetectorEfficiencies(s[detectorEfficienciesLine])
        ;help,weights,/struct
        ;print,weights
      endif
    endif
  endif

  return,1
end;MACSRunner_v1_data::init


pro MACSRunner_v1_data__define,class

  class = {MACSRunner_v1_data,$
            filename:'',$
            contents:ptr_new()}

end;MACSRunner_v1_data__define

