; $Id$


;------------------------------------------------------------------------------------------------------------------
;
; simple routine to read and grid MACS data projected on momentum plane
;   files: array of file names to be included. It reads raw macs data
;   x0 : qx in A(-1)
;   y0 : qy in A(-1)
;   zo : intensity.
;   detector:  'diff'  for diffraction detectors. 'spec' for spectroscopic  Default value 'spec'
;   white: special value assigned to empty pixel
;   nx:number of pixels along Qx
;   ny:number of pixels along Qy
;   empty: empty scan to be substracted
;   a3 shift:  a3 shift value.
;   weights:  20x1 elements array. Detector weights. Default value: 1 for all the detectors
;   a3_mask:  2x1 elements array. a3 range to be mask.
;   a4_mask:  2x1 elements array. a4 range to be mask 
;   mask_det: 20x1 elements array. Mask detectors values:  0-mask  1-mask
;   a4_pos: 20x1 elements array a4 detector positions. default values: 8 degrees distance between detectors.
;   zoerr:  intensity error
;   nfold:  folding simmetry.
;   xabs:  all the x0 values are positive
;   yabs:  all the y0 values are positive
;   invert: The data will be plotted in the positive and negative xo and y0 values.
;-----------------------------------------------------------------------------------------------------------------
pro macs_slice3,files,emptyfile=emptyfile,xo,yo,zo,hw,avhw=avhw,white=white,nx=nx,ny=ny,$
            xran=xran,yran=yran,detector=detector,a3shift=a3shift,weights=weights,$
            specweights=specweights,diffweights=diffweights,$   ;LRK - 04/12/10  ADDING THESE KEYWORDS B/C I BELIEVE WEIGHTS
                                                                ;                ARE NOT APPLIED PROPERLY            
            a3_mask=a3_mask,a4_mask=a4_mask,mask_det=mask_det,a4_pos=a4_pos,zoerr=zoerr,n_fold=n_fold,$
            xabs=xabs,yabs=yabs,invert=invert,$
            dataObj=dataObj,emptyObj=emptyObj,$; THESE KEYWORDS WILL REPLACE THE files ARGUMENT
            spectroscopic=spectroscopic,diffraction=diffraction


;void = dialog_message('GET THE OBJECTS WORKING!!!!!!  macs_slice3')
;print,'______________________macs_slice3______________________'
;  help,dataObj
;  help,emptyObj
;  help,emptyfile
if n_elements(diffraction) eq 0 then diffraction = 0
if n_elements(spectroscopic) eq 0 then spectroscopic = 0


if n_elements(ef) ne 1 then ef=2.35
if n_elements(white) ne 1 then white=-123.79
if n_elements(file) ne 1 then file='slice.ps'
if n_elements(a3ran) ne 2 then a3ran=[-360,360]

;print,weights
d = fltarr(5000000,7)
d=d*0
point = 0
if n_elements(emptyfile) eq 1 then begin
;readmacsfile,emptyfile,emptyptr
emptyPtr = emptyObj->pullTheData('STR')

endif

for i=0,n_elements(files)-1 do begin
  ;readmacsfile,files[i],ptr
  ptr = dataObj[i]->pullTheData('STR')

  if n_elements(emptyfile) eq 1 then begin
    ;void = dialog_message('In macs_slice3: Calling macs_subtract_empty ---- CHECK THAT IT WORKS RIGHT.')
    print,'In macs_slice3: Note, only one empty allowed in macs_slice3 --- UPDATE SO THAT IT MATCHES macs_slice2'  
      
    macs_subtract_empty,ptr,emptyptr
  endif  
  macs_get_a12345_int,ptr,a1,a2,a3,a4,a5,a6,spec,diff,monitor=monitor,weights=weights,mask_det=mask_det,$
                      specweights=specweights,diffweights=diffweights,$   ;LRK - 04/12/10  ADDING THESE KEYWORDS B/C I BELIEVE WEIGHTS
                                                                          ;                ARE NOT APPLIED PROPERLY  
                      a3_mask=a3_mask,a4_mask=a4_mask,a4_pos=a4_pos
              
                 
                 
  ;di=fltarr(n_elements(a1),7)
  ;di(*,0)=a1
  ;di(*,1)=a2
  ;  di(*,2)=a3
  if n_elements(a3shift) eq 1 then begin
     di(*,2)=a3+a3shift
  endif
  
  if keyword_set(invert) then begin
       a1 = [a1,a1]
       a2 = [a2,a2]
       a3 = [a3,a3-180.]
       a4 = [a4,a4]
       a5 = [a5,a5]
       a6 = [a6,a6]
       spec = [spec,spec]
       diff = [diff,diff]
       monitor = [monitor,monitor]
    end
    
    
  di=fltarr(n_elements(a1),7)
  di(*,0)=a1
  di(*,1)=a2
    di(*,2)=a3
  
;di=fltarr(n_elements(a1),7) 
  
  di(*,3)=a4
  di(*,4)=a5
  di(*,5)=spec*1200000/monitor
  errspec=sqrt(abs(spec))
  errmon=sqrt(monitor)
  errdiff=sqrt(diff)
  ;di(*,6)=1200000*(spec/monitor)*sqrt((errmon/monitor)^2 +(errspec/spec)^2)
  ;help,monitor,errspec
  ;aa=errspec/monitor
  di(*,6)=1200000*errspec/monitor
  
  if n_elements(detector) eq 0 then begin
      detector='spec'
  endif
  
  if detector eq 'diff' then begin
      di(*,5)=diff*1200000/monitor
      ;di(*,6)=1200000*(spec/diff)*sqrt((errmon/monitor)^2+(errspec/diff)^2)
       di(*,6)=1200000/monitor*errdiff
  endif
  nnew  = long64(n_elements(di(*,0)))
  d(point:point+nnew-1,*) = di(*,*)
  point = long64(point+nnew)
end
d = d(0:point-1,*)
ndef  = fix(sqrt(point))
if n_elements(nx) ne 1 then nx=ndef
if n_elements(ny) ne 1 then ny=ndef

;------------------------------------------------
; convert to wave vector and energy transfer
;------------------------------------------------
taum    = 1.87325
ki    = taum/2./sin(d(*,1)/2.*!dtor)
kf    = taum/2./sin(d(*,4)*!dtor)
ei    = 2.072*ki^2
ef    = 2.072*kf^2
hw    = ei-ef
avhw    = total(hw)/n_elements(hw)
q   = sqrt(ki^2+kf^2-2.*ki*kf*cos(d(*,3)*!dtor))
cospsi  = (ki^2+q^2-kf^2)/2./ki/q
psi   = acos(cospsi)/!dtor
lis   = where(d(*,3) lt 0,nlis)
if nlis gt 0 then psi(lis)  = -psi(lis)
lis = where(d(*,2) ge a3ran(0) and d(*,2) le a3ran(1),nlis)
phi   = psi-(90.-d(lis,2))
qx    = q(lis)*cos(phi*!dtor)
qy    = q(lis)*sin(phi*!dtor)

if n_elements(n_fold) eq 1 then macs_fold,qx,qy,n_fold
if keyword_set(xabs) then qx = abs(qx)
if keyword_set(yabs) then qy = abs(qy)



rint    = d(lis,5)
zoerr= d(lis,6)
xo=qx
yo=qy
zo=rint
;----------------------------
; bin it in a square grid
;----------------------------
;help,rint,qx,qy
;sqbin,qx,qy,rint,sqrt(rint),xo,yo,zo,dzo,nx=nx,ny=ny,white=white,xran=xran,yran=yran

end;macs_slice3



