; $Id$

pro MACS_grabFTPFiles,path=path,ftpURLObj=ftpURLObj,instrument=instrument,group_leader=group_leader,_Extra=extra

    catch, catchError
    if (catchError ne 0) then begin
        eTitle = 'MACS_grabFTPFiles: Error encountered'
        eMsg = 'An error or unusual condition was encountered at MACS_grabFTPFiles!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle)
        catch, /cancel
        return
    endif


  ;if n_elements(path) eq 0 then path = '.'
  if n_elements(path) eq 0 then path='C:\Documents and Settings\kneller\Desktop\Data\MACS'
  if n_elements(ftpURLObj) ne 0 and obj_valid(ftpURLObj) gt 0 then u = ftpURLObj
  if n_elements(instrument) eq 0 then instrument = ''
  if n_elements(group_leader) eq 0 then gl = 0L else gl = group_leader

  fn = Dialog_NCNRpublicData(u,$
                             group_leader=gl,$
                             count=count, $
                             title='Select '+instrument+' data:', $
                             filter=['*.ng0'])  

  if obj_valid(u) then ftpURLObj = u

;print,n_elements(fn),count
  if count gt 0 and fn[0] ne '' then begin

        odir = dialog_pickfile(title='Local directory to store these files:',/directory,path=path)
      
        
        if odir[0] ne '' then begin
          endvalues=[long(n_elements(fn))]
      ;    print,endvalues
          duh = nse_cwo_progress(labels=['File # '],$
                                 startvalues=[0L],$
                                 endvalues=endvalues,$
                                 values=[0L],$
                                 ;steps=[1L],$
                                 obj=progobj,$
                                 group_leader=gl,$
                                 /nostop)
      ;print,endvalues,odir    
      ;help,progobj
          for i=0,n_elements(fn)-1 do begin
            ofn = odir+path_sep()+file_basename(fn[i])
      ;      print,endvalues,ofn
            ;stuff = u->GetFileContent(fn[0], localfilename=ofn, /string);, buffer=b)
            stuff = u->GetFileContent(fn[0], /string)
            openw,lun,ofn,/get_lun
            printf,lun,stuff
            free_lun,lun
            progobj->step,0
          endfor;i
        endif
        obj_destroy,progobj

  endif
end;grabFTPFiles

