; opan_Temperature_widget.pro,v 1.2 2006/07/13 13:08:49 tregenna Exp $
;###############################################################################
;
; NAME:
;  IN5_opan_Temperature_widget
;
; PURPOSE:
;  This widget dialog allows the user to input the value of the temperature when this is not present in the file
; CATEGORY:
;  TOF Utilities
;
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro IN5_opan_Temperature_widget_event,event
widget_control,event.top,get_uvalue = pstate
    widget_control,(*pstate).Temperature,get_value = temp
    temp=float(temp[0])
    if temp le 0 then return
    (*pstate).temp=temp
    widget_control,event.top,/destroy
    return
    end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function IN5_opan_Temperature_widget,filename,group_leader = group_leader

if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'Enter Temperature Field',/tlb_frame_attr)
endif else begin
    tlb = widget_base(group_leader = group_leader, /col,/modal, $
        title = 'Enter Temperature Field',/tlb_frame_attr)
endelse

temp=5.0

;step=(qmax-qmin)/(nqbins)
base = widget_base(tlb,/col)

;void = widget_label(base,value = 'Current Binning')


file = cw_field(base,/row,value = string(filename),title = 'Filename',/noedit)
Temperature = cw_field(base,/row,value = '',title = 'Temperature')

acceptButton = widget_button(base,value = 'Accept')

centertlb,tlb

widget_control,tlb,/realize

state = {file:file,Temperature:Temperature,temp:temp, $
         acceptButton:acceptButton}



pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate

xmanager,'IN5_opan_Temperature_widget',tlb,event_handler = 'IN5_opan_Temperature_widget_event'

temp = (*pstate).temp
ptr_free,pstate
return,temp
end