; $ Id$
;###############################################################################
;
; NAME:
;  HFBS_HSCNREDUCE
;
; PURPOSE:
;
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; hfbs_hscnreduce.pro
;
; This reduction procedure is called from DAVE.PRO
;
; Written by R.M.Dimeo (01/14/02)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro hfbs_hscnreduce,event
widget_control,event.top,get_uvalue = pState

outPtr = hfbs_hscn(group_leader = event.top)
nfiles = n_elements(*(*outPtr).outFilePtr)

if ((*outPtr).msg eq 'CANCEL') or (nfiles eq 0) then return
files = *(*outPtr).outFilePtr
ptr_free,(*outPtr).outFilePtr
ptr_free,outPtr

thisPtr = hfbs_showDave(group_leader = event.top,files)
widget_control,event.top,set_uvalue = pState
return
end