; $Id: triangle_cam_funq.pro,v 1.3 2005/02/09 16:58:01 dimeo Exp $
;###############################################################################
;
; NAME:
;  TRIANGLE_CAM_FUNQ
;
; PURPOSE:
;  Triangle cam function implementation for the time-to-energy conversion
;  for the HFBS data.
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function triangle_cam_funQ,npts,f
  ; Function returns the monochromator velocity profile over
  ; one period of oscillation of the monochromator (half
  ; period of the cam rotation).
  ;
  pi = !pi
  thetalo = 0.0 & thetahi = 1.0*pi
  dtheta = (thetahi-thetalo)/(npts-1)
  theta = Fltarr(npts)
  theta = thetalo+dtheta*Findgen(npts)
  region1 = Where(theta lt 3.0*pi/16.0,n1)
  region2 = Where(theta ge 3.0*pi/16.0 and theta lt 5.0*pi/16.0,n2)
  region3 = Where(theta ge 5.0*pi/16.0 and theta lt 0.5*pi,n3)
  a = 0.09*256.0/(15.0*pi^2+8.0)
  s1 = Fltarr(npts) & s2 = Fltarr(npts) & s3 = Fltarr(npts)
  a1 = Fltarr(npts) & a2 = Fltarr(npts) & a3 = Fltarr(npts)
  a1 = a & a2 = a*Cos(8.*(theta-3.*!pi/16.))
  a3 = -a
  s1 = 0.5*a*theta^2
  s2 = a*(-(1.0/64.)*Cos(8.*(theta-3.0*!pi/16.))+3.0*!pi/16.*theta+1./64.-9.*!pi^2/512)
  s3 = a*(-0.5*theta^2+0.5*!pi*theta+1./32.-17.*!pi^2/256.)
  v1 = Fltarr(npts)
  v1 = a*theta
  v2 = Fltarr(npts)
  v2 = a*((1.0/8.0)*Sin(8.0*(theta-3.0*pi/16.0))+3.0*pi/16.0)
  v3 = Fltarr(npts)
  v3 = a*(0.5*pi-theta)

  newpts = n1+n2+n3
  v = Fltarr(newpts) & v = [v1[region1],v2[region2],v3[region3]]
  s = Fltarr(newpts) & s = [s1[region1],s2[region2],s3[region3]]
  acc = Fltarr(newpts) & acc = [a1[region1],a2[region2],a3[region3]]
  finalpts = 4*newpts
  vnew = Fltarr(finalpts) & snew = Fltarr(finalpts) & anew = Fltarr(finalpts)
  snew = [s[0:newpts-1],Max(s[0:newpts-1])-s[0:newpts-1],s[0:newpts-1],Max(s[0:newpts-1])-s[0:newpts-1]]
  vnew = [v[0:newpts-1],-v[0:newpts-1],v[0:newpts-1],-v[0:newpts-1]]
  anew = [acc[0:newpts-1],-acc[0:newpts-1],acc[0:newpts-1],-acc[0:newpts-1]]
  snew = Shift(snew,-Fix(0.25*finalpts))
  vnew = Shift(vnew,-Fix(0.25*finalpts))
  anew = Shift(anew,-Fix(0.25*finalpts))

  ango = 0.0 & anghi = 1.0*pi
  dang = (anghi-ango)/(4*npts-1)
  ang = Fltarr(4*npts)
  ang = ango+dang*Findgen(4*npts)

  ango1 = 0.0 & anghi1 = 2.0*pi
  dang1 = (anghi1-ango1)/(finalpts-1)
  ang1 = Fltarr(finalpts)
  ang1 = ango1+dang1*Findgen(finalpts)

  sout = Fltarr(npts)
  sout = Interpol(snew,ang1,ang)
  aout = Fltarr(npts)
  aout = Interpol(anew,ang1,ang)
  yout = Fltarr(npts)
  yout = Interpol(vnew,ang1,ang)

  yout = pi*f*yout
  youtnew = Fltarr(npts)
  youtnew = Congrid(yout,npts)
  soutnew = Congrid(sout,npts)
  aoutnew = Fltarr(npts)
  aoutnew = (!pi*f)^2*Congrid(aout,npts)

  ;plot,aoutnew
  ;oplot,youtnew,linestyle=3

  data = Fltarr(2,npts)
  t = Fltarr(npts)
  tlo = 0.0 & thi = 1.0/f
  dt = (thi-tlo)/(npts-1)
  t = tlo+dt*Findgen(npts)
  k1 = 5.22707e-3 & k2 = 1261.64 & vb = k2*0.5
  dsad = 4.12 & dms = 2.25
  e = Fltarr(npts) & efrench = Fltarr(npts)
  td = Fltarr(npts) & tfrench = Fltarr(npts)
  td = t+(dsad/vb)+(dms+soutnew)/(vb+youtnew)
  tfrench = t + ((dsad+dms)/vb)
  efrench = k1*(k2*youtnew+youtnew^2)
  e = Interpol(efrench,td,tfrench)
  ;plot,tfrench,e,psym=0;,xrange=[0.02,0.03],yrange=[-2.,2.]
  ;oplot,tfrench,efrench,linestyle=3

  data[0,0:npts-1] = t[0:npts-1]
  data[1,0:npts-1] = Shift(youtnew[0:npts-1],-Fix(0.25*npts))
  Return,data
end