; $Id$
;###############################################################################
;
;FILENAME:
;directory_hfbs_summary.pro
;
;PURPOSE:
;           Summarize contents of and HFBS directory.
;CATEGORY:
;
; AUTHOR:
; Antonio L. Faraone
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; afaraone@nist.gov  301-975-5254
; Jul 19,2007
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
;
pro directory_hfbs_summary_cleanup,id


    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'directory_hfbs_summary_cleanup: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif

    widget_control,id,get_uvalue=pstate

    if (*pstate).unit ne -1 then $
        free_lun,(*pstate).unit
    if ptr_valid(pstate) gt 0 then $
       ptr_free,pstate


end ; directory_hfbs_summary_cleaup

;*****

Pro directory_hfbs_summary_event,event




    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'directory_hfbs_summary_event: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif





tick=intarr(17)
ptr_addresses=ptrarr(17)

title=['Comments', $
    'User', $
    'Runmode', $
    'Start time', $
    'Stop time', $
    'No. of Cycles', $
    'Cycle time', $
    'Live time', $
    'Time bin', $
    'Ave. Doppler frequency', $
    'Doppler frequency std', $
    'Ave. white beam', $
    'White beam std', $
    'Ave. Trans. beam', $
    'Trans. beam std', $
    'Ave. T', $
    'T std']

title=transpose(title)

widget_control,event.top,get_uvalue=pstate

if event.id eq (*pstate).proceed_button then begin

	widget_control,(*pstate).comments_tick,get_value=tempvar
	tick[0]=tempvar
	widget_control,(*pstate).user_tick,get_value=tempvar
	tick[1]=tempvar
	widget_control,(*pstate).runmode_tick,get_value=tempvar
	tick[2]=tempvar
	widget_control,(*pstate).start_tick,get_value=tempvar
	tick[3]=tempvar
	widget_control,(*pstate).stop_tick,get_value=tempvar
	tick[4]=tempvar
	widget_control,(*pstate).nocycles_tick,get_value=tempvar
	tick[5]=tempvar
	widget_control,(*pstate).cycletime_tick,get_value=tempvar
	tick[6]=tempvar
	widget_control,(*pstate).livetime_tick,get_value=tempvar
	tick[7]=tempvar
	widget_control,(*pstate).timebin_tick,get_value=tempvar
	tick[8]=tempvar
	widget_control,(*pstate).doppl_tick,get_value=tempvar
	tick[9]=tempvar
	widget_control,(*pstate).dopplstd_tick,get_value=tempvar
	tick[10]=tempvar
	widget_control,(*pstate).white_tick,get_value=tempvar
	tick[11]=tempvar
	widget_control,(*pstate).whitestd_tick,get_value=tempvar
	tick[12]=tempvar
	widget_control,(*pstate).trans_tick,get_value=tempvar
	tick[13]=tempvar
	widget_control,(*pstate).transstd_tick,get_value=tempvar
	tick[14]=tempvar
	widget_control,(*pstate).T_tick,get_value=tempvar
	tick[15]=tempvar
	widget_control,(*pstate).Tstd_tick,get_value=tempvar
	tick[16]=tempvar

  dataDir = (*pstate).dataDir
  workDir = (*pstate).workDir
	widget_control,(*pstate).tlb,/destroy

	pathdir=dialog_pickfile(/directory,title='Select a data directory',path=dataDir)


	pathdirlength=strlen(pathdir)

	;ADD A PATH SEPARATOR
	hfbsfiles=file_search(pathdir+path_sep()+'*.hfbs')


;	help,hfbsfiles


	;REMOVE THE DIRECTORY BY USING file_basename()
	shorthfbsfiles=file_basename(hfbsfiles);strmid(hfbsfiles,pathdirlength)

    if (pathdir eq '') or (hfbsfiles[0] eq '') then begin
       void = dialog_message('No .hfbs files there.')
    endif else begin
		device,get_screen_size=screen_size
		temp_tlb=widget_base(/col)
		temp_message=widget_label(temp_tlb,value='Please, wait...')
		geom=widget_info(temp_tlb,/geometry)
		widget_control,temp_tlb,xoff= (screen_size[0]/2)-(geom.scr_xsize/2), $
		yoff= (screen_size[1]/2)-(geom.scr_ysize/2)
		widget_control,temp_tlb,/realize

		hfbsfilesno=n_elements(hfbsfiles)
		comments=strarr(hfbsfilesno)
		user=strarr(hfbsfilesno)
		runmode=strarr(hfbsfilesno)
		start=strarr(hfbsfilesno)
		stop=strarr(hfbsfilesno)
		no_cycles=strarr(hfbsfilesno)
		cycletime=strarr(hfbsfilesno)
		livetime=strarr(hfbsfilesno)
		timebin=strarr(hfbsfilesno)
		dopp_avg=strarr(hfbsfilesno)
		dopp_var=strarr(hfbsfilesno)
		white_avg=strarr(hfbsfilesno)
		white_var=strarr(hfbsfilesno)
		trans_avg=strarr(hfbsfilesno)
		trans_var=strarr(hfbsfilesno)
		T_avg=strarr(hfbsfilesno)
		T_var=strarr(hfbsfilesno)
		dummy=strarr(hfbsfilesno)
		dummy1=strarr(hfbsfilesno)
		dummy(*)='                                                                                                             '
		dummy1(*)='   '

		for i=0,hfbsfilesno-1 do begin
			openr,unit,hfbsfiles[i],/get_lun
			lines=strarr(6)
			readf,unit,lines
			free_lun,unit

			num_cycles=float(strmid(lines[5],21,strlen(lines[5])-21))
			lines=strarr((((1-num_cycles+abs(1-num_cycles))/2+num_cycles+1)+1)*4+9)
			openr,unit,hfbsfiles[i],/get_lun
			readf,unit,lines
			free_lun,unit

			comments[i]=strtrim(strmid(lines[0],21,strlen(lines[0])-21),2)
			user[i]=strtrim(strmid(lines[1],21,strlen(lines[1])-21),2)
			runmode[i]=strtrim(strmid(lines[2],21,strlen(lines[2])-21),2)
			start[i]=strtrim(strmid(lines[3],21,strlen(lines[3])-21),2)
			stop[i]=strtrim(strmid(lines[4],21,strlen(lines[4])-21),2)
			no_cycles[i]=strtrim(string(float(strmid(lines[5],21,strlen(lines[5])-21))),2)
			cycletime[i]=strtrim(string(float(strmid(lines[6],21,strlen(lines[6])-21))),2)
			livetime[i]=strtrim(string(float(strmid(lines[7],21,strlen(lines[7])-21))),2)
			timebin[i]=strtrim(string(float(strmid(lines[8],21,strlen(lines[8])-21))),2)


			dopp_pos_1=where(strmatch(lines,'#Log Doppler Freq*'))
			white_pos_1=where(strmatch(lines,'#Log White beam*'))

			norm=white_pos_1-dopp_pos_1-1

			dopp_avg[i]=strtrim(string(total(float(lines(dopp_pos_1+1:dopp_pos_1+norm)))/norm),2)
			dopp_var[i]=strtrim(string(sqrt(total((float(lines(dopp_pos_1+1:dopp_pos_1+norm))-dopp_avg[i])^2)/norm)),2)

			white_avg[i]=strtrim(string(total(float(lines(white_pos_1+1:white_pos_1+norm)))/norm),2)
			white_var[i]=strtrim(string(sqrt(total((float(lines(white_pos_1+1:white_pos_1+norm))-white_avg[i])^2)/norm)),2)

			trans_pos_1=where(strmatch(lines,'#Log Trans beam*'))
			trans_avg[i]=strtrim(string(total(float(lines(trans_pos_1+1:trans_pos_1+norm)))/norm),2)
			trans_var[i]=strtrim(string(sqrt(total((float(lines(trans_pos_1+1:trans_pos_1+norm))-trans_avg[i])^2)/norm)),2)

			temp_pos_1=where(strmatch(lines,'#Log Sample temp*'))
			T_avg[i]=strtrim(string(total(float(lines(temp_pos_1+1:temp_pos_1+norm)))/norm),2)
			T_var[i]=strtrim(string(sqrt(total((float(lines(temp_pos_1+1:temp_pos_1+norm))-T_avg[i])^2)/norm)),2)

		endfor;i

		widget_control,temp_tlb,/destroy

		ptr_addresses[0]=ptr_new(comments)
		ptr_addresses[1]=ptr_new(user)
		ptr_addresses[2]=ptr_new(runmode)
		ptr_addresses[3]=ptr_new(start)
		ptr_addresses[4]=ptr_new(stop)
		ptr_addresses[5]=ptr_new(no_cycles)
		ptr_addresses[6]=ptr_new(cycletime)
		ptr_addresses[7]=ptr_new(livetime)
		ptr_addresses[8]=ptr_new(timebin)
		ptr_addresses[9]=ptr_new(dopp_avg)
		ptr_addresses[10]=ptr_new(dopp_var)
		ptr_addresses[11]=ptr_new(white_avg)
		ptr_addresses[12]=ptr_new(white_var)
		ptr_addresses[13]=ptr_new(trans_avg)
		ptr_addresses[14]=ptr_new(trans_var)
		ptr_addresses[15]=ptr_new(T_avg)
		ptr_addresses[16]=ptr_new(T_var)

		titletofile=['Filename        ']
		datatofile=[transpose(shorthfbsfiles)]

		for j=0,16 do begin

			max_str=max([max(strlen(*(ptr_addresses[j]))),strlen(title[j])])
			if tick[j] eq 1 then begin
				datatofile=[datatofile,transpose(dummy1)+transpose(*(ptr_addresses[j]))+ $
				    transpose(strmid(dummy,0,transpose(max_str-strlen(*(ptr_addresses[j])))))]
				titletofile=titletofile+'   '+title[j]+strmid(dummy[0],0,max_str-strlen(title[j]))
			endif

		;       print,[strlen(transpose(*(ptr_addresses[j]))+transpose(strmid(dummy,0,max_str-strlen(*(ptr_addresses[j]))))), $
		;         strlen(transpose(*(ptr_addresses[j]))), $
		;         strlen(strmid(dummy,0,max_str-strlen(*(ptr_addresses[j]))))]

		;    print,strlen(transpose(strmid(dummy,0,transpose(max_str-strlen(*(ptr_addresses[j]))))))

		endfor;j



		;LRK 10/03/07
		;I MOVED THIS INSIDE THE else STATEMENT
		;THERE SEEMS TO BE NO REASON TO EXECUTE THIS UNLESS THERE ARE ACTUALLY FILES AVAILABLE.
		filename=dialog_pickfile(title='Save File',/write,path=workDir)

		if filename ne '' then begin
			openw,unit,filename,/get_lun
			format_str='('+strtrim(string(floor(total(tick)+1)),2)+'a)'
			printf,unit,titletofile,format=format_str
			printf,unit,datatofile,format=format_str
			free_lun,unit
		endif


	endelse


  endif;event.id

end;directory_hfbs_summary_event

; ***

Pro directory_hfbs_summary,group_leader=group_leader,workDir=workDir,dataDir=dataDir,_Extra=extra

	device,get_screen_size=screen_size


	if n_elements(group_leader) eq 0 then group_leader = 0L
  if n_elements(dataDir) eq 0 then dataDir = '.'
  if n_elements(workDir) eq 0 then workDir = '.'
  
	tlb=widget_base(/col,group_leader = group_leader,title='HFBS Summary Startup:')
	;geom=widget_info(tlb,/geometry)
	;widget_control,tlb,xoff= (screen_size[0]/2)-(geom.scr_xsize/2), $
	;    yoff= (screen_size[1]/2)-(geom.scr_ysize/2)

	comments_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	comments_label=widget_label(comments_base,xsize=screen_size[0]*0.10,value='Comments',/align_left)
	comments_tick=cw_bgroup(comments_base,'include ',/nonexclusive,set_value=1)

	user_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	user_label=widget_label(user_base,xsize=screen_size[0]*0.10,value='User',/align_left)
	user_tick=cw_bgroup(user_base,'include ',/nonexclusive,set_value=1)

	runmode_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	runmode_label=widget_label(runmode_base,xsize=screen_size[0]*0.10,value='Run mode',/align_left)
	runmode_tick=cw_bgroup(runmode_base,'include ',/nonexclusive)

	start_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	start_label=widget_label(start_base,xsize=screen_size[0]*0.10,value='Start time',/align_left)
	start_tick=cw_bgroup(start_base,'include ',/nonexclusive)

	stop_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	stop_label=widget_label(stop_base,xsize=screen_size[0]*0.10,value='Stop time',/align_left)
	stop_tick=cw_bgroup(stop_base,'include ',/nonexclusive)

	nocycles_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	nocycles_label=widget_label(nocycles_base,xsize=screen_size[0]*0.10,value='No of cycles',/align_left)
	nocycles_tick=cw_bgroup(nocycles_base,'include ',/nonexclusive)

	cycletime_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	cycletime_label=widget_label(cycletime_base,xsize=screen_size[0]*0.10,value='Cycle time',/align_left)
	cycletime_tick=cw_bgroup(cycletime_base,'include ',/nonexclusive)

	livetime_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	livetime_label=widget_label(livetime_base,xsize=screen_size[0]*0.10,value='Live time',/align_left)
	livetime_tick=cw_bgroup(livetime_base,'include ',/nonexclusive)

	timebin_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	timebin_label=widget_label(timebin_base,xsize=screen_size[0]*0.10,value='Time bin (usec)',/align_left)
	timebin_tick=cw_bgroup(timebin_base,'include ',/nonexclusive)

	doppl_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	doppl_label=widget_label(doppl_base,xsize=screen_size[0]*0.10,value='Average doppler speed',/align_left)
	doppl_tick=cw_bgroup(doppl_base,'include ',/nonexclusive)

	dopplstd_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	dopplstd_label=widget_label(dopplstd_base,xsize=screen_size[0]*0.10,value='Doppler speed std',/align_left)
	dopplstd_tick=cw_bgroup(dopplstd_base,'include ',/nonexclusive)

	white_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	white_label=widget_label(white_base,xsize=screen_size[0]*0.10,value='White monitor',/align_left)
	white_tick=cw_bgroup(white_base,'include ',/nonexclusive)

	whitestd_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	whitestd_label=widget_label(whitestd_base,xsize=screen_size[0]*0.10,value='White monitor std',/align_left)
	whitestd_tick=cw_bgroup(whitestd_base,'include ',/nonexclusive)

	trans_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	trans_label=widget_label(trans_base,xsize=screen_size[0]*0.10,value='Trans monitor',/align_left)
	trans_tick=cw_bgroup(trans_base,'include ',/nonexclusive)

	transstd_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	transstd_label=widget_label(transstd_base,xsize=screen_size[0]*0.10,value='Trans monitor std',/align_left)
	transstd_tick=cw_bgroup(transstd_base,'include ',/nonexclusive)

	T_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	T_label=widget_label(T_base,xsize=screen_size[0]*0.10,value='T avg',/align_left)
	T_tick=cw_bgroup(T_base,'include ',/nonexclusive)

	Tstd_base=widget_base(tlb,ysize=screen_size[1]*0.03,/base_align_center,/row)
	Tstd_label=widget_label(Tstd_base,xsize=screen_size[0]*0.10,value='T std',/align_left)
	Tstd_tick=cw_bgroup(Tstd_base,'include ',/nonexclusive)

	proceed_button=widget_button(tlb,xsize=screen_size[0]*0.10,value='Proceed',/align_center)

	widget_control,tlb,/realize

	state={comments_tick:comments_tick, user_tick:user_tick, $
	    runmode_tick:runmode_tick, start_tick:start_tick, $
	    stop_tick:stop_tick, nocycles_tick:nocycles_tick, $
	    cycletime_tick:cycletime_tick, livetime_tick:livetime_tick, $
	    timebin_tick:timebin_tick, doppl_tick:doppl_tick, $
	    dopplstd_tick:dopplstd_tick, white_tick:white_tick, $
	    whitestd_tick:whitestd_tick, trans_tick:trans_tick, $
	    transstd_tick:transstd_tick, T_tick:T_tick, $
	    Tstd_tick:Tstd_tick, proceed_button:proceed_button, tlb:tlb, unit:-1L,$
	    workDir:workDir,dataDir:dataDir}


	pstate=ptr_new(state)

	widget_control,tlb,/realize

	widget_control,tlb,set_uvalue=pstate

	xmanager,'directory_hfbs_summary',tlb,/no_block,cleanup='directory_hfbs_summary_cleanup'

end;directory_hfbs_summary

