; $ Id: $
;
;
;THIS FUNCTION CREATES THE VERTICES NECESSARY TO CREATE A VOLUME OUTLINE POLYGON
;FOR ThreeDenPro
;
;
function ThreeDenPro_createVolVertices,abc,abg,nx,ny,nz,corners=corners,$
                                       xset=xset,yset=yset,zset=zset,$
                                       _Extra=extra

    if n_elements(nx) eq 0 then begin
      nx = 1
      xarr = findgen(2)
    endif else begin
      ;CREATE EDGES OF THE BOX
      xarr = findgen(nx+1)/float(nx-1)
    endelse
 
    if n_elements(ny) eq 0 then begin
      ny = 1
      yarr = findgen(2)
    endif else begin
      ;CREATE EDGES OF THE BOX
      yarr = findgen(ny+1)/float(ny-1)
    endelse
 
    if n_elements(nz) eq 0 then begin
      nz = 1
      zarr = findgen(2)
    endif else begin
      ;CREATE EDGES OF THE BOX
      zarr = findgen(nz+1)/float(nz-1)
    endelse

    ;BOTTOM EDGES
    side01 = fltarr(3,nx+1)
    side02 = fltarr(3,ny+1)
    side03 = fltarr(3,nx+1)
    side04 = fltarr(3,ny+1)

    side01[0,*] = xarr

    side02[1,*] = yarr
    side02[0,*] = max(xarr)

    side03[1,*] = max(yarr)
    side03[0,*] = xarr

    side04[1,*] = yarr


    ;CONNECTOR EDGE
    side05 = fltarr(3,nz+1)
    side05[2,*] = zarr


    ;TOP
    side06 = fltarr(3,nx+1)
    side06[2,*] = max(zarr)
    side06[0,*] = xarr

    side07 = fltarr(3,ny+1)
    side07[2,*] = max(zarr)
    side07[1,*] = yarr
    side07[0,*] = max(xarr)

    side08 = fltarr(3,nx+1)
    side08[2,*] = max(zarr)
    side08[1,*] = max(yarr)
    side08[0,*] = xarr

    side09 = fltarr(3,ny+1)
    side09[2,*] = max(zarr)
    side09[1,*] = yarr


    ;OTHER CONNECTOR EDGES
    side10 = fltarr(3,nz+1)
    side10[2,*] = zarr
    side10[0,*] = max(xarr)

    side11 = fltarr(3,nz+1)
    side11[2,*] = zarr
    side11[1,*] = max(yarr)
    side11[0,*] = max(xarr)

    side12 = fltarr(3,nz+1)
    side12[2,*] = zarr
    side12[1,*] = max(yarr)


    ;CONVERT EDGE COORDINATES INTO THE DATA SPACE
    for i=0,nx do begin
      side01[*,i] = readgrid_convert_coords(side01[*,i],abc,abg)
      side03[*,i] = readgrid_convert_coords(side03[*,i],abc,abg)
      side06[*,i] = readgrid_convert_coords(side06[*,i],abc,abg)
      side08[*,i] = readgrid_convert_coords(side08[*,i],abc,abg)
    endfor;i
    xset = side01
    for i=0,ny do begin
      side02[*,i] = readgrid_convert_coords(side02[*,i],abc,abg)
      side04[*,i] = readgrid_convert_coords(side04[*,i],abc,abg)
      side07[*,i] = readgrid_convert_coords(side07[*,i],abc,abg)
      side09[*,i] = readgrid_convert_coords(side09[*,i],abc,abg)
    endfor;i
    yset = side04
    for i=0,nz do begin
      side05[*,i] = readgrid_convert_coords(side05[*,i],abc,abg)
      side10[*,i] = readgrid_convert_coords(side10[*,i],abc,abg)
      side11[*,i] = readgrid_convert_coords(side11[*,i],abc,abg)
      side12[*,i] = readgrid_convert_coords(side12[*,i],abc,abg)
    endfor;i
    zset = side05

    ;TO CREATE COORDS FOR ALL DATA IN THE VOLUME I WOULD NEED TO
    ;CREATE A 4D ARRAY, dblarr(3,NX,NY,NZ)

    cverts = dblarr(3,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz+nx+nx+ny+nz+ny+nz+1)
    cverts[*,0:nx] = side01
    cverts[*,nx:nx+ny] = side02

    for i=0,nx do begin
      cverts[*,nx+ny+i] = side03[*,nx-i]
    endfor;i

    for i=0,ny do begin
      cverts[*,nx+ny+nx+i] = side04[*,ny-i]
    endfor;i

    cverts[*,nx+ny+nx+ny:nx+ny+nx+ny+nz] = side05
    cverts[*,nx+ny+nx+ny+nz:nx+ny+nx+ny+nz+nx] = side06
    cverts[*,nx+ny+nx+ny+nz+nx:nx+ny+nx+ny+nz+nx+ny] = side07

    for i=0,nx do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+i] = side08[*,nx-i]
    endfor;i

    for i=0,ny do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+i] = side09[*,ny-i]
    endfor;i

    for i=0,nz do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+i] = side05[*,nz-i]
    endfor;i

    ;NOW I AM BACK AT THE STARTING POINT.
    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz: $
           nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx] = side01
    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz] = side10
    for i=0,nx do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+i] = side06[*,nx-i]
    endfor;i
    for i=0,nz do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+i] = side05[*,nz-i]
    endfor;i

    ;NOW I AM BACK AT THE STARTING POINT AGAIN.
    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz] = side05
    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz: $
           nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny] = side09
    for i=0,nz do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+i] = side12[*,nz-i]
    endfor;i
    for i=0,ny do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+i] = side04[*,ny-i]
    endfor;i


    ;CONNECT
    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx] = $
          side01


    ;BACK RIGHT FACE
    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny] = $
          side02

    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz] = $
          side11

    for i=0,ny do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+i] =  $
          side07[*,ny-i]
    endfor;i
    for i=0,nz do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+i] =  $
          side10[*,nz-i]
    endfor;i


    ;CONNECT
    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny] = $
          side02


    ;BACK LEFT FACE
    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz] = $
          side11

    for i=0,nx do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+i] = $
          side08[*,nx-i]
    endfor;i

    for i=0,nz do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+i] = $
          side12[*,nz-i]
    endfor;i

    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz+nx] = $
          side03


    ;CONNECT
    for i=0,nx do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz+nx+i] = $
          side03[*,nx-i]
    endfor;i

    ;FRONT LEFT FACE
    for i=0,ny do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz+nx+nx+i] = $
          side04[*,ny-i]
    endfor;i

    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz+nx+nx+ny: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz+nx+nx+ny+nz] = $
          side05

    cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz+nx+nx+ny+nz: $
         nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz+nx+nx+ny+nz+ny] = $
          side09

    for i=0,nz do begin
      cverts[*,nx+ny+nx+ny+nz+nx+ny+nx+ny+nz+nx+nz+nx+nz+nz+ny+nz+ny+nx+ny+nz+ny+nz+ny+nz+nx+nz+nx+nx+ny+nz+ny+i] = $
            side12[*,nz-i]
    endfor;i


    corners = fltarr(3,8)
    corners[*,0] = side01[*,0]
    corners[*,1] = side01[*,nx]
    corners[*,2] = side02[*,ny]
    corners[*,3] = side03[*,0]
    corners[*,4] = side05[*,nz]
    corners[*,5] = side06[*,nx]
    corners[*,6] = side07[*,ny]
    corners[*,7] = side08[*,0]


    return,cverts
end;ThreeDenPro_createVolVertices
