; $Id$
;
;This reads information about van der Waals radii from a data
;file and uses the information in the list to create the 
;orbs that form the molecule.
;
;The orbs are returned in the container via the argument.
;If the model does not exist, create it.
    
pro threeDenPro_createSpaceFillBalls,spacefillmodel,list,datapath=datapath    
    if n_elements(spacefillmodel) eq 0 then $
        spacefillmodel = obj_new('idlgrmodel',name='spacefillmodel')
;print,'!**!!**!*!*!*!*!**!**!*!**!*!*!*!*!*!*'
;    help,list
;    help,spacefillmodel
;print,'!**!!**!*!*!*!*!**!**!*!**!*!*!*!*!*!*'
  
    vdwOrb = objarr(n_elements(list))

    ;GET van der Waals RADII INFORMATION
    vdWfn = 'C:\Documents and Settings\kneller\Desktop\GRID\VanDerWaalsRadii.dat'
    
    vdWfn = 'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\VanDerWaalsRadii.dat'

    if file_test(vdWfn) ne 1 then begin
      vdWfn = dialog_pickfile(path = dataPath,filter='*.dat',title='Get van der Waals .dat file.')
      if vdWfn eq '' then return
      datapath = file_dirname(vdWfn)
    endif;vdWfn
    nlines = file_lines(vdWfn)
    vdw = strarr(nlines-2)
    openr,lun,vdWfn,/get_lun
    dum = ''
    readf,lun,dum
    readf,lun,dum
    readf,lun,vdw
    free_lun,lun
    vdwElements = strarr(nlines-2)
    vdwRadii = dblarr(nlines-2)
    for i=0,nlines-1-2 do begin
      segs = strsplit(vdw[i],/extract)
      vdwelements[i] = segs[1]
      vdwradii[i]  = double(segs[n_elements(segs)-1])
    endfor;i

    for i=0,n_elements(vdWOrb)-1 do begin
;     orb[i] = obj_new('orb',pos=[x[i],y[i],z[i]],color = cifcolor(atoms[i]),radius=cifradius(atoms[i]))

      whatom = where(strupcase(list[i]._atom_site_type_symbol) eq $
                      strupcase(vdwElements),count)
      ;print,whatom,list[i]._atom_site_label,vdwElements
      theradius = vdwradii[whatom]
      pos = [list[i].x,list[i].y,list[i].z]
      vdWOrb[i] = obj_new('orb',pos=pos,$
                                color = list[i].color,$
                                radius=theradius,$
                                hide=0,$
                                name='spacefill')
;help,vdWOrb
;print,pos

      spacefillmodel->add,vdWorb[i]
    endfor;i
    spacefillmodel->setproperty,hide=1

end;threeDenPro_createSpaceFillBalls   
