; $Id$
;

;;-------------------------------------------------------------------------
;; DenProWDTool_callback
;;
;; Purpose:
;;   Callback routine for the tool interface widget, allowing it to
;;   receive update messages from the system.
;;
;; Parameters:
;;   wBase     - Base id of this widget
;;
;;   strID     - ID of the message.
;;
;;   MessageIn - What is the message
;;
;;   userdata  - Data associated with the message
;
pro DenProWDTool_callback, wBase, strID, messageIn, userdata
    compile_opt idl2, hidden

    if (~WIDGET_INFO(wBase, /VALID)) then $
        return

    ;; Grab the state of the widget
    WIDGET_CONTROL, WIDGET_INFO(wBase, /CHILD), GET_UVALUE=pState

    case STRUPCASE(messageIn) of

    ; Check the file name changes to display
    'FILENAME': begin
        ; Use the new filename to construct the title.
        ; Remove the path.
        filename = STRSPLIT(userdata, '/\', /EXTRACT)
        filename = filename[N_ELEMENTS(filename)-1]
        ; Append the filename onto the base title.
        newTitle = (*pState).title + ' [' + filename + ']'
        WIDGET_CONTROL, wBase, TLB_SET_TITLE=newTitle
    end

    ; A panel was added to the tool. See if our size changed.
    'ADDUIPANELS': begin
        DenProWDTool_resize, pState, 0, 0
        end

    ; The show/hide was changed. See if our size changed.
    'SHOWUIPANELS': begin
        DenProWDTool_resize, pState, 0, 0
        end

    ;; Virtual dims changed
    'VIRTUAL_DIMENSIONS': begin
        ; Retrieve the original geometry (prior to the resize).
        WIDGET_CONTROL, wBase, TLB_GET_SIZE=basesize
        geom = WIDGET_INFO((*pState).wDraw, /GEOMETRY)

        ; See if the window shrank.
        dx = (userdata[0] - geom.xsize) < 0
        dy = (userdata[1] - geom.ysize) < 0

        ; No shrinkage.
        if ((dx eq 0) && (dy eq 0)) then $
            break

        DenProWDTool_resize, pState, dx, dy
        end

    ; The sensitivity is to be changed
    'SENSITIVE': begin
        WIDGET_CONTROL, wBase, SENSITIVE=userdata
    end

    ;; Canvas zoom might have added/removed scroll bars changing the
    ;; size of the top-level base
    'CANVAS_ZOOM' : begin
      ;; Reset the draw window to previous size to eliminate any
      ;; resizing due to adding/removing scroll bars
      Cw_Itwindow_Resize, (*pState).wDraw, ((*pState).drawSize)[0], $
                          ((*pState).drawSize)[1]

      ;; Retrieve and store the new top-level base size.
      if (WIDGET_INFO((*pState).wBase, /REALIZED)) then begin
        WIDGET_CONTROL, (*pState).wBase, TLB_GET_SIZE=basesize
        (*pState).basesize = basesize
      endif

    end

    else:  ; do nothing

    endcase

end;DenProWDTool_callback


;;-------------------------------------------------------------------------
;; DenProWDTool_resize
;;
;; Purpose:
;;    Called when the user has resize the TLB of this tool interface.
;;    Will recalculate the size of the major elements in the
;;    interface.
;;
;; Parameters:
;;   pState   - pointer to the state struct for this widget.
;;
;;   deltaW   - The change in the width of the interface.
;;
;;   deltaH   - The change in the height of the interface.
;
pro DenProWDTool_resize, pState, deltaW, deltaH

    compile_opt idl2, hidden

    ; Retrieve the original geometry (prior to the resize)
    ; of the draw widget.
    drawgeom = WIDGET_INFO((*pState).wDraw, /GEOMETRY)

    ; Compute the updated dimensions of the visible portion
    ; of the draw widget.
    newVisW = (drawgeom.scr_xsize + deltaW) > (*pState).minsize[0]
    newVisH = (drawgeom.scr_ysize + deltaH) > (*pState).minsize[1]

    isUpdate = WIDGET_INFO((*pState).wBase, /UPDATE)

    ; If update turned off on unix, draw window won't resize properly.
    ; So just turn off update on Windows.
    if (!version.os_family eq 'Windows') then begin
        if (isUpdate) then $
            widget_control, (*pState).wBase, UPDATE=0
    endif else begin
        ; On Unix make sure update is on.
        if (~isUpdate) then $
            widget_control, (*pState).wBase, /UPDATE
    endelse

    ; Resize the panel retrieve the size.
    cw_itpanel_resize, (*pState).wPanel, newVisH
    panelgeom = widget_info((*pState).wPanel, /geometry)

    ; Update the statusbar to be the same width as the draw + panel.
    cw_itStatusBar_Resize, (*pState).wStatus, newVisW + panelgeom.xsize

    ; Update the toolbar row to be the same width as the draw.
    WIDGET_CONTROL, (*pState).wToolbar, SCR_XSIZE=newVisW

    ; Update the draw widget dimensions and scrollbars.
    if (newVisW ne drawgeom.xsize || newVisH ne drawgeom.ysize) then begin
        CW_ITWINDOW_resize, (*pState).wDraw, newVisW, newVisH
    endif


    if (isUpdate && ~WIDGET_INFO((*pState).wBase, /UPDATE)) then $
        widget_control, (*pState).wBase, /UPDATE


    ; Retrieve and store draw widget size.
    drawgeom = WIDGET_INFO((*pState).wDraw, /GEOMETRY)
    (*pState).drawSize = [drawgeom.scr_xsize, drawgeom.scr_ysize]

    ; Retrieve and store the new top-level base size.
    if (WIDGET_INFO((*pState).wBase, /REALIZED)) then begin
        WIDGET_CONTROL, (*pState).wBase, TLB_GET_SIZE=basesize
        (*pState).basesize = basesize
    endif
end;DenProWDTool_resize



pro DenProWDTool_makeCIFLeaf,CIFFolder,oData,filename,oVis,oUC

;    print,'DenProWDTool_makeCIFLeaf'
;    oData->getProperty,name=name
;    print,name
    
    print,'DenProWDTool_makeCIFLeaf'
    
    name = file_basename(filename)
    if n_elements(oVis) eq 0 then oVis = obj_new()
    if n_elements(oUC) eq 0 then oUC = obj_new()
    if n_elements(oData) eq 0 then oData = obj_new() 

    CIFLeaf = widget_tree(CIFFolder,value=name,uname='CIF_'+name,/context_Events)
    help,oData,oVis
    widget_control,CIFLeaf,set_uvalue={oData:oData,oVis:oVis,oUC:oUC}
    print,'CIFLeaf=',CIFLeaf

end;DenProWDTool_makeCIFLeaf

pro DenProWDTool_makeGRDLeaf,GRDFolder,oData,filename,oVol,oSurf,oUC,oNegSurf=oNegSurf

    ;print,'DenProWDTool_makeGRDLeaf'

    ;oData->getProperty,name=name
    ;print,name
    name=file_basename(filename)
    if n_elements(oVol) eq 0 then oVol = obj_new()
    if n_elements(oSurf) eq 0 then oSurf = obj_new()
    if n_elements(oUC) eq 0 then oUC = obj_new()
    if n_elements(oNegSurf) eq 0 then oNegSurf = obj_new()
    if n_elements(oData) eq 0 then oData = obj_new() 

    GRDLeaf = widget_tree(GRDFolder,value=name,uname='GRD_'+name,/context_Events)
    
    help,oData,oVol,oSurf,oNegSurf
    widget_control,GRDLeaf,set_uvalue={oData:oData,oVol:oVol,oSurf:oSurf,oUC:oUC,oNegSurf:oNegSurf}

    print,'GRDLeaf=',GRDLeaf
    
    ;THE VISUALIZATION SHOULD ALSO BE STORED IN THE LEAF.  That way the visualization SHOW field can be 
    ;altered from the tree event handler.
    
    ;NOW GET THE op_AddGRD Object and run the following with the oData kwd.
    ;Op_AddGRD::DoAction, oTool,filename=filename,nodata=nodata,oData=oData    

end;DenProWDTool_makeGRDLeaf

pro DenProWDTool_addDataToTree,pState,oData,filename,oVis1,ovis2

    print,'DenProWDTool_addDataToTree'
    oTool = getDenProTool()

        ;NOW REPLACE THIS WITH A METHOD TO ADD THE DATA SOMEWHERE IN 
        ;DENPRO HANDLED BY THE TREE WIDGET.
;help,oData,filename
        
        ;NOW I NEED TO ADD THE VISUALIZATION AND PASS IT TO THE data Tree:


;THE NEXT STUFF IS PURELY FOR LEARNING.
        
;        ;FIRST GET op_addgrd OBJECT AND call
;        ;Op_AddGRD::DoAction, oTool,oData=oData,oVis=oVis
;        visids = oTool->getVisualization(/all)
;        dum = oTool->getOperations(count=opcount)
;        print,'opcount=',opcount
;  ;THESE STEPS ARE KEY TO FINDING THE OPERATION USED TO ADD THE VISUALIZATION!!!
;  ;THESE SHOULD BE DONE IN denprowdtool
;        CIFDesc = oTool->getOperations(identifier='Insert/Add Molecule')
;        CIFids = oTool->findIdentifiers('*CIF*')
;        print,transpose(CIFids)
;        GRDids = oTool->findIdentifiers('*GRD*')
;        print,transpose(GRDids)
;        CIFOpDesc = oTool->getByIdentifier('/TOOLS/DENPRO/OPERATIONS/FILE/OPEN CIF FILE')
;        CIFOp = CIFOpDesc->getObjectInstance()



        oVis = obj_new()
        





;    help,oData,filename
    ext = strupcase(nseGetExtension(filename))
;    help,ext

    if n_elements(oVis1) eq 0 then oVis1 = obj_new()
    if n_elements(oVis2) eq 0 then oVis2 = obj_new()
    if n_elements(oData) eq 0 then oData = obj_new() 

    case ext of
    'GRD':begin  
      ADDGRDID = '/TOOLS/DENPRO/OPERATIONS/INSERT/ADD GRD'

      grdaddopid = oTool->findIdentifiers('*tool*denpro*op*insert*grd*')
      help,grdaddopid
      addgrdid = grdaddopid[0]
      grdaddopdesc = oTool->getbyidentifier(addgrdid)
      grdaddop = grdaddopdesc->getObjectInstance() 


      success = grdaddop->DoAction( oTool,filename=filename,nodata=nodata,oData=oData,oVol=oVol,oSurf=oSurf,oParmSet=oParmSet,oNegSurf=oNegSurf)

;MONDAY
;************************************************************************************
  ;NOW CREATE AN INSERT UNIT CELL OPERATION
  ;IS oData Still available?????????
  
      UCaddopid = oTool->findIdentifiers('*tool*denpro*op*insert*Unit Cell*')
      help,UCaddopid
      addUCid = UCaddopid[0]
      UCaddopdesc = oTool->getbyidentifier(addUCid)
      UCaddop = UCaddopdesc->getObjectInstance() 
      help,oData,oParmSet
      success = UCaddop->DoAction( oTool,filename=filename,nodata=nodata,oData=oParmSet,oUC=oUC);oData,oUC=oUC)


      
      oVis1 = oVol
      oVis2 = oSurf
      oVis3 = oUC
      if obj_valid(oNegSurf) gt 0 then begin
        oVis4 = oNegSurf 
      endif
      ;print,'GRD success=',success
      ;print,'_________________________________________________________________________________________________________________'
      

      grdID = (*pstate).GRDFolder
      DenProWDTool_makeGRDLeaf,GRDid,oData,filename,oVol,oSurf,oUC,oNegSurf=oNegSurf




    end;GRD  
    'CIF':begin
      print,'_________________________________________________________________________________________________________________'
      ;createCIF,oData=oData,oVis=oVis

;      CIFDesc = oTool->getOperations(identifier='Insert/Add Molecule')
;      CIFOp = CIFDesc->getObjectInstance()
;      CIF->doAction,oData=oData,oVis=oVis

      moladdopid = oTool->findIdentifiers('*op*molecule*')
      moladdopdesc = oTool->getbyidentifier(moladdopid[0])
      moladdop = moladdopdesc->getObjectInstance() 
       
      success = moladdop->DoAction( oTool,filename=filename,nodata=nodata,oData=oData,oVis=oVis,oParmSet=oParmSet)
      ;print,'CIF success=',success
      ;print,'_________________________________________________________________________________________________________________'

  
      UCaddopid = oTool->findIdentifiers('*tool*denpro*op*insert*Unit Cell*')
      help,UCaddopid
      addUCid = UCaddopid[0]
      UCaddopdesc = oTool->getbyidentifier(addUCid)
      UCaddop = UCaddopdesc->getObjectInstance() 
      help,oData,oParmSet
      success = UCaddop->DoAction( oTool,filename=filename,nodata=nodata,oData=oParmSet,oUC=oUC);oData,oUC=oUC)




      CIFid = (*pstate).CIFFolder
      DenProWDTool_makeCIFLeaf,CIFid,oData,filename,oVis,oUC
    end;CIF  
    else:
    endcase

end;DenProWDTool_makeGRDLeaf




;;-------------------------------------------------------------------------
;; DenProWDTool__cleanup
;;
;; Purpose:
;;   Called when the widget is dying, allowing the state ptr to be
;;   released.
;;
;; Parameters:
;;    wChild   - The id of the widget that contains this widgets
;;               state.
;;
pro DenProWDTool_cleanup, wChild

    compile_opt hidden, idl2

    if (~WIDGET_INFO(wChild, /VALID)) then $
        return

    WIDGET_CONTROL, wChild, GET_UVALUE=pState
    if (PTR_VALID(pState)) then $
        PTR_FREE, pState

end


;;-------------------------------------------------------------------------
;; DenProWDTool_Event
;;
;; Purpose:
;;    Event handler for the tool interface IDL widget.
;;
;; Parameters:
;;    event    - The widget event to process.
;;
pro DenProWDTool_event, event
    compile_opt idl2, hidden
;help,event,/struct
@idlit_on_error2

    ;; Get our state
    wChild = WIDGET_INFO(event.handler, /CHILD)
    WIDGET_CONTROL, wChild, GET_UVALUE=pState

    case TAG_NAMES(event, /STRUCTURE_NAME) of

    ;; Kill the widget?
    'WIDGET_KILL_REQUEST': begin
        ; Let the tool know that shutdown was requested.
        ; This code must be here, and not in the _cleanup, because
        ; the tool may not actually be killed, say if the user is
        ; asked if they want to "save", and they hit "Cancel" instead.
        oTool = (*pState).oUI->GetTool()
        oShutdown = oTool->GetService("SHUTDOWN")
        void = (*pState).oUI->DoAction(oShutdown->getFullIdentifier())
    end

    ;; Focus change
    'WIDGET_KBRD_FOCUS': begin
        if (obj_valid((*pState).oUI) && event.enter) then begin
            oTool = (*pState).oUI->GetTool()
            oCurrent = oTool->GetService("SET_AS_CURRENT_TOOL")
            void = oTool->DoAction(oCurrent->GetFullIdentifier())
            ;; DONT DO THIS our tools could enter a focus loop in the
            ;; following situation:
            ;;    IDL> Iplot & iPlot
            ;; widget_control, (*pState).wDraw, /input_Focus
        endif
    end

    ;; The TLB was resized
    'WIDGET_BASE': begin
        ; Compute the size change of the base relative to
        ; its stored former size.
        WIDGET_CONTROL, event.top, TLB_GET_SIZE=newSize
        deltaW = newSize[0] - (*pState).basesize[0]
        deltaH = newSize[1] - (*pState).basesize[1]
        ; Bail if no change.
        if (deltaW eq 0 && deltaH eq 0) then $
            break
        DenProWDTool_resize, pState, deltaW, deltaH
        end
    'WIDGET_TREE_SEL':begin
        widget_control,event.id,get_value=val
        ;print,'WIDGET_TREE_SEL EVENT FROM '+val
    end;tree
    'WIDGET_CONTEXT':begin
        ;widget_control,event.id,get_value=val
        child = WIDGET_INFO(event.handler, /CHILD)
        tsel = widget_info(event.id,/tree_select)

        widget_control,tsel,get_value=val
        name = widget_info(tsel,/uname)

        widget_control,child,get_uvalue=pstate
        
        cb = (*pstate).contextBase
        CIFcb = (*pstate).CIFcontextBase
        GRDcb = (*pstate).GRDcontextBase
        tb = (*pstate).dataTree
        print,'UNAME,VAL,event.id=',name,val,tsel
        ext = strupcase(nsegetextension(val))
        case ext of
        'CIF':begin
            widget_displayContextMenu,tb,event.x,event.y,CIFcb
        end
        'GRD':begin
            widget_displayContextMenu,tb,event.x,event.y,GRDcb
        end
        
        else: 
        endcase
    end;context
    'WIDGET_BUTTON':begin
        child = WIDGET_INFO(event.handler, /CHILD)
        widget_control,child,get_uvalue=pstate

        tsel = widget_info((*pstate).datatree,/tree_select)

        widget_control,tsel,get_value=val,get_uvalue=uval
        name = widget_info(tsel,/uname)

        print,name

;      print,'TEST'
      name = widget_info(event.id,/uname)
;      print,name,event.id
      case strupcase(name) of
      'CONTEXTINTEGRATEDATA':begin
        print,'YOU SELECTED CONTEXTINTEGRATEDATA'

        help,uval,/structure
        (uval.oVol)->integrateDensity,xcen,ycen,zcen,rmin,rmax,normfactor
        print,'Integration Results=',xcen,ycen,zcen,rmin,rmax,normfactor
        
      end
      'CONTEXTADDVIS':begin
          print,'ADD VIS'
          help,uval,/struct
      end
      'CONTEXTDELETEVIS':begin
          print,'DELETE VIS'
          widget_control,tsel,/destroy
          uval.oVis->setProperty,hide=1
          oTool = (*pState).oUI->GetTool()          
          oTool->enableUpdates
          oTool->refreshCurrentWindow
      end
      'CONTEXTHIDEVIS':begin

          
          print,'TOGGLE HIDE VIS'


          tags = tag_names(uval)
;print,'tags=',tags
        if n_elements(tags) le 5L then begin
          if where(strpos(strupcase(tags),'OVIS') ne -1) ne -1 then begin
                    print,'THIS IS A CIF'
                    uval.oVis->getProperty,hide=hide
                    uval.oVis->setProperty,hide=((hide eq 1) ? 0 : 1)
                    uval.oUC->getProperty,hide=hide
                    uval.oUC->setProperty,hide=((hide eq 1) ? 0 : 1)
                    ;DUH:  I HAVE TO UPDATE THE TOOL, NOT THE VISUALIZATION!!!
                    oTool = (*pState).oUI->GetTool()          
                    oTool->enableUpdates
                    oTool->refreshCurrentWindow
                    ;help,oTool
                    ;oTool = getDenProTool()
                    ;help,oTool
          endif
          if where(strpos(strupcase(tags),'OVOL') ne -1) ne -1 then begin
                    ;print,'THIS IS A GRD!'
                    ;help,uval,/struct
                    uval.oVol->getProperty,hide=hidev
                    uval.oSurf->getProperty,hide=hides
                    uval.oUC->getProperty,hide=hideuc
                    
                    if obj_valid(uval.oNegSurf) gt 0 then uval.oNegSurf->getProperty,hide=hideneg 
                    ;print,'hidev=',hidev,((hidev eq 1) ? 0 : 1)
                    ;print,'hides=',hides,((hides eq 1) ? 0 : 1)

                    uval.oVol->setProperty,hide=((hidev eq 1) ? 0 : 1)
                    uval.oSurf->setProperty,hide=((hides eq 1) ? 0 : 1)
                    uval.oUC->setProperty,hide=((hideuc eq 1) ? 0 : 1)
                    if obj_valid(uval.oNegSurf) gt 0 then uval.oNegSurf->setProperty,hide=((hideneg eq 1) ? 0 : 1)
                    ;uval.oVis->rotate,[1,0,0],90
          
                    ;print,checkforobjinstance('idlitvisisosurface',ref=iso)
;                   print,checkforobjinstance('denprovisisosurface',ref=iso)
;                    print,'IS THIS WORKING HERE?'
;                    help,uval,/struct
;help,iso
;for i=0,n_elements(iso)-1 do begin
;  iso[i]->getproperty,name=myname
;  print,myname
;  iso[i]->setproperty,hide=1
;endfor;i
;                    iso[0]->setProperty,hide=((hidev eq 1) ? 0 : 1)
           
                    ;DUH:  I HAVE TO UPDATE THE TOOL, NOT THE VISUALIZATION!!!
                    oTool = (*pState).oUI->GetTool()
;help,otool                              
                    oTool->enableUpdates
                    oTool->refreshCurrentWindow
                    ;help,oTool
                    ;oTool = getDenProTool()
                    ;help,oTool
           endif
         endif
      end
      else:
      endcase
    end;button
    else: ; do nothing
    endcase
end;DenProWDTool_event


;;-------------------------------------------------------------------------
;; DenProWDTool
;;
;; Purpose:
;;    This is the main entry point for the iTools common IDL Widget
;;    user interface. This is passed a tool and the routine will then
;;    build a UI that contains the contents of the tool object.
;;
;; Parameters:
;;   oTool    - The tool object to use.
;;
;; Keywords:
;;    TITLE          - The title for the tool. If not provided, IDL
;;                     iTool is used.
;;
;;    LOCATION       - Where to place the new widget. X,Y
;;
;;    DIMENSIONS     - The size of the drawable.
;;
;;    VIRTUAL_DIMENSIONS - The virtual size of the drawing area
;;
;;    USER_INTERFACE - If set to an IDL variable, will return the user
;;                     interface object built during this UI
;;                     construction.
;
pro DenProWDTool, oTool, TITLE=titleIn, $
                 LOCATION=location, $
                 DIMENSIONS=dimensionsIn, $
                 VIRTUAL_DIMENSIONS=virtualDimensions, $
                 XSIZE=swallow1, $  ; should use DIMENSIONS
                 YSIZE=swallow2, $  ; should use DIMENSIONS
                 USER_INTERFACE=oUI, $  ; output keyword
                 _REF_EXTRA=_extra

    compile_opt idl2, hidden

@idlit_on_error2

    if (~OBJ_VALID(oTool)) then $
        MESSAGE, IDLitLangCatQuery('UI:InvalidTool')

    title = (N_ELEMENTS(titleIn) gt 0) ? titleIn[0] : $
      IDLitLangCatQuery('UI:wdTool:Title')

    WIDGET_CONTROL, /HOURGLASS

    ;*** Base to hold everything
    ;
    wBase = WIDGET_BASE(/COLUMN, MBAR=wMenubar, $
                        TITLE=title, $
                        /TLB_KILL_REQUEST_EVENTS, $
                        /TLB_SIZE_EVENTS, $
                        /KBRD_FOCUS_EVENTS, $
                        _EXTRA=_extra)

    ;*** Create a new UI tool object, using our iTool.
    ;
    oUI = OBJ_NEW('IDLitUI', oTool, GROUP_LEADER=wBase)


    ;***  Menubars
    ;
    wFile       = CW_ITMENU(wMenubar, oUI, 'Operations/File')
    ;wInsert     = CW_ITMENU(wMenubar, oUI, 'Operations/Edit')
    wInsert     = CW_ITMENU(wMenubar, oUI, 'Operations/Insert')
    wOperations = CW_ITMENU(wMenubar, oUI, 'Operations/Operations')
    ;wWindow     = CW_ITMENU(wMenubar, oUI, 'Operations/Window')
    swHelp       = CW_ITMENU(wMenubar, oUI, 'Operations/Help')

    ; Assume we were already at 90% at this point.
;    void = IDLitwdSplash(PERCENT=92)

    ;***  Drawing area.
    ;
    screen = GET_SCREEN_SIZE(RESOLUTION=cm_per_pixel)
    hasDimensions = (N_ELEMENTS(dimensionsIn) eq 2)
    if (~hasDimensions)then begin
        ;; Some multi monitor deployments will report a screen size
        ;; that includes all monitors, which can lead to some
        ;; interesting screen geometry. To take this into account, the
        ;; following logic is used to determine the default tool size.
        ;;  - Find the minimum dimension
        ;;  - minDim = dim/2
        ;;  - The other maxDim = minDim * 1.4
        ;;
        ;; The only possible issue with this logic would be if the
        ;; logical screen is so large that this calculation will
        ;; result in a window exceeding a screen.
        dimensions = 0.5*screen
        if(screen[0] gt screen[1])then $ ;; x larger than Y
          dimensions[0] = dimensions[1] * 1.4 $
        else $
          dimensions[1] = dimensions[0] * 1.4
    endif else $
        dimensions = dimensionsIn

    ; Make sure our dimensions are larger than the menubar.
    ; Otherwise strange things happen on Windows.
    ; We do this regardless of whether the user provided
    ; their own dimensions.
    geom = WIDGET_INFO(wMenubar, /GEOMETRY)
    minsize = [geom.scr_xsize + 10, 100]

    dimensions >= minsize


    ;***  Toolbars
    ;
    wToolbar = WIDGET_BASE(wBase, /ROW, XPAD=0, YPAD=0, SPACE=7)
    wTool1 = CW_ITTOOLBAR(wToolbar, oUI, 'Toolbar/File')
    wTool2 = CW_ITTOOLBAR(wToolbar, oUI, 'Toolbar/Edit')
    wTool3 = CW_ITTOOLBAR(wToolbar, oUI, 'Manipulators', /EXCLUSIVE)
    wTool4 = CW_ITTOOLBAR(wToolbar, oUI, 'Manipulators/View', /EXCLUSIVE)
    wTool5 = CW_ITTOOLBAR(wToolbar, oUI, 'Toolbar/View')
    wTool6 = CW_ITTOOLBAR(wToolbar, oUI, 'Manipulators/Annotation', /EXCLUSIVE)


    ; It may happen that our toolbar is just slightly larger than
    ; the specified dimensions. In this case, adjust the dimensions
    ; to fit the toolbar (unless the user has provided their
    ; own dimensions).
    if (~hasDimensions) then begin
        geom = WIDGET_INFO(wToolbar, /GEOMETRY)
        if ((geom.xsize gt dimensions[0]) && $
            (geom.xsize lt (dimensions[0] + 40))) then $
        dimensions[0] = geom.xsize
    endif

    ; Always adjust the toolbar to fit the base width.
    if (dimensions[0] lt geom.xsize) then $
        WIDGET_CONTROL, wToolbar, SCR_XSIZE=dimensions[0]

    ;***  Panel and Drawing area
    wRow = widget_base(wBase, /ROW, $
                         xpad=0, ypad=0, space=0)

    wBaseTree = widget_base(wRow, xpad=0, ypad=0, space=0)
    wBaseDraw = widget_base(wRow, xpad=0, ypad=0, space=0)
    wBasePanel  = widget_base(wRow, xpad=0, ypad=0, space=0)

    wPanel = CW_ITPANEL(wBasePanel, oUI)

    ; If the user did not explicitly provide dimensions, and
    ; the panel height is greater than the default (half-screen)
    ; height, but less than half again the default height, then
    ; adjust our default height to match the panel height (so
    ; scrollbars will not be necessary).
    if (~hasDimensions) then begin
        geom = WIDGET_INFO(wPanel, /GEOMETRY)
        if ((geom.scr_ysize gt dimensions[1]) && $
            (geom.scr_ysize lt (dimensions[1]*1.5))) then begin
            dimensions[1] = geom.scr_ysize
        endif
    endif

;    void = IDLitwdSplash(PERCENT=95)

    ;; Make our window
    if (hasDimensions && N_ELEMENTS(virtualDimensions) eq 0) then $
        virtualDimensions = dimensions



    datatree = widget_tree(wBaseTree,uname='DenProTree',value='THE TREE',/context_events)
  
    contextBase = widget_base(dataTree,/context_Menu)
    cbutton1 = widget_button(contextBase,value='Add Vis',uname='ContextAddVis')
    cbutton2 = widget_button(contextBase,value='Delete Vis',uname='ContextDeleteVis')
    cbutton3 = widget_button(contextBase,value='Toggle Hide',uname='ContextHideVis')

    GRDcontextBase = widget_base(dataTree,/context_Menu)
    cbutton0 = widget_button(GRDcontextBase,value='Integrate Data',uname='ContextIntegrateData')    
    cbutton1 = widget_button(GRDcontextBase,value='Add Vis',uname='ContextAddVis')
    cbutton2 = widget_button(GRDcontextBase,value='Delete Vis',uname='ContextDeleteVis')
    cbutton3 = widget_button(GRDcontextBase,value='Toggle Hide',uname='ContextHideVis')

    CIFcontextBase = widget_base(dataTree,/context_Menu)
    cbutton1 = widget_button(CIFcontextBase,value='Add Vis',uname='ContextAddVis')
    cbutton2 = widget_button(CIFcontextBase,value='Delete Vis',uname='ContextDeleteVis')
    cbutton3 = widget_button(CIFcontextBase,value='Toggle Hide',uname='ContextHideVis')


    mainTreeFolder = widget_tree(datatree,value='DenProDataFolder',/folder,/expanded)
    GRDFolder = widget_tree(mainTreeFolder,value='GRDFolder',/folder,/expanded)
    ;GRDLeaf = widget_tree(GRDFolder,value='GRD Leaf A',uname='GRD',uvalue=obj_new(),/context_Events)
    CIFFolder = widget_tree(mainTreeFolder,value='CIFFolder',/folder,/expanded)
    ;CIFLeaf = widget_tree(CIFFolder,value='CIF Leaf B',uname='CIF',uvalue=obj_new(),/context_Events)


    wDraw = CW_ITWINDOW(wBaseDraw, oUI, $
                        DIMENSIONS=dimensions, $
                        VIRTUAL_DIMENSIONS=virtualDimensions, $
                        _EXTRA=['RENDERER'])

    ;*** Status bar.
    ;
    wStatus = CW_itStatusBar(wBase, oUI, XSIZE=dimensions[0])

  

    ; Cache some information.
    ;
    wChild = WIDGET_INFO(wBase, /CHILD)

    if(n_elements(location) eq 0)then begin
        location = [(screen[0] - dimensions[0])/2 - 10, $
                    ((screen[1] - dimensions[1])/2 - 100) > 10]
    endif
    WIDGET_CONTROL, wBase, MAP=0, $
        TLB_SET_XOFFSET=location[0], TLB_SET_YOFFSET=location[1]


    
    ;; State structure for the widget
    State = { $
              oTool     : oTool,    $    ;oTool IS NEEDED TO ADD VISUALIZATIONS ONCE A DATA SET IS SELECTED
              oUI       : oUI,      $
              wBase      : wBase,    $
              title     : title,    $
              minsize   : minsize,  $
              basesize  : [0L, 0L], $
              wToolbar  : wToolbar, $
              wDraw     : wDraw,    $
              drawSize  : dimensions, $
              wPanel    : wPanel,   $
              wStatus   : wStatus,  $
              datatree  : datatree, $
              CIFFolder : CIFFolder,$
              GRDFolder : GRDFolder,$
              contextbase:contextbase,$
              GRDcontextbase:GRDcontextbase,$
              CIFcontextbase:CIFcontextbase $
              }
    pState = PTR_NEW(state, /NO_COPY)
    WIDGET_CONTROL, wChild, SET_UVALUE=pState

    ; Force an initial resize.
    DenProWDTool_resize, pState, 0, 0

;    void = IDLitwdSplash(PERCENT=100)

    WIDGET_CONTROL, wBase, /REALIZE

    ; Retrieve the starting dimensions and store them.
    ; Used for window resizing in event processing.
    WIDGET_CONTROL, wBase, TLB_GET_SIZE=basesize
    (*pState).basesize = basesize

    ;; Register ourself as a widget with the UI object.
    ;; Returns a string containing our identifier.
    myID = oUI->RegisterWidget(wBase, 'ToolBase', 'DenProWDTool_callback')

    ;; Register for our messages.
    oUI->AddOnNotifyObserver, myID, oTool->GetFullIdentifier()
    oSys = oTool->_GetSystem()
    ; Observe the system so that we can be desensitized when a macro is running
    oUI->AddOnNotifyObserver, myID, oSys->GetFullIdentifier()

    WIDGET_CONTROL, wChild, KILL_NOTIFY="DenProWDTool_cleanup"
    WIDGET_CONTROL, wBase, /MAP ;show the user what we have made.

    ; Start event processing for the tool.
    XMANAGER, 'DenProWDTool', wBase, /NO_BLOCK

end;DenProWDTool

