


;===============================================================================
pro DenPro, identifier=identifier, $
            group_leader=group_leader,$
            workDir=workDir,$
            dataDir=dataDir,$
            DAVETool=DAVETool,$
            _REF_EXTRA=extra

print,'DenPro:   group_leader=',group_leader

compile_opt idl2


;LRK 09/29/10
;IN IDL 7.1 itregister WAS REPLACED BY iregister FOR SOM UNKNKOWN REASON.
;COMMENT OUT THE NEXT BLOCK OF CODE AND REPLACE WITH THE BLOCK BELOW IT 
;CONTAINING THE MORE MODERN iregister USAGE.

if !version.release lt 7.1 then begin
          ;register the Tool
          itregister, 'DenPro', 'DenProTool'
          
          ;NOW REGISTER THE MAIN UI CODE:
          ITREGISTER, "DenProMain_UI", "DenProWDTool", /USER_INTERFACE
          
          ;register the main user interface widget creation routine
          ;itregister, "DenPro_UI", "wd_DenPro", /USER_INTERFACE
          
          ; register orb viz
          itregister, 'Orb', 'IDLitvisOrb', /visualization
          itregister, 'Bond', 'IDLitvisBond', /visualization
          itregister, 'DenproBond', 'DenProBond', /visualization
          
          itregister, 'UnitCellOutline', 'DenProUnitCellOutline', /visualization
          itregister, 'VisUnitCellOutline', 'DenProVisUCOutline', /visualization
          
          ;080108
          ;REGISTER THE VOLUME VISUALIZATION HERE
          ;THIS IS UNREGISTERED IN daveSetup.pro BUT IT NEEDED FOR READING GRD FILES.
          ;
          ;I SHOULD REGISTER THIS SPECIFICALLY TO THIS APPLICATION, BUT FOR NOW:
          itregister, 'Volume', 'IDLitvisVolume', /visualization
          
          ;080808
          itregister, 'DenProVolume', 'DenProVisVolume', /visualization
          itregister, 'DenProIsoSurface', 'DenProVisIsoSurface', /visualization
          
          
          
          ;;register the legend:
          ;itregister,'Legend','ITLitOrbLegend',/visualization
          ;
          ;
          ;;register the CIFReader:
          ;itregister,'CIFReader','DAVEReadCIF',/file_reader

          ;Okay, launch the Tool
          title = 'DAVE: DenPro'
          
          identifier = IDLITSYS_CREATETOOL('DenPro', name='DenPro' $
                                           ,title=title $
                                           ,USER_INTERFACE="DenProMain_UI" $
          ;                                 ,group_leader=group_leader,$
          ;                                  workDir=workDir,$
          ;                                  dataDir=dataDir,$
          ;                                  DAVETool=DAVETool $
          ;                                 ,USER_INTERFACE="DenPro_UI" $
                                          )


endif else begin
          ;LRK - 09/29/10
          
          ;register the Tool
          iregister, 'DenPro', 'DenProTool'
          
          ;NOW REGISTER THE MAIN UI CODE:
          IREGISTER, "DenProMain_UI", "DenProWDTool", /USER_INTERFACE
          
          ;register the main user interface widget creation routine
          ;iregister, "DenPro_UI", "wd_DenPro", /USER_INTERFACE
          
          ; register orb viz
          iregister, 'Orb', 'IDLitvisOrb', /visualization
          iregister, 'Bond', 'IDLitvisBond', /visualization
          iregister, 'DenproBond', 'DenProBond', /visualization
          
          iregister, 'UnitCellOutline', 'DenProUnitCellOutline', /visualization
          iregister, 'VisUnitCellOutline', 'DenProVisUCOutline', /visualization
          
          ;080108
          ;REGISTER THE VOLUME VISUALIZATION HERE
          ;THIS IS UNREGISTERED IN daveSetup.pro BUT IT NEEDED FOR READING GRD FILES.
          ;
          ;I SHOULD REGISTER THIS SPECIFICALLY TO THIS APPLICATION, BUT FOR NOW:
          iregister, 'Volume', 'IDLitvisVolume', /visualization
          
          ;080808
          iregister, 'DenProVolume', 'DenProVisVolume', /visualization
          iregister, 'DenProIsoSurface', 'DenProVisIsoSurface', /visualization
          
          
          
          ;;register the legend:
          ;iregister,'Legend','ITLitOrbLegend',/visualization
          ;
          ;
          ;;register the CIFReader:
          ;iregister,'CIFReader','DAVEReadCIF',/file_reader

          ;Okay, launch the Tool
          title = 'DAVE: DenPro'
          
          identifier = IDLITSYS_CREATETOOL('DenPro', name='DenPro' $
                                           ,window_title=title $
                                           ,USER_INTERFACE="DenProMain_UI" $
          ;                                 ,group_leader=group_leader,$
          ;                                  workDir=workDir,$
          ;                                  dataDir=dataDir,$
          ;                                  DAVETool=DAVETool $
          ;                                 ,USER_INTERFACE="DenPro_UI" $
                                          )


endelse;ge 7.1




; Get the tool instance and perform any application initializations as necessary!

oSystem = _IDLitSys_GetSystem()
;oSystem=getDaveTool()

;LRK 053008
                            ;Component, Classname
oSystem->RegisterFileReader,'Read CIF','DAVEReadCIF',icon='open'
oSystem->RegisterFileReader,'Read GRD','DAVEReadGRD',icon='open'

;070208
;THE VOLUME VISUALIZATION IS REQUIRED FOR DenPro.
;IT IS UNREGISTERED AT DAVE STARTUP.
;oSystem->RegisterVisualization, 'Volume'


oDenProTool = oSystem->getbyidentifier(identifier)

;SET UP THE UI SO IT IS AWARE OF THE DAVE group_leader
;(So if you exit DAVE 3DePro closes.)
oDenProUI = oDenProTool->getUI()
oDenProUI->getproperty,group_leader=tlb_oDenProUI
widget_control,tlb_oDenProUI,group_leader=group_leader

if (obj_valid(oDenProTool)) then begin
    ;; Initialize application state

  registeredVis = oDenProTool->GetVisualization(Identifier, /ALL, COUNT=regCount)
  for ii = 0,regCount-1 do begin
    registeredVis[ii]->getProperty,name=visname
    print,visName
  endfor;ii 

endif

oDenProTool->disableUpdates, previously_disabled=prvslyDisabled ; temporarily disable updates

t0 = systime(1,/seconds)

;LRK 053008
;TEMPORARILY DISABLE ADDING DATA.
;; Add Data
;create3DenProMoleculeHierarchy,oDenProTool,nodata=nodata
nodata = 1

print,'Total time for create3DenProMoleculeHierarchy,oDenProTool,nodata=nodata:'
print,systime(1,/seconds)-t0

if nodata eq 0 then $
  if (~prvslyDisabled) then oDenProTool->enableUpdates ; re-enable updates

end;DenPro

;
;pro createSpheres, oTool
;compile_opt idl2
;
;
;
;addOpID = 'Operations/Insert/Add Orb'
;
;
;;GET THE Add Orb DESCRIPTOR OBJECT
;opDesc = oTool->getByIdentifier(addOpID)
;if (~obj_valid(opDesc)) then return
;
;
;;GET THE Add Orb OBJECT
;oAddOp = opDesc->getObjectInstance()
;if (~obj_valid(oAddOp)) then return
;
;;GET THE CURRENT SETTING OF THE show_execution VARIABLE
;;showUiSetting WILL HOLD THE CURRENT STATE
;oAddOp->getProperty, show_execution_ui=showUiSetting
;
;;SET THE show_execution VARIABLE TO 0 SO BNO DIALOG IS DISPLAYED
;oAddOp->setProperty, show_execution_ui=0 ; switch off ui - no user interation required
;
;
;; Create a sphere
;oAddOp->setProperty, radius=0.16, color=[255,0,0],label='Na',xpos=-0.3,ypos=0.3,zpos=0.1
;
;;THE NEXT LINE CREATES THE SPHERE AND RETURNS ITS iTools IDENTIFIER IN THE DATA HIERARCHY
;void = oAddOp->doAction(oTool,identifier=id)
;
;;GET THE ACTUAL IDLitVisOrb(?) OBJECT
;sodium = oTool->getByIdentifier(id)
;
;; Create 3 additional spheres representing H2O
;oAddOp->setProperty, radius=0.14, color=[0,255,0],label='O',xpos=-0.1,ypos=0.0,zpos=-0.1
;void = oAddOp->doAction(oTool,identifier=id)
;oxy = oTool->getByIdentifier(id)
;oAddOp->setProperty, radius=0.05, color=[0,0,255],label='H1',xpos=0.2,ypos=-0.2,zpos=-0.1
;void = oAddOp->doAction(oTool,identifier=id)
;H1 = oTool->getByIdentifier(id)
;oAddOp->setProperty, radius=0.05, color=[0,0,255],label='H2',xpos=0.2,ypos=0.2,zpos=-0.1
;void = oAddOp->doAction(oTool,identifier=id)
;H2 = oTool->getByIdentifier(id)
;
;
;;SET UP THE GROUPING IN THE VISUALIZATION HIERARCHY
;; Group the spheres representing H2O together
;oxy->getProperty, _parent=oParent ; require parent of spheres to group
;
;
;;CREATE AN IDLitVisGroup THAT CAN BE AFFECTED BY A MANIPULATOR
;oGroup = obj_new('IDLitvisGroup',name='H2O',/manipulator_target)
;
;;FIRST ADD THE GROUP TO THE VISUALIZATION HIERARCHY
;oParent->add, oGroup
;
;;REMOVE THE ATOMS FROM THE HIERARCHY
;oParent->remove, [oxy,H1,H2]
;
;;PLACE THE ATOMS IN THE GROUP IN THE HIERARCHY
;oGroup->add, Oxy ; bug in IDLitvisGroup::Add prevents adding a vector of objects
;oGroup->add, H1
;oGroup->add, H2
;
;;WHAT DOES THIS DO?  UPDATE THE SELECTION TREE????
;oGroup->UpdateSelectionVisual
;
;;RESTORE THE ORIGINAL show_execution SETTING
;oAddOp->setProperty, show_execution_ui=showUiSetting ; revert to original setting
;
;end;createSpheres

;pro createGRD, oTool
;compile_opt idl2
;
;opID = 'Operations/Insert/Add GRD'
;opDesc = oTool->getByIdentifier(opID)
;if (~obj_valid(opDesc)) then return
;oOp = opDesc->getObjectInstance()
;if (~obj_valid(oOp)) then return
;oOp->setProperty, show_execution_ui=0
;void = oOp->doAction(oTool) ; adds GRD + isosurface
;
;; Retrieve isosurface and make it semi-transparent
;ids = oTool->findIdentifiers('*isosurface*',/visualization,count=cnt)
;if (cnt eq 1) then begin
;    ; expect a single isosurface!
;
;    ;THIS COULE BE DONE IN TWO STEPS
;    void = oTool->doSetProperty(ids[0],'transparency', 50) ; set transparency to 55%
;endif
;
;end;createGRD


pro createVolume, oTool
compile_opt idl2

opID = 'Operations/Insert/Add Clouds'
opDesc = oTool->getByIdentifier(opID)
if (~obj_valid(opDesc)) then return
oOp = opDesc->getObjectInstance()
if (~obj_valid(oOp)) then return
oOp->setProperty, show_execution_ui=0
void = oOp->doAction(oTool) ; adds cloud + isosurface

; Retrieve isosurface and make it semi-transparent
ids = oTool->findIdentifiers('*isosurface*',/visualization,count=cnt)
if (cnt eq 1) then begin
    ; expect a single isosurface!

    ;THIS COULE BE DONE IN TWO STEPS
    void = oTool->doSetProperty(ids[0],'transparency', 50) ; set transparency to 55%
endif

end;createVolume
