; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro DCSToolsPhases_cleanup,tlb
;************************************************************************************************
;
compile_opt strictarr
;
end


;************************************************************************************************
pro DCSToolsPhases_handler,event
;************************************************************************************************
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'DCSToolsPhases_handler: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif


widget_control,event.top,get_uvalue=state
intab=state.intab
outtab=state.outtab
reset=state.reset
done=state.done
input=state.input
input0=state.input0; save original input
message=state.message
addedt0butt=state.addedt0butt
adjust_t0=state.adjust_t0
;
id=event.id
;
if (id eq addedt0butt) then adjust_t0=event.select
;
if (id eq done) then begin
	widget_control,event.top,/destroy
	return
endif
;
if (id eq reset) then begin
	input=input0
	widget_control,intab,set_value=input0
endif
;
widget_control,intab,get_value=input
;
; Ensure that SR mode is 1 or 2. Calculate SR numerator.
srmode=input.srm>1<2
if (srmode eq 2 and input.srd gt 2) then srn=input.srd-1 else srn=1
input.srm=srmode
; This is so that the input data can be right justified, and visible.
input.wl=string(format="(f6.3)",input.wl)+"  "
input.ms=string(format="(f7.1)",input.ms)+"  "
input.rm=string(format="(i1)",input.rm)+"  "
input.srm=string(format="(i1)",input.srm)+"  "
input.srd=string(format="(i1)",input.srd)+"  "
input.sc=string(format="(i1)",input.sc)+"  "
breakpos=strpos(input.addf,"/")
if (breakpos ge 0) then begin
	addfnum=strmid(input.addf,0,breakpos)
	addfden=strmid(input.addf,breakpos+1)
	input.addf=float(addfnum)/addfden
endif
input.addf=string(format="(f6.4)",input.addf)+"  "
input.tsdm=string(format="(f7.1)",input.tsdm)+"  "
widget_control,intab,set_value=input
;
dcs_calculate_phases,input.wl,input.ms,input.rm,srn,$
	input.srd,input.sc,input.addf,input.tsdm,$
	distances,angles,speeds,phases,delays,mspeed_corr,$
	adjust_t0,addf_corr,delay0
;
output=strarr(5,8)
output[0,*]=[string(format="(f10.1)",distances),""]
output[1,*]=[string(format="(f10.1)",angles),""]
output[2,*]=[string(format="(f10.1)",speeds),""]
output[3,*]=[string(format="(f10.2)",phases),""]
output[4,*]=[string(format="(f10.2)",delays)+"  ",string(format="(f10.2)",delay0)+"  "]
widget_control,outtab,set_value=output
messages=["Corrected Master Speed = "+string(format="(f10.2)",mspeed_corr)+$
					"  ("+strcompress(round(mspeed_corr),/remove_all)+") rpm",$
				  "Corrected Added t0 frac = "+string(format="(f10.4)",addf_corr)+$
				  "  ("+strcompress(round(addf_corr*360),/remove_all)+"/360)"]
widget_control,message,set_value=messages
;
state.adjust_t0=adjust_t0
widget_control,event.top,set_uvalue=state
end


;************************************************************************************************
pro DCSToolsPhases,$
	group_leader = group_leader,$
;	notify_ids = notify_ids,$
	register_name = register_name, $
	_EXTRA=etc

;************************************************************************************************
;
compile_opt strictarr
;
;
;;;;;;;added following 4 lines for non-modal widget action
if n_elements(group_leader) eq 0 then group_leader = 0L
;if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(register_name) eq 0 then register_name = 'DCSToolsPhases'
if xregistered(register_name) then return
;
; Lines commented out.
;widget_control,group_leader,get_uvalue=statePtr
;davePtr=(*statePtr).davePtr
dcs_sysvars,davePtr=davePtr
;
; Lines commented out.
;tvlct,r,g,b,/get
;rgbptr=ptr_new({r:r,g:g,b:b})
;
input={wl:" 7.5  ",ms:" 20000  ",rm:" 1  ",srm:" 2  ",srd:" 4  ",$
	sc:" 5  ",addf:" 0.0  ",tsdm:" 500.0  "}
;
; This is so that the input data can be right justified, and visible.
input.wl=string(format="(f6.3)",input.wl)+"  "
input.ms=string(format="(f7.1)",input.ms)+"  "
input.rm=string(format="(i1)",input.rm)+"  "
input.srm=string(format="(i1)",input.srm)+"  "
input.srd=string(format="(i1)",input.srd)+"  "
input.sc=string(format="(i1)",input.sc)+"  "
input.addf=string(format="(f6.4)",input.addf)+"  "
input.tsdm=string(format="(f7.1)",input.tsdm)+"  "
;
input_names=["Wavelength","Master speed","Resn. mode","SC SR_mode","SC SR_denom",$
	"Slow Chopper","Added t0 frac","Min. T_sd"]
output_names=[string("Chopper")+strcompress(indgen(7)+1),"Reference"]
column_labels=["Distance-sample","Theta","Speed","Phase","Delay"]
output=strarr(5,8)
column_widths=[80,50,70,70,70]
;
title="Calculation of chopper phases and delays."
tlb=widget_base(title=title,/col,group_leader=group_leader)
	tables=widget_base(tlb,/row)
	buttons=widget_base(tlb,/row)
	intab=widget_table(tables,/editable,/sensitive,column_widths=[80],$
		column_labels=["Parameter"],row_labels=input_names,xsize=1,ysize=8,$
		/column_major,value=input,alignment=2)
	outtab=widget_table(tables,column_widths=column_widths,$
		column_labels=column_labels,row_labels=output_names,xsize=5,ysize=8,$
		value=output,alignment=2)
	addedt0base=widget_base(buttons,/nonexclusive)
	addedt0butt=widget_button(addedt0base,value='Adjust t0 frac')
	reset=widget_button(buttons,value="Reset")
	done=widget_button(buttons,value="Done")
	message=widget_list(buttons,ysize=2,xsize=60)
widget_control,tlb,/realize
;
; Initially permit adjustments to t0 frac.
adjust_t0=1
;
input0=input
state={intab:intab,outtab:outtab,reset:reset,done:done,$
	input:input,input0:input0,message:message,$
	addedt0butt:addedt0butt,adjust_t0:adjust_t0}
widget_control,tlb,set_uvalue=state
;
; Ensure that SR mode is 1 or 2. Calculate SR numerator.
srmode=input.srm>1<2
if (srmode eq 2 and input.srd gt 2) then srn=input.srd-1 else srn=1
input.srm=srmode
input.srm=string(format="(i1)",input.srm)+"  "
;
widget_control,addedt0butt,set_button=adjust_t0
dcs_calculate_phases,input.wl,input.ms,input.rm,srn,$
	input.srd,input.sc,input.addf,input.tsdm,$
	distances,angles,speeds,phases,delays,mspeed_corr,$
	adjust_t0,addf_corr,delay0
widget_control,intab,set_value=input
;
output=strarr(5,8)
output[0,*]=[string(format="(f10.1)",distances),""]
output[1,*]=[string(format="(f10.1)",angles),""]
output[2,*]=[string(format="(f10.1)",speeds),""]
output[3,*]=[string(format="(f10.2)",phases),""]
output[4,*]=[string(format="(f10.2)",delays)+"  ",string(format="(f10.2)",delay0)+"  "]
widget_control,outtab,set_value=output
messages=["Corrected Master Speed = "+string(format="(f10.2)",mspeed_corr)+$
					"  ("+strcompress(round(mspeed_corr),/remove_all)+") rpm",$
				  "Corrected Added t0 frac = "+string(format="(f10.4)",addf_corr)+$
				  "  ("+strcompress(round(addf_corr*360),/remove_all)+"/360)"]
widget_control,message,set_value=messages
;
; added register_name variable to the call to xmanager.
xmanager,register_name,tlb,/no_block,cleanup='DCSToolsPhases_cleanup',$
	event_handler="DCSToolsPhases_handler"
;
; Lines commented out.
;dave_makeDavePtr,davePtr=davePtr
;(*statePtr).davePtr=davePtr
;tvlct,(*rgbptr).r,(*rgbptr).g,(*rgbptr).b
;ptr_free,rgbptr
;
end
