; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_read_multiple_messages,inputfile,message_str
;************************************************************************************************
;
compile_opt strictarr
;
; This routine reads multiple multiline message texts from a single input file called
; inputfile (!). Each text is preceded by a title. Each text is formed into a single string.
; Titles and texts are stored in the string arrays message_title and message_text
; respectively.
;
on_ioerror, no_file
get_lun,unit
openr,unit,inputfile
;
; Initialization of variables.
imsg=-1
line=""
message_title=strarr(1000)
message_text=strarr(1000)
message_choices=strarr(1000)
message_def=intarr(1000)
message_can=intarr(1000)
;
; Start reading file.
while not eof(unit) do begin
	readf,unit,line
	case line of
		"TITLE": begin; read the next line which is a message title
			imsg=imsg+1
			readf,unit,line
			message_title[imsg]=line
		end
		"MESSAGE": ; do nothing
		"CHOICES": begin
			readf,unit,line
			message_choices[imsg]=line
		end
		"DEF": begin
			readf,unit,line
			message_def[imsg]=line
		end
		"CAN": begin
			readf,unit,line
			message_can[imsg]=line
		end
		"END": begin; calculate number of messages and create an output structure.
			nmsg=imsg+1
			message_str={title:message_title[0:nmsg-1],$
				text:message_text[0:nmsg-1],$
				choices:message_choices[0:nmsg-1],$
				def:message_def[0:nmsg-1],$
				can:message_can[0:nmsg-1]}
			return
		end
		else: begin ; the line is all or part of a message text
			if (strlen(message_text[imsg]) eq 0) then $
				message_text[imsg]=line else $
				message_text[imsg]=message_text[imsg]+" "+line
			end
	endcase
endwhile
;
read_err: free_lun,unit
return
;
no_file: begin
	free_lun,unit
	if (!debug) then print,"There is no file named ",inputfile
	stop,"Program terminated."
end
;
end