; $Id: dm_set_viewlabel.pro,v 1.6 2016/02/25 21:56:29 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_set_viewlabel
;
; PURPOSE:
;  construct view label
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  May, 2018
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

; label :   string
; viewaxis: three element array
; qoffset:  three element array, optional
function dm_set_viewlabel,label,viewaxis,qoffset,unit
    if total(abs(viewaxis)) eq 0 then return,label
    if n_elements(qoffset) ne 3 then qoffset = [0,0,0]
    if n_elements(unit) eq 0 then unit = ''
    qoffstr = [dm_to_string(qoffset[0]),dm_to_string(qoffset[1]),dm_to_string(qoffset[2])]
    viewlabel = '['
    viewlabel=viewlabel+(viewaxis[0] eq 0?qoffstr[0]:(abs(viewaxis[0]) eq 1?(viewaxis[0] eq 1?'':'-'):dm_to_string(viewaxis[0]))+label+((qoffset[0] ne 0)?(qoffset[0] gt 0?'+':'')+qoffstr[0]:''))+','
    viewlabel=viewlabel+(viewaxis[1] eq 0?qoffstr[1]:(abs(viewaxis[1]) eq 1?(viewaxis[1] eq 1?'':'-'):dm_to_string(viewaxis[1]))+label+((qoffset[1] ne 0)?(qoffset[1] gt 0?'+':'')+qoffstr[1]:''))+','
    viewlabel=viewlabel+(viewaxis[2] eq 0?qoffstr[2]:(abs(viewaxis[2]) eq 1?(viewaxis[2] eq 1?'':'-'):dm_to_string(viewaxis[2]))+label+((qoffset[2] ne 0)?(qoffset[2] gt 0?'+':'')+qoffstr[2]:''))+']'
    if strlen(unit) ne 0 then viewlabel = viewlabel +' ('+unit[0]+')'
    return,viewlabel
end