; $Id: dm_proj_view.pro,v 1.9 2015/09/16 17:23:05 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_proj_view
;
; PURPOSE:
;  project Q[3,ne,ndet] onto viewing axis U1[3], U2[3], U3[3]
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  August, 2015
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

function dm_proj_view,Q,U1,U2,U3,no_copy=no_copy,n_fold=n_fold,sr_type=sr_type,sr_startvec=sr_startvec,debug=debug
    if keyword_set(debug) then begin
       print,'$$proj view...'
       current=systime(/sec)
    endif
    abc = [[U1],[U2],[U3]]
    for i=0,2 do begin
        if total(abs(abc[*,i])) eq 0 then begin
           abc[*,i]=crossp(abc[*,(i+1) mod 3],abc[*,(i+2) mod 3])
           break
        endif
    endfor
    V  = dm_q2hkl(Q,abc,no_copy=no_copy,n_fold=n_fold,sr_type=sr_type,sr_startvec=sr_startvec,debug=debug)
    if keyword_set(debug) then begin
       print,'$$proj view finished in ',systime(/sec)-current,' sec.'
    endif
    return,V
end