; $Id$
;#######################################################################
;
; NAME:
;  dm_ispower2
;
; PURPOSE:
;  check if a positive integer number is power of 2
;
; CATEGORY:
;  general
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-8562
;  United States
;  yiming.qiu@nist.gov
;  Feb, 2005
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

function dm_ispower2,x
    tmp0 = abs(x)
    if tmp0 eq 0 then return,0              ;0
    tmp1 = fix(tmp0,type=15)                ;unsigned long64
    if abs(tmp0-tmp1) gt 1e-6 then return,0 ;not an integer
    tmp2 = fix(alog(tmp1)/alog(2)+0.5)
    tmp3 = (2ULL)^tmp2
    if abs(tmp1-tmp3) gt 0 then return,0    ;not a power of 2
    return,1
end