; $Id: $
;#######################################################################
;
; NAME:
;  dm_filemenu
;
; PURPOSE:
;
;
; CATEGORY:
;  dcs_mslice
;
; HISTORY:
;  02/2010: added NXSPE support - Andrei Savici (saviciat@ornl.gov)   
; 
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  June, 2025
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

pro dcs_mslice::dm_filemenu,init=init,pdt_reset=pdt_reset,keep_extravaxis=keep_extravaxis
    ftypemenu = widget_info(self.tlb,find_by_uname='ftypeMenu')
    ftoolmenu = widget_info(self.tlb,find_by_uname='ftoolMenu')
    if keyword_set(init) then begin  ;initialization
       ;instrument name or file types to be shown in the menu
       self.ftypename = ptr_new(['DCS','SPE','NXSPE','INX','MACS','WAND'])
       ;corresponding file type extensions
       self.ftypeext  = ptr_new(['DCS','SPE','NXSPE','INX','NG0,.BT9','WAND'])
       
       for i=0,n_elements(*self.ftypename)-1 do begin
           void = dm_widget_button(ftypemenu,value=(*self.ftypename)[i],uname='ftype_'+dm_to_string(i))
       endfor
    endif 
    
    if ~keyword_set(keep_extravaxis) then self.extravaxis_yn[*] = 0
    
    self.psi_spe      = 0                                           ;default detector psi definition is not SPE type
    self.psi_0only    = 0                                           ;default there are out-of-plane detectors
    self.intn_lab     = 'Intensity (arb. unit)'
    self.instrname    = strlowcase((*self.ftypename)[self.ftype])   ;lower case of the current instrment name
    *(self.rebinsize) = [1s,2s,4s,5s,8s,10s,20s,25s,40s,50s]        ;default rebin size value list
    self.ftypecheckmask[*] = 0                                      ;default flag is not checking masks
    self.zero_error[1:2] = [0.,!values.f_nan]                       ;not all instruments need to check zero error bar
    
    ;add your own credit here if you would like to
    nlin = n_elements(*self.info) 
    date = strsplit((*self.info)[nlin-1],' ',/extract) & date = date[n_elements(date)-1]
    case self.instrname of 
         'nxspe':   (*self.info)[nlin-1] = 'Yiming Qiu (yiming.qiu@nist.gov), Andrei Savici (saviciat@ornl.gov)'+'   '+date 
         else:      (*self.info)[nlin-1] = 'Yiming Qiu (yiming.qiu@nist.gov)'+'   '+date 
    endcase
   
    ;construct tool menus
    ;delete all possible menu items in ftoolMenu
    repeat begin
       tmp = widget_info(ftoolmenu,/child)
       if tmp ne 0 then widget_control, tmp,/destroy
    endrep until tmp eq 0
    
    ptr_free,self.detPosPtr
    
    ;reconstruct tool menus according to file type and preset some parameters
    ;warning: don't use a tool uname starts with 'ftype_' !!!
    self.edep_det = [1.0,6.0] ;DCS He3 detector thickness 1 cm, pressure 6 atm
    case self.instrname of  
      'dcs':begin   ;DCS file
            void = dm_widget_button(ftoolmenu,value='Plot Single Crystal Alignment Files',uname='cryst_algnBut',imagefile=self.iconfiles[2],/notchecked)
            void = dm_widget_button(ftoolmenu,value='Copy Files from NCNR Data Repository',uname='dm_copyftpBut',imagefile=self.iconfiles[3],/notchecked)
            void = widget_button(ftoolmenu,value='Convert DCS Files to SPE Files',uname='dcs_cspeBut')
            void = widget_button(ftoolmenu,value='Patch DCS Files',uname='dcs_patchBut')
            void = widget_button(ftoolmenu,value='Q and Energy Resolution Convolution',uname='dcs_convBut')
            void = widget_button(ftoolmenu,value='White Beam Transmission Calculation',uname='dcs_wbeamBut')
            void = widget_button(ftoolmenu,value='Polarization Analysis',uname='panalBut')
            self.detPosPtr  = dm_load_detpos(/dcs,adjust2th=self.tthcorr)       ;load detector position information
            self.intn_typ   = 0      ;default S(q,w) intensity type
            self.edep_yn    = 1
            self.instrgeom  = 0
            fixedgeom       = 1      ;a direct geometry instrument only
            end
      'macs':begin  ;MACS file
            void = dm_widget_button(ftoolmenu,value='Experiment Sequence Editor',uname='macs_seqBut',imagefile=self.iconfiles[4],/notchecked)
            void = dm_widget_button(ftoolmenu,value='Plot Alignment Files',uname='cryst_algnBut',imagefile=self.iconfiles[2],/notchecked)
            void = dm_widget_button(ftoolmenu,value='Copy Files from NCNR Data Repository',uname='dm_copyftpBut',imagefile=self.iconfiles[3],/notchecked)
            void = widget_button(ftoolmenu,value='Patch MACS Files',uname='macs_patchBut')
            void = widget_button(ftoolmenu,value='Polarization Analysis',uname='panalBut')
            self.edep_det   = [16.0/3/!pi*4.445/2,3.0] ;MACS He3 detector diameter 4.445 cm(1.75 inch), average thickness =16R/(3pi),  pressure=3 atm
            self.intn_typ   = n_elements(self.intn_typ_str)-1      ;default no kfactor adjustment
            self.edep_yn    = 0      ;no energy dependent detector efficiency correction
            self.eadjust    = 0      ;no elastic peak adjustment
            self.eint_yn    = 0      ;no E-integrated intensity
            self.instrgeom  = 1
            fixedgeom       = 0      ;could be 1
            self.eief       = !values.f_nan
            self.detPosPtr  = dm_load_detpos(/macs)
            self.ftoolflag[[1,3]] = 0b  ;clear flag
            self.macs_mon[0,*] = !values.f_nan
            if self.samp_typ ne 1 then self->change_samptyp,1,pdt_reset=pdt_reset
            self->script,'set_parameter',name='oriePsi',value=0.0 ;load parameter will not reset self.orie_psi to 0.0
            self.orie_psi   = 0.0
            self.psi_0only  = 1      ;no out-of-plane detector
            ptr_free,self.eff,self.ssfacPtr
            end      
      'spe':begin   ;SPE file   no tools available
            self.intn_typ   = n_elements(self.intn_typ_str)-1      ;default no kfactor adjustment
            self.edep_yn    = 0      ;no energy dependent detector efficiency correction
            fixedgeom       = 0      ;could be either direct or inverse geometry
            self.psi_spe    = 1      ;spe type detector psi definition
            self.ncnrftp    = 0
            self.ftypecheckmask[*] = 1 ;check mask
            end
      'nxspe':begin ;NXSPE file
            void = dm_widget_button(ftoolmenu,value='Save Detector Info as a PHX File...',uname='nxspe_savephxBut',imagefile=self.iconfiles[5],/notchecked)
            self.intn_typ   = n_elements(self.intn_typ_str)-1      ;default no kfactor adjustment
            self.edep_yn    = 0      ;no energy dependent detector efficiency correction
            fixedgeom       = 0      ;could be either direct or inverse geometry
            self.psi_spe    = 1      ;spe type detector psi definition
            self.ncnrftp    = 0
            self.ftypecheckmask[*] = 1 ;check mask
            end
      'inx':begin   ;INX file   no tools available
            *(self.rebinsize) = [1s,2s,4s,8s,16s,32s,64s]
            self.intn_typ   = n_elements(self.intn_typ_str)-1      ;default no kfactor adjustment
            self.edep_yn    = 0      ;no energy dependent detector efficiency correction
            fixedgeom       = 0      ;could be either direct or inverse geometry
            self.ncnrftp    = 0
            end
      'wand':begin  ;WAND file
            void = dm_widget_button(ftoolmenu,value='Plot Single Crystal Alignment Files',uname='cryst_algnBut',imagefile=self.iconfiles[2],/notchecked)
            self.intn_typ   = n_elements(self.intn_typ_str)-1      ;default no kfactor adjustment
            self.edep_yn    = 0      ;no energy dependent detector efficiency correction
            self.eadjust    = 0      ;no elastic peak adjustment
            self.eint_yn    = 0      ;no E-integrated intensity
            self.instrgeom  = 0
            fixedgeom       = 1
            self.ncnrftp    = 0      
            self.ftypecheckmask[*] = 1 ;check mask
            self.detPosPtr  = dm_load_detpos(/wand,adjust2th=self.tthcorr)
            self.e_bin[2]   = 1      ;only elastic peak option
            dm_set_droplist,widget_info(self.fileBas,find_by_uname='eBin'),select=1
            self.eief       = 81.8042/1.46/1.46       ;1.46 A
            self.psi_0only  = 1      ;no out-of-plane detector 
            if self.samp_typ ne 2 then self->change_samptyp,2,pdt_reset=pdt_reset
            end
       else:begin
            self.intn_typ   = n_elements(self.intn_typ_str)-1      ;default no kfactor adjustment
            self.edep_yn    = 0
            fixedgeom       = 0
            end
    endcase
    
    ;reset menus
    self->reset_menu,geomsensitive=1-fixedgeom,pdt_reset=pdt_reset
    
    if obj_valid(self.fileSel) then begin
       if ~keyword_set(pdt_reset) then self->reset_pdt
       self->reset_file
    endif
end