; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_make_tlookup_fixed_dt,Period,nout,dt_VME,tsdmin,tstart,tstop
;************************************************************************************************
;
compile_opt strictarr
;
tstart=tsdmin+lindgen(nout)*Period/(nout)
tstart=round(tstart/dt_VME)*dt_VME
tstop=[tstart[1:nout-1],tsdmin+Period]
end


;************************************************************************************************
pro DCS_make_tlookup_fixed_de,emin,emax,nout,econvert,dt_VME,tstart,tstop
;************************************************************************************************
;
compile_opt strictarr
;
de=(emax-emin)/nout
ef=emax-findgen(nout)*de
tstart=sqrt(econvert/ef)
tstart=round(tstart/dt_VME)*dt_VME
tstopx=sqrt(econvert/emin)
tstopx=round(tstopx/dt_VME)*dt_VME
tstop=[tstart[1:nout-1],tstopx]
end


;************************************************************************************************
pro dcs_make_tlookup,wavelength,Period,method,nout,tsdmin,fname,imsg,nch
;************************************************************************************************
; This is a program that creates a time lookup table.
;
compile_opt strictarr
;
; This statement is included in order to force compilation of procedures in this file
; in the event that dcs_make_tlookup is called with wavelength < 0.
if (wavelength lt 0.0) then return
;
imsg=0
econvert=!dcs_hsq2mn/(!dcs_hom/!dcs_dsd)^2
tsd0=wavelength/!dcs_hom*!dcs_dsd
e0=econvert/tsd0^2
dt_VME=0.05
nin=Period/dt_VME
if (abs(nin-round(nin)) gt 0.01) then begin
	imsg=1
	return
endif
;
tsdmax=tsdmin+Period
if ((tsdmin lt 0) or (tsd0 lt tsdmin) or (tsd0 gt tsdmax)) then begin
	imsg=2
	return
endif
;
emax=econvert/tsdmin^2
emin=econvert/tsdmax^2
;
n10=2l^10
n20=2l^20
nleft=n20-nin
;
case method of
	0: dcs_make_tlookup_fixed_dt,Period,nout,dt_VME,tsdmin,tstart,tstop
	1: dcs_make_tlookup_fixed_de,emin,emax,nout,econvert,dt_VME,tstart,tstop
	else: stop
endcase
;
nch=ulonarr(n10)
nch[0:nout-1]=round((tstop-tstart)/dt_VME)
nch[n10-1]=nleft
snch=strcompress(nch)
;
openw,unit,fname,/get_lun
for i=0,n10-1 do printf,unit,snch[i]
close,unit
;
end