; $Id$

; Thos class provides a series of colored labels.


function cwo_lk_multilabel_event,event

    stash = widget_info(event.handler,/child)
    widget_control,stash,get_uvalue=obj


    new_event = obj->event(event)

    return,new_event

end;cwo_lk_multilabel_event

function cwo_lk_multilabel::event,event

    motion = 1
    check = 0
    enter = 0
    exit = 0
    index = -1
    if tag_names(event,/structure_name) eq 'WIDGET_TRACKING' then begin

        ;SET MOUSE TO POINTER


        self.released = -1
        if event.enter eq 1 then begin
            enter = 1
            exit = 0
        endif else begin
            self.pressed = -1
            self.released = -1
            enter = 0
            exit = 1
        endelse
        new_event = {lk_multilabel_event, id:self.tlb,$
                                        top:self.parent,$
                                        handler:self.parent,$
                                        press:0,$
                                        release:0,$
                                        index:-1,$
                                        motion:motion,$
                                        enter:enter,$
                                        exit:exit $
                                        }

        return,new_event
    endif else begin
        if event.press ne 0 then begin

            motion = 0
            index = self->selectedindex(event)
;            wh_incheckbox = where(incheckbox gt 0,wh_count)

            if index ne -1 then begin
                self.released = -1
                self.pressed = index
                self->draw
            endif;index
            motion = 0
            press = event.press

            new_event = {lk_multilabel_event, id:self.tlb,$
                                            top:self.parent,$
                                            handler:self.parent,$
                                            press:event.press,$
                                            release:event.release,$
                                            index:index,$
                                            motion:motion,$
                                            enter:enter,$
                                            exit:exit}


        endif else begin

            motion = 1
;            ;SET TOP AND HANDLER TO 0L TO SWALLOW THE EVENT??????
            ;index = self->selectedindex(event)


            index = self->selectedindex(event)
            if event.release ne 0 then begin

                if index ne -1 then begin
                    self.released = index
                endif;index

                ;print,self.released
                ;print,self.pressed
                if self.released ne self.pressed then index = -1
                self.pressed = -1
                self.released = -1
                self->draw
            endif

            new_event = {lk_multilabel_event, id:self.tlb,$
                                            top:self.parent,$
                                            handler:self.parent,$
                                            press:event.press,$
                                            release:event.release,$
                                            index:index,$
                                            motion:motion,$
                                            enter:enter,$
                                            exit:exit}
        endelse

        return,new_event
    endelse

end;cwo_lk_multilabel_event
function cwo_lk_multilabel::selectedindex,event


    index = -1


    height = self.buttonheight
    width =  self.buttonheight

    xcen = self.buttonheight/2
    ycen = self.buttonheight/2   ;SET YSIZE/CHECKBOX EQUAL TO 20      self.ysize/2

    totalheight = self.nbuttons*self.buttonheight


    ;FIND WHICH BUTTON MOUSE IS IN.
    for i=0,self.nbuttons-1 do begin
        xmax = self.xsize
        xmin = 0

        ymax = totalheight - i*self.buttonheight

        ymin = ymax-height


        if event.x le xmax and event.x ge xmin and $
           event.y le ymax and event.y ge ymin then begin
                index = i
        endif
    endfor;i

    return,index

end;cwo_lk_multilabel::index


pro cwo_lk_multilabel_set_value,id,value

    ;print,'SET_VALUE: DO_NOTHING'

    stash = widget_info(id,/child)
    widget_control,stash,get_uvalue=obj

    obj->set_value,value

end;cwo_lk_multilabel_set_value
pro cwo_lk_multilabel::set_value,value
    if n_elements(value) eq n_elements((*self.value)) then begin
        ptr_free,self.value
        self.value = ptr_new(value)
    endif else print,'Wrong number of elements in "value".'
    self->draw
end;cwo_lk_multilabel::set_value


function cwo_lk_multilabel_get_value,id

    widget_control,widget_info(id,/child),get_uvalue=obj

    return,obj

    obj->getproperty,value = value
    return,*value

end;cwo_lk_multilabel_get_value


pro cwo_lk_multilabel::drawButtons


    device,get_decomposed=dc
    device,decomposed=1


    for i=0,self.nbuttons-1 do begin
        color = (*self.color)[i]


        yoffset = self.ysize - (i+1)*self.buttonheight

        ;COLOR IN THE WINDOW
        xfill = [0,1,1,0,0]
        yfill = [0,0,1,1,0]



        xfill = xfill*self.xsize
        yfill = yfill*self.buttonheight + yoffset

        polyfill,xfill,yfill,color=color,/device,linestyle=0

        xcen = self.buttonheight/2
        ycen = self.buttonheight/2 + yoffset

        xtext = xcen + self.buttonheight/2
        ytext = ycen - 3

        xyouts, xtext,ytext,/device,(*self.value)[i],$
                    color = self.black,charsize=1.0
    endfor;i

    device,decomposed=dc
end;cwo_lk_multilabel::drawButtons


pro cwo_lk_multilabel::draw

    if widget_info(self.draw,/realized) gt 0 then begin

        wset,self.winpix

        self->drawButtons

        wset,self.winvis
        device,copy=[0,0,self.xsize,self.ysize,0,0,self.winpix]
    endif;realized

end;cwo_lk_multilabel::draw



pro cwo_lk_multilabel::getProperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winvis=winvis,$
                winpix=winpix,$
                xsize=xsize,$
                ysize=ysize,$
                color=color,$
                _ref_extra=extra

    if arg_present(parent)  then parent = self.parent
    if arg_present(color)   then color = self.color
    if arg_present(tlb)     then tlb = self.tlb
    if arg_present(draw)    then draw = self.draw
    if arg_present(winvis)  then winvis = self.winvis
    if arg_present(winpix)  then winpix = self.winpix
    if arg_present(xsize)   then xsize = self.xsize
    if arg_present(ysize)   then ysize = self.ysize

end;cwo_lk_multilabel::getProperty
pro cwo_lk_multilabel::setProperty,$
                        parent=parent,$
                        tlb=tlb,$
                        draw=draw,$
                        winvis=winvis,$
                        winpix=winpix,$
                        xsize=xsize,$
                        ysize=ysize,$
                        color=color,$
                        _ref_extra=extra

    if n_elements(parent)  gt 0 then self.parent = parent
    if n_elements(color)   gt 0 then self.color = color
    if n_elements(tlb)     gt 0 then self.tlb = tlb
    if n_elements(draw)    gt 0 then self.draw = draw
    if n_elements(winvis)  gt 0 then self.winvis = winvis
    if n_elements(winpix)  gt 0 then self.winpix = winpix
    if n_elements(xsize)   gt 0 then self.xsize = xsize
    if n_elements(ysize)   gt 0 then self.ysize = ysize


end;cwo_lk_multilabel::setProperty

pro cwo_lk_multilabel_realize,id
    widget_control,id,get_uvalue=obj
    obj->realize
end;cwo_lk_multilabel_realize
pro cwo_lk_multilabel::realize

    id = self.draw

    widget_control,id,get_value=winvis
    self.winvis = winvis
    geom = widget_info(id,/geometry)

    window,/free,/pixmap,xsize=geom.xsize,ysize=geom.ysize
    self.winpix = !d.window

    self->draw

end;cwo_lk_multilabel::realize
pro cwo_lk_multilabel_cleanup,id

    widget_control,id,get_uvalue=obj
    obj_destroy,obj

end;cwo_lk_multilabel_cleanup
pro cwo_lk_multilabel::cleanup
    print,'cwo_lk_multilabel::cleanup'


    ;if ptr_valid(self.checked) then ptr_free,self.checked
    if ptr_valid(self.color) then ptr_free,self.color
    if ptr_valid(self.value) then ptr_free,self.value

    obj_destroy,self.winObj
    obj_destroy,self.view
    obj_destroy,self.model
    obj_destroy,self.textObj
    obj_destroy,self.boxObj

end;cwo_lk_multilabel::cleanup

function cwo_lk_multilabel,parent,obj=obj,_ref_extra=extra
    obj = obj_new('cwo_lk_multilabel',parent,_strict_extra=extra)
    obj->getproperty,tlb=tlb
    return,tlb
end;cwo_lk_multilabel

function cwo_lk_multilabel::init,parent,obj=obj,$
                            tooltip=tooltip,$
                            value=value,$
                            uvalue=uvalue,$
                            uname=uname,$
                            color=color,$
                            frame=frame,$
                            xsize=xsize,$
                            ysize=ysize,$
                            _ref_extra=extra

    if n_elements(tooltip) eq 0 then tooltip = ''
    if n_elements(value)   eq 0 then value = 'Button 1'
    if n_elements(uvalue)  eq 0 then uvalue = 0
    if n_elements(uname)   eq 0 then uname = 0
    if n_elements(frame)   eq 0 then frame = 1
    if n_elements(xsize)   eq 0 then xsize = 100

    if n_elements(ysize) eq 0 then ysize = 20

    self.black = 0L
    self.red   = 255L
    self.green = 256L*self.red
    self.blue  = 256L*self.green
    self.white = self.red + self.green + self.blue
    self.gray = 100L + 256L*(100L + 256L*100L)

    if n_elements(color) eq 0 then color = self.blue + 100L + 256L*100L

    ptr_free,self.value
    self.value = ptr_new(value)
help,value
    self.nbuttons = n_elements(*self.value)
print,self.nbuttons

    ptr_free,self.color
    self.color = ptr_new(lonarr(self.nbuttons)+color)


    self.buttonheight = ysize
    self.buttoncenter = 10
;    self.label = ptr_new(label)

    self.xsize = xsize
    self.ysize = self.buttonheight*self.nbuttons
print,self.ysize
    self.parent = parent


    tlb = widget_base(parent,/col,$
                                uvalue=uvalue,$
                                uname=uname,$
;                                xsize=xsize,$
;                                ysize=self.ysize,$
                                event_func='cwo_lk_multilabel_event',$
                                pro_set_value ='cwo_lk_multilabel_set_value',$
                                func_get_value='cwo_lk_multilabel_get_value',$
                                frame = 0,$;frame,$
                                _strict_extra=extra)
    self.tlb = tlb


;NEED STASH TO RESERVE value AND uvalue OF tlb FOR THE CALLING PROGRAM.
    draw = widget_draw(tlb,xsize=self.xsize,ysize=self.ysize,$
                                uname='STASH',$
                                kill_notify='cwo_lk_multilabel_cleanup',$
                                notify_realize='cwo_lk_multilabel_realize',$
                                tooltip=tooltip,$
                                uvalue=self)

    self.draw = draw

    return,1
end;cwo_lk_multilabel::init

pro cwo_lk_multilabel__define,class

    class = {cwo_lk_multilabel,$
                parent:0L,$
                tlb:0L,$
                draw:0L,$
                winvis:0L,$
                winpix:0L,$
                value:ptr_new(),$
                color:ptr_new(),$
                nbuttons:0,$
                buttonheight:0,$
                buttoncenter:0,$
                black:0L,$
                red:0L,$
                green:0L,$
                blue:0L,$
                white:0L,$
                gray:0L,$
                xsize:0,$
                ysize:0,$               ;MAY NEED THESE FOR CONTROLLING HOW MOUSE LOOKS!!!!
                winObj:obj_new(),$      ;THE OBJECT WINDOW FOR THE CHECKBOX DRAW WINDOW
                view :obj_new(),$     ;THE VIEW
                model:obj_new(),$    ;THE MODEL
                textObj:obj_new(),$     ;THE TEXT OF THE CHECKBOX
                boxObj:obj_new() $      ;THE CHECKBOX WILL BE A PLOT WITH NO AXES
                }

end;cwo_lk_multilabel__define



pro cwo_lk_multilabel_test_event,event
    ;if tag_names(event,/structure_name) eq 'WIDGET_DRAW' then

    if tag_names(event,/structure_name) eq 'lk_multilabel_EVENT' then begin
        if event.motion eq 0 then begin
            print,tag_names(event,/structure_name)
            print,event
        endif
    endif
end;cwo_lk_multilabel_test_event
pro cwo_lk_multilabel_test


    b = widget_base(xoffset=300,yoffset=300,/col,$
                    title='CWO_lk_multilabel_TEST');,$
                    ;/gridlayout);,xsize = 100,ysize = 100)
;    bl = widget_base(b,/col)
;    bl = widget_base(b,/col)

    ccolor1 =   [256L*256L*255L+100*256L+100L,$
                255L,$
                256L*255L,$
                256L*256L*255L+256L*100L,$
                255L + 256L*256L*255L]

    clabel1 = ['scattering','incoherent','Al Spheres','u,v orientation vectors','Q, Ki and Kf']

    c1 = cwo_lk_multilabel(b,tooltip='This is a colorful textbox.',$
                          value = 'CHECKBOX 1',$
                          xsize=200,$
                          ysize=20,$
                          uname ='CHECKBOX UNAME',$
                          uvalue='CHECKBOX UVALUE',$
                          obj=obj)

    c2 = cwo_lk_multilabel(b,tooltip='This is a colorful textbox.',$
                          value = 'CHECKBOX 2',$
                          xsize=120,$
                          ysize=20,$
                          color = 255L,$
                          uname ='CHECKBOX UNAME',$
                          uvalue='CHECKBOX UVALUE',$
                          obj=obj)
    c1 = cwo_lk_multilabel(b,tooltip='This is a colorful label set.',$
                          value = clabel1,$
                          color=ccolor1,$
                          xsize=120,$
                          ysize=20,$
                          uname ='CHECKBOX UNAME',$
                          uvalue='CHECKBOX UVALUE',$
                          obj=obj)



    widget_control,b,/realize

    xmanager,'cwo_lk_multilabel_test',b,/no_block

end;cwo_lk_multilabel_test
