; $Id$
;
;
;THIS WAS INTENDED TO BE A GENERAL IMAGE DISPLAY WIDGET, BUT IT IS NOT YET USED IN DAVE.
;



;###############################################################################
;
;NAME:
;        cwo_drawImage_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawImage_event,event

    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'cwo_drawImage: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return,-1
    endif

    widget_control,widget_info(event.handler,/child),get_uvalue=self
    event = self->event(event)
    return,event
end;cwo_drawImage_event
pro cwo_drawimage_class::contextEvent,event

    case event.id of
    self.flipButton:begin
        void = self->event(event)
        print,'cwo_drawimage_class::contextEvent'
    end;self.flipbutton
    else:void = self->cwo_drawplot_class::event(event)
    endcase

end;cwo_drawimage_class::contextEvent


function cwo_drawimage_class::event,event

    case event.id of
    self.flipButton:begin
        print,'cwo_drawimage_class::event'
        for i=0,self->count()-1 do begin
            self->draw,position=i
            wait,1
        endfor;i

        return,-1
    end;self.flipbutton
    else:return,self->cwo_drawplot_class::event(event)
    endcase

end;cwo_drawimage_class::event



function cwo_drawimage_class::randomImage

    return,bindgen(100,100)

end;cwo_drawimage_class::randomImage
;###############################################################################
;
;NAME:
;        cwo_drawimage_class::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawimage_class::draw,printwin=printwin,$
                       ps=ps,jpg=jpg,printdir=printdir,$
                       position=position,$
                       _Ref_Extra=extra;,position=position,_Extra=extra

    if n_elements(printwin) eq 0 then printwin = 0
    if n_elements(jpg) eq 0 then jpg = 0
    if n_elements(ps) eq 0 then ps = 0
    if n_elements(position) eq 0 then position = self.imageindex

    device,get_decomposed=dc
    device,decomposed=1

    win = self->setwindow() ;THE PRINT METHOD SHOULD CHANGE THE WINDOW TO 'PS'
                            ;AND THEN CHANGE IT BACK AT THE END OF PRINTING.
                            ;setWindow and copyWindow FUNCTIONALITY SHOULE BE
                            ;SET UP TO MAKE THE PRINT PROCESS WORK OUT.

;print,'win=',win
    if win ne 0 then begin

        if self.zoomboxflag eq 0 then begin

                black = 0L
                red = 255L & green = 256L*red & blue = 256L*green
                white = red + green + blue

                xrange = self.zoomxrange
                yrange = self.zoomyrange

                if self.zoomflag eq 1 then begin
                    xstyle = 1
                    ystyle = 1
                endif else begin
                    xstyle = 0
                    ystyle = 0
                endelse

                font=0;-1
                !p.font = -1
;print,'cwo_drawimage_class::draw self.imageindex=',self.imageindex
;print,self->count()
                if n_elements(position) eq 0 then position = self.imageindex

                if self->count() gt 0 then begin
                    (self->get(position=position))->getImage,image
                endif else begin
                    image = self->randomImage()
                endelse

                ;SET THE AXIS RANGES FOR THIS PLOT
                if min(xrange) ne max(xrange) $
                    and min(yrange) ne max(yrange) then begin

                        if self.xticks ne -1 then xticks = self.xticks else xticks = 0
                        if abs(xrange[1]-xrange[0]) lt 0.01 then xticks = 2

                        plotimage,bytscl(image),$
                            background=white,$
                            xrange = xrange,$;self.zoomxrange,$
                            yrange = yrange,$;self.zoomyrange,$
                            xstyle=xstyle,ystyle=ystyle,$
                            color = black,$
                            title=self.title,$
                            xtitle=self.xtitle,$
                            ytitle=self.ytitle

                            ;,$
                            ;xlog = self.xlog,$
                            ;ylog = self.ylog,$
        ;                    position = self.position,$
        ;                    xcharsize=1.25,$
        ;                    ycharsize=1.25,$
        ;                    xticks=xticks;,font=font
                endif else begin
        ;print,'test2'
                   plotimage,bytscl(image)


        ;                plotimage,bytscl(image),$
        ;                    background=white,$
        ;                    xstyle=xstyle,ystyle=ystyle,$
        ;                    color = black,$
        ;                    title=self.title,$
        ;                    xtitle=self.xtitle,$
        ;                    ytitle=self.ytitle,$
        ;                    ;xlog = self.xlog,$
        ;                    ;ylog = self.ylog,$
        ;                    position = self.position,$
        ;                    xcharsize=1.25,$
        ;                    ycharsize=1.25,$
        ;                    xticks=xticks;,font=font
                endelse

                ;RELEASE AXIS POINTERS FOR WINDOW
                ptr_free,self.xptr
                ptr_free,self.yptr

                ;RESET AXIS POINTERS
                self.xptr = ptr_new(!x)           ;MUST SET THESE HERE TO ASSIGN
                self.yptr = ptr_new(!y)           ;POINTERS TO PROPER AXES!!!
        ;
        ;        ;OPLOT THE DATA
        ;        self->oplot,win,_strict_Extra=extra


                self->showMode,win
                self->savewindow

        endif else begin
            geom = widget_info(self.draw,/geometry)
            device,copy=[0,0,geom.xsize,geom.ysize,0,0,self.winsav]
        endelse
;PERHAPS WANT A ZOOMBOX v. SELECTBOX OPTION.
        self->zoombox,win
        ;self->showMode,win

        self->copywindow
        if printwin eq 1 then self->printWindow,jpg=jpg,ps=ps,printdir=printdir



    endif;win ne 0

    device,decomposed = dc
end;cwo_drawimage_class::draw

pro cwo_drawimage_class::setData,image

    ;print,'cwo_drawimage_class::setData'
    if ptr_valid(self.imageData) gt 0 then ptr_free,self.imageData

    self.imageData = ptr_new(image)

end;cwo_drawimage_class::setData

pro cwo_drawimage_class::addData,image

    ;print,'cwo_drawimage_class::addData'

    obj = obj_new('cwo_drawImage_data',image=image)
    self->add,obj

    self.imageIndex = self->count()-1


    if ptr_valid(self.imageData) gt 0 then ptr_free,self.imageData

    self.imageData = ptr_new(image)

end;cwo_drawimage_class::setData

pro cwo_drawimage_class::clearData,image

    ;print,'cwo_drawimage_class::clearData'

    o = self->get(/all)
    if obj_valid(o[0]) gt 0 then begin
        self->remove,/all
        obj_destroy,o
        self.imageIndex = -1
    endif

end;cwo_drawimage_class::clearData


;###############################################################################
;
;NAME:
;        cwo_drawimage_class::getDataRange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawimage_class::getDataRange,xmin=xin,xmax=xmax,ymin=ymin,ymax=ymax


    count = self->count()   ;inherited from idl_container


    if count gt 0 then begin
        ref = self->get(position=0)
        xvals = ref->xrange()
        yvals = ref->yrange()


        for i=1,count-1 do begin
            ref = self->get(position=i)
            xvals = [xvals,ref->xrange()]
            yvals = [yvals,ref->yrange()]
        endfor;i
        xmin = min(xvals)
        xmax = max(xvals)
        ymin = min(yvals)
        ymax = max(yvals)


        self.xrange = [xmin,xmax]
        self.yrange = [ymin,ymax]
    endif else begin
        self.xrange = [0,1]
        self.yrange = [0,1]
        self.zoomxrange = [0,1]
        self.zoomyrange = [0,1]
    endelse



end;cwo_drawimage_class::getDataRange



;###############################################################################
;
;NAME:
;        cwo_drawimage_class::createContextMenu
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawimage_class::createContextMenu



    ;print,'Creating Context Menu:'


    self.contextMenu = widget_base( self.tlb, $
                                    /CONTEXT_MENU,/col,$
                                    uname = 'CWO_DRAWPLOT_CONTEXTMENU',$
                                    uvalue={object:self,$
                                            method:'drawEvents',$
                                            id:'CWO_DRAWPLOT_CONTEXTMENU'})


    bttn0 = widget_button(self.contextMenu, value='Unzoom',$
                                uname='UNZOOM',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'UNZOOM',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn0 = widget_button(self.contextMenu, value='Print to .ps',$
                                uname='PRINTPS',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'PRINTPS',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn0 = widget_button(self.contextMenu, value='Print to .jpg',$
                                uname='PRINTJPG',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'PRINTJPG',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})



;    bttn1 = widget_button(self.contextMenu,value='Log/Lin',/menu)
;    bttn1a = widget_button(bttn1, value='[_] Log(x)',$
;                                uname='LOGXMODE',$
;                                uvalue={object:self,$
;                                        method:'contextMenuEvents',$
;                                        id:'LOGXMODE',$
;                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
;    bttn1a = widget_button(bttn1, value='[_] Log(y)',$
;                                uname='LOGYMODE',$
;                                uvalue={object:self,$
;                                        method:'contextMenuEvents',$
;                                        id:'LOGYMODE',$
;                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})




    bttn1 = widget_button(self.contextMenu,value='Select/Zoom Mode',/menu)
    bttn1a = widget_button(bttn1, value='[X] Zoom',$
                                uname='ZOOMMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'ZOOMMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})


    bttn1b = widget_button(bttn1, value='[_] Position',$
                                uname='POSITIONMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'POSITIONMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn1c = widget_button(bttn1, value='[_] Start/End',$
                                uname='START_ENDMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'START_ENDMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn1d = widget_button(bttn1, value='[_] Region Select',$
                                uname='REGIONMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'REGIONMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})


    bttn1e = widget_button(bttn1, value='Hide/Show mode label',$
                                uname='HIDEMODELABEL',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'HIDEMODELABEL',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})

    self.flipbutton = widget_button(self.contextmenu, value='Flip through images',$
                                uname='FLIPTHROUGHIMAGES',$
                                uvalue={object:self,$
                                        method:'ContextEvent',$;contextMenuEvents',$
                                        id:'FLIPTHROUGHIMAGES',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})


    if !version.os eq 'Win32' then sensitive = 1 else sensitive = 0


    self.showHideSetMenu = widget_button(self.contextMenu,value='Show/Hide Set',$
                                                          /menu,$
                                                          sensitive=0);sensitive)


    self.showHideSetList = widget_button(self.showHideSetMenu,value='Sets:',/menu)


    return,1
end;cwo_drawimage_class::createContextMenu



pro cwo_drawimage_class::cleanup

    print,'cwo_drawimage_class::cleanup'

    if ptr_valid(self.imagedata) gt 0 then ptr_free,self.imagedata

end;cwo_drawimage_class::cleanup
function cwo_drawimage_class::init,parent, tlb=tlb,$
                                    xhide=xhide,yhide=yhide,$
                                    xshow=xshow,yshow=yshow,$
                                    showplot=showplot,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    frame=frame,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
				                    position=position,$
				                    xoffset=xoffset,yoffset=yoffset,$
                                    xmaxrange=xmaxrange,$
                                    ymaxrange=ymaxrange,$
                                    xticks=xticks,yticks=yticks,$
                                    image=image,$
                                    mode=mode,$
                                    _ref_extra=extra

print,'cwo_drawimage_class::init'


        ret = self->cwo_drawplot_class::init( parent, tlb=tlb,$
                                        xhide=xhide,yhide=yhide,$
                                        xshow=xshow,yshow=yshow,$
                                        showplot=showplot,$
                                        xsize=xsize,$
                                        ysize=ysize,$
                                        uvalue=uvalue,$
                                        uname=uname,$
                                        frame=frame,$
                                        title=title,$
                                        xtitle=xtitle,$
                                        ytitle=ytitle,$
                                        kill_notify=kill_notify,$
				                        position=position,$
				                        xoffset=xoffset,yoffset=yoffset,$
                                        xmaxrange=xmaxrange,$
                                        ymaxrange=ymaxrange,$
                                        xticks=xticks,yticks=yticks,$
                                        mode=mode,$
                                        _extra=extra)

        if n_elements(image) gt 0 then self->add,obj_new('cwo_drawImage_data',image=image)
        self.imageIndex = 0

    self->draw





    return,1
end;cwo_drawimage_class::init


pro cwo_drawimage_class__define,class



    class = {cwo_drawimage_class,$
                inherits cwo_drawplot_class,$
                imageData:ptr_new(),$
                imageIndex:0,$
                flipbutton:0L}




end;cwo_drawimage_class__define

pro test_cwo_drawimage_event,event
  print,'a cwo_drawimage event occurred.'
  
end;test_cwo_drawimage_event

pro test_cwo_drawimage

  h1 = hanning(300,300)
  h2 = hanning(40,40)
  b = widget_base(title='test_cwo_drawimage')
  i=cwo_drawimage(b,obj=o,xsize=300,ysize=300,image=bytscl(h1))
  widget_control,b,/realize
  xmanager,'test',b,/no_block,event_handler='test_cwo_drawimage_event'
  o->addData,bytscl(h2)

end;test_cwo_drawimage

function cwo_drawimage,parent,xsize=xsize,ysize=ysize,obj=obj,image=image,_Extra=Extra

    obj = obj_new('cwo_drawimage_class',parent,xsize=xsize,ysize=ysize,tlb=tlb,image=image,_Extra=extra)

    return, tlb

end;cwo_drawImage
