; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro centertlb,tlb
; This procedure centers the entire widget (the
; top-level-base) on the screen (independent of
; the platform).
device,get_screen_size = screenSize
; Note that we need to test for whether this application is
; running on a two-monitor (side-by-side) system.
aspect_ratio = float(screenSize[0])/float(screenSize[1])
dual_monitor = aspect_ratio gt (4./3.)
geom = widget_info(tlb,/geometry)
if dual_monitor then begin
   widget_control,tlb,  xoff = (screenSize[0]/4)-(geom.scr_xsize/2),$
                        yoff = (screenSize[1]/2)-(geom.scr_ysize/2)
endif else begin
   widget_control,tlb,  xoff = (screenSize[0]/2)-(geom.scr_xsize/2),$
                        yoff = (screenSize[1]/2)-(geom.scr_ysize/2)
endelse
end
