/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import ptolemy.plot.PlotBox;

public class PlotBoxMLParser
extends HandlerBase {
    public static String PlotML_DTD_1 = "<!ELEMENT plot (barGraph | bin | dataset | default | noColor | noGrid | size | title | wrap | xLabel | xLog | xRange | xTicks | yLabel | yLog | yRange | yTicks)*><!ELEMENT barGraph EMPTY><!ATTLIST barGraph width CDATA #IMPLIED offset CDATA #IMPLIED><!ELEMENT bin EMPTY><!ATTLIST bin width CDATA #IMPLIED offset CDATA #IMPLIED><!ELEMENT dataset (m | move | p | point)*><!ATTLIST dataset connected (yes | no) #IMPLIED marks (none | dots | points | various) #IMPLIED name CDATA #IMPLIED stems (yes | no) #IMPLIED><!ELEMENT default EMPTY><!ATTLIST default connected (yes | no) \"yes\" marks (none | dots | points | various) \"none\" stems (yes | no) \"no\"><!ELEMENT noColor EMPTY><!ELEMENT noGrid EMPTY><!ELEMENT reuseDatasets EMPTY><!ELEMENT size EMPTY><!ATTLIST size height CDATA #REQUIRED width CDATA #REQUIRED><!ELEMENT title (#PCDATA)><!ELEMENT wrap EMPTY><!ELEMENT xLabel (#PCDATA)><!ELEMENT xLog EMPTY><!ELEMENT xRange EMPTY><!ATTLIST xRange min CDATA #REQUIRED max CDATA #REQUIRED><!ELEMENT xTicks (tick)+><!ELEMENT yLabel (#PCDATA)><!ELEMENT yLog EMPTY><!ELEMENT yRange EMPTY><!ATTLIST yRange min CDATA #REQUIRED max CDATA #REQUIRED><!ELEMENT yTicks (tick)+><!ELEMENT tick EMPTY><!ATTLIST tick label CDATA #REQUIRED position CDATA #REQUIRED><!ELEMENT m EMPTY><!ATTLIST m x CDATA #IMPLIED y CDATA #REQUIRED lowErrorBar CDATA #IMPLIED highErrorBar CDATA #IMPLIED><!ELEMENT move EMPTY><!ATTLIST move x CDATA #IMPLIED y CDATA #REQUIRED lowErrorBar CDATA #IMPLIED highErrorBar CDATA #IMPLIED><!ELEMENT p EMPTY><!ATTLIST p x CDATA #IMPLIED y CDATA #REQUIRED lowErrorBar CDATA #IMPLIED highErrorBar CDATA #IMPLIED><!ELEMENT point EMPTY><!ATTLIST point x CDATA #IMPLIED y CDATA #REQUIRED lowErrorBar CDATA #IMPLIED highErrorBar CDATA #IMPLIED>";
    protected Hashtable _attributes;
    protected StringBuffer _currentCharData = new StringBuffer();
    protected XmlParser _parser = new XmlParser();
    protected PlotBox _plot;
    private Stack _externalEntities = new Stack();
    private boolean _xtick;

    public PlotBoxMLParser(PlotBox plot) {
        this._plot = plot;
    }

    protected PlotBoxMLParser() {
    }

    @Override
    public void attribute(String name, String value, boolean specified) throws XmlException {
        if (name == null) {
            throw new XmlException("Attribute has no name", this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        if (value != null) {
            this._attributes.put(name, value);
        }
    }

    @Override
    public void charData(char[] chars, int offset, int length) {
        this._currentCharData.append(chars, offset, length);
    }

    @Override
    public void endDocument() throws Exception {
    }

    @Override
    public void endElement(String elementName) throws Exception {
        if (elementName.equals("noGrid")) {
            this._plot.setGrid(false);
        } else if (elementName.equals("noColor")) {
            this._plot.setColor(false);
        } else if (elementName.equals("title")) {
            this._plot.setTitle(this._currentCharData.toString());
        } else if (elementName.equals("wrap")) {
            this._plot.setWrap(true);
        } else if (elementName.equals("xLabel")) {
            this._plot.setXLabel(this._currentCharData.toString());
        } else if (elementName.equals("xLog")) {
            this._plot.setXLog(true);
        } else if (elementName.equals("yLabel")) {
            this._plot.setYLabel(this._currentCharData.toString());
        } else if (elementName.equals("yLog")) {
            this._plot.setYLog(true);
        }
    }

    @Override
    public void error(String message, String systemID, int line, int column) throws XmlException {
        throw new XmlException(message, this._currentExternalEntity(), line, column);
    }

    public void parse(URL base, InputStream input) throws Exception {
        this.parse(base, new InputStreamReader(input));
    }

    public void parse(URL base, Reader reader) throws Exception {
        this._parser.setHandler(this);
        BufferedReader buffered = new BufferedReader(reader);
        if (base == null) {
            this._parser.parse(null, null, buffered);
        } else {
            this._parser.parse(base.toExternalForm(), null, buffered);
        }
    }

    public void parse(URL base, String text) throws Exception {
        this.parse(base, new StringReader(text));
    }

    @Override
    public Object resolveEntity(String publicID, String systemID) {
        if (publicID != null && publicID.equals("-//UC Berkeley//DTD PlotML 1//EN")) {
            return new StringReader(PlotML_DTD_1);
        }
        return null;
    }

    @Override
    public void startDocument() {
        this._attributes = new Hashtable();
    }

    @Override
    public void startElement(String elementName) throws XmlException {
        try {
            if (elementName.equals("size")) {
                String spec = (String)this._attributes.get("height");
                this._checkForNull(spec, "No height argument for element \"size\"");
                int height = Integer.valueOf(spec);
                spec = (String)this._attributes.get("width");
                this._checkForNull(spec, "No width argument for element \"size\"");
                int width = Integer.valueOf(spec);
                this._plot.setSize(width, height);
            } else if (elementName.equals("tick")) {
                String label = (String)this._attributes.get("label");
                this._checkForNull(label, "No label for element \"tick\"");
                String spec = (String)this._attributes.get("position");
                this._checkForNull(spec, "No position for element \"tick\"");
                double position = Double.valueOf(spec);
                if (this._xtick) {
                    this._plot.addXTick(label, position);
                } else {
                    this._plot.addYTick(label, position);
                }
            } else if (elementName.equals("title")) {
                this._currentCharData = new StringBuffer();
            } else if (elementName.equals("xLabel")) {
                this._currentCharData = new StringBuffer();
            } else if (elementName.equals("xRange")) {
                String spec = (String)this._attributes.get("min");
                this._checkForNull(spec, "No min argument for element \"xRange\"");
                double min = Double.valueOf(spec);
                spec = (String)this._attributes.get("max");
                this._checkForNull(spec, "No max argument for element \"xRange\"");
                double max = Double.valueOf(spec);
                this._plot.setXRange(min, max);
            } else if (elementName.equals("xTicks")) {
                this._xtick = true;
            } else if (elementName.equals("yLabel")) {
                this._currentCharData = new StringBuffer();
            } else if (elementName.equals("yRange")) {
                String spec = (String)this._attributes.get("min");
                this._checkForNull(spec, "No min argument for element \"yRange\"");
                double min = Double.valueOf(spec);
                spec = (String)this._attributes.get("max");
                this._checkForNull(spec, "No max argument for element \"yRange\"");
                double max = Double.valueOf(spec);
                this._plot.setYRange(min, max);
            } else if (elementName.equals("yTicks")) {
                this._xtick = false;
            }
        }
        catch (Throwable ex) {
            if (ex instanceof XmlException) {
                throw (XmlException)ex;
            }
            String msg = "XML element \"" + elementName + "\" triggers exception:\n  " + ex.toString();
            throw new XmlException(msg, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        this._attributes.clear();
    }

    @Override
    public void startExternalEntity(String systemID) {
        this._externalEntities.push(systemID);
    }

    protected void _checkForNull(Object object, String message) throws XmlException {
        if (object == null) {
            throw new XmlException(message, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
    }

    protected String _currentExternalEntity() {
        return (String)this._externalEntities.peek();
    }
}

