/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyFastSequenceIter;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PyTuple$exposed___new__;
import org.python.core.PyTuple$tuple___add___exposer;
import org.python.core.PyTuple$tuple___contains___exposer;
import org.python.core.PyTuple$tuple___eq___exposer;
import org.python.core.PyTuple$tuple___ge___exposer;
import org.python.core.PyTuple$tuple___getitem___exposer;
import org.python.core.PyTuple$tuple___getnewargs___exposer;
import org.python.core.PyTuple$tuple___getslice___exposer;
import org.python.core.PyTuple$tuple___gt___exposer;
import org.python.core.PyTuple$tuple___hash___exposer;
import org.python.core.PyTuple$tuple___iter___exposer;
import org.python.core.PyTuple$tuple___le___exposer;
import org.python.core.PyTuple$tuple___lt___exposer;
import org.python.core.PyTuple$tuple___mul___exposer;
import org.python.core.PyTuple$tuple___ne___exposer;
import org.python.core.PyTuple$tuple___repr___exposer;
import org.python.core.PyTuple$tuple___rmul___exposer;
import org.python.core.PyTupleDerived;
import org.python.core.PyType;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="tuple", base=PyObject.class)
public class PyTuple
extends PySequenceList
implements List {
    public static final PyType TYPE;
    private final PyObject[] array;
    private volatile List<PyObject> cachedList = null;
    private static final PyTuple EMPTY_TUPLE;

    public PyTuple() {
        this(TYPE, Py.EmptyObjects);
    }

    public PyTuple(PyObject ... elements) {
        this(TYPE, elements);
    }

    public PyTuple(PyType subtype, PyObject[] elements) {
        super(subtype);
        if (elements == null) {
            this.array = new PyObject[0];
        } else {
            this.array = new PyObject[elements.length];
            System.arraycopy(elements, 0, this.array, 0, elements.length);
        }
    }

    public PyTuple(PyObject[] elements, boolean copy) {
        this(TYPE, elements, copy);
    }

    public PyTuple(PyType subtype, PyObject[] elements, boolean copy) {
        super(subtype);
        if (copy) {
            this.array = new PyObject[elements.length];
            System.arraycopy(elements, 0, this.array, 0, elements.length);
        } else {
            this.array = elements;
        }
    }

    private static PyTuple fromArrayNoCopy(PyObject[] elements) {
        return new PyTuple(elements, false);
    }

    List<PyObject> getList() {
        if (this.cachedList == null) {
            this.cachedList = Arrays.asList(this.array);
        }
        return this.cachedList;
    }

    @ExposedNew
    static final PyObject tuple_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("tuple", args, keywords, new String[]{"sequence"}, 0);
        PyObject S2 = ap.getPyObject(0, null);
        if (new_.for_type == subtype) {
            if (S2 == null) {
                return EMPTY_TUPLE;
            }
            if (S2 instanceof PyTupleDerived) {
                return new PyTuple(((PyTuple)S2).getArray());
            }
            if (S2 instanceof PyTuple) {
                return S2;
            }
            return PyTuple.fromArrayNoCopy(Py.make_array(S2));
        }
        if (S2 == null) {
            return new PyTupleDerived(subtype, Py.EmptyObjects);
        }
        return new PyTupleDerived(subtype, Py.make_array(S2));
    }

    public static PyTuple fromIterable(PyObject iterable) {
        return PyTuple.fromArrayNoCopy(Py.make_array(iterable));
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyTuple.sliceLength(start, stop, step);
        PyObject[] newArray = new PyObject[n];
        if (step == 1) {
            System.arraycopy(this.array, start, newArray, 0, stop - start);
            return PyTuple.fromArrayNoCopy(newArray);
        }
        int i = start;
        for (int j = 0; j < n; ++j) {
            newArray[j] = this.array[i];
            i += step;
        }
        return PyTuple.fromArrayNoCopy(newArray);
    }

    @Override
    protected PyObject repeat(int count) {
        int newSize;
        int size;
        if (count < 0) {
            count = 0;
        }
        if ((size = this.size()) == 0 || count == 1) {
            if (this.getType() == TYPE) {
                return this;
            }
            if (size == 0) {
                return EMPTY_TUPLE;
            }
        }
        if ((newSize = size * count) / size != count) {
            throw Py.MemoryError("");
        }
        PyObject[] newArray = new PyObject[newSize];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(this.array, 0, newArray, i * size, size);
        }
        return PyTuple.fromArrayNoCopy(newArray);
    }

    @Override
    public int __len__() {
        return this.tuple___len__();
    }

    final int tuple___len__() {
        return this.size();
    }

    final boolean tuple___contains__(PyObject o) {
        return super.__contains__(o);
    }

    final PyObject tuple___ne__(PyObject o) {
        return super.__ne__(o);
    }

    final PyObject tuple___eq__(PyObject o) {
        return super.__eq__(o);
    }

    final PyObject tuple___gt__(PyObject o) {
        return super.__gt__(o);
    }

    final PyObject tuple___ge__(PyObject o) {
        return super.__ge__(o);
    }

    final PyObject tuple___lt__(PyObject o) {
        return super.__lt__(o);
    }

    final PyObject tuple___le__(PyObject o) {
        return super.__le__(o);
    }

    @Override
    public PyObject __add__(PyObject generic_other) {
        return this.tuple___add__(generic_other);
    }

    final PyObject tuple___add__(PyObject generic_other) {
        PyTuple sum = null;
        if (generic_other instanceof PyTuple) {
            PyTuple other = (PyTuple)generic_other;
            PyObject[] newArray = new PyObject[this.array.length + other.array.length];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            System.arraycopy(other.array, 0, newArray, this.array.length, other.array.length);
            sum = PyTuple.fromArrayNoCopy(newArray);
        }
        return sum;
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.tuple___mul__(o);
    }

    final PyObject tuple___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.tuple___rmul__(o);
    }

    final PyObject tuple___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __iter__() {
        return this.tuple___iter__();
    }

    public PyObject tuple___iter__() {
        return new PyFastSequenceIter(this);
    }

    final PyObject tuple___getslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        return this.seq___getslice__(s_start, s_stop, s_step);
    }

    final PyObject tuple___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + index);
        }
        return ret;
    }

    final PyTuple tuple___getnewargs__() {
        return new PyTuple(new PyTuple(this.getArray()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.tuple___getnewargs__();
    }

    @Override
    public int hashCode() {
        return this.tuple___hash__();
    }

    /*
     * WARNING - void declaration
     */
    final int tuple___hash__() {
        int n = this.size();
        int len = 1000003;
        int mult = 3430008;
        while (--n >= 0) {
            void y;
            int x = this.array[n].hashCode();
            mult = (mult ^ x) * len;
            len += 82520 + y + y;
        }
        return mult + 97531;
    }

    private String subobjRepr(PyObject o) {
        if (o == null) {
            return "null";
        }
        return o.__repr__().toString();
    }

    @Override
    public String toString() {
        return this.tuple___repr__();
    }

    final String tuple___repr__() {
        StringBuilder buf = new StringBuilder("(");
        for (int i = 0; i < this.array.length - 1; ++i) {
            buf.append(this.subobjRepr(this.array[i]));
            buf.append(", ");
        }
        if (this.array.length > 0) {
            buf.append(this.subobjRepr(this.array[this.array.length - 1]));
        }
        if (this.array.length == 1) {
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        PyObject[] elements = new PyObject[toIndex - fromIndex];
        int i = 0;
        int j = fromIndex;
        while (i < elements.length) {
            elements[i] = this.array[j];
            ++i;
            ++j;
        }
        return new PyTuple(elements);
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private final Iterator<PyObject> iter;
            {
                this.iter = PyTuple.this.getList().iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }
        };
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            private final ListIterator<PyObject> iter;
            {
                this.iter = PyTuple.this.getList().listIterator(index);
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }

            public boolean hasPrevious() {
                return this.iter.hasPrevious();
            }

            public Object previous() {
                return this.iter.previous().__tojava__(Object.class);
            }

            public int nextIndex() {
                return this.iter.nextIndex();
            }

            public int previousIndex() {
                return this.iter.previousIndex();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "can only concatenate tuple (not \"{2}\") to tuple";
        }
        return super.unsupportedopMessage(op, o2);
    }

    @Override
    public void pyset(int index, PyObject value) {
        throw Py.TypeError("'tuple' object does not support item assignment");
    }

    @Override
    public boolean contains(Object o) {
        return this.getList().contains(Py.java2py(o));
    }

    @Override
    public boolean containsAll(Collection c) {
        if (c instanceof PyList) {
            return this.getList().containsAll(((PyList)c).getList());
        }
        if (c instanceof PyTuple) {
            return this.getList().containsAll(((PyTuple)c).getList());
        }
        return this.getList().containsAll(new PyList(c));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PyObject) {
            return this._eq((PyObject)other).__nonzero__();
        }
        if (other instanceof List) {
            return other.equals(this);
        }
        return false;
    }

    @Override
    public Object get(int index) {
        return this.array[index].__tojava__(Object.class);
    }

    @Override
    public PyObject[] getArray() {
        return this.array;
    }

    @Override
    public int indexOf(Object o) {
        return this.getList().indexOf(Py.java2py(o));
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(Py.java2py(o));
    }

    @Override
    public void pyadd(int index, PyObject element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean pyadd(PyObject o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PyObject pyget(int index) {
        return this.array[index];
    }

    @Override
    public void remove(int start, int stop) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public Object[] toArray() {
        Object[] converted = new Object[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            converted[i] = this.array[i].__tojava__(Object.class);
        }
        return converted;
    }

    @Override
    public Object[] toArray(Object[] converted) {
        int i;
        Class<?> type = converted.getClass().getComponentType();
        if (converted.length < this.array.length) {
            converted = (Object[])Array.newInstance(type, this.array.length);
        }
        for (i = 0; i < this.array.length; ++i) {
            converted[i] = type.cast(this.array[i].__tojava__(type));
        }
        if (this.array.length < converted.length) {
            for (i = this.array.length; i < converted.length; ++i) {
                converted[i] = null;
            }
        }
        return converted;
    }

    static {
        PyType.addBuilder(PyTuple.class, new PyTuple$PyExposer());
        TYPE = PyType.fromClass(PyTuple.class);
        EMPTY_TUPLE = new PyTuple();
    }

    public class PyTuple$tuple___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyTuple$tuple___len___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyTuple$tuple___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyTuple$tuple___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyTuple)this.self).tuple___len__());
        }
    }

    public class PyTuple$PyExposer
    extends BaseTypeBuilder {
        public PyTuple$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyTuple$tuple___len___exposer("__len__"), new PyTuple$tuple___contains___exposer("__contains__"), new PyTuple$tuple___ne___exposer("__ne__"), new PyTuple$tuple___eq___exposer("__eq__"), new PyTuple$tuple___gt___exposer("__gt__"), new PyTuple$tuple___ge___exposer("__ge__"), new PyTuple$tuple___lt___exposer("__lt__"), new PyTuple$tuple___le___exposer("__le__"), new PyTuple$tuple___add___exposer("__add__"), new PyTuple$tuple___mul___exposer("__mul__"), new PyTuple$tuple___rmul___exposer("__rmul__"), new PyTuple$tuple___iter___exposer("__iter__"), new PyTuple$tuple___getslice___exposer("__getslice__"), new PyTuple$tuple___getitem___exposer("__getitem__"), new PyTuple$tuple___getnewargs___exposer("__getnewargs__"), new PyTuple$tuple___hash___exposer("__hash__"), new PyTuple$tuple___repr___exposer("__repr__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("tuple", PyTuple.class, PyObject.class, true, pyBuiltinMethodArray, pyDataDescrArray, new PyTuple$exposed___new__());
        }
    }
}

