/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropShadowBorder
implements Border {
    private static final Map<Integer, Map<Position, BufferedImage>> CACHE = new HashMap<Integer, Map<Position, BufferedImage>>();
    private Color lineColor;
    private int lineWidth;
    private int shadowSize;
    private float shadowOpacity;
    private int cornerSize;
    private boolean showTopShadow;
    private boolean showLeftShadow;
    private boolean showBottomShadow;
    private boolean showRightShadow;

    public DropShadowBorder() {
        this(UIManager.getColor("Control"), 1, 5);
    }

    public DropShadowBorder(Color color, int n, int n2) {
        this(color, n, n2, 0.5f, 12, false, false, true, true);
    }

    public DropShadowBorder(Color color, int n, boolean bl) {
        this(color, n, 5, 0.5f, 12, false, bl, true, true);
    }

    public DropShadowBorder(Color color, int n, int n2, float f, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.lineColor = color;
        this.lineWidth = n;
        this.shadowSize = n2;
        this.shadowOpacity = f;
        this.cornerSize = n3;
        this.showTopShadow = bl;
        this.showLeftShadow = bl2;
        this.showBottomShadow = bl3;
        this.showRightShadow = bl4;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Map<Position, BufferedImage> map = this.getImages(null);
        Insets insets = this.getBorderInsets(component);
        int n5 = n + insets.left - this.lineWidth;
        int n6 = n + n3 - insets.right;
        int n7 = n2 + insets.top - this.lineWidth;
        int n8 = n2 + n4 - insets.bottom;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.lineColor);
        Point point = null;
        if (this.showLeftShadow || this.showTopShadow) {
            point = new Point();
            if (this.showLeftShadow && !this.showTopShadow) {
                point.setLocation(n, n2 + this.shadowSize);
            } else if (this.showLeftShadow && this.showTopShadow) {
                point.setLocation(n, n2);
            } else if (!this.showLeftShadow && this.showTopShadow) {
                point.setLocation(n + this.shadowSize, n2);
            }
        }
        Point point2 = null;
        if (this.showLeftShadow || this.showBottomShadow) {
            point2 = new Point();
            if (this.showLeftShadow && !this.showBottomShadow) {
                point2.setLocation(n, n2 + n4 - this.shadowSize - this.shadowSize);
            } else if (this.showLeftShadow && this.showBottomShadow) {
                point2.setLocation(n, n2 + n4 - this.shadowSize);
            } else if (!this.showLeftShadow && this.showBottomShadow) {
                point2.setLocation(n + this.shadowSize, n2 + n4 - this.shadowSize);
            }
        }
        Point point3 = null;
        if (this.showRightShadow || this.showBottomShadow) {
            point3 = new Point();
            if (this.showRightShadow && !this.showBottomShadow) {
                point3.setLocation(n + n3 - this.shadowSize, n2 + n4 - this.shadowSize - this.shadowSize);
            } else if (this.showRightShadow && this.showBottomShadow) {
                point3.setLocation(n + n3 - this.shadowSize, n2 + n4 - this.shadowSize);
            } else if (!this.showRightShadow && this.showBottomShadow) {
                point3.setLocation(n + n3 - this.shadowSize - this.shadowSize, n2 + n4 - this.shadowSize);
            }
        }
        Point point4 = null;
        if (this.showRightShadow || this.showTopShadow) {
            point4 = new Point();
            if (this.showRightShadow && !this.showTopShadow) {
                point4.setLocation(n + n3 - this.shadowSize, n2 + this.shadowSize);
            } else if (this.showRightShadow && this.showTopShadow) {
                point4.setLocation(n + n3 - this.shadowSize, n2);
            } else if (!this.showRightShadow && this.showTopShadow) {
                point4.setLocation(n + n3 - this.shadowSize - this.shadowSize, n2);
            }
        }
        if (this.showLeftShadow) {
            rectangle = new Rectangle(n, (int)(point.getY() + (double)this.shadowSize), this.shadowSize, (int)(point2.getY() - point.getY() - (double)this.shadowSize));
            graphics2D.drawImage(map.get((Object)Position.LEFT).getScaledInstance(rectangle.width, rectangle.height, 2), rectangle.x, rectangle.y, null);
        }
        if (this.showBottomShadow) {
            rectangle = new Rectangle((int)(point2.getX() + (double)this.shadowSize), n2 + n4 - this.shadowSize, (int)(point3.getX() - point2.getX() - (double)this.shadowSize), this.shadowSize);
            graphics2D.drawImage(map.get((Object)Position.BOTTOM).getScaledInstance(rectangle.width, rectangle.height, 2), rectangle.x, rectangle.y, null);
        }
        if (this.showRightShadow) {
            rectangle = new Rectangle(n + n3 - this.shadowSize, (int)(point4.getY() + (double)this.shadowSize), this.shadowSize, (int)(point3.getY() - point4.getY() - (double)this.shadowSize));
            graphics2D.drawImage(map.get((Object)Position.RIGHT).getScaledInstance(rectangle.width, rectangle.height, 2), rectangle.x, rectangle.y, null);
        }
        if (this.showTopShadow) {
            rectangle = new Rectangle((int)point.getX() + this.shadowSize, n2, (int)(point4.getX() - point.getX() - (double)this.shadowSize), this.shadowSize);
            graphics2D.drawImage(map.get((Object)Position.TOP).getScaledInstance(rectangle.width, rectangle.height, 2), rectangle.x, rectangle.y, null);
        }
        if (this.showLeftShadow || this.showTopShadow) {
            graphics2D.drawImage(map.get((Object)Position.TOP_LEFT), null, (int)point.getX(), (int)point.getY());
        }
        if (this.showLeftShadow || this.showBottomShadow) {
            graphics2D.drawImage(map.get((Object)Position.BOTTOM_LEFT), null, (int)point2.getX(), (int)point2.getY());
        }
        if (this.showRightShadow || this.showBottomShadow) {
            graphics2D.drawImage(map.get((Object)Position.BOTTOM_RIGHT), null, (int)point3.getX(), (int)point3.getY());
        }
        if (this.showRightShadow || this.showTopShadow) {
            graphics2D.drawImage(map.get((Object)Position.TOP_RIGHT), null, (int)point4.getX(), (int)point4.getY());
        }
    }

    private Map<Position, BufferedImage> getImages(Graphics2D graphics2D) {
        Map<Position, BufferedImage> map = CACHE.get(this.shadowSize);
        if (map == null) {
            map = new HashMap<Position, BufferedImage>();
            int n = this.cornerSize + 1;
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n, n, this.cornerSize, this.cornerSize);
            int n2 = n + this.shadowSize * 2;
            BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D2.setColor(new Color(0.0f, 0.0f, 0.0f, this.shadowOpacity));
            graphics2D2.translate(this.shadowSize, this.shadowSize);
            graphics2D2.fill(double_);
            float f = 1.0f / (float)(this.shadowSize * this.shadowSize);
            float[] fArray = new float[this.shadowSize * this.shadowSize];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = f;
            }
            ConvolveOp convolveOp = new ConvolveOp(new Kernel(this.shadowSize, this.shadowSize, fArray));
            BufferedImage bufferedImage2 = new BufferedImage(n2, n2, 2);
            ((Graphics2D)bufferedImage2.getGraphics()).drawImage(bufferedImage, convolveOp, -(this.shadowSize / 2), -(this.shadowSize / 2));
            int n3 = 1;
            int n4 = 1;
            int n5 = this.shadowSize;
            int n6 = this.shadowSize;
            map.put(Position.TOP_LEFT, bufferedImage2.getSubimage(n3, n4, n5, n6));
            n3 = 1;
            n4 = n6;
            n5 = this.shadowSize;
            n6 = 1;
            map.put(Position.LEFT, bufferedImage2.getSubimage(n3, n4, n5, n6));
            n3 = 1;
            n4 = n;
            n5 = this.shadowSize;
            n6 = this.shadowSize;
            map.put(Position.BOTTOM_LEFT, bufferedImage2.getSubimage(n3, n4, n5, n6));
            n3 = this.cornerSize + 1;
            n4 = n;
            n5 = 1;
            n6 = this.shadowSize;
            map.put(Position.BOTTOM, bufferedImage2.getSubimage(n3, n4, n5, n6));
            n4 = n3 = n;
            n5 = this.shadowSize;
            n6 = this.shadowSize;
            map.put(Position.BOTTOM_RIGHT, bufferedImage2.getSubimage(n3, n4, n5, n6));
            n3 = n;
            n4 = this.cornerSize + 1;
            n5 = this.shadowSize;
            n6 = 1;
            map.put(Position.RIGHT, bufferedImage2.getSubimage(n3, n4, n5, n6));
            n3 = n;
            n4 = 1;
            n5 = this.shadowSize;
            n6 = this.shadowSize;
            map.put(Position.TOP_RIGHT, bufferedImage2.getSubimage(n3, n4, n5, n6));
            n3 = this.shadowSize;
            n4 = 1;
            n5 = 1;
            n6 = this.shadowSize;
            map.put(Position.TOP, bufferedImage2.getSubimage(n3, n4, n5, n6));
            graphics2D2.dispose();
            bufferedImage.flush();
        }
        return map;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        int n = this.showTopShadow ? this.lineWidth + this.shadowSize : this.lineWidth;
        int n2 = this.showLeftShadow ? this.lineWidth + this.shadowSize : this.lineWidth;
        int n3 = this.showBottomShadow ? this.lineWidth + this.shadowSize : this.lineWidth;
        int n4 = this.showRightShadow ? this.lineWidth + this.shadowSize : this.lineWidth;
        return new Insets(n, n2, n3, n4);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public boolean isShowTopShadow() {
        return this.showTopShadow;
    }

    public boolean isShowLeftShadow() {
        return this.showLeftShadow;
    }

    public boolean isShowRightShadow() {
        return this.showRightShadow;
    }

    public boolean isShowBottomShadow() {
        return this.showBottomShadow;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Position {
        TOP,
        TOP_LEFT,
        LEFT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        RIGHT,
        TOP_RIGHT;

    }
}

