/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.MenuElement;
import org.jdesktop.swingx.event.MessageEvent;
import org.jdesktop.swingx.event.MessageListener;
import org.jdesktop.swingx.event.MessageSource;

public class MouseMessagingHandler
extends MouseAdapter {
    private Object source;
    private MessageSource messageSource;
    private MessageListener messageListener;

    public MouseMessagingHandler(Object object, MessageSource messageSource) {
        this.setSource(object);
        this.setMessageSource(messageSource);
    }

    public MouseMessagingHandler(Object object, MessageListener messageListener) {
        this.setSource(object);
        this.setMessageListener(messageListener);
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.fireMessage("");
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton;
        Action action;
        if (mouseEvent.getSource() instanceof AbstractButton && (action = (abstractButton = (AbstractButton)mouseEvent.getSource()).getAction()) != null) {
            this.fireMessage((String)action.getValue("LongDescription"));
        }
    }

    public void registerListeners(MenuElement[] menuElementArray) {
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] instanceof AbstractButton) {
                ((AbstractButton)((Object)menuElementArray[i])).addMouseListener(this);
            }
            this.registerListeners(menuElementArray[i].getSubElements());
        }
    }

    public void unregisterListeners(MenuElement[] menuElementArray) {
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] instanceof AbstractButton) {
                ((AbstractButton)((Object)menuElementArray[i])).removeMouseListener(this);
            }
            this.unregisterListeners(menuElementArray[i].getSubElements());
        }
    }

    public void registerListeners(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            componentArray[i].addMouseListener(this);
        }
    }

    public void unregisterListeners(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            componentArray[i].removeMouseListener(this);
        }
    }

    private void fireMessage(String string) {
        MessageEvent messageEvent = new MessageEvent(this.source, string, Level.FINE);
        if (this.messageListener != null) {
            this.messageListener.message(messageEvent);
        }
        if (this.messageSource != null) {
            MessageListener[] messageListenerArray = this.messageSource.getMessageListeners();
            for (int i = 0; i < messageListenerArray.length; ++i) {
                messageListenerArray[i].message(messageEvent);
            }
        }
    }
}

