/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.swingx.JXPanel;

public class JXGlassBox
extends JXPanel {
    private static final int SHOW_DELAY = 30;
    private static final int TIMER_INCREMENT = 10;
    private float alphaStart = 0.01f;
    private float alphaEnd = 0.8f;
    private Timer animateTimer;
    private float alphaIncrement = 0.02f;
    private boolean dismissOnClick = false;
    private MouseAdapter dismissListener = null;

    public JXGlassBox() {
        this.setOpaque(false);
        this.setAlpha(this.alphaStart);
        this.setBackground(Color.white);
        this.setDismissOnClick(true);
        this.animateTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXGlassBox.this.setAlpha(JXGlassBox.this.getAlpha() + JXGlassBox.this.alphaIncrement);
            }
        });
    }

    public JXGlassBox(float f) {
        this();
        this.setAlpha(f);
    }

    public void setAlpha(float f) {
        super.setAlpha(f);
        this.alphaIncrement = (this.alphaEnd - this.alphaStart) / 3.0f;
    }

    public void setDismissOnClick(boolean bl) {
        boolean bl2 = this.dismissOnClick;
        this.dismissOnClick = bl;
        if (bl && !bl2) {
            if (this.dismissListener == null) {
                this.dismissListener = new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        JXGlassBox jXGlassBox = JXGlassBox.this;
                        JComponent jComponent = (JComponent)jXGlassBox.getParent();
                        Container container = jComponent.getTopLevelAncestor();
                        jComponent.remove(jXGlassBox);
                        container.validate();
                        container.repaint();
                    }
                };
            }
            this.addMouseListener(this.dismissListener);
        } else if (!bl && bl2) {
            this.removeMouseListener(this.dismissListener);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.animateTimer.isRunning() && this.getAlpha() < this.alphaEnd) {
            this.animateTimer.start();
        }
        if (this.animateTimer.isRunning() && this.getAlpha() >= this.alphaEnd) {
            this.animateTimer.stop();
        }
    }

    public void setVisible(boolean bl) {
        this.setAlpha(this.alphaStart);
        super.setVisible(bl);
    }

    private Container getTopLevel() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
        }
        return container;
    }

    public void showOnGlassPane(Container container, Component component, int n, int n2, int n3) {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = container.getSize();
        Rectangle rectangle = component.getBounds();
        int n4 = 0;
        int n5 = 0;
        int n6 = Math.min(dimension.width, dimension2.width);
        int n7 = Math.min(dimension.height, dimension2.height);
        Point point = SwingUtilities.convertPoint(component.getParent(), rectangle.x, rectangle.y, container);
        if (n3 == 1) {
            n4 = point.x + n + n6 <= dimension2.width ? point.x + n : dimension2.width - n6;
            n5 = point.y - n7;
            if (n5 < 0) {
                n5 = point.y + rectangle.height <= dimension2.height ? point.y + rectangle.height : 0;
            }
        }
        container.setLayout(null);
        this.setBounds(n4, n5, n6, n7);
        container.add(this);
        container.setVisible(true);
        Container container2 = this.getTopLevel();
        container2.validate();
        container2.repaint();
    }

    public void showOnGlassPane(Container container, int n, int n2) {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = container.getSize();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n5 = Math.min(dimension.width, dimension2.width);
        n6 = Math.min(dimension.height, dimension2.height);
        n4 = n2 - n6 >= 0 ? n2 - n6 : (n2 + n6 <= dimension2.height ? n2 : dimension2.height - n6);
        n3 = n + n5 <= dimension2.width ? n : (n >= n5 ? n - n5 : dimension2.width - n5);
        container.setLayout(null);
        this.setBounds(n3, n4, n5, n6);
        container.add(this);
        container.setVisible(true);
        Container container2 = this.getTopLevel();
        container2.validate();
        container2.repaint();
    }
}

