/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.LinkModel;

public class EditorPaneLinkVisitor
implements ActionListener {
    private JXEditorPane editorPane;
    private HyperlinkListener hyperlinkListener;
    private LinkModel internalLink;

    public EditorPaneLinkVisitor() {
        this(null);
    }

    public EditorPaneLinkVisitor(JXEditorPane jXEditorPane) {
        if (this.editorPane != null) {
            this.editorPane.removeHyperlinkListener(this.getHyperlinkListener());
        }
        if (jXEditorPane == null) {
            jXEditorPane = this.createDefaultEditorPane();
        }
        this.editorPane = jXEditorPane;
        jXEditorPane.addHyperlinkListener(this.getHyperlinkListener());
    }

    public JXEditorPane getOutputComponent() {
        return this.editorPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof LinkModel) {
            final LinkModel linkModel = (LinkModel)actionEvent.getSource();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorPaneLinkVisitor.this.visit(linkModel);
                }
            });
        }
    }

    public void visit(LinkModel linkModel) {
        try {
            this.editorPane.getDocument().putProperty("stream", null);
            this.editorPane.setPage(linkModel.getURL());
            linkModel.setVisited(true);
        }
        catch (IOException iOException) {
            this.editorPane.setText("<html>Error 404: couldn't show " + linkModel.getURL() + " </html>");
        }
    }

    protected JXEditorPane createDefaultEditorPane() {
        JXEditorPane jXEditorPane = new JXEditorPane();
        jXEditorPane.setEditable(false);
        jXEditorPane.setContentType("text/html");
        return jXEditorPane;
    }

    protected HyperlinkListener getHyperlinkListener() {
        if (this.hyperlinkListener == null) {
            this.hyperlinkListener = this.createHyperlinkListener();
        }
        return this.hyperlinkListener;
    }

    protected HyperlinkListener createHyperlinkListener() {
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (HyperlinkEvent.EventType.ACTIVATED == hyperlinkEvent.getEventType()) {
                    EditorPaneLinkVisitor.this.visitInternal(hyperlinkEvent.getURL());
                }
            }
        };
        return hyperlinkListener;
    }

    protected LinkModel getInternalLink() {
        if (this.internalLink == null) {
            this.internalLink = new LinkModel("internal");
        }
        return this.internalLink;
    }

    protected void visitInternal(URL uRL) {
        try {
            this.getInternalLink().setURL(uRL);
            this.visit(this.getInternalLink());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

