/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingworker;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AccumulativeRunnable<T>
implements Runnable {
    private List<T> arguments = null;
    private Class<?> componentType = null;

    AccumulativeRunnable() {
    }

    protected abstract void run(T ... var1);

    @Override
    public final void run() {
        this.run(this.flush());
    }

    public final synchronized void add(T ... TArray2) {
        if (this.componentType == null) {
            this.componentType = TArray2.getClass().getComponentType();
        }
        boolean bl = true;
        if (this.arguments == null) {
            bl = false;
            this.arguments = new ArrayList<T>();
        }
        Collections.addAll(this.arguments, TArray2);
        if (!bl) {
            this.submit();
        }
    }

    protected void submit() {
        SwingUtilities.invokeLater(this);
    }

    private final synchronized T[] flush() {
        List<Object> list = this.arguments;
        this.arguments = null;
        if (this.componentType == null) {
            this.componentType = Object.class;
        }
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, list.size());
        list.toArray(objectArray);
        return objectArray;
    }
}

