/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.provider.sql;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.swing.SwingUtilities;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataProvider;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.event.TableChangeEvent;
import org.jdesktop.dataset.provider.LoadTask;
import org.jdesktop.dataset.provider.SaveTask;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class WebRowSetDataProvider
extends DataProvider {
    private static final Logger LOG = Logger.getLogger(WebRowSetDataProvider.class.getName());
    private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    private URL url;
    private Runnable completionRunnable;
    private Runnable metadataCompleteRunnable;

    protected SaveTask createSaveTask(DataTable[] dataTableArray) {
        return new SaveTask(dataTableArray){

            protected void saveData(DataTable[] dataTableArray) throws Exception {
            }
        };
    }

    protected LoadTask createLoadTask(DataTable[] dataTableArray) {
        return new LoadTask(dataTableArray){

            protected void loadData(LoadTask.LoadItem[] loadItemArray) {
                for (LoadTask.LoadItem loadItem : loadItemArray) {
                    DataTable dataTable = loadItem.table;
                    List list = (List)loadItem.data;
                    for (RowLoadItem rowLoadItem : list) {
                        DataRow dataRow = dataTable.appendRowNoEvent();
                        List<DataColumn> list2 = dataTable.getColumns();
                        for (int i = 0; i < rowLoadItem.values.length; ++i) {
                            try {
                                dataRow.setValue(list2.get(i).getName(), rowLoadItem.values[i]);
                                continue;
                            }
                            catch (Exception exception) {
                                LOG.log(Level.FINE, "{0}", rowLoadItem.values.length);
                            }
                        }
                        dataRow.setStatus(rowLoadItem.status);
                        loadItem.table.fireDataTableChanged(TableChangeEvent.newRowAddedEvent(loadItem.table, dataRow));
                    }
                    loadItem.table.fireDataTableChanged(TableChangeEvent.newLoadCompleteEvent(loadItem.table));
                }
            }

            protected void readData(DataTable[] dataTableArray) throws Exception {
                try {
                    for (int i = 0; i < dataTableArray.length; ++i) {
                        InputStream inputStream = WebRowSetDataProvider.this.url.openStream();
                        this.readXml(new InputStreamReader(inputStream), dataTableArray[i]);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Error", exception);
                }
            }

            public void doLoad(DataTable dataTable, List list) {
                super.scheduleLoad(new LoadTask.LoadItem<List>(dataTable, list));
            }

            public void readXml(Reader reader, DataTable dataTable) throws SQLException {
                try {
                    WebRowSetXMLHandler webRowSetXMLHandler = new WebRowSetXMLHandler(dataTable);
                    SAXParser sAXParser = FACTORY.newSAXParser();
                    XMLReader xMLReader = sAXParser.getXMLReader();
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", webRowSetXMLHandler);
                    sAXParser.parse(new InputSource(reader), (DefaultHandler)webRowSetXMLHandler);
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Error", exception);
                    throw new SQLException("Error while parsing a the xml document for a WebRowSetDataProvider");
                }
            }

            class WebRowSetXMLHandler
            extends DefaultHandler
            implements LexicalHandler {
                DataTable table;
                private List dataToLoad = new LinkedList();
                private Stack<String> tagStack = new Stack();
                private boolean inProperties = false;
                private boolean inMetaData = false;
                private boolean inData = false;
                private RowSetMetaData metaData = null;
                private int columnIndex = 1;
                private Stack<Integer> keyColumnsStack = new Stack();
                private String mapType;
                private String mapClass;
                private Map<String, Class<?>> typeMap = new HashMap();
                private String data;
                private boolean wasNull;
                private String tableName = "";
                private Object[] rowValues;
                private int currentRow = 0;

                public WebRowSetXMLHandler(DataTable dataTable) {
                    this.table = dataTable;
                }

                public void comment(char[] cArray, int n, int n2) throws SAXException {
                }

                public void startCDATA() throws SAXException {
                }

                public void endCDATA() throws SAXException {
                }

                public void startEntity(String string) throws SAXException {
                }

                public void endEntity(String string) throws SAXException {
                }

                public void startDTD(String string, String string2, String string3) throws SAXException {
                }

                public void endDTD() throws SAXException {
                }

                public void characters(char[] cArray, int n, int n2) throws SAXException {
                    this.data = this.data == null ? new String(cArray, n, n2) : this.data + new String(cArray, n, n2);
                    this.data = this.data.trim();
                }

                private void setValue(int n, String string) throws Exception {
                    if (this.wasNull || string == null) {
                        this.rowValues[n - 1] = null;
                    } else {
                        switch (this.metaData.getColumnType(n)) {
                            case -6: {
                                this.rowValues[n - 1] = Byte.valueOf(string.trim());
                                break;
                            }
                            case 5: {
                                this.rowValues[n - 1] = Short.valueOf(string.trim());
                                break;
                            }
                            case 4: {
                                this.rowValues[n - 1] = Integer.valueOf(string.trim());
                                break;
                            }
                            case -5: {
                                this.rowValues[n - 1] = Long.valueOf(string.trim());
                                break;
                            }
                            case 7: {
                                this.rowValues[n - 1] = Float.valueOf(string.trim());
                                break;
                            }
                            case 6: 
                            case 8: {
                                this.rowValues[n - 1] = Double.valueOf(string.trim());
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.rowValues[n - 1] = new BigDecimal(string.trim());
                                break;
                            }
                            case -7: 
                            case 16: {
                                this.rowValues[n - 1] = Boolean.valueOf(string.trim());
                                break;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                this.rowValues[n - 1] = string;
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                byte[] byArray = Base64.decode(string);
                                this.rowValues[n - 1] = byArray;
                                break;
                            }
                            case 91: 
                            case 92: 
                            case 93: {
                                this.rowValues[n - 1] = new Timestamp(Long.parseLong(string.trim()));
                                break;
                            }
                            case 70: 
                            case 1111: 
                            case 2000: 
                            case 2001: 
                            case 2002: 
                            case 2003: 
                            case 2004: 
                            case 2005: 
                            case 2006: {
                                break;
                            }
                        }
                    }
                }

                public void endDocument() throws SAXException {
                    this.doLoad(this.table, this.dataToLoad);
                    if (WebRowSetDataProvider.this.completionRunnable != null) {
                        SwingUtilities.invokeLater(WebRowSetDataProvider.this.completionRunnable);
                    }
                }

                public void endElement(String string, String string2, String string3) throws SAXException {
                    if (this.tagStack.size() == 0) {
                        return;
                    }
                    String string4 = this.tagStack.pop();
                    try {
                        if (string4.equals("null")) {
                            this.wasNull = true;
                        } else if (string4.equals("columnvalue")) {
                            this.setValue(this.columnIndex++, this.wasNull ? null : this.data);
                        } else if (string4.equals("updatevalue")) {
                            this.setValue(this.columnIndex - 1, this.wasNull ? null : this.data);
                        } else if (string4.equals("currentrow")) {
                            RowLoadItem rowLoadItem = new RowLoadItem();
                            rowLoadItem.values = new Object[this.rowValues.length];
                            System.arraycopy(this.rowValues, 0, rowLoadItem.values, 0, this.rowValues.length);
                            rowLoadItem.status = DataRow.DataRowStatus.UNCHANGED;
                            this.dataToLoad.add(rowLoadItem);
                        } else if (string4.equals("insertrow")) {
                            RowLoadItem rowLoadItem = new RowLoadItem();
                            rowLoadItem.values = new Object[this.rowValues.length];
                            System.arraycopy(this.rowValues, 0, rowLoadItem.values, 0, this.rowValues.length);
                            rowLoadItem.status = DataRow.DataRowStatus.INSERTED;
                        } else if (string4.equals("deleterow")) {
                            RowLoadItem rowLoadItem = new RowLoadItem();
                            rowLoadItem.values = new Object[this.rowValues.length];
                            System.arraycopy(this.rowValues, 0, rowLoadItem.values, 0, this.rowValues.length);
                            rowLoadItem.status = DataRow.DataRowStatus.DELETED;
                        } else if (string4.equals("modifyrow")) {
                            RowLoadItem rowLoadItem = new RowLoadItem();
                            rowLoadItem.values = new Object[this.rowValues.length];
                            System.arraycopy(this.rowValues, 0, rowLoadItem.values, 0, this.rowValues.length);
                            rowLoadItem.status = DataRow.DataRowStatus.UPDATED;
                        } else if (string4.equals("column")) {
                            if (!this.wasNull) {
                                this.keyColumnsStack.push(new Integer(this.data.trim()));
                            }
                        } else if (string4.equals("type")) {
                            this.mapType = this.wasNull ? null : this.data;
                        } else if (string4.equals("class")) {
                            this.mapClass = this.wasNull ? null : this.data;
                            this.typeMap.put(this.mapType, this.mapClass == null ? null : Class.forName(this.mapClass));
                        } else if (string4.equals("table-name")) {
                            if (!this.inProperties && this.inMetaData) {
                                this.metaData.setTableName(this.columnIndex, this.wasNull ? null : this.data);
                            }
                        } else if (string4.equals("column-count")) {
                            this.metaData.setColumnCount(this.wasNull ? 0 : Integer.parseInt(this.data.trim()));
                        } else if (string4.equals("column-index")) {
                            this.columnIndex = Integer.parseInt(this.data.trim());
                        } else if (string4.equals("key-columns")) {
                            int[] nArray = new int[this.keyColumnsStack.size()];
                            int n = 0;
                            for (Integer n2 : this.keyColumnsStack) {
                                nArray[n++] = n2;
                            }
                        } else if (!string4.equals("map")) {
                            if (string4.equals("auto-increment")) {
                                this.metaData.setAutoIncrement(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data));
                            } else if (string4.equals("case-sensitive")) {
                                this.metaData.setCaseSensitive(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data));
                            } else if (string4.equals("currency")) {
                                this.metaData.setCurrency(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data.trim()));
                            } else if (string4.equals("nullable")) {
                                this.metaData.setNullable(this.columnIndex, this.wasNull ? 0 : Integer.parseInt(this.data.trim()));
                            } else if (string4.equals("signed")) {
                                this.metaData.setSigned(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data.trim()));
                            } else if (string4.equals("searchable")) {
                                this.metaData.setSearchable(this.columnIndex, this.wasNull ? false : Boolean.parseBoolean(this.data.trim()));
                            } else if (string4.equals("column-display-size")) {
                                this.metaData.setColumnDisplaySize(this.columnIndex, this.wasNull ? 255 : Integer.parseInt(this.data.trim()));
                            } else if (string4.equals("column-label")) {
                                this.metaData.setColumnLabel(this.columnIndex, this.wasNull ? null : this.data);
                            } else if (string4.equals("column-name")) {
                                this.metaData.setColumnName(this.columnIndex, this.data);
                            } else if (string4.equals("schema-name")) {
                                this.metaData.setSchemaName(this.columnIndex, this.wasNull ? null : this.data);
                            } else if (string4.equals("column-precision")) {
                                this.metaData.setPrecision(this.columnIndex, this.wasNull ? 0 : Integer.parseInt(this.data.trim()));
                            } else if (string4.equals("column-scale")) {
                                this.metaData.setScale(this.columnIndex, this.wasNull ? 0 : Integer.parseInt(this.data.trim()));
                            } else if (string4.equals("catalog-name")) {
                                this.metaData.setCatalogName(this.columnIndex, this.wasNull ? null : this.data);
                            } else if (string4.equals("column-type")) {
                                this.metaData.setColumnType(this.columnIndex, this.wasNull ? 12 : Integer.parseInt(this.data.trim()));
                            } else if (string4.equals("column-type-name")) {
                                this.metaData.setColumnTypeName(this.columnIndex, this.wasNull ? null : this.data);
                            } else if (string4.equals("metadata")) {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        DataColumn[] dataColumnArray;
                                        WebRowSetXMLHandler.this.table.clear();
                                        for (DataColumn dataColumn : dataColumnArray = WebRowSetXMLHandler.this.table.getColumns().toArray(new DataColumn[WebRowSetXMLHandler.this.table.getColumns().size()])) {
                                            WebRowSetXMLHandler.this.table.dropColumn(dataColumn.getName());
                                        }
                                        try {
                                            block17: for (int i = 0; i < WebRowSetXMLHandler.this.metaData.getColumnCount(); ++i) {
                                                DataColumn dataColumn = WebRowSetXMLHandler.this.table.createColumn(WebRowSetXMLHandler.this.metaData.getColumnName(i + 1));
                                                switch (WebRowSetXMLHandler.this.metaData.getColumnType(i + 1)) {
                                                    case -6: {
                                                        dataColumn.setType(Byte.class);
                                                        continue block17;
                                                    }
                                                    case 5: {
                                                        dataColumn.setType(Short.class);
                                                        continue block17;
                                                    }
                                                    case 4: {
                                                        dataColumn.setType(Integer.class);
                                                        continue block17;
                                                    }
                                                    case -5: {
                                                        dataColumn.setType(BigInteger.class);
                                                        continue block17;
                                                    }
                                                    case 7: {
                                                        dataColumn.setType(Float.class);
                                                        continue block17;
                                                    }
                                                    case 6: 
                                                    case 8: {
                                                        dataColumn.setType(Double.class);
                                                        continue block17;
                                                    }
                                                    case 2: 
                                                    case 3: {
                                                        dataColumn.setType(BigDecimal.class);
                                                        continue block17;
                                                    }
                                                    case -7: 
                                                    case 16: {
                                                        dataColumn.setType(Boolean.class);
                                                        continue block17;
                                                    }
                                                    case -1: 
                                                    case 1: 
                                                    case 12: {
                                                        dataColumn.setType(String.class);
                                                        continue block17;
                                                    }
                                                    case -4: 
                                                    case -3: 
                                                    case -2: {
                                                        dataColumn.setType(Byte[].class);
                                                        continue block17;
                                                    }
                                                    case 91: 
                                                    case 92: 
                                                    case 93: {
                                                        dataColumn.setType(Timestamp.class);
                                                        continue block17;
                                                    }
                                                    case 70: 
                                                    case 1111: 
                                                    case 2000: 
                                                    case 2001: 
                                                    case 2002: 
                                                    case 2003: 
                                                    case 2004: 
                                                    case 2005: 
                                                    case 2006: {
                                                        continue block17;
                                                    }
                                                }
                                            }
                                        }
                                        catch (Exception exception) {
                                            LOG.log(Level.WARNING, "Error", exception);
                                        }
                                    }
                                });
                                if (WebRowSetDataProvider.this.metadataCompleteRunnable != null) {
                                    SwingUtilities.invokeLater(WebRowSetDataProvider.this.metadataCompleteRunnable);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, "Error", exception);
                    }
                    this.data = null;
                    if (this.dataToLoad.size() >= 100) {
                        this.doLoad(this.table, this.dataToLoad);
                        this.dataToLoad = new LinkedList();
                    }
                }

                public void startDocument() throws SAXException {
                }

                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    this.wasNull = false;
                    String string4 = string3.toLowerCase();
                    this.tagStack.push(string4);
                    try {
                        if (string4.equals("properties")) {
                            this.inProperties = true;
                            this.inMetaData = false;
                            this.inData = false;
                        } else if (string4.equals("metadata")) {
                            this.inProperties = false;
                            this.inMetaData = true;
                            this.inData = false;
                            this.metaData = new RowSetMetaDataImpl();
                        } else if (string4.equals("data")) {
                            this.inProperties = false;
                            this.inMetaData = false;
                            this.inData = true;
                            this.rowValues = new Object[this.metaData.getColumnCount()];
                        } else if (string4.equals("currentrow")) {
                            this.columnIndex = 1;
                            this.reinitRowValues();
                            ++this.currentRow;
                        } else if (string4.equals("insertrow")) {
                            this.columnIndex = 1;
                            this.reinitRowValues();
                            ++this.currentRow;
                        } else if (string4.equals("deleterow")) {
                            this.columnIndex = 1;
                            this.reinitRowValues();
                            ++this.currentRow;
                        } else if (string4.equals("modifyrow")) {
                            this.columnIndex = 1;
                            this.reinitRowValues();
                            ++this.currentRow;
                        }
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, "Error", exception);
                    }
                }

                private void reinitRowValues() {
                    for (int i = 0; i < this.rowValues.length; ++i) {
                        this.rowValues[i] = null;
                    }
                }
            }
        };
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public Runnable getCompletionRunnable() {
        return this.completionRunnable;
    }

    public void setCompletionRunnable(Runnable runnable) {
        this.completionRunnable = runnable;
    }

    public Runnable getMetadataCompleteRunnable() {
        return this.metadataCompleteRunnable;
    }

    public void setMetadataCompleteRunnable(Runnable runnable) {
        this.metadataCompleteRunnable = runnable;
    }

    static {
        FACTORY.setValidating(false);
    }

    final class RowLoadItem {
        public Object[] values;
        public DataRow.DataRowStatus status;

        RowLoadItem() {
        }
    }
}

