/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.provider.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jdesktop.dataset.DataConnection;

public class JDBCDataConnection
extends DataConnection {
    private static final Logger LOG = Logger.getLogger(JDBCDataConnection.class.getName());
    private Connection conn;
    private final Object connMutex = new String("Connection_Mutex");
    private String jndiContext;
    private String url;
    private String userName;
    private String password;
    private Properties properties;

    public JDBCDataConnection() {
    }

    public JDBCDataConnection(String string, String string2, String string3, String string4) {
        try {
            Class.forName(string);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "The driver passed to the JDBCDataConnection constructor could not be loaded. This may be due to the driver not being on the classpath", exception);
        }
        this.setUrl(string2);
        this.setUserName(string3);
        this.setPassword(string4);
    }

    public JDBCDataConnection(String string, String string2, Properties properties) {
        try {
            Class.forName(string);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "The driver passed to the JDBCDataConnection constructor could not be loaded. This may be due to the driver not being on the classpath", exception);
        }
        this.setUrl(string2);
        this.setProperties(properties);
    }

    public JDBCDataConnection(String string, String string2, String string3) {
        this.jndiContext = string;
        this.setUserName(string2);
        this.setPassword(string3);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected void connect() throws Exception {
        if (this.jndiContext != null) {
            try {
                this.connectByJNDI();
            }
            catch (Exception exception) {
                try {
                    this.connectByDriverManager();
                }
                catch (Exception exception2) {
                    throw new Exception("Failed to connect to the database", exception);
                }
            }
        } else {
            try {
                this.connectByDriverManager();
            }
            catch (Exception exception) {
                throw new Exception("Failed to connect to the database", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectByJNDI() throws Exception {
        InitialContext initialContext = new InitialContext();
        DataSource dataSource = (DataSource)initialContext.lookup(this.jndiContext);
        Object object = this.connMutex;
        synchronized (object) {
            this.conn = dataSource.getConnection(this.getUserName(), this.getPassword());
            this.conn.setTransactionIsolation(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectByDriverManager() throws Exception {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.getProperties() != null) {
                try {
                    this.conn = DriverManager.getConnection(this.getUrl(), this.getProperties());
                    this.conn.setTransactionIsolation(4);
                }
                catch (Exception exception) {
                    try {
                        this.conn = DriverManager.getConnection(this.getUrl(), this.getUserName(), this.getPassword());
                        this.conn.setTransactionIsolation(4);
                    }
                    catch (Exception exception2) {
                        this.conn = DriverManager.getConnection(this.getUrl());
                        this.conn.setTransactionIsolation(4);
                    }
                }
            } else {
                try {
                    this.conn = DriverManager.getConnection(this.getUrl(), this.getUserName(), this.getPassword());
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "Couldn't connect with the supplied user name and password. Attempting to connect annonymously.", exception);
                    this.conn = DriverManager.getConnection(this.getUrl());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() throws Exception {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(PreparedStatement preparedStatement) {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.conn != null) {
                try {
                    return preparedStatement.executeQuery();
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Failed to execute query {0}", preparedStatement);
                    LOG.log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(PreparedStatement preparedStatement) {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.conn != null) {
                try {
                    return preparedStatement.executeUpdate();
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Failed to execute update {0}", preparedStatement);
                    LOG.log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String string) throws Exception {
        Object object = this.connMutex;
        synchronized (object) {
            if (this.conn != null) {
                return this.conn.prepareStatement(string);
            }
        }
        return null;
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Failed to commit", exception);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }
}

