/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.provider;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.provider.AbstractTask;

public abstract class SaveTask
extends AbstractTask {
    private static final Logger LOG = Logger.getLogger(SaveTask.class.getName());
    private DataTable[] tables;

    public SaveTask(DataTable[] dataTableArray) {
        this.tables = dataTableArray == null ? new DataTable[]{} : dataTableArray;
    }

    public void run() {
        this.setIndeterminate(true);
        try {
            this.saveData(this.tables);
            this.setProgress(this.getMaximum());
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            LOG.log(Level.WARNING, "Failed to save data from tables {0}", Arrays.asList(this.tables));
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            this.setProgress(this.getMaximum());
        }
    }

    protected abstract void saveData(DataTable[] var1) throws Exception;

    public String getDescription() {
        return "<html><h3>Saving data</h3></html>";
    }

    public Icon getIcon() {
        return null;
    }

    public String getMessage() {
        return "Saving item " + (this.getProgress() + 1) + " of " + this.getMaximum();
    }

    public boolean cancel() throws Exception {
        return false;
    }
}

