/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.io.schema;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataRelation;
import org.jdesktop.dataset.DataRelationTable;
import org.jdesktop.dataset.DataSelector;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.DataValue;
import org.jdesktop.dataset.io.schema.DataSetIOUtility;
import org.jdesktop.dataset.io.schema.DataSetSchemaWriter;
import org.jdesktop.dataset.io.schema.SchemaWriterException;

public class XMLDataSetSchemaWriter
implements DataSetSchemaWriter {
    private PrintWriter outputPrintWriter;

    public XMLDataSetSchemaWriter(OutputStream outputStream) {
        if (!(outputStream instanceof BufferedOutputStream)) {
            outputStream = new BufferedOutputStream(outputStream);
        }
        this.outputPrintWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
    }

    public XMLDataSetSchemaWriter(Writer writer) {
        if (writer instanceof PrintWriter) {
            this.outputPrintWriter = (PrintWriter)writer;
        } else {
            if (writer instanceof BufferedWriter) {
                writer = new BufferedWriter(writer);
            }
            this.outputPrintWriter = new PrintWriter(writer);
        }
    }

    public void writeDataSet(DataSet dataSet) throws SchemaWriterException {
        this.writeXmlSchema(dataSet, "");
        this.outputPrintWriter.flush();
    }

    public void writeDataSet(DataSet dataSet, String ... stringArray) throws SchemaWriterException {
        this.writeXmlSchema(dataSet, stringArray);
        this.outputPrintWriter.flush();
    }

    private void writeXmlSchema(DataSet dataSet, String ... stringArray) {
        Object object;
        Set<String> set;
        Object object2;
        Object object3;
        PrintWriter printWriter = this.outputPrintWriter;
        boolean bl = stringArray.length == 1 && stringArray[0].length() == 0;
        printWriter.println("<?xml version=\"1.0\" standalone=\"yes\" ?>");
        printWriter.print("<xs:schema id=\"");
        printWriter.print(dataSet.getName());
        printWriter.print("\" targetNamespace=\"http://jdesktop.org/tempuri/");
        printWriter.print(dataSet.getName());
        printWriter.print(".xsd\" xmlns=\"http://javadesktop.org/tempuri/");
        printWriter.print(dataSet.getName());
        printWriter.println(".xsd\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\">");
        printWriter.print("\t<xs:element name=\"");
        printWriter.print(dataSet.getName());
        printWriter.println("\">");
        printWriter.println("\t\t<xs:complexType>");
        printWriter.println("\t\t\t<xs:choice maxOccurs=\"unbounded\">");
        Map<String, Set<String>> map = DataSetIOUtility.extractTableList(stringArray);
        for (DataTable object5 : dataSet.getTables()) {
            if (object5 instanceof DataRelationTable) continue;
            object3 = object5.getName();
            if (!bl && !map.containsKey(object3)) continue;
            printWriter.print("\t\t\t\t<xs:element name=\"");
            printWriter.print((String)object3);
            printWriter.print("\" appendRowSupported=\"");
            printWriter.print(object5.isAppendRowSupported());
            printWriter.print("\" deleteRowSupported=\"");
            printWriter.print(object5.isDeleteRowSupported());
            printWriter.println("\">");
            printWriter.println("\t\t\t\t\t<xs:complexType>");
            printWriter.println("\t\t\t\t\t\t<xs:sequence>");
            for (DataColumn dataColumn : object5.getColumns()) {
                object2 = dataColumn.getName();
                set = map.get(object3);
                if (!bl && !set.contains(object2)) continue;
                printWriter.print("\t\t\t\t\t\t\t<xs:element name=\"");
                printWriter.print(dataColumn.getName());
                printWriter.print("\" type=\"");
                if (dataColumn.getType() == String.class || dataColumn.getType() == Character.class) {
                    printWriter.print("xs:string");
                } else if (dataColumn.getType() == BigDecimal.class) {
                    printWriter.print("xs:decimal");
                } else if (dataColumn.getType() == Integer.class) {
                    printWriter.print("xs:integer");
                } else if (dataColumn.getType() == Boolean.class) {
                    printWriter.print("xs:boolean");
                } else if (dataColumn.getType() == Date.class) {
                    printWriter.print("xs:dateTime");
                } else if (dataColumn.getType() == Byte.class) {
                    printWriter.print("xs:unsignedByte");
                } else {
                    System.out.println("Couldn't find type for xsd for Class " + dataColumn.getType());
                }
                if (dataColumn.getDefaultValue() != null) {
                    printWriter.print("\" default=\"");
                    printWriter.print(dataColumn.getDefaultValue());
                }
                if (!dataColumn.isRequired()) {
                    printWriter.print("\" minOccurs=\"0");
                }
                printWriter.print("\" keyColumn=\"");
                printWriter.print(dataColumn.isKeyColumn());
                printWriter.print("\" readOnly=\"");
                printWriter.print(dataColumn.isReadOnly());
                if (dataColumn.getExpression() != null && !dataColumn.getExpression().trim().equals("")) {
                    printWriter.print("\" expression=\"");
                    printWriter.print(dataColumn.getExpression());
                }
                printWriter.println("\" />");
            }
            printWriter.println("\t\t\t\t\t\t</xs:sequence>");
            printWriter.println("\t\t\t\t\t</xs:complexType>");
            printWriter.println("\t\t\t\t</xs:element>");
        }
        printWriter.println("\t\t\t</xs:choice>");
        printWriter.println("\t\t</xs:complexType>");
        printWriter.println("\t\t<xs:annotation>");
        printWriter.println("\t\t\t<xs:appinfo>");
        for (DataRelation dataRelation : dataSet.getRelations()) {
            object3 = dataRelation.getParentColumn();
            object = dataRelation.getChildColumn();
            String string = ((DataColumn)object3).getTable().getName();
            object2 = ((DataColumn)object).getTable().getName();
            if (!bl && (!map.containsKey(string) || !map.containsKey(object2))) continue;
            set = null;
            set = map.get(string);
            if (!bl && !set.contains(((DataColumn)object3).getName())) continue;
            set = map.get(object2);
            if (!bl && !set.contains(((DataColumn)object).getName())) continue;
            printWriter.print("\t\t\t\t<dataRelation name=\"");
            printWriter.print(dataRelation.getName());
            printWriter.print("\" parentColumn=\"");
            if (object3 != null) {
                printWriter.print(((DataColumn)object3).getTable().getName());
                printWriter.print(".");
                printWriter.print(((DataColumn)object3).getName());
            }
            printWriter.print("\" childColumn=\"");
            if (object != null) {
                printWriter.print(((DataColumn)object).getTable().getName());
                printWriter.print(".");
                printWriter.print(((DataColumn)object).getName());
            }
            printWriter.println("\" />");
        }
        for (DataTable dataTable : dataSet.getTables()) {
            if (!(dataTable instanceof DataRelationTable)) continue;
            object3 = (DataRelationTable)dataTable;
            if (!bl && !map.containsKey(((DataRelationTable)object3).getParentTable().getName())) continue;
            printWriter.print("\t\t\t\t<dataRelationTable name=\"");
            printWriter.print(((DataTable)object3).getName());
            printWriter.print("\" relation=\"");
            object = ((DataRelationTable)object3).getRelation();
            printWriter.print(object == null ? "" : ((DataRelation)object).getName());
            printWriter.print("\" parentSelector=\"");
            DataSelector dataSelector = ((DataRelationTable)object3).getParentSelector();
            printWriter.print(dataSelector == null ? "" : dataSelector.getName());
            printWriter.print("\" parentTable=\"");
            object2 = ((DataRelationTable)object3).getParentTable();
            printWriter.print(object2 == null ? "" : ((DataTable)object2).getName());
            printWriter.println("\" />");
        }
        for (DataValue dataValue : dataSet.getValues()) {
            printWriter.print("\t\t\t\t<dataValue name=\"");
            printWriter.print(dataValue.getName());
            printWriter.print("\" expression=\"");
            if (dataValue.getExpression() != null) {
                printWriter.print(dataValue.getExpression());
            }
            printWriter.println("\" />");
        }
        printWriter.println("\t\t\t</xs:appinfo>");
        printWriter.println("\t\t</xs:annotation>");
        printWriter.println("\t</xs:element>");
        printWriter.println("</xs:schema>");
    }
}

