/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.event.DataTableListener;
import org.jdesktop.dataset.event.RowChangeEvent;
import org.jdesktop.dataset.event.TableChangeEvent;

public abstract class DataTableEventAdapter
implements DataTableListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(DataTableEventAdapter.class.getName());

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        LOG.log(Level.FINE, "propertyChange: {0}", propertyChangeEvent);
        if (propertyChangeEvent.getSource().getClass() == DataRow.class) {
            LOG.log(Level.FINE, "  is data row");
            DataRow dataRow = (DataRow)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getPropertyName().equals("status")) {
                LOG.log(Level.FINE, "  is status change");
                this.rowStatusChanged(RowChangeEvent.newRowStatusChangeEvent(dataRow, (DataRow.DataRowStatus)((Object)propertyChangeEvent.getOldValue())));
            }
        }
    }

    public void rowChanged(RowChangeEvent rowChangeEvent) {
        switch (rowChangeEvent.getEventType()) {
            case ROW_STATUS_CHANGED: {
                this.rowStatusChanged(rowChangeEvent);
                break;
            }
            case CELL_CHANGED: {
                this.cellChanged(rowChangeEvent);
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type on row change event " + (Object)((Object)rowChangeEvent.getEventType()));
            }
        }
    }

    public void rowStatusChanged(RowChangeEvent rowChangeEvent) {
    }

    public void cellChanged(RowChangeEvent rowChangeEvent) {
    }

    public void tableChanged(TableChangeEvent tableChangeEvent) {
        switch (tableChangeEvent.getEventType()) {
            case LOAD_STARTED: {
                this.tableLoadStarted(tableChangeEvent);
                break;
            }
            case LOAD_COMPLETE: {
                this.tableLoadComplete(tableChangeEvent);
                break;
            }
            case SAVE_STARTED: {
                this.tableSaveStarted(tableChangeEvent);
                break;
            }
            case SAVE_COMPLETE: {
                this.tableSaveComplete(tableChangeEvent);
                break;
            }
            case TABLE_CLEARED: {
                this.tableCleared(tableChangeEvent);
                break;
            }
            case ROW_ADDED: {
                this.rowAdded(tableChangeEvent);
                break;
            }
            case ROW_DELETED: {
                this.rowDeleted(tableChangeEvent);
                break;
            }
            case ROW_DISCARDED: {
                this.rowDiscarded(tableChangeEvent);
                break;
            }
            case COLUMN_ADDED: {
                this.columnAdded(tableChangeEvent);
                break;
            }
            case COLUMN_REMOVED: {
                this.columnRemoved(tableChangeEvent);
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type on row change event " + (Object)((Object)tableChangeEvent.getEventType()));
            }
        }
    }

    public void tableLoadStarted(TableChangeEvent tableChangeEvent) {
    }

    public void tableLoadComplete(TableChangeEvent tableChangeEvent) {
    }

    public void tableSaveStarted(TableChangeEvent tableChangeEvent) {
    }

    public void tableSaveComplete(TableChangeEvent tableChangeEvent) {
    }

    public void tableCleared(TableChangeEvent tableChangeEvent) {
    }

    public void rowAdded(TableChangeEvent tableChangeEvent) {
    }

    public void rowDeleted(TableChangeEvent tableChangeEvent) {
    }

    public void rowDiscarded(TableChangeEvent tableChangeEvent) {
    }

    public void columnAdded(TableChangeEvent tableChangeEvent) {
    }

    public void columnRemoved(TableChangeEvent tableChangeEvent) {
    }
}

