/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.metadata.Validator;
import org.jdesktop.binding.swingx.Binding;

public class BindingHandler {
    private List bindings;
    private boolean modified;
    private PropertyChangeSupport propertySupport;
    private PropertyChangeListener bindingListener;
    private boolean autoCommit;

    public boolean isModified() {
        return this.modified;
    }

    public void add(Binding binding) {
        if (binding == null) {
            return;
        }
        this.getBindingList().add(binding);
        binding.addPropertyChangeListener(this.getBindingListener());
    }

    public void remove(Binding binding) {
        if (binding == null) {
            return;
        }
        this.getBindingList().remove(binding);
        binding.removePropertyChangeListener(this.getBindingListener());
    }

    public void removeAll() {
        Iterator iterator = this.getBindingList().iterator();
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            binding.removePropertyChangeListener(this.getBindingListener());
            iterator.remove();
        }
        this.setModified(false);
    }

    public Binding[] getBindings() {
        if (this.bindings != null) {
            return this.bindings.toArray(new Binding[this.bindings.size()]);
        }
        return new Binding[0];
    }

    public boolean pull() {
        boolean bl = true;
        for (Binding binding : this.getBindingList()) {
            if (binding.pull()) continue;
            bl = false;
        }
        return bl;
    }

    public boolean validate() {
        Validator[] validatorArray;
        boolean bl = true;
        ArrayList<Validator[]> arrayList = new ArrayList<Validator[]>();
        for (Object object : this.getBindingList()) {
            validatorArray = object.getDataModel();
            if (!arrayList.contains(validatorArray)) {
                arrayList.add(validatorArray);
            }
            if (object.isValid()) continue;
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                object = (DataModel)arrayList.get(i);
                validatorArray = object.getValidators();
                for (int j = 0; j < validatorArray.length; ++j) {
                    String[] stringArray = new String[1];
                    if (validatorArray[j].validate(object, null, stringArray)) continue;
                    bl = false;
                }
            }
        }
        return bl;
    }

    public boolean push() {
        if (!this.validate()) {
            return false;
        }
        boolean bl = true;
        for (Binding binding : this.getBindingList()) {
            if (binding.push()) continue;
            bl = false;
        }
        return bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertySupport == null) {
            return;
        }
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.propertySupport == null) {
            return;
        }
        this.propertySupport.firePropertyChange(string, object, object2);
    }

    private PropertyChangeListener getBindingListener() {
        if (this.bindingListener == null) {
            this.bindingListener = this.createBindingListener();
        }
        return this.bindingListener;
    }

    protected PropertyChangeListener createBindingListener() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                    BindingHandler.this.updateModifiedFromBinding((Binding)propertyChangeEvent.getSource(), (Boolean)propertyChangeEvent.getNewValue());
                }
            }
        };
        return propertyChangeListener;
    }

    protected void updateModifiedFromBinding(Binding binding, boolean bl) {
        if (this.isAutoCommit() && bl) {
            this.invokePush(binding);
            return;
        }
        if (this.isModified()) {
            return;
        }
        this.setModified(this.isModified() || bl);
    }

    private void invokePush(final Binding binding) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = binding.push();
                BindingHandler.this.setModified(!bl);
            }
        });
    }

    private List getBindingList() {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        return this.bindings;
    }

    private void setModified(boolean bl) {
        boolean bl2 = this.isModified();
        this.modified = bl;
        this.firePropertyChange("modified", bl2, this.isModified());
    }

    public void setAutoCommit(boolean bl) {
        boolean bl2 = this.isAutoCommit();
        if (bl2 == bl) {
            return;
        }
        this.autoCommit = bl;
        if (bl && this.isModified()) {
            this.push();
        }
        this.firePropertyChange("autoCommit", bl2, this.isAutoCommit());
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }
}

