/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.swingx.Binding;
import org.jdesktop.binding.swingx.BindingCreator;
import org.jdesktop.binding.swingx.BooleanBinding;
import org.jdesktop.binding.swingx.ComboBoxBinding;
import org.jdesktop.binding.swingx.DatePickerBinding;
import org.jdesktop.binding.swingx.HyperlinkBinding;
import org.jdesktop.binding.swingx.ImagePanelBinding;
import org.jdesktop.binding.swingx.LabelBinding;
import org.jdesktop.binding.swingx.LabelMetaBinding;
import org.jdesktop.binding.swingx.ListBinding;
import org.jdesktop.binding.swingx.RadioBinding;
import org.jdesktop.binding.swingx.SpinnerBinding;
import org.jdesktop.binding.swingx.TableBinding;
import org.jdesktop.binding.swingx.TextBinding;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXImagePanel;
import org.jdesktop.swingx.JXRadioGroup;

public class BindingFactory {
    private Map bindingMap;
    private static BindingFactory instance;
    private LabelMetaBindingCreator metaBindingCreator;

    public static BindingFactory getInstance() {
        if (instance == null) {
            instance = new BindingFactory();
        }
        return instance;
    }

    public static void setInstance(BindingFactory bindingFactory) {
        instance = bindingFactory;
    }

    public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
        BindingCreator bindingCreator = this.getBindingCreator(jComponent);
        if (bindingCreator != null) {
            return bindingCreator.createBinding(jComponent, dataModel, string);
        }
        return null;
    }

    public Binding createMetaBinding(JLabel jLabel, DataModel dataModel, String string) {
        BindingCreator bindingCreator = this.getMetaBindingCreator();
        if (bindingCreator != null) {
            return bindingCreator.createBinding(jLabel, dataModel, string);
        }
        return null;
    }

    protected BindingCreator getMetaBindingCreator() {
        if (this.metaBindingCreator == null) {
            this.metaBindingCreator = new LabelMetaBindingCreator();
        }
        return this.metaBindingCreator;
    }

    protected BindingCreator getBindingCreator(JComponent jComponent) {
        BindingCreator bindingCreator = (BindingCreator)this.getBindingMap().get(jComponent.getClass());
        if (bindingCreator == null) {
            bindingCreator = this.findByAssignable(jComponent.getClass());
        }
        return bindingCreator;
    }

    protected BindingCreator findByAssignable(Class clazz) {
        Set set = this.getBindingMap().keySet();
        for (Class clazz2 : set) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return (BindingCreator)this.getBindingMap().get(clazz2);
        }
        return null;
    }

    protected Map getBindingMap() {
        if (this.bindingMap == null) {
            this.bindingMap = new HashMap();
            this.initBindingMap(this.bindingMap);
        }
        return this.bindingMap;
    }

    protected void initBindingMap(Map map) {
        map.put(JXHyperlink.class, new HyperlinkBindingCreator());
        map.put(JXRadioGroup.class, new RadioGroupBindingCreator());
        map.put(JLabel.class, new LabelBindingCreator());
        map.put(JCheckBox.class, new CheckBoxBindingCreator());
        TextBindingCreator textBindingCreator = new TextBindingCreator();
        map.put(JTextComponent.class, textBindingCreator);
        map.put(JComboBox.class, new ComboBoxBindingCreator());
        TableBindingCreator tableBindingCreator = new TableBindingCreator();
        map.put(JTable.class, tableBindingCreator);
        ListBindingCreator listBindingCreator = new ListBindingCreator();
        map.put(JList.class, listBindingCreator);
        map.put(JSpinner.class, new SpinnerBindingCreator());
        map.put(JXImagePanel.class, new ImagePanelBindingCreator());
        map.put(JXDatePicker.class, new DatePickerBindingCreator());
    }

    public class LabelMetaBindingCreator
    implements BindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            if (jComponent instanceof JLabel) {
                return new LabelMetaBinding((JLabel)jComponent, dataModel, string);
            }
            return null;
        }
    }

    public static class SpinnerBindingCreator
    extends RequiredBindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            SpinnerBinding spinnerBinding = new SpinnerBinding((JSpinner)jComponent, dataModel, string);
            this.doAddBindingBorder(jComponent, spinnerBinding);
            return spinnerBinding;
        }
    }

    public static class CheckBoxBindingCreator
    extends RequiredBindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            BooleanBinding booleanBinding = new BooleanBinding((JCheckBox)jComponent, dataModel, string);
            this.doAddBindingBorder(jComponent, booleanBinding);
            return booleanBinding;
        }
    }

    public static class RadioGroupBindingCreator
    extends RequiredBindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            RadioBinding radioBinding = new RadioBinding((JXRadioGroup)jComponent, dataModel, string);
            this.doAddBindingBorder(jComponent, radioBinding);
            return radioBinding;
        }
    }

    public static class ComboBoxBindingCreator
    extends RequiredBindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            ComboBoxBinding comboBoxBinding = new ComboBoxBinding((JComboBox)jComponent, dataModel, string);
            this.doAddBindingBorder(jComponent, comboBoxBinding);
            return comboBoxBinding;
        }
    }

    public static abstract class RequiredBindingCreator
    implements BindingCreator {
        protected void doAddBindingBorder(JComponent jComponent, Binding binding) {
        }
    }

    public static class DatePickerBindingCreator
    implements BindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            return new DatePickerBinding((JXDatePicker)jComponent, dataModel, string);
        }
    }

    public static class HyperlinkBindingCreator
    implements BindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            return new HyperlinkBinding((JButton)jComponent, dataModel, string);
        }
    }

    public static class ImagePanelBindingCreator
    implements BindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            return new ImagePanelBinding((JXImagePanel)jComponent, dataModel, string);
        }
    }

    public static class LabelBindingCreator
    implements BindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            return new LabelBinding((JLabel)jComponent, dataModel, string);
        }
    }

    public static class TextBindingCreator
    implements BindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            Binding binding = this.doCreateBinding((JTextComponent)jComponent, dataModel, string);
            return binding;
        }

        protected Binding doCreateBinding(JTextComponent jTextComponent, DataModel dataModel, String string) {
            TextBinding textBinding = new TextBinding(jTextComponent, dataModel, string);
            return textBinding;
        }

        protected void configureComponent(JComponent jComponent, Binding binding) {
            int n = jComponent instanceof JTextArea ? 2 : 7;
        }
    }

    public class TableBindingCreator
    implements BindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            return new TableBinding((JTable)jComponent, dataModel, string);
        }
    }

    public static class ListBindingCreator
    implements BindingCreator {
        public Binding createBinding(JComponent jComponent, DataModel dataModel, String string) {
            return new ListBinding((JList)jComponent, dataModel, string);
        }
    }
}

