/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.ValueChangeEvent;
import org.jdesktop.binding.ValueChangeListener;
import org.jdesktop.binding.metadata.ConversionException;
import org.jdesktop.binding.metadata.Converter;
import org.jdesktop.binding.metadata.MetaData;
import org.jdesktop.binding.metadata.Validator;
import org.jdesktop.binding.swingx.Binding;

public abstract class AbstractBinding
implements Binding {
    protected DataModel dataModel;
    protected MetaData metaData;
    protected String fieldName;
    protected Object cachedValue;
    protected ArrayList errorList;
    protected boolean modified = false;
    protected int validState = 0;
    protected boolean pulling = false;
    protected boolean pushing = false;
    private PropertyChangeSupport pcs;
    private int validationPolicy;
    private static final PropertyChangeListener[] EMPTY_PROPERTY_CHANGE_LISTENER_ARRAY = new PropertyChangeListener[0];

    protected AbstractBinding(JComponent jComponent, DataModel dataModel, String string, int n) {
        this.checkNull(jComponent, "component must not be null");
        this.checkNull(dataModel, "model must not be null");
        this.checkNull(string, "fieldName must not be null");
        this.installDataModel(dataModel, string);
        this.setComponent(jComponent);
        this.setValidationPolicy(n);
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setValidationPolicy(int n) {
        int n2 = this.validationPolicy;
        this.validationPolicy = n;
        this.installInputVerifier();
        if (n != n2) {
            this.firePropertyChange("validationPolicy", new Integer(n2), new Integer(n));
        }
    }

    public int getValidationPolicy() {
        return this.validationPolicy;
    }

    public boolean pull() {
        this.pulling = true;
        this.cachedValue = this.dataModel.getValue(this.metaData.getName());
        this.setComponentValue(this.cachedValue);
        this.setModified(false);
        this.setValidState(0);
        this.isValid();
        this.pulling = false;
        return true;
    }

    public boolean push() {
        if (this.isValid()) {
            this.pushing = true;
            this.dataModel.setValue(this.metaData.getName(), this.cachedValue);
            this.setModified(false);
            this.pushing = false;
            return true;
        }
        return false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isValid() {
        if (this.validState != 0) {
            return this.validState == 1;
        }
        this.clearValidationErrors();
        Object object = this.getComponentValue();
        boolean bl = this.checkRequired(object);
        Object object2 = null;
        if (bl) {
            try {
                object2 = this.convertToModelType(object);
            }
            catch (Exception exception) {
                bl = false;
                this.addError("value must be type " + this.metaData.getElementClass().getName());
            }
        }
        if (bl) {
            bl = this.executeValidators(object2);
        }
        if (bl) {
            this.cachedValue = object2;
        }
        this.setValidState(bl ? 1 : 2);
        return this.validState == 1;
    }

    public int getValidState() {
        return this.validState;
    }

    public String[] getValidationErrors() {
        if (this.errorList != null) {
            return this.errorList.toArray(new String[1]);
        }
        return new String[0];
    }

    public void clearValidationErrors() {
        if (this.errorList != null) {
            this.errorList.clear();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.pcs == null) {
            return EMPTY_PROPERTY_CHANGE_LISTENER_ARRAY;
        }
        return this.pcs.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.pcs == null) {
            return;
        }
        this.pcs.firePropertyChange(string, object, object2);
    }

    protected abstract void setComponent(JComponent var1);

    protected abstract Object getComponentValue();

    protected abstract void setComponentValue(Object var1);

    protected boolean checkRequired(Object object) {
        if (this.metaData.isRequired() && this.isEmpty(object)) {
            this.addError("requires a value");
            return false;
        }
        return true;
    }

    protected boolean isEmpty(Object object) {
        return object == null;
    }

    protected Object convertToModelType(Object object) throws ConversionException {
        Object object2 = null;
        if (this.isEmpty(object)) {
            return object2;
        }
        Class clazz = this.metaData.getElementClass();
        if (object instanceof String) {
            String string = (String)object;
            Converter converter = this.metaData.getConverter();
            if (converter != null) {
                object2 = converter.decode(string, this.metaData.getDecodeFormat());
            } else if (this.metaData.getElementClass() == String.class) {
                object2 = object;
            }
        } else {
            if (!clazz.isAssignableFrom(object.getClass())) {
                throw new ConversionException("cannot assign component value");
            }
            object2 = object;
        }
        return object2;
    }

    protected String convertFromModelType(Object object) {
        if (object != null) {
            try {
                Converter converter = this.metaData.getConverter();
                return converter.encode(object, this.metaData.getEncodeFormat());
            }
            catch (Exception exception) {
                return object.toString();
            }
        }
        return "";
    }

    protected boolean executeValidators(Object object) {
        Validator[] validatorArray = this.metaData.getValidators();
        boolean bl = true;
        for (int i = 0; i < validatorArray.length; ++i) {
            String[] stringArray = new String[1];
            boolean bl2 = validatorArray[i].validate(object, null, stringArray);
            if (bl2) continue;
            String string = stringArray[0];
            if (string != null) {
                this.addError(string);
            }
            bl = false;
        }
        return bl;
    }

    protected void addError(String string) {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
        }
        this.errorList.add(string);
    }

    protected void setModified(boolean bl) {
        boolean bl2 = this.modified;
        this.modified = bl;
        if (bl) {
            this.cachedValue = null;
            this.setValidState(0);
        }
        if (bl2 != bl) {
            this.firePropertyChange("modified", bl2, bl);
        }
    }

    protected void setValidState(int n) {
        int n2 = this.validState;
        this.validState = n;
        if (n2 != n && n == 0) {
            this.clearValidationErrors();
        }
        if (n != n2) {
            this.firePropertyChange("validState", new Integer(n2), new Integer(n));
        }
    }

    protected void installInputVerifier() {
        this.getComponent().setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                if (AbstractBinding.this.validationPolicy != 2) {
                    boolean bl = AbstractBinding.this.isValid();
                    return bl || AbstractBinding.this.validationPolicy != 1;
                }
                return true;
            }
        });
    }

    protected void checkNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    protected void installDataModel(DataModel dataModel, String string) {
        this.dataModel = dataModel;
        this.fieldName = string;
        this.metaData = dataModel.getMetaData(string);
        this.checkNull(this.metaData, "Field " + string + " does not exist in metadata");
        this.installDataModelListener();
        this.installMetaDataListener();
    }

    protected void installDataModelListener() {
        this.dataModel.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent valueChangeEvent) {
                if (valueChangeEvent.getFieldName().equals(AbstractBinding.this.fieldName) && !AbstractBinding.this.pushing) {
                    AbstractBinding.this.pull();
                }
            }
        });
    }

    protected void installMetaDataListener() {
    }
}

