/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.metadata;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jdesktop.binding.metadata.ConversionException;
import org.jdesktop.binding.metadata.Converter;

public class Converters {
    private static Map map = new HashMap();

    public static Converter get(Class clazz) {
        Object v = map.get(clazz);
        Converter converter = null;
        if (v != null) {
            if (v instanceof String) {
                try {
                    Class<?> clazz2 = Class.forName((String)v);
                    converter = (Converter)clazz2.newInstance();
                    map.put(clazz, converter);
                }
                catch (Exception exception) {
                    converter = null;
                }
            } else {
                converter = (Converter)v;
            }
        }
        return converter;
    }

    public static void put(Class clazz, Converter converter) {
        map.put(clazz, converter);
    }

    public static Class[] getTypes() {
        Set set = map.keySet();
        return set.toArray(new Class[0]);
    }

    protected Converters() {
    }

    static {
        map.put(Boolean.class, "org.jdesktop.binding.metadata.Converters$BooleanConverter");
        map.put(Date.class, "org.jdesktop.binding.metadata.Converters$DateConverter");
        map.put(Double.class, "org.jdesktop.binding.metadata.Converters$DoubleConverter");
        map.put(Float.class, "org.jdesktop.binding.metadata.Converters$FloatConverter");
        map.put(Integer.class, "org.jdesktop.binding.metadata.Converters$IntegerConverter");
        map.put(Long.class, "org.jdesktop.binding.metadata.Converters$LongConverter");
        map.put(Short.class, "org.jdesktop.binding.metadata.Converters$ShortConverter");
        map.put(String.class, "org.jdesktop.binding.metadata.Converters$StringConverter");
    }

    public static class DateConverter
    implements Converter {
        private DateFormat defaultInputFormat;
        private DateFormat defaultOutputFormat;

        public DateConverter() {
            this.defaultInputFormat = this.defaultOutputFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        }

        public DateConverter(DateFormat dateFormat, DateFormat dateFormat2) {
            this.defaultInputFormat = dateFormat;
            this.defaultOutputFormat = dateFormat2;
        }

        public String encode(Object object, Object object2) throws ConversionException {
            try {
                DateFormat dateFormat = object2 == null ? this.defaultOutputFormat : (DateFormat)object2;
                return dateFormat.format((Date)object);
            }
            catch (Exception exception) {
                throw new ConversionException(object, Date.class, (Throwable)exception);
            }
        }

        public Object decode(String string, Object object) throws ConversionException {
            try {
                DateFormat dateFormat = object == null ? this.defaultInputFormat : (DateFormat)object;
                return dateFormat.parse(string);
            }
            catch (Exception exception) {
                throw new ConversionException(string, Date.class, (Throwable)exception);
            }
        }
    }

    static class DoubleConverter
    implements Converter {
        DoubleConverter() {
        }

        public String encode(Object object, Object object2) throws ConversionException {
            try {
                Double d = (Double)object;
                return d.toString();
            }
            catch (Exception exception) {
                throw new ConversionException(object, Double.class, (Throwable)exception);
            }
        }

        public Object decode(String string, Object object) throws ConversionException {
            try {
                return Double.valueOf(string);
            }
            catch (Exception exception) {
                throw new ConversionException(string, Double.class, (Throwable)exception);
            }
        }
    }

    static class FloatConverter
    implements Converter {
        FloatConverter() {
        }

        public String encode(Object object, Object object2) throws ConversionException {
            try {
                Float f = (Float)object;
                return f.toString();
            }
            catch (Exception exception) {
                throw new ConversionException(object, Float.class, (Throwable)exception);
            }
        }

        public Object decode(String string, Object object) throws ConversionException {
            try {
                return Float.valueOf(string);
            }
            catch (Exception exception) {
                throw new ConversionException(string, Float.class, (Throwable)exception);
            }
        }
    }

    static class ShortConverter
    implements Converter {
        ShortConverter() {
        }

        public String encode(Object object, Object object2) throws ConversionException {
            try {
                int n = ((Short)object).intValue();
                int n2 = object2 == null ? 10 : (Integer)object2;
                return Integer.toString(n, n2);
            }
            catch (Exception exception) {
                throw new ConversionException(object, Short.class, (Throwable)exception);
            }
        }

        public Object decode(String string, Object object) throws ConversionException {
            try {
                int n = object == null ? 10 : (Integer)object;
                return Short.valueOf(string, n);
            }
            catch (Exception exception) {
                throw new ConversionException(string, Short.class, (Throwable)exception);
            }
        }
    }

    static class LongConverter
    implements Converter {
        LongConverter() {
        }

        public String encode(Object object, Object object2) throws ConversionException {
            try {
                long l = (Long)object;
                int n = object2 == null ? 10 : (Integer)object2;
                return Long.toString(l, n);
            }
            catch (Exception exception) {
                throw new ConversionException(object, Long.class, (Throwable)exception);
            }
        }

        public Object decode(String string, Object object) throws ConversionException {
            try {
                int n = object == null ? 10 : (Integer)object;
                return Long.valueOf(string, n);
            }
            catch (Exception exception) {
                throw new ConversionException(string, Long.class, (Throwable)exception);
            }
        }
    }

    static class IntegerConverter
    implements Converter {
        IntegerConverter() {
        }

        public String encode(Object object, Object object2) throws ConversionException {
            try {
                int n = (Integer)object;
                int n2 = object2 == null ? 10 : (Integer)object2;
                return Integer.toString(n, n2);
            }
            catch (Exception exception) {
                throw new ConversionException(object, Integer.class, (Throwable)exception);
            }
        }

        public Object decode(String string, Object object) throws ConversionException {
            try {
                int n = object == null ? 10 : (Integer)object;
                return Integer.valueOf(string, n);
            }
            catch (Exception exception) {
                throw new ConversionException(string, Integer.class, (Throwable)exception);
            }
        }
    }

    static class BooleanConverter
    implements Converter {
        BooleanConverter() {
        }

        public String encode(Object object, Object object2) throws ConversionException {
            try {
                Boolean bl = (Boolean)object;
                return bl.toString();
            }
            catch (Exception exception) {
                throw new ConversionException(object, Boolean.class, (Throwable)exception);
            }
        }

        public Object decode(String string, Object object) throws ConversionException {
            try {
                return Boolean.valueOf(string);
            }
            catch (Exception exception) {
                throw new ConversionException(string, Boolean.class, (Throwable)exception);
            }
        }
    }

    static class StringConverter
    implements Converter {
        StringConverter() {
        }

        public String encode(Object object, Object object2) throws ConversionException {
            if (object != null && object instanceof String) {
                return (String)object;
            }
            throw new ConversionException(object, String.class);
        }

        public Object decode(String string, Object object) throws ConversionException {
            try {
                return string.toString();
            }
            catch (Exception exception) {
                throw new ConversionException(string, String.class, (Throwable)exception);
            }
        }
    }
}

