/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.wbxml;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.wbxml.WBXMLParser;
import org.freehep.wbxml.WBXMLTagWriter;

public class WBXMLWriter
implements WBXMLTagWriter {
    private DataOutputStream os;
    private String dtd;
    private String version;
    private boolean writtenHeader;
    private int tagPage;
    private int attributePage;
    private boolean hasAttributes;
    private int[] attributeTypes;
    private boolean[][] attributeBoolean;
    private int[] attributeBooleanOffset;
    private int[] attributeBooleanLength;
    private byte[][] attributeByte;
    private int[] attributeByteOffset;
    private int[] attributeByteLength;
    private char[][] attributeChar;
    private int[] attributeCharOffset;
    private int[] attributeCharLength;
    private double[][] attributeDouble;
    private int[] attributeDoubleOffset;
    private int[] attributeDoubleLength;
    private float[][] attributeFloat;
    private int[] attributeFloatOffset;
    private int[] attributeFloatLength;
    private int[][] attributeInt;
    private int[] attributeIntOffset;
    private int[] attributeIntLength;
    private long[][] attributeLong;
    private int[] attributeLongOffset;
    private int[] attributeLongLength;
    private short[][] attributeShort;
    private int[] attributeShortOffset;
    private int[] attributeShortLength;
    private String[][] attributeString;
    private int[] attributeStringOffset;
    private int[] attributeStringLength;
    private String encoding;
    private boolean standalone;

    public WBXMLWriter(OutputStream os2, int maxAttributeTagCode) throws IOException {
        this.os = os2 instanceof DataOutputStream ? (DataOutputStream)os2 : new DataOutputStream(os2);
        this.tagPage = 0;
        this.attributePage = 0;
        int len = maxAttributeTagCode + 1;
        this.attributeBoolean = new boolean[len][];
        this.attributeBooleanOffset = new int[len];
        this.attributeBooleanLength = new int[len];
        this.attributeByte = new byte[len][];
        this.attributeByteOffset = new int[len];
        this.attributeByteLength = new int[len];
        this.attributeChar = new char[len][];
        this.attributeCharOffset = new int[len];
        this.attributeCharLength = new int[len];
        this.attributeDouble = new double[len][];
        this.attributeDoubleOffset = new int[len];
        this.attributeDoubleLength = new int[len];
        this.attributeFloat = new float[len][];
        this.attributeFloatOffset = new int[len];
        this.attributeFloatLength = new int[len];
        this.attributeInt = new int[len][];
        this.attributeIntOffset = new int[len];
        this.attributeIntLength = new int[len];
        this.attributeLong = new long[len][];
        this.attributeLongOffset = new int[len];
        this.attributeLongLength = new int[len];
        this.attributeShort = new short[len][];
        this.attributeShortOffset = new int[len];
        this.attributeShortLength = new int[len];
        this.attributeString = new String[len][];
        this.attributeStringOffset = new int[len];
        this.attributeStringLength = new int[len];
        this.attributeTypes = new int[len];
        this.clearAttributes();
    }

    private void clearAttributes() {
        this.hasAttributes = false;
        for (int i = 0; i < this.attributeTypes.length; ++i) {
            this.attributeTypes[i] = -1;
        }
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void openDoc() throws IOException {
        this.openDoc("Binary/1.0", "UTF-8", false);
    }

    public void openDoc(String version, String encoding, boolean standalone) throws IOException {
        this.dtd = null;
        this.writtenHeader = false;
        this.version = version;
        this.encoding = encoding;
        this.standalone = standalone;
    }

    private void writeHeader() throws IOException {
        if (this.writtenHeader) {
            return;
        }
        if (this.dtd == null) {
            throw new IOException("DTD is missing");
        }
        this.writeByte(3);
        this.writeByte(0);
        this.writeMultiByteInt(0L);
        this.writeMultiByteInt(106L);
        int len = WBXMLParser.stringUTFLength(this.dtd) + 2 + 1;
        this.writeMultiByteInt(len += WBXMLParser.stringUTFLength(this.version) + 2 + 1);
        this.writeString(this.dtd);
        this.writeString(this.version);
        this.writtenHeader = true;
    }

    public void closeDoc() throws IOException {
    }

    public void referToDTD(String name, String pid, String ref) {
    }

    public void referToDTD(String name, String system) {
        this.dtd = name + " " + system;
    }

    public void openTag(int tag) throws IOException {
        this.writeTag(tag, true);
    }

    public void closeTag() throws IOException {
        this.writeByte(1);
    }

    public void printTag(int tag) throws IOException {
        this.writeTag(tag, false);
    }

    public void print(String text) throws IOException {
        this.writeByte(3);
        this.writeString(text);
    }

    public void printComment(String comment) throws IOException {
    }

    private void writeTag(int tag, boolean hasContent) throws IOException {
        int page;
        if (!this.writtenHeader) {
            this.writeHeader();
        }
        if ((page = tag / 59) != this.tagPage) {
            this.writeByte(0);
            this.writeByte(page);
            this.tagPage = page;
        }
        this.writeByte((tag %= 59) + 5 | (hasContent ? 64 : 0) | (this.hasAttributes ? 128 : 0));
        if (this.hasAttributes) {
            block11: for (int i = 0; i < this.attributeTypes.length; ++i) {
                if (this.attributeTypes[i] < 0) continue;
                this.writeAttribute(i);
                switch (this.attributeTypes[i]) {
                    case 0: {
                        int j;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeBooleanLength[i] * 1 + 1);
                        this.writeByte(0);
                        for (j = 0; j < this.attributeBooleanLength[i]; ++j) {
                            this.writeByte(this.attributeBoolean[i][j + this.attributeBooleanOffset[i]] ? 1 : 0);
                        }
                        continue block11;
                    }
                    case 1: {
                        int j;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeByteLength[i] * 1 + 1);
                        this.writeByte(1);
                        for (j = 0; j < this.attributeByteLength[i]; ++j) {
                            this.writeByte(this.attributeByte[i][j + this.attributeByteOffset[i]]);
                        }
                        continue block11;
                    }
                    case 2: {
                        int j;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeCharLength[i] * 2 + 1);
                        this.writeByte(2);
                        for (j = 0; j < this.attributeCharLength[i]; ++j) {
                            this.os.writeChar(this.attributeChar[i][j + this.attributeCharOffset[i]]);
                        }
                        continue block11;
                    }
                    case 3: {
                        int j;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeDoubleLength[i] * 8 + 1);
                        this.writeByte(3);
                        for (j = 0; j < this.attributeDoubleLength[i]; ++j) {
                            this.os.writeDouble(this.attributeDouble[i][j + this.attributeDoubleOffset[i]]);
                        }
                        continue block11;
                    }
                    case 4: {
                        int j;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeFloatLength[i] * 4 + 1);
                        this.writeByte(4);
                        for (j = 0; j < this.attributeFloatLength[i]; ++j) {
                            this.os.writeFloat(this.attributeFloat[i][j + this.attributeFloatOffset[i]]);
                        }
                        continue block11;
                    }
                    case 5: {
                        int j;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeIntLength[i] * 4 + 1);
                        this.writeByte(5);
                        for (j = 0; j < this.attributeIntLength[i]; ++j) {
                            this.os.writeInt(this.attributeInt[i][j + this.attributeIntOffset[i]]);
                        }
                        continue block11;
                    }
                    case 6: {
                        int j;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeLongLength[i] * 8 + 1);
                        this.writeByte(6);
                        for (j = 0; j < this.attributeLongLength[i]; ++j) {
                            this.os.writeLong(this.attributeLong[i][j + this.attributeLongOffset[i]]);
                        }
                        continue block11;
                    }
                    case 7: {
                        int j;
                        this.writeByte(195);
                        this.writeMultiByteInt(this.attributeShortLength[i] * 2 + 1);
                        this.writeByte(7);
                        for (j = 0; j < this.attributeShortLength[i]; ++j) {
                            this.os.writeShort(this.attributeShort[i][j + this.attributeShortOffset[i]]);
                        }
                        continue block11;
                    }
                    case 8: {
                        int j;
                        int length = 0;
                        for (j = 0; j < this.attributeStringLength[i]; ++j) {
                            length += WBXMLParser.stringUTFLength(this.attributeString[i][j + this.attributeStringOffset[i]]) + 2 + 1;
                        }
                        this.writeByte(195);
                        this.writeMultiByteInt(length + 1);
                        this.writeByte(8);
                        for (j = 0; j < this.attributeStringLength[i]; ++j) {
                            this.writeString(this.attributeString[i][j + this.attributeStringOffset[i]]);
                        }
                        continue block11;
                    }
                }
            }
            this.writeByte(1);
            this.clearAttributes();
        }
    }

    private void writeAttribute(int tag) throws IOException {
        int page = tag / 59;
        tag %= 59;
        if (page != this.attributePage) {
            this.writeByte(0);
            this.writeByte(page);
            this.attributePage = page;
        }
        this.writeByte(tag + 5);
    }

    public void setAttribute(int tag, String value) {
        this.setAttribute(tag, new String[]{value}, 0, 1);
    }

    public void setAttribute(int tag, String[] value, int offset, int length) {
        this.hasAttributes = true;
        this.attributeString[tag] = value;
        this.attributeStringOffset[tag] = offset;
        this.attributeStringLength[tag] = length;
        this.attributeTypes[tag] = 8;
    }

    public void setAttribute(int tag, byte value) {
        this.setAttribute(tag, new byte[]{value}, 0, 1);
    }

    public void setAttribute(int tag, byte[] value, int offset, int length) {
        this.hasAttributes = true;
        this.attributeByte[tag] = value;
        this.attributeByteOffset[tag] = offset;
        this.attributeByteLength[tag] = length;
        this.attributeTypes[tag] = 1;
    }

    public void setAttribute(int tag, long value) {
        this.setAttribute(tag, new long[]{value}, 0, 1);
    }

    public void setAttribute(int tag, long[] value, int offset, int length) {
        this.hasAttributes = true;
        this.attributeLong[tag] = value;
        this.attributeLongOffset[tag] = offset;
        this.attributeLongLength[tag] = length;
        this.attributeTypes[tag] = 6;
    }

    public void setAttribute(int tag, int value) {
        this.setAttribute(tag, new int[]{value}, 0, 1);
    }

    public void setAttribute(int tag, int[] value, int offset, int length) {
        this.hasAttributes = true;
        this.attributeInt[tag] = value;
        this.attributeIntOffset[tag] = offset;
        this.attributeIntLength[tag] = length;
        this.attributeTypes[tag] = 5;
    }

    public void setAttribute(int tag, boolean value) {
        this.setAttribute(tag, new boolean[]{value}, 0, 1);
    }

    public void setAttribute(int tag, boolean[] value, int offset, int length) {
        this.hasAttributes = true;
        this.attributeBoolean[tag] = value;
        this.attributeBooleanOffset[tag] = offset;
        this.attributeBooleanLength[tag] = length;
        this.attributeTypes[tag] = 0;
    }

    public void setAttribute(int tag, float value) {
        this.setAttribute(tag, new float[]{value}, 0, 1);
    }

    public void setAttribute(int tag, float[] value, int offset, int length) {
        this.hasAttributes = true;
        this.attributeFloat[tag] = value;
        this.attributeFloatOffset[tag] = offset;
        this.attributeFloatLength[tag] = length;
        this.attributeTypes[tag] = 4;
    }

    public void setAttribute(int tag, double value) {
        this.setAttribute(tag, new double[]{value}, 0, 1);
    }

    public void setAttribute(int tag, double[] value, int offset, int length) {
        this.hasAttributes = true;
        this.attributeDouble[tag] = value;
        this.attributeDoubleOffset[tag] = offset;
        this.attributeDoubleLength[tag] = length;
        this.attributeTypes[tag] = 3;
    }

    public void setAttribute(int tag, Color value) {
        this.setAttribute(tag, new Color[]{value}, 0, 1);
    }

    public void setAttribute(int tag, Color[] value, int offset, int length) {
    }

    public void setAttribute(int tag, char value) {
        this.setAttribute(tag, new char[]{value}, 0, 1);
    }

    public void setAttribute(int tag, char[] value, int offset, int length) {
        this.hasAttributes = true;
        this.attributeChar[tag] = value;
        this.attributeCharOffset[tag] = offset;
        this.attributeCharLength[tag] = length;
        this.attributeTypes[tag] = 2;
    }

    public void setAttribute(int tag, short value) {
        this.setAttribute(tag, new short[]{value}, 0, 1);
    }

    public void setAttribute(int tag, short[] value, int offset, int length) {
        this.hasAttributes = true;
        this.attributeShort[tag] = value;
        this.attributeShortOffset[tag] = offset;
        this.attributeShortLength[tag] = length;
        this.attributeTypes[tag] = 7;
    }

    private void writeMultiByteInt(long ui) throws IOException {
        int[] buf = new int[5];
        int idx = 0;
        do {
            buf[idx++] = (int)(ui & 0x7FL);
        } while ((ui >>= 7) != 0L);
        while (idx > 1) {
            this.writeByte(buf[--idx] | 0x80);
        }
        this.writeByte(buf[0]);
    }

    private void writeByte(int b) throws IOException {
        this.os.writeByte(b);
    }

    private void writeString(String s) throws IOException {
        this.os.writeUTF(s);
        this.os.writeByte(0);
    }
}

