/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.MinimumError;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MnAlgebraicVector;

class MinimumState {
    private MinimumParameters theParameters;
    private MinimumError theError;
    private FunctionGradient theGradient;
    private double theEDM;
    private int theNFcn;

    MinimumState(int n) {
        this.theParameters = new MinimumParameters(n);
        this.theError = new MinimumError(n);
        this.theGradient = new FunctionGradient(n);
    }

    MinimumState(MinimumParameters states, MinimumError err, FunctionGradient grad, double edm, int nfcn) {
        this.theParameters = states;
        this.theError = err;
        this.theGradient = grad;
        this.theEDM = edm;
        this.theNFcn = nfcn;
    }

    MinimumState(MinimumParameters states, double edm, int nfcn) {
        this.theParameters = states;
        this.theError = new MinimumError(states.vec().size());
        this.theGradient = new FunctionGradient(states.vec().size());
        this.theEDM = edm;
        this.theNFcn = nfcn;
    }

    MinimumParameters parameters() {
        return this.theParameters;
    }

    MnAlgebraicVector vec() {
        return this.theParameters.vec();
    }

    int size() {
        return this.theParameters.vec().size();
    }

    MinimumError error() {
        return this.theError;
    }

    FunctionGradient gradient() {
        return this.theGradient;
    }

    double fval() {
        return this.theParameters.fval();
    }

    double edm() {
        return this.theEDM;
    }

    int nfcn() {
        return this.theNFcn;
    }

    boolean isValid() {
        if (this.hasParameters() && this.hasCovariance()) {
            return this.parameters().isValid() && this.error().isValid();
        }
        if (this.hasParameters()) {
            return this.parameters().isValid();
        }
        return false;
    }

    boolean hasParameters() {
        return this.theParameters.isValid();
    }

    boolean hasCovariance() {
        return this.theError.isAvailable();
    }
}

