/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.freehep.application.studio.Plugin;
import org.jdom.Element;

public class PluginInfo {
    private Throwable errorStatus;
    private Plugin plugin;
    private File loadDir;
    private String name;
    private String author;
    private String version;
    private String mainClass;
    private String title;
    private String description;
    private String[] category;
    private Map files;
    private Map properties;
    private boolean loadAtStart;
    private boolean defaultLoadAtStart;
    private static final String[] NOCATEGORY = new String[0];

    public PluginInfo(Element node) {
        Element info = node.getChild("information");
        this.name = info.getChildTextNormalize("name");
        this.author = info.getChildTextNormalize("author");
        String temp = info.getChildTextNormalize("category");
        this.category = temp == null ? NOCATEGORY : temp.split("\\.");
        this.version = info.getChildTextNormalize("version");
        this.loadAtStart = info.getChild("load-at-start") != null;
        this.defaultLoadAtStart = this.loadAtStart;
        this.mainClass = node.getChild("plugin-desc").getAttributeValue("class");
        List desc = info.getChildren("description");
        Iterator i = desc.iterator();
        while (i.hasNext()) {
            Element d = (Element)i.next();
            String type = d.getAttributeValue("type");
            String text = d.getTextNormalize();
            if (type != null && type.equals("short")) {
                this.title = text;
                continue;
            }
            this.description = text;
        }
        Element resources = node.getChild("resources");
        if (resources != null) {
            List fileList = resources.getChildren("file");
            if (!fileList.isEmpty()) {
                this.files = new HashMap();
            }
            Iterator i2 = fileList.iterator();
            while (i2.hasNext()) {
                Element f = (Element)i2.next();
                String href = f.getAttributeValue("href");
                String location = f.getAttributeValue("location");
                this.files.put(location, href);
            }
            List propList = resources.getChildren("property");
            if (!propList.isEmpty()) {
                this.properties = new HashMap();
            }
            Iterator i3 = propList.iterator();
            while (i3.hasNext()) {
                Element f = (Element)i3.next();
                String name = f.getAttributeValue("name");
                String value = f.getAttributeValue("value");
                this.properties.put(name, value);
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PluginInfo) {
            return this.name.equals(((PluginInfo)o).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    String getMainClass() {
        return this.mainClass;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isLoadAtStart() {
        return this.loadAtStart;
    }

    public void setLoadAtStart(boolean loadAtStart) {
        this.loadAtStart = loadAtStart;
    }

    public Map getFiles() {
        return this.files == null ? Collections.EMPTY_MAP : this.files;
    }

    public Map getProperties() {
        return this.properties == null ? Collections.EMPTY_MAP : this.properties;
    }

    public void setLoadDirectory(File dir) {
        this.loadDir = dir;
    }

    public File getLoadDirectory() {
        return this.loadDir;
    }

    void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String[] getCategory() {
        return this.category;
    }

    void loadUserProperties(Properties user) {
        String prop = user.getProperty("loadAtStart." + this.name);
        if (prop != null) {
            this.loadAtStart = Boolean.valueOf(prop);
        }
    }

    void saveUserProperties(Properties user) {
        String key = "loadAtStart." + this.name;
        if (this.loadAtStart == this.defaultLoadAtStart) {
            user.remove(key);
        } else {
            user.setProperty(key, String.valueOf(this.loadAtStart));
        }
    }

    void setErrorStatus(Throwable t) {
        this.errorStatus = t;
    }

    public Throwable getErrorStatus() {
        return this.errorStatus;
    }
}

