/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import org.freehep.application.Application;

public class LookAndFeelMenu
extends JMenu {
    public LookAndFeelMenu() {
        super("Look and Feel");
    }

    public void fireMenuSelected() {
        this.removeAll();
        LAFActionListener listener = new LAFActionListener();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        String currentLAF = UIManager.getLookAndFeel().getClass().getName();
        for (int i = 0; i < info.length; ++i) {
            JRadioButtonMenuItem radio = new JRadioButtonMenuItem(info[i].getName());
            String className = info[i].getClassName();
            radio.setActionCommand(className);
            radio.setSelected(className.equals(currentLAF));
            radio.addActionListener(listener);
            this.add(radio);
        }
        super.fireMenuSelected();
    }

    private class LAFActionListener
    implements ActionListener {
        private LAFActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Application.getApplication().setLookAndFeel(e.getActionCommand());
        }
    }
}

