/*
 * Decompiled with CFR 0.152.
 */
package ice.util.StructuredDeviceList;

import ice.data.InstalledDevice;
import java.util.ArrayList;

public class DeviceNode
implements Comparable {
    private ArrayList<DeviceNode> children = null;
    public String name = null;
    private InstalledDevice installedDevice = null;
    private boolean isClientSideDeviceContainer = false;
    private boolean readOnlyDevice = false;
    private boolean visible = true;

    public DeviceNode() {
        this.init(false, false, true);
    }

    public DeviceNode(boolean isClientSideDeviceContainer, boolean readOnlyDevice, boolean visible) {
        this.init(isClientSideDeviceContainer, readOnlyDevice, visible);
    }

    private void init(boolean isClientSideDeviceContainer, boolean readOnlyDevice, boolean visible) {
        this.name = "";
        this.isClientSideDeviceContainer = isClientSideDeviceContainer;
        this.readOnlyDevice = readOnlyDevice;
        this.visible = visible;
        this.children = new ArrayList();
    }

    public void add(DeviceNode newChild) {
        this.children.add(newChild);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeviceNode hasChild(String name) {
        DeviceNode returnValue = null;
        int numberOfChildren = -1;
        DeviceNode currentChild = null;
        if (this.children != null) {
            numberOfChildren = this.children.size();
            int i = 0;
            while (i < numberOfChildren) {
                currentChild = this.children.get(i);
                if (currentChild.name.compareTo(name) == 0) {
                    returnValue = currentChild;
                    break;
                }
                ++i;
            }
        }
        return returnValue;
    }

    public ArrayList<DeviceNode> getChildren() {
        return this.children;
    }

    public InstalledDevice getInstalledDevice() {
        return this.installedDevice;
    }

    public void setInstalledDevice(InstalledDevice installedDevice) {
        this.installedDevice = installedDevice;
    }

    public boolean isClientSideDeviceContainer() {
        return this.isClientSideDeviceContainer;
    }

    public String toString() {
        String returnValue = null;
        returnValue = super.toString();
        returnValue = String.valueOf(returnValue) + " " + this.name;
        return returnValue;
    }

    public boolean isReadOnlyDevice() {
        return this.readOnlyDevice;
    }

    public void setReadOnlyDevice(boolean readOnlyDevice) {
        this.readOnlyDevice = readOnlyDevice;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int compareTo(Object o) {
        DeviceNode deviceNode = (DeviceNode)o;
        String thisName = this.getName();
        String deviceNodeName = deviceNode.getName();
        int returnValue = thisName.compareTo(deviceNodeName);
        return returnValue;
    }
}

