/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.FileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PreferencesManager {
    private static Logger logger = Logger.getLogger("StaticLogger");
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final String UNDEFINED = "undefined";
    private static Properties properties = new Properties();
    private static File preferencesFile;

    static {
        try {
            preferencesFile = FileManager.getInstance().getPreferencesFile();
            FileInputStream iStream = new FileInputStream(preferencesFile);
            properties.load(iStream);
            iStream.close();
        }
        catch (IOException ioe) {
            logger.error("Error while reading properties file.", ioe);
        }
    }

    public static synchronized String getPreferenceString(String key) {
        return properties.getProperty(key, UNDEFINED);
    }

    public static synchronized String getPreferenceString(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static synchronized void setPreferenceString(String key, String value) throws IOException {
        FileOutputStream oStream = new FileOutputStream(preferencesFile);
        properties.setProperty(key, value);
        properties.store(oStream, "Preferences file for JICE options");
        oStream.close();
    }
}

